/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessTranferSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessTranferSetPlugin.class);
    private static final String KEY_RELATION = "relation";
    private static final String KEY_ENTRYENTITY_CONDITION = "entryentity_condition";
    private static final String KEY_PARAM = "param";
    private static final String KEY_COMPARETYPE = "comparetype";
    private static final String KEY_VALUETYPE = "valuetype";
    private static final String KEY_TEXTVALUE = "textvalue";
    private static final String KEY_PARAMVALUE = "paramvalue";

    @Override
    public void initData() {
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_CONDITION);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRYENTITY_CONDITION);
        rows.clear();
        Flow flow = this.getFlow();
        Condition condition = flow.findTransferById(this.getNodeId()).getCondition();
        if (condition == null) {
            return;
        }
        List conditonRows = condition.getConditionRows();
        if (conditonRows != null && conditonRows.size() > 0) {
            for (int i = 0; i < conditonRows.size(); ++i) {
                Condition.Row conditionRow = (Condition.Row)conditonRows.get(i);
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_PARAM, (Object)String.format("%s#%s", conditionRow.getLeftNodeId(), conditionRow.getLeftVarName()));
                row.set(KEY_COMPARETYPE, (Object)conditionRow.getOperator().toCompareTypeEnum().getId());
                row.set(KEY_VALUETYPE, (Object)conditionRow.getValueType());
                row.set(KEY_TEXTVALUE, (Object)conditionRow.getText());
                if (conditionRow.getRightVarName() != null) {
                    row.set(KEY_PARAMVALUE, (Object)String.format("%s#%s", conditionRow.getRightNodeId(), conditionRow.getRightVarName()));
                }
                rows.add((Object)row);
            }
        }
        this.getModel().setValue(KEY_RELATION, (Object)(condition.getRelation() != null ? condition.getRelation() : Condition.RelationType.AND));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setDataChanged(true);
    }

    @Override
    protected void setComboItem() {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserInput(true);
        config.setAddUserChatHistory(false);
        List<ComboItem> beforeNodesParamItems = this.getComboItem(config);
        ComboEdit comboEditParam = (ComboEdit)this.getControl(KEY_PARAM);
        comboEditParam.setComboItems(beforeNodesParamItems);
        ComboEdit comboEditParamValue = (ComboEdit)this.getControl(KEY_PARAMVALUE);
        comboEditParamValue.setComboItems(beforeNodesParamItems);
        ArrayList<ComboItem> compareTypeItems = new ArrayList<ComboItem>();
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.EQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.NOTEQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.GREATER));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.GREATEROREQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LESS));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LESSOREQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.ISNULL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.ISNOTNULL));
        ComboEdit comboEditValueType = (ComboEdit)this.getControl(KEY_COMPARETYPE);
        comboEditValueType.setComboItems(compareTypeItems);
    }

    private ComboItem getCompareTypeItem(CompareTypeEnum compareTypeEnum) {
        CompareType compareType = FilterMetadata.get().getCompareTypeByCompareTypeId(compareTypeEnum.getId());
        ComboItem item = new ComboItem(compareType.getName(), compareType.getId());
        return item;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        String sNewValue;
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(KEY_COMPARETYPE) && ((sNewValue = (changeData = e.getChangeSet()[0]).getNewValue().toString()).equals(CompareTypeEnum.ISNULL.getId()) || sNewValue.equals(CompareTypeEnum.ISNOTNULL.getId()))) {
            changeData.getDataEntity().set(KEY_VALUETYPE, null);
            changeData.getDataEntity().set(KEY_TEXTVALUE, null);
            changeData.getDataEntity().set(KEY_PARAMVALUE, null);
            this.getView().updateView(KEY_ENTRYENTITY_CONDITION);
        }
        if (e.getProperty().getName().equals(KEY_VALUETYPE)) {
            changeData = e.getChangeSet()[0];
            sNewValue = changeData.getNewValue().toString();
            if (sNewValue.equals(Condition.ValueType.TEXT.toString()) || sNewValue.equals(Condition.ValueType.DECIMAL.toString())) {
                changeData.getDataEntity().set(KEY_PARAMVALUE, null);
            }
            if (sNewValue.equals(Condition.ValueType.PARAM.toString())) {
                changeData.getDataEntity().set(KEY_TEXTVALUE, null);
            }
            this.getView().updateView(KEY_ENTRYENTITY_CONDITION);
        }
    }

    private void clickCondition(Flow flow) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRYENTITY_CONDITION);
        ArrayList<Condition.Row> conditionRows = new ArrayList<Condition.Row>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            String param = row.getString(KEY_PARAM);
            if (!StringUtils.isNotEmpty((CharSequence)param)) continue;
            Condition.Row conditionRow = new Condition.Row();
            conditionRow.setLeftNodeId(Integer.parseInt(param.split("#")[0]));
            conditionRow.setLeftVarName(param.split("#")[1]);
            CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)row.getString(KEY_COMPARETYPE));
            conditionRow.setOperator(Condition.Operator.fromCompareTypeEnum((CompareTypeEnum)compareTypeEnum));
            if (!compareTypeEnum.equals((Object)CompareTypeEnum.ISNULL) && !compareTypeEnum.equals((Object)CompareTypeEnum.ISNOTNULL)) {
                conditionRow.setValueType(Condition.ValueType.valueOf((String)row.getString(KEY_VALUETYPE)));
                if (row.getString(KEY_VALUETYPE).equals(Condition.ValueType.TEXT.toString()) || row.getString(KEY_VALUETYPE).equals(Condition.ValueType.DECIMAL.toString())) {
                    conditionRow.setText(row.getString(KEY_TEXTVALUE));
                } else if (row.getString(KEY_VALUETYPE).equals(Condition.ValueType.PARAM.toString())) {
                    String paramValue = row.getString(KEY_PARAMVALUE);
                    conditionRow.setRightNodeId(Integer.parseInt(paramValue.split("#")[0]));
                    conditionRow.setRightVarName(paramValue.split("#")[1]);
                }
            }
            conditionRows.add(conditionRow);
        }
        Transfer transfer = flow.findTransferById(this.getNodeId());
        Condition condition = transfer.getCondition();
        if (!conditionRows.isEmpty()) {
            if (condition == null) {
                condition = new Condition();
                transfer.setCondition(condition);
            }
            condition.setConditionRows(conditionRows);
        } else {
            transfer.setCondition(null);
        }
    }

    private void setConditionVisible(boolean bVisible) {
        String nodeName = bVisible ? this.getModel().getValue("name").toString() : "";
        this.sendNodeNameToCustomControl(nodeName);
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickCondition(flow);
    }

    private String check() {
        DynamicObjectCollection rowConditions = this.getModel().getEntryEntity(KEY_ENTRYENTITY_CONDITION);
        this.setConditionVisible(!rowConditions.isEmpty());
        for (int i = 0; i < rowConditions.size(); ++i) {
            DynamicObject row = (DynamicObject)rowConditions.get(i);
            if (StringUtils.isEmpty((CharSequence)row.getString(KEY_PARAM)) || StringUtils.isEmpty((CharSequence)row.getString(KEY_COMPARETYPE))) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"GaiProcessTranferSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
            }
            if (!row.getString(KEY_COMPARETYPE).equals(CompareTypeEnum.ISNULL.getId()) && !row.getString(KEY_COMPARETYPE).equals(CompareTypeEnum.ISNOTNULL.getId())) {
                if (StringUtils.isEmpty((CharSequence)row.getString(KEY_VALUETYPE))) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"GaiProcessTranferSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
                }
                if (row.getString(KEY_VALUETYPE).equals(Condition.ValueType.PARAM.toString()) && StringUtils.isEmpty((CharSequence)row.getString(KEY_PARAMVALUE))) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"GaiProcessTranferSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
                }
            }
            String valueType = row.getString(KEY_VALUETYPE);
            if (!Condition.ValueType.DECIMAL.name().equals(valueType)) continue;
            String value = row.getString(KEY_TEXTVALUE);
            try {
                Float.parseFloat(value);
                continue;
            }
            catch (Exception ex) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u914d\u7f6e\u7684\u503c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u503c", (String)"GaiProcessTranferSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
            }
        }
        return "";
    }
}

