/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.ActionBaseInfo;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.flow.param.legacy.LegacyMigrationHelper;
import kd.ai.gai.core.util.RecommendNodeUtil;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.flow.FlowDesigner;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.event.InitEventHandler;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ValidateService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiProcessUpdatePlugin
extends AbstractFormPlugin {
    private static final String SYSTEM = "ai-gai-plugin";
    private static final String BTN_UPDATE = "update";
    private static final String BTN_ROLLBACK = "rollback";
    private static final String CONFIRM_UPDATE = "confirmUpdate";
    private static final String CONFIRM_ROLLBACK = "confirmRollback";
    private FlowDesigner flowDesigner;

    private FlowDesigner getFlowDesigner() {
        if (this.flowDesigner == null) {
            this.flowDesigner = new FlowDesigner(this.getView());
        }
        return this.flowDesigner;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        Flow flow = this.getModelService().getFlow();
        Long flowId = this.getFlowId().orElse(0L);
        DynamicObject backupData = BusinessDataServiceHelper.loadSingleFromCache((Object)flowId, (String)"gai_process_backup");
        if (ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_UPDATE});
            this.getView().setVisible(Boolean.valueOf(backupData != null), new String[]{BTN_ROLLBACK});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_UPDATE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ROLLBACK});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean iscancel;
        super.beforeItemClick(evt);
        if ((BTN_UPDATE.equals(evt.getItemKey()) || BTN_ROLLBACK.equals(evt.getItemKey())) && (iscancel = this.getFlowDesigner().getEditingContext().getService(ValidateService.class).validateFlow())) {
            evt.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTN_UPDATE.equals(evt.getItemKey())) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u5347\u7ea7\u3002", (String)"GaiProcessUpdatePlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5373\u5c06\u4e3a\u60a8\u5347\u7ea7\u5f53\u524d\u4efb\u52a1\u6d41\u6570\u636e\u81f3\u652f\u6301\u590d\u6742\u53c2\u6570\uff0c\u5347\u7ea7\u540e\u8bf7\u52a1\u5fc5\u5b8c\u6210\u529f\u80fd\u6d4b\u8bd5\u540e\u518d\u4e0a\u7ebf\u3002\r\n\u662f\u5426\u786e\u5b9a\uff1f", (String)"GaiProcessUpdatePlugin_1", (String)SYSTEM, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_UPDATE));
        } else if (BTN_ROLLBACK.equals(evt.getItemKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5373\u5c06\u56de\u9000\u5f53\u524d\u4efb\u52a1\u6d41\u6570\u636e\u81f3\u5347\u7ea7\u524d\u7684\u7248\u672c\uff0c\u6b64\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u4f1a\u6e05\u9664\u5347\u7ea7\u540e\u66f4\u65b0\u7684\u76f8\u5173\u914d\u7f6e\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\uff01\r\n\u662f\u5426\u786e\u5b9a\uff1f", (String)"GaiProcessUpdatePlugin_2", (String)SYSTEM, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_ROLLBACK));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CONFIRM_UPDATE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            long primaryKeyValue = this.getFlowId().orElseThrow(() -> new RuntimeException("\u6d41\u7a0bID\u4e3a\u7a7a, \u8bf7\u4fdd\u5b58\u540e\u91cd\u65b0\u6253\u5f00\u8be5\u6d41\u7a0b"));
            DynamicObject originData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gai_process");
            String flowStr = originData.getString("flow");
            Flow flow = JsonUtil.fromBase64String((String)flowStr);
            if (ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
                this.getView().showTipNotification("\u5df2\u662f\u65b0\u7248\u4efb\u52a1\u6d41\uff0c \u65e0\u9700\u5347\u7ea7");
                return;
            }
            this.backupFlow(originData, flowStr);
            this.updateNewFlow(originData, flow);
            this.getView().showSuccessNotification("\u5347\u7ea7\u6210\u529f");
            this.getView().updateView();
        } else if (CONFIRM_ROLLBACK.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            long primaryKeyValue = this.getFlowId().orElseThrow(() -> new RuntimeException("\u6d41\u7a0bID\u4e3a\u7a7a, \u8bf7\u4fdd\u5b58\u540e\u91cd\u65b0\u6253\u5f00\u8be5\u6d41\u7a0b"));
            DynamicObject originData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gai_process");
            String flowStr = originData.getString("flow");
            Flow flow = JsonUtil.fromBase64String((String)flowStr);
            if (!ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
                this.getView().showTipNotification("\u975e\u65b0\u7248\u4efb\u52a1\u6d41\uff0c \u65e0\u9700\u6062\u590d");
                return;
            }
            DynamicObject backupData = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"gai_process_backup");
            if (backupData == null) {
                this.getView().showTipNotification("\u65e0\u5347\u7ea7\u8fc7\u7a0b\u6570\u636e\uff0c \u65e0\u6cd5\u6062\u590d\uff0c \u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u5347\u7ea7\u4efb\u52a1\u6d41");
                return;
            }
            this.rollbackFlow(originData, backupData);
            this.getView().showSuccessNotification("\u6062\u590d\u6210\u529f");
            this.getView().updateView();
        }
    }

    private Optional<Long> getFlowId() {
        ModelService modelService = this.getModelService();
        Flow flow = modelService.getFlow();
        return Optional.of(flow.getId());
    }

    private ModelService getModelService() {
        return this.getFlowDesigner().getEditingContext().getService(ModelService.class);
    }

    private void backupFlow(DynamicObject originData, String flowStr) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"gai_process_backup");
        DynamicObject backupData = new DynamicObject((DynamicObjectType)dataEntityType);
        backupData.set("id", originData.getPkValue());
        backupData.set("billno", (Object)originData.getString("number"));
        backupData.set("flow_tag", (Object)flowStr);
        boolean exists = QueryServiceHelper.exists((String)"gai_process_backup", (Object)originData.getPkValue());
        if (exists) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{backupData});
            return;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{backupData});
    }

    private void updateNewFlow(DynamicObject originData, Flow flow) {
        Start start = flow.getStart();
        End end = flow.getEnd();
        List actions = flow.getActions();
        LegacyMigrationHelper.migrateNode((Action)start);
        LegacyMigrationHelper.migrateNode((Action)end);
        for (Action action : actions) {
            LegacyMigrationHelper.migrateNode((Action)action);
        }
        flow.setParamMode(ParamMode.VARIABLE.name());
        String flowStr = JsonUtil.toBase64String((Flow)flow);
        originData.set("flow", (Object)flowStr);
        SaveServiceHelper.update((DynamicObject)originData);
        this.getModelService().updateFlow(flow);
        this.sendInitAction(flow);
    }

    private void rollbackFlow(DynamicObject originData, DynamicObject backupData) {
        String flowStr = backupData.getString("flow_tag");
        originData.set("flow", (Object)flowStr);
        SaveServiceHelper.update((DynamicObject)originData);
        Flow originFlow = JsonUtil.fromBase64String((String)flowStr);
        this.getModelService().updateFlow(originFlow);
        FlowEditingContext.get().getService(ModelService.class).getNodeDataManager().clear();
        FlowEditingContext.get().getService(ModelService.class).getDeleteDataManager().clear();
        this.sendInitAction(originFlow);
    }

    private void sendInitAction(Flow flow) {
        CustomControlAction action = new CustomControlAction("init");
        RecommendNodeUtil.removeRecommendNode((Flow)flow);
        action.setValue(JsonUtil.toJson((Object)flow));
        List<ActionBaseInfo> actionBaseInfoList = InitEventHandler.getActionBaseInfoByFlow(flow);
        action.setActionBaseInfos(JsonUtil.toJson(actionBaseInfoList));
        this.getFlowDesigner().getEditingContext().getService(FlowActionService.class).sendAction(action);
    }
}

