/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.cache.SessionCache;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.agent.AgentTypeEnum;
import kd.ai.gai.core.enuz.agent.CtrlStrategyEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.RoleModeEnum;
import kd.ai.gai.core.enuz.agent.SystemAgentEnum;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.agent.PictureAvatarService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiAgentBaseFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(GaiAgentBaseFormPlugin.class);
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_PICTURE = "picture";
    private static final String KEY_NAME = "name";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_FLEX_PICTURE_CLICK = "flexpictureclick";
    private static final String KEY_BACKGROUND = "background";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_FLEX_PICTURE_CLICK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        RequestContext rc = RequestContext.get();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_BTN_OK)) {
            String useOrgId;
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
                String createOrg;
                String newOrgValue = this.getPageCache().get("newOrgValue");
                if (StringUtils.isEmpty((CharSequence)newOrgValue)) {
                    IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
                    useOrgId = createOrg = pageCache.get("createOrg");
                } else {
                    useOrgId = createOrg = newOrgValue;
                }
            } else {
                useOrgId = String.valueOf(rc.getOrgId());
            }
            long id = ID.genLongId();
            String picture = (String)this.getModel().getValue(KEY_PICTURE);
            String name = (String)this.getModel().getValue(KEY_NAME);
            OrmLocaleValue description = (OrmLocaleValue)this.getModel().getValue(KEY_DESCRIPTION);
            DynamicObject agentDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_AGENT.getId());
            String number = CodeRuleServiceHelper.getNumber((String)GaiFormIdEnum.GAI_AGENT.getId(), (DynamicObject)agentDo, (String)String.valueOf(RequestContext.get().getOrgId()));
            agentDo.set(KEY_PICTURE, (Object)picture);
            agentDo.set(KEY_NAME, (Object)name);
            agentDo.set("number", (Object)number);
            agentDo.set("agentname", (Object)number);
            agentDo.set(KEY_DESCRIPTION, (Object)description);
            agentDo.set("type", (Object)AgentTypeEnum.CUSTOM.getId());
            agentDo.set("rolemode", (Object)RoleModeEnum.REACT.getId());
            String bgColor = this.getPageCache().get("bgcolor");
            agentDo.set("bgcolor", (Object)(StringUtils.isNotEmpty((CharSequence)bgColor) ? bgColor : "#EAF6FF"));
            agentDo.set("creator", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            agentDo.set("masterid", (Object)id);
            agentDo.set("enable", (Object)EnableEnum.NO.getKeyStr());
            agentDo.set("ctrlstrategy", (Object)CtrlStrategyEnum.ALL.getId());
            agentDo.set("org", (Object)rc.getOrgId());
            agentDo.set("createorg", (Object)useOrgId);
            agentDo.set("useorg", (Object)useOrgId);
            agentDo.set("llmstyle", (Object)LlmStyle.BALANCE.getValue());
            String llmNumber = null;
            String llmName = null;
            List serviceList = AiccService.getLlmList();
            for (Map service : serviceList) {
                if (!Boolean.TRUE.equals(service.get("active"))) continue;
                llmNumber = (String)service.get("number");
                llmName = (String)service.get(KEY_NAME);
                break;
            }
            if (StringUtils.isEmpty(llmNumber)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u8fdb\u5165\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u5217\u8868\u4e2d\u914d\u7f6e\u6a21\u578bAPI\u53c2\u6570\u3002", (String)"GaiAgentFormPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            agentDo.set("llm", llmNumber);
            agentDo.set("llmname", llmName);
            DynamicObject[] saveObjs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentDo});
            long orgId = rc.getOrgId();
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)agentDo, (Long)orgId);
            if (saveObjs != null && saveObjs.length > 0) {
                long pkValue = (Long)saveObjs[0].getPkValue();
                log.info("save success size: {} id:{}", (Object)saveObjs.length, (Object)pkValue);
                SessionCache.get().put("LAST_ADD_AGENT_ID", String.valueOf(pkValue));
                this.getView().close();
            }
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)KEY_FLEX_PICTURE_CLICK)) {
            this.showPictureSelector();
        }
    }

    private void showPictureSelector() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(GaiFormIdEnum.GAI_PICTURE_DLG.getId());
        fsp.setCustomParam(KEY_PICTURE, this.getModel().getValue(KEY_PICTURE));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_PICTURE));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        JSONObject dataJo;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_PICTURE, (CharSequence)actionId) && (dataJo = (JSONObject)returnData) != null) {
            String picture = dataJo.getString(KEY_PICTURE);
            String background = dataJo.getString(KEY_BACKGROUND);
            if (StringUtils.isNotEmpty((CharSequence)background)) {
                this.getModel().setValue(KEY_PICTURE, (Object)picture);
                background = String.format("#%s", background);
            }
            this.getPageCache().put("bgcolor", background);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(KEY_PICTURE, (Object)PictureAvatarService.getPictureByAgentName((String)SystemAgentEnum.COMMON_AGENT.getAgentName()));
    }
}

