/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.agent.AgentSample;
import kd.ai.gai.core.domain.dto.agent.AgentSkill;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.domain.dto.agent.FileMetadata;
import kd.ai.gai.core.domain.dto.agent.InitAgentPlaygroud;
import kd.ai.gai.core.domain.dto.agent.annotations.FormAnnotation;
import kd.ai.gai.core.domain.prompt.PromptOptimizeTemplate;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.enuz.RepoTypeEnum;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.SkillSrcEnum;
import kd.ai.gai.core.enuz.agent.AgentTypeEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.ParamConfigEnum;
import kd.ai.gai.core.enuz.agent.PurposeEnum;
import kd.ai.gai.core.enuz.agent.RoleModeEnum;
import kd.ai.gai.core.enuz.agent.SystemAgentEnum;
import kd.ai.gai.core.enuz.agent.TipsTypeEnum;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.service.agent.PictureAvatarService;
import kd.ai.gai.core.service.config.GaiParamConfigService;
import kd.ai.gai.core.trace.MonitorServiceHelper;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.plugin.AbstractGaiAssistantPlugin;
import kd.ai.gai.plugin.card.action.ShowBillAction;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiAgentFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(GaiAgentFormPlugin.class);
    private static final String KEY_LLM = "llm";
    private static final String KEY_ROLEMODE = "rolemode";
    private static final String KEY_USEORG = "useorg";
    private static final String KEY_TOOL = "tool";
    private static final String KEY_PROMPT = "prompt";
    private static final String KEY_PROCESS = "process";
    private static final String KEY_REPO = "repo";
    private static final String KEY_OPENAPI = "openapi";
    private static final String KEY_SEND_MSG = "sendmsg";
    private static final String NEW_ENTRY_TOOL = "newentrytool";
    private static final String NEW_ENTRY_PROMPT = "newentryprompt";
    private static final String NEW_ENTRY_PROCESS = "newentryprocess";
    private static final String BTN_ADD_TOOL = "btnaddtool";
    private static final String BTN_ADD_PROCESS = "btnaddprocess";
    private static final String BTN_ADD_PROMPT = "btnaddprompt";
    private static final String BTN_ADD_REPO = "btnaddrepo";
    public static final String KEY_LLMSTYLE_PREFIX = "llmstyle";
    public static final String KEY_LLMSTYLE_FLEX_PREFIX = "llmstyleflex_";
    public static final String KEY_LLMSTYLE_LABEL_PREFIX = "llmstylelabel_";
    public static final String KEY_LLMSTYLE_VECTOR_PREFIX = "llmstylevector_";
    public static final String CUSTOM_CONTROL_AGENT_EDIT = "agent_edit";
    public static final String CUSTOM_EVENT_ADD_SKILL = "addSkill";
    public static final String CUSTOM_EVENT_DEL_SKILL = "delSkill";
    public static final String CUSTOM_EVENT_VIEW_SKILL = "viewSkill";
    public static final String CUSTOM_EVENT_AGENT_EDIT = "agentEdit";
    public static final String CUSTOM_EVENT_REPO_EDIT = "repoAutoCallEdit";
    public static final String KEY_EDITABLE = "editable";
    public static final String KEY_REPO_EDITABLE = "repoEditable";
    public static final String KEY_BAR_SAVE = "bar_save";
    private static final int TOOL_MAX_COUNT = 30;
    private static final String SELECT_TEMPLATE_CALLBACK_ACTION_ID = "select_template_callback";
    private static final String[] EDIT_CONTROL_ARR = new String[]{"picture", "number", "name", "useorg", "llm", "llmstyle", "flexllmstyle", "remembercount", "app", "rolemode", "prologue", "description", "roledesc", "bar_save", "gai_agent_repo", "gai_agent_start", "gai_agent_tool", "gai_agent_prompt", "gai_agent_process", "newentrystart", "newentryrepo", "deleteentryrepo", "deleteentrystart", "moveentryupstart", "moveentrydownstart", "newentrytool", "deleteentrytool", "newentryprompt", "deleteentryprompt", "newentryprocess", "deleteentryprocess"};
    private static final String[] EDIT_CONTROL_ARR_LLM = new String[]{"picture", "number", "name", "useorg", "llmstyle", "flexllmstyle", "remembercount", "app", "rolemode", "prologue", "agent_edit", "description", "roledesc", "gai_agent_repo", "gai_agent_start", "gai_agent_tool", "gai_agent_prompt", "gai_agent_process", "newentrystart", "newentryrepo", "deleteentryrepo", "deleteentrystart", "moveentryupstart", "moveentrydownstart", "newentrytool", "deleteentrytool", "newentryprompt", "deleteentryprompt", "newentryprocess", "deleteentryprocess"};
    private static final String[] EDIT_CONTROL_ARR_2 = new String[]{"llm", "llmstyle", "flexllmstyle", "bar_save", "prologue", "gai_agent_start", "newentrystart", "deleteentrystart", "moveentryupstart", "moveentrydownstart"};
    private static final String[] LLM_STYLE_ARR = new String[]{"creativity", "balance", "precision"};
    public static final String DEFAULT_LLM_STYLE = "balance";
    public static final String ENABLE_COLOR = "#FFFFFF";
    public static final String DISABLE_COLOR = "#999999";
    public static final String DEFAULT_BORDER_COLOR = "#d9d9d9";
    public static final String KEY_FLEX_TITLE = "flextitle";
    public static final String REMEMBER_COUNT_TIPS = "remembercounttips";
    public static final String LLM_TIPS = "llmtips";
    public static final String LLM_STYLE_TIPS = "llmstyletips";
    public static final String USEORG_TIPS = "useorgtips";
    public static final String APP_TIPS = "apptips";
    public static final String PROLOGUE_TIPS = "prologuetips";
    public static final String START_TIPS = "starttips";
    public static final String DESCRIPTION_TIPS = "descriptiontips";
    public static final String ADVANCED_CONFIG_TIPS = "advancedconfigtips";
    public static final String ROLEDESC_TIPS = "roledesctips";
    private static final String KEY_PICTURE = "picture";
    private static final String KEY_BACKGROUND = "background";
    private static final String KEY_FLEX_PICTURE_CLICK = "flexpictureclick";
    private static final String FLEX_TEMPLATE = "flextemplate";
    private static final String FLEX_OPTIMIZE = "flexoptimize";
    private static final String FLEX_WRAP_TEMPLATE = "flexwraptemplate";
    private static final String FLEX_WRAP_OPTIMIZE = "flexwrapoptimize";
    private static final String TOOL_EDIT_FORM_ID = "gai_tool_edit";

    private String getChatSessionId() {
        return this.getPageCache().get("chatSessionId");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit toolBD = (BasedataEdit)this.getView().getControl(KEY_TOOL);
        toolBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit gptPromptBD = (BasedataEdit)this.getView().getControl(KEY_PROMPT);
        gptPromptBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit gptProcessBD = (BasedataEdit)this.getView().getControl(KEY_PROCESS);
        gptProcessBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{KEY_SEND_MSG, BTN_ADD_TOOL, BTN_ADD_PROCESS, BTN_ADD_PROMPT, BTN_ADD_REPO, KEY_FLEX_PICTURE_CLICK});
        for (String llmStyle : LLM_STYLE_ARR) {
            Control flex = this.getControl(KEY_LLMSTYLE_FLEX_PREFIX + llmStyle);
            Control vector = this.getControl(KEY_LLMSTYLE_VECTOR_PREFIX + llmStyle);
            Control label = this.getControl(KEY_LLMSTYLE_LABEL_PREFIX + llmStyle);
            if (flex instanceof ISuportClick) {
                ((ISuportClick)flex).addClickListener((ClickListener)this);
            }
            if (vector instanceof ISuportClick) {
                ((ISuportClick)vector).addClickListener((ClickListener)this);
            }
            if (!(label instanceof ISuportClick)) continue;
            ((ISuportClick)label).addClickListener((ClickListener)this);
        }
        Control flexTemplate = this.getControl(FLEX_TEMPLATE);
        ((ISuportClick)flexTemplate).addClickListener((ClickListener)this);
        Control flexOptimize = this.getControl(FLEX_OPTIMIZE);
        ((ISuportClick)flexOptimize).addClickListener((ClickListener)this);
        Control flexWrapTemplate = this.getControl(FLEX_WRAP_TEMPLATE);
        ((ISuportClick)flexWrapTemplate).addClickListener((ClickListener)this);
        Control flexWrapOptimize = this.getControl(FLEX_WRAP_OPTIMIZE);
        ((ISuportClick)flexWrapOptimize).addClickListener((ClickListener)this);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.initAgentPlaygroud();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String type = (String)this.getModel().getValue("type");
        Boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        if (isPreset.booleanValue()) {
            this.getModel().setValue("ispreset", (Object)false);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)AgentTypeEnum.SYSTEM.getId())) {
            String roleModel = (String)this.getModel().getValue(KEY_ROLEMODE);
            if (roleModel == null || roleModel.length() == 0) {
                this.getModel().setValue(KEY_ROLEMODE, (Object)RoleModeEnum.REACT.getId());
            }
            String llm = (String)this.getModel().getValue(KEY_LLM);
            if (this.getModel().getValue(KEY_LLM) == null || llm.length() == 0) {
                List serviceList = AiccService.getLlmList();
                for (Map service : serviceList) {
                    if (!Boolean.TRUE.equals(service.get("active"))) continue;
                    this.getModel().setValue(KEY_LLM, (Object)((String)service.get("number")));
                    break;
                }
            }
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.initAgentPlaygroud();
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        this.initAgentPlaygroud();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(KEY_PICTURE, (Object)PictureAvatarService.getPictureByAgentName((String)SystemAgentEnum.COMMON_AGENT.getAgentName()));
        this.getModel().setValue("bgcolor", (Object)"#EAF6FF");
        this.setLlmStyleFocusStatus(DEFAULT_LLM_STYLE);
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        if (orgId != null) {
            this.getModel().setValue("createorg", orgId);
        }
    }

    public void initialize() {
        super.initialize();
        this.getView().getFormShowParameter().setCustomParam("slideEnv", (Object)SLIDEENV.AGENT);
    }

    public List<ComboItem> createLlmComboItem() {
        List serviceList = AiccService.getLlmList();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(serviceList.size());
        String id = String.valueOf(this.getModel().getValue("id"));
        for (Map service : serviceList) {
            String agentId;
            List<String> agentIds;
            boolean isLimit = (Boolean)service.get("limit");
            if (isLimit && !(agentIds = Arrays.asList((agentId = service.get("agentIdsTag").toString()).split(","))).contains(id)) continue;
            ComboItem comboItem = new ComboItem();
            if (!Boolean.TRUE.equals(service.get("active"))) continue;
            comboItem.setCaption(new LocaleString(service.get("name") + "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09"));
            comboItem.setValue((String)service.get("number"));
            list.add(comboItem);
        }
        return list;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dataEntity.getDataEntityType().getName(), (DynamicObject)dataEntity, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dataEntity);
        this.getView().getModel().setValue("number", (Object)number);
        String type = (String)this.getModel().getValue("type");
        if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)AgentTypeEnum.SYSTEM.getId())) {
            ComboEdit llm = (ComboEdit)this.getControl(KEY_LLM);
            llm.setMustInput(true);
            llm.setDroppable(false);
        }
        List<ComboItem> comboItems = this.createLlmComboItem();
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(KEY_LLM);
        llmComboEdit.setComboItems(comboItems);
        GaiUtils.newContextInAgentPlayground((IFormView)this.getView());
        this.initGaiInitConfig();
        this.setControlEnableStatus();
        this.initControlTips();
        if (dataEntity != null) {
            this.resetFormTitle(dataEntity);
            this.initFlexTitleBgColor(dataEntity.getString("bgcolor"));
            this.setLlmStyleFocusStatus(dataEntity.getString(KEY_LLMSTYLE_PREFIX));
        }
    }

    private void resetFormTitle(DynamicObject dataEntity) {
        OrmLocaleValue name = (OrmLocaleValue)dataEntity.getLocaleString("name");
        if (name != null) {
            String agentStr;
            String nameLocaleValue = name.getLocaleValue();
            String title = agentStr = ResManager.loadKDString((String)"\u667a\u80fd\u4f53", (String)"GaiAgentFormPlugin_20", (String)"ai-gai-plugin", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)nameLocaleValue)) {
                if (StringUtils.length((CharSequence)nameLocaleValue) > 10) {
                    nameLocaleValue = nameLocaleValue.substring(0, 10) + "...";
                }
                title = String.format("%s-%s", agentStr, nameLocaleValue);
            }
            this.getView().setFormTitle(new LocaleString(title));
        }
    }

    private void initControlTips() {
        this.getModel().setValue(REMEMBER_COUNT_TIPS, (Object)ResManager.loadKDString((String)"\u5728\u6bcf\u6b21\u8bf7\u6c42\u4e2d\u7528\u6237\u548c\u7cfb\u7edf\u4ea4\u4e92\u7684\u603b\u5386\u53f2\u6d88\u606f\u4e2a\u6570\uff0c\u6709\u52a9\u4e8e\u7ed9\u6a21\u578b\u63d0\u4f9b\u5bf9\u8bdd\u7684\u4e0a\u6587", (String)"GaiAgentFormPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(LLM_TIPS, (Object)ResManager.loadKDString((String)"\u4e3a\u667a\u80fd\u4f53\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u4ece\u4e0b\u5217\u9009\u9879\u4e2d\u9009\u62e9\u3002", (String)"GaiAgentFormPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(LLM_STYLE_TIPS, (Object)ResManager.loadKDString((String)"\u9009\u62e9\u4e0d\u540c\u7684\u6a21\u578b\u98ce\u683c\u3002", (String)"GaiAgentFormPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(USEORG_TIPS, (Object)ResManager.loadKDString((String)"\u9009\u62e9\u4e1a\u52a1\u5355\u5143\uff0c\u7528\u4e8e\u6570\u636e\u9694\u79bb\u3002", (String)"GaiAgentFormPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(APP_TIPS, (Object)ResManager.loadKDString((String)"\u9009\u62e9\u5e94\u7528\uff0c\u4fa7\u8fb9\u680f\u52a9\u624b\u7684\u667a\u80fd\u4f53\u5c06\u6839\u636e\u7528\u6237\u6253\u5f00\u7684\u5e94\u7528\u8fc7\u6ee4\u663e\u793a\u3002", (String)"GaiAgentFormPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(PROLOGUE_TIPS, (Object)ResManager.loadKDString((String)"\u586b\u5199\u5f15\u5bfc\u8bed\uff0c\u4fa7\u8fb9\u680f\u52a9\u624b\u89e6\u53d1\u8be5\u667a\u80fd\u4f53\uff0c\u4f1a\u5c06\u5f15\u5bfc\u8bed\u53d1\u7ed9\u7528\u6237\u3002", (String)"GaiAgentFormPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(START_TIPS, (Object)ResManager.loadKDString((String)"\u7ed3\u5408\u667a\u80fd\u4f53\u7684\u529f\u80fd\uff0c\u8bbe\u7f6e\u51e0\u4e2a\u7b80\u6d01\u660e\u4e86\u7684\u95ee\u9898\uff0c\u5f15\u5bfc\u7528\u6237\u4f7f\u7528\u3002", (String)"GaiAgentFormPlugin_11", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(DESCRIPTION_TIPS, (Object)ResManager.loadKDString((String)"\u7b80\u6d01\u3001\u6e05\u6670\u5730\u63cf\u8ff0\u5176\u4f5c\u7528\u3002", (String)"GaiAgentFormPlugin_16", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(ADVANCED_CONFIG_TIPS, (Object)ResManager.loadKDString((String)"\u6807\u51c6ReAct\u548cFunctionCall", (String)"GaiAgentFormPlugin_18", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue(ROLEDESC_TIPS, (Object)ResManager.loadKDString((String)"\u8be6\u7ec6\u63cf\u8ff0\u667a\u80fd\u4f53\u89d2\u8272\u8bbe\u5b9a\u3001\u529f\u80fd\uff0c\u5e2e\u52a9\u8bed\u8a00\u6a21\u578b\u66f4\u597d\u5730\u4e86\u89e3\u5176\u627f\u62c5\u7684\u5de5\u4f5c\u4efb\u52a1\u3002", (String)"GaiAgentFormPlugin_19", (String)"ai-gai-plugin", (Object[])new Object[0]));
    }

    private void initGaiInitConfig() {
        String chatSessionId = this.getChatSessionId();
        GaiInitConfig gaiInitConfig = new GaiInitConfig(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, SLIDEENV.AGENT, chatSessionId);
        GaiUtils.setUserAgree((GaiInitConfig)gaiInitConfig, (Long)RequestContext.get().getCurrUserId());
        Map resultMap = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
        this.playgroundSetData(resultMap);
        this.cacheAssistantInfo(chatSessionId, gaiInitConfig.getAssistantId());
    }

    private void setControlEnableStatus() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (dataEntity.getPkValue() != null && (Long)dataEntity.getPkValue() > 0L) {
            String agentName = dataEntity.getString("agentname");
            this.setLlmStyleFocusStatus(dataEntity.getString(KEY_LLMSTYLE_PREFIX));
            String type = (String)this.getModel().getValue("type");
            String enableStr = (String)this.getModel().getValue("enable");
            boolean enable = StringUtils.equalsIgnoreCase((CharSequence)enableStr, (CharSequence)EnableEnum.YES.getKeyStr());
            Boolean ispreset = (Boolean)this.getModel().getValue("ispreset");
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)AgentTypeEnum.SYSTEM.getId()) || enable) {
                this.getView().setEnable(Boolean.FALSE, EDIT_CONTROL_ARR);
            }
            if (ispreset.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, EDIT_CONTROL_ARR_LLM);
            }
            if (!enable && StringUtils.equalsIgnoreCase((CharSequence)agentName, (CharSequence)"query_entity")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BAR_SAVE});
            }
            if (!enable) {
                if (ispreset.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, EDIT_CONTROL_ARR_LLM);
                } else {
                    this.getView().setEnable(Boolean.TRUE, EDIT_CONTROL_ARR_2);
                }
            }
        } else {
            this.getModel().setValue("type", (Object)AgentTypeEnum.CUSTOM.getId());
            this.getModel().setValue("version", null);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldName = e.getKey();
        String type = (String)this.getModel().getValue("type");
        if (KEY_LLM.equals(fieldName)) {
            List instanceList;
            String language_model = (String)e.getValue();
            if (!(StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)AgentTypeEnum.SYSTEM.getId()) && language_model.length() <= 0 || (instanceList = AiccService.getAiccInstanceList()).contains(language_model))) {
                this.getView().updateView(fieldName);
                e.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u8fdb\u5165\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u5217\u8868\u4e2d\u914d\u7f6e\u6a21\u578bAPI\u53c2\u6570\u3002", (String)"GaiAgentFormPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal value;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_PICTURE)) {
            if (changeData[0] != null) {
                String picture = (String)changeData[0].getNewValue();
                if (picture == null) {
                    picture = PictureAvatarService.getPictureByAgentName(null);
                    this.getModel().setValue(KEY_PICTURE, (Object)picture);
                }
                if (picture != null) {
                    String fileName = picture.substring(picture.lastIndexOf(47) + 1, picture.lastIndexOf(46));
                    String[] fileNameBgColorArr = fileName.split("_", 2);
                    String bgColor = "#EAF6FF";
                    if (fileNameBgColorArr.length > 1) {
                        bgColor = String.format("#%s", fileNameBgColorArr[1]);
                    }
                    this.getModel().setValue("bgcolor", (Object)bgColor);
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"bgcolor")) {
            if (changeData[0] != null) {
                String bgColor = (String)changeData[0].getNewValue();
                this.initFlexTitleBgColor(bgColor);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"remembercount") && changeData[0] != null && (value = (BigDecimal)changeData[0].getNewValue()).compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue("remembercount", (Object)0);
        }
        this.initAgentPlaygroud();
    }

    private void initFlexTitleBgColor(String bgColor) {
        if (StringUtils.isNotEmpty((CharSequence)bgColor)) {
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("bc", bgColor);
            this.getView().updateControlMetadata(KEY_FLEX_TITLE, fieldMap);
            HashMap<String, String> bgMap = new HashMap<String, String>(1);
            bgMap.put("bc", bgColor);
            HashMap<String, HashMap<String, String>> itemMap = new HashMap<String, HashMap<String, String>>(1);
            itemMap.put("item", bgMap);
            this.getView().updateControlMetadata("name", itemMap);
        }
    }

    private void initAgentPlaygroud() {
        String chatSessionId = this.getChatSessionId();
        DynamicObject agentDo = this.getModel().getDataEntity(true);
        AgentSample agent = AgentService.trans2AgentSample((DynamicObject)agentDo);
        InitAgentPlaygroud initAgentPlaygroud = new InitAgentPlaygroud();
        initAgentPlaygroud.setChatSessionId(chatSessionId);
        initAgentPlaygroud.setAgent(agent);
        Map<String, Object> customData = GaiAgentFormPlugin.buildResult(ResultActionType.initAgentPlayground.name(), initAgentPlaygroud);
        this.playgroundSetData(customData);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        String name = property.getName();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            DynamicObject useOrgDo;
            String entityKey = "gai_agent_" + name;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection toolDoc = dataEntity.getDynamicObjectCollection(entityKey);
            ArrayList<Long> idList = new ArrayList<Long>(toolDoc.size());
            if (toolDoc != null) {
                for (DynamicObject toolDo : toolDoc) {
                    DynamicObject tempDo = toolDo.getDynamicObject(2);
                    if (tempDo == null) continue;
                    idList.add((Long)tempDo.getPkValue());
                }
                qFilters.add(new QFilter("id", "not in", idList));
            }
            if ((useOrgDo = (DynamicObject)this.getModel().getValue(KEY_USEORG)) != null) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.setShowApproved(false);
                qFilters.add(new QFilter(KEY_USEORG, "=", useOrgDo.getPkValue()));
                listShowParameter.getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    private void doSave(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        RequestContext rc = RequestContext.get();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        long orgId = rc.getOrgId();
        BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)dataEntity, (Long)orgId);
        if (dataEntity.getPkValue() != null && (Long)dataEntity.getPkValue() > 0L) {
            String agentName;
            if ((dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)GaiFormIdEnum.GAI_AGENT.getId())).getBoolean("enable")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91", (String)"GaiAgentFormPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)(agentName = dataEntity.getString("agentname")), (CharSequence)"query_entity")) {
                String entryKey = "gai_agent_repo";
                DynamicObjectCollection repoDoc = this.getModel().getEntryEntity(entryKey);
                if (repoDoc == null || repoDoc.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u77e5\u8bc6\u5e93\u3002", (String)"GaiAgentFormPlugin_17", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
        if (this.getToolsCount() > 30) {
            this.getView().showTipNotification(ResManager.loadKDString((String)String.format("\u5de5\u5177\u96c6\u4e2d\u914d\u7f6e\u7684\u5de5\u5177\u548c\u4efb\u52a1\u6d41\u603b\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7%s\u4e2a", 30), (String)"GaiAgentFormPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            this.doSave(args);
        }
    }

    private int getToolsCount() {
        int toolCount = this.getEntryNotNullRowCount("gai_agent_tool");
        int promptCount = this.getEntryNotNullRowCount("gai_agent_prompt");
        int processCount = this.getEntryNotNullRowCount("gai_agent_process");
        int toolsCount = toolCount + promptCount + processCount;
        return toolsCount;
    }

    private int getEntryNotNullRowCount(String entryKey) {
        int count = 0;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection doc = dataEntity.getDynamicObjectCollection(entryKey);
        if (doc != null) {
            for (DynamicObject entryDo : doc) {
                DynamicObject tempDo = entryDo.getDynamicObject(2);
                if (tempDo == null) continue;
                ++count;
            }
        }
        return count;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            DynamicObject agentDo = this.getModel().getDataEntity(true);
            String type = (String)this.getModel().getValue("type");
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)AgentTypeEnum.CUSTOM.getId())) {
                String number = agentDo.getString("number");
                agentDo.set("agentname", (Object)number);
                String llm = agentDo.getString(KEY_LLM);
                List serviceList = AiccService.getLlmList();
                for (Map service : serviceList) {
                    if (!llm.equals(service.get("number"))) continue;
                    agentDo.set("llmname", (Object)((String)service.get("name")));
                    Object modelTags = service.get("modelTags");
                    agentDo.set(KEY_ROLEMODE, (Object)"react");
                    if (modelTags == null || modelTags.equals("null")) break;
                    JSONArray jsonArray = JSONArray.parseArray((String)modelTags.toString());
                    for (Object arr : jsonArray) {
                        String tagKey = ((JSONObject)arr).getString("tagKey");
                        if (tagKey.equalsIgnoreCase("function_call")) {
                            agentDo.set(KEY_ROLEMODE, (Object)"functioncall");
                            continue;
                        }
                        agentDo.set(KEY_ROLEMODE, (Object)"react");
                    }
                }
                RequestContext rc = RequestContext.get();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentDo});
                long orgId = rc.getOrgId();
                BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)agentDo, (Long)orgId);
                this.getModel().setValue("agentname", (Object)number);
            }
            if (agentDo.getBoolean("enable")) {
                this.setControlEnableStatus();
            }
            this.initAgentPlaygroud();
        } else if (source instanceof StatusConvert) {
            String type = (String)this.getModel().getValue("type");
            String agentName = (String)this.getModel().getValue("agentname");
            Boolean ispreset = (Boolean)this.getModel().getValue("ispreset");
            Boolean enable = Boolean.FALSE;
            this.getView().setEnable(Boolean.TRUE, EDIT_CONTROL_ARR);
            if (StringUtils.equalsIgnoreCase((CharSequence)((StatusConvert)source).getType(), (CharSequence)"enable")) {
                enable = Boolean.TRUE;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)AgentTypeEnum.SYSTEM.getId()) || enable.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, EDIT_CONTROL_ARR);
            }
            if (ispreset.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, EDIT_CONTROL_ARR_LLM);
            }
            if (!enable.booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)agentName, (CharSequence)"query_entity")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BAR_SAVE});
            }
            if (!enable.booleanValue() && ispreset.booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, EDIT_CONTROL_ARR_2);
            }
            this.refreshAgentEditData();
        } else if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"templateclick")) {
                this.showTemplate();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"optimizeclick")) {
                this.showOptimize();
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)KEY_LLMSTYLE_PREFIX)) {
            String llmStyleValue = key.split("_", 2)[1];
            this.setLlmStyleFocusStatus(llmStyleValue);
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)KEY_FLEX_PICTURE_CLICK)) {
            this.showPictureSelector();
        } else if (FLEX_TEMPLATE.equals(key) || FLEX_WRAP_TEMPLATE.equals(key)) {
            this.showTemplate();
        } else if (FLEX_OPTIMIZE.equals(key) || FLEX_WRAP_OPTIMIZE.equals(key)) {
            this.showOptimize();
        }
    }

    private void showTemplate() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
        lsp.setFormId("bos_templatetreelistf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        lsp.setCustomParam("enable", (Object)EnableEnum.YES.getKeyStr());
        lsp.setLookUp(true);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700");
        inlineStyleCss.setWidth("1080");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_TEMPLATE_CALLBACK_ACTION_ID);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showOptimize() {
        if (null == this.getModel().getValue(KEY_LLM)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bed\u8a00\u6a21\u578b\u3002", (String)"GaiAgentFormPlugin_39", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("roledesc")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u89d2\u8272\u4e0e\u4efb\u52a1\u8bbe\u5b9a\u4fe1\u606f\u3002", (String)"GaiAgentFormPlugin_40", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        OrmLocaleValue nameOlv = (OrmLocaleValue)this.getModel().getValue("name");
        String input = (String)this.getModel().getValue("roledesc_tag");
        String serviceNumber = (String)this.getModel().getValue(KEY_LLM);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(GaiFormIdEnum.GAI_SIMPLE_CHAT.getId());
        fsp.setShowTitle(false);
        fsp.setShowClose(false);
        OpenStyle openStyle = fsp.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("80%");
        inlineStyleCss.setWidth("60%");
        openStyle.setInlineStyleCss(inlineStyleCss);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "simpleChatResult"));
        String userInput = Constant.GaiPrompt.TEMPLATE_DEFAULT_PROMPT;
        String templateValue = GaiParamConfigService.getConfigValue((String)ParamConfigEnum.PROMPT_OPTIMITIZE_TEMPLATE.getId());
        if (StringUtils.isNotEmpty((CharSequence)templateValue) && StrUtils.isValidJSONObject((String)templateValue)) {
            PromptOptimizeTemplate template = (PromptOptimizeTemplate)JSONObject.parseObject((String)templateValue, PromptOptimizeTemplate.class);
            userInput = StringUtils.isNotEmpty((CharSequence)template.getPrompt()) ? template.getPrompt() : Constant.GaiPrompt.TEMPLATE_DEFAULT_PROMPT;
            serviceNumber = StringUtils.isNotEmpty((CharSequence)template.getLlm()) ? template.getLlm() : serviceNumber;
        }
        userInput = StringUtils.replace((String)userInput, (String)"{{name}}", (String)nameOlv.getLocaleValue());
        userInput = StringUtils.replace((String)userInput, (String)"{{prompt}}", (String)input);
        fsp.setCustomParam("userInput", (Object)userInput);
        fsp.setCustomParam("serviceNumber", (Object)serviceNumber);
        this.getView().showForm(fsp);
    }

    private void setLlmStyleFocusStatus(String llmStyleValue) {
        if (StringUtils.isEmpty((CharSequence)llmStyleValue)) {
            llmStyleValue = DEFAULT_LLM_STYLE;
        }
        for (String llmStyle : LLM_STYLE_ARR) {
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            HashMap<String, Map<String, Map<String, String>>> borderMap = new HashMap<String, Map<String, Map<String, String>>>();
            if (!StringUtils.equalsIgnoreCase((CharSequence)llmStyleValue, (CharSequence)llmStyle)) {
                this.getModel().setValue(KEY_LLMSTYLE_PREFIX, (Object)llmStyleValue.toUpperCase());
                String color = DEFAULT_BORDER_COLOR;
                Map<String, Map<String, String>> map2 = this.getBorderMap(color);
                borderMap.put("s", map2);
            } else {
                fieldMap.put("bc", ENABLE_COLOR);
                Map<String, Map<String, String>> map2 = this.getBorderMap(this.getThemeColor());
                borderMap.put("s", map2);
            }
            this.getView().updateControlMetadata(KEY_LLMSTYLE_FLEX_PREFIX + llmStyle, fieldMap);
            this.getView().updateControlMetadata(KEY_LLMSTYLE_FLEX_PREFIX + llmStyle, borderMap);
            this.getView().updateControlMetadata(KEY_LLMSTYLE_VECTOR_PREFIX + llmStyle, fieldMap);
            this.getView().updateControlMetadata(KEY_LLMSTYLE_LABEL_PREFIX + llmStyle, fieldMap);
        }
    }

    private Map<String, Map<String, String>> getBorderMap(String color) {
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("r", "1px_solid_" + color);
        map3.put("l", "1px_solid_" + color);
        map3.put("t", "1px_solid_" + color);
        map3.put("b", "1px_solid_" + color);
        HashMap<String, Map<String, String>> map2 = new HashMap<String, Map<String, String>>();
        map2.put("b", map3);
        return map2;
    }

    private void showOpenAPISelectList() {
        Object[] selectedIdArr = this.getSelectedIdArr(KEY_OPENAPI);
        ListShowParameter lsp = new ListShowParameter();
        String billFormId = "openapi_apilist";
        lsp.setShowApproved(true);
        lsp.setBillFormId(billFormId);
        lsp.setFormId("bos_listf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        lsp.setMultiSelect(Boolean.TRUE.booleanValue());
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700");
        inlineStyleCss.setWidth("1200");
        lsp.setSelectedRows(selectedIdArr);
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), KEY_OPENAPI));
        lsp.setLookUp(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showSkillF7(String skillType) {
        Object[] selectedIdArr = this.getSelectedIdArr(skillType);
        ListShowParameter lsp = new ListShowParameter();
        String billFormId = this.getBillFormId(skillType);
        lsp.setShowApproved(true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
        DynamicObject useOrgDo = (DynamicObject)this.getModel().getValue(KEY_USEORG);
        if (useOrgDo != null) {
            qFilters.add(new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_REPO)) {
            // empty if block
        }
        if (qFilters != null && qFilters.size() > 0) {
            lsp.getListFilterParameter().setQFilters(qFilters);
        }
        lsp.setSelectedRows(selectedIdArr);
        if (!StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_TOOL) && !StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_OPENAPI)) {
            lsp.setBillFormId(billFormId);
            lsp.setFormId("bos_listf7");
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setShowTitle(false);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("700");
            inlineStyleCss.setWidth("1200");
            lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            lsp.setLookUp(true);
            lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), skillType));
            this.getView().showForm((FormShowParameter)lsp);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_OPENAPI)) {
            this.showOpenAPISelectList();
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("gai_tool_select_custom");
            DynamicObject agentDo = this.getModel().getDataEntity(true);
            DynamicObjectCollection toolDoc = agentDo.getDynamicObjectCollection("gai_agent_tool");
            JSONArray selected_tool = new JSONArray();
            HashMap<String, JSONObject> maps = new HashMap<String, JSONObject>(16);
            if (toolDoc != null) {
                for (DynamicObject tempDo : toolDoc) {
                    String selected_tag = tempDo.getString("selected_tag");
                    if (selected_tag == null || selected_tag.length() <= 0) continue;
                    JSONObject jsonObject = JSONObject.parseObject((String)selected_tag);
                    String toolId = jsonObject.getString("toolId");
                    if (maps.get(toolId) == null) {
                        maps.put(toolId, jsonObject);
                        continue;
                    }
                    String operationId = jsonObject.getString("operations");
                    JSONObject json = (JSONObject)maps.get(toolId);
                    String operationIds = json.getString("operations");
                    json.put("operations", (Object)String.format("%s,%s", operationIds, operationId));
                    maps.put(toolId, json);
                }
                Set entries = maps.entrySet();
                for (Map.Entry entry : entries) {
                    selected_tool.add(entry.getValue());
                }
            }
            if (selected_tool.size() > 0) {
                formShowParameter.setCustomParam("selected_tool_config", (Object)selected_tool);
            }
            formShowParameter.setCustomParam("is_process", (Object)false);
            formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), skillType));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    private String getThemeColor() {
        Map map = UserServiceHelper.getUserThemeNumAndVerNew((Long)RequestContext.get().getCurrUserId());
        return (String)map.get("color");
    }

    private void refreshAgentEditData() {
        String Agenttype = (String)this.getModel().getValue("type");
        if (!StringUtils.equalsIgnoreCase((CharSequence)Agenttype, (CharSequence)AgentTypeEnum.SYSTEM.getId())) {
            ComboEdit llm = (ComboEdit)this.getControl(KEY_LLM);
            llm.setMustInput(true);
            llm.setDroppable(false);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean enable = dataEntity.getBoolean("enable");
        boolean ispreset = dataEntity.getBoolean("ispreset");
        String agentName = dataEntity.getString("agentname");
        String agentType = dataEntity.getString("type");
        DynamicObjectCollection toolDoc = dataEntity.getDynamicObjectCollection("gai_agent_tool");
        DynamicObjectCollection processDoc = dataEntity.getDynamicObjectCollection("gai_agent_process");
        DynamicObjectCollection promptDoc = dataEntity.getDynamicObjectCollection("gai_agent_prompt");
        DynamicObjectCollection repoDoc = dataEntity.getDynamicObjectCollection("gai_agent_repo");
        JSONObject dataJo = new JSONObject();
        JSONObject toolJo = new JSONObject();
        if (toolDoc != null) {
            toolJo.put("title", (Object)ResManager.loadKDString((String)"\u5de5\u5177", (String)"GaiAgentFormPlugin_33", (String)"ai-gai-plugin", (Object[])new Object[0]));
            toolJo.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u5de5\u5177\uff0c\u6269\u5c55\u667a\u80fd\u4f53\u7684\u80fd\u529b\u548c\u4f7f\u7528\u573a\u666f\u3002", (String)"GaiAgentFormPlugin_12", (String)"ai-gai-plugin", (Object[])new Object[0]));
            ArrayList<AgentSkill> agentSkillList = new ArrayList<AgentSkill>(toolDoc.size());
            if (toolDoc != null) {
                for (int i = 0; i < toolDoc.size(); ++i) {
                    DynamicObject selectedDo = (DynamicObject)toolDoc.get(i);
                    DynamicObject tempDo = selectedDo.getDynamicObject(KEY_TOOL);
                    String selected_tag = selectedDo.getString("selected_tag");
                    if (tempDo == null) continue;
                    String operationName = null;
                    String operationDes = null;
                    String operationId = null;
                    String type = tempDo.getString("tool_type");
                    if (selected_tag != null && selected_tag.length() > 0) {
                        JSONObject json = JSONObject.parseObject((String)selected_tag);
                        operationName = json.getString("operationName");
                        operationDes = json.getString("operationDescription");
                        operationId = json.getString("operations");
                    }
                    String name = null;
                    String description = null;
                    name = tempDo.getString("name");
                    description = operationDes != null ? operationDes : tempDo.getString("description");
                    operationId = operationId != null ? tempDo.getPkValue() + "_" + operationId : tempDo.getPkValue() + "";
                    String typeName = ToolConstant.ToolType.getName((String)type);
                    AgentSkill agentSkill = new AgentSkill(operationId + "", name, tempDo.getString("number"), description, type, typeName, operationName);
                    agentSkillList.add(agentSkill);
                }
            }
            toolJo.put("list", agentSkillList);
        }
        dataJo.put(KEY_TOOL, (Object)toolJo);
        JSONObject flowJo = new JSONObject();
        if (processDoc != null) {
            flowJo.put("title", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6d41", (String)"GaiAgentFormPlugin_35", (String)"ai-gai-plugin", (Object[])new Object[0]));
            flowJo.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u5de5\u4f5c\u6d41\uff0c\u6267\u884c\u56fa\u5b9a\u4efb\u52a1\u3002", (String)"GaiAgentFormPlugin_13", (String)"ai-gai-plugin", (Object[])new Object[0]));
            ArrayList<AgentSkill> agentSkillList = new ArrayList<AgentSkill>(processDoc.size());
            if (processDoc != null) {
                for (int i = 0; i < processDoc.size(); ++i) {
                    DynamicObject selectedDo = (DynamicObject)processDoc.get(i);
                    DynamicObject tempDo = selectedDo.getDynamicObject(2);
                    if (tempDo == null) continue;
                    AgentSkill skill = new AgentSkill(tempDo.getPkValue() + "", tempDo.getString("name"), tempDo.getString("number"), tempDo.getString("servicedesc"));
                    agentSkillList.add(skill);
                }
            }
            flowJo.put("list", agentSkillList);
        }
        dataJo.put(KEY_PROCESS, (Object)flowJo);
        JSONObject promptJo = new JSONObject();
        if (promptDoc != null) {
            promptJo.put("title", (Object)ResManager.loadKDString((String)"\u63d0\u793a\u8bcd", (String)"GaiAgentFormPlugin_38", (String)"ai-gai-plugin", (Object[])new Object[0]));
            promptJo.put("description", (Object)ResManager.loadKDString((String)"\u9009\u62e9\u5df2\u914d\u7f6e\u7684\u63d0\u793a\u8bcd\u3002", (String)"GaiAgentFormPlugin_14", (String)"ai-gai-plugin", (Object[])new Object[0]));
            ArrayList<AgentSkill> agentSkillList = new ArrayList<AgentSkill>(promptDoc.size());
            if (promptDoc != null) {
                for (int i = 0; i < promptDoc.size(); ++i) {
                    DynamicObject selectedDo = (DynamicObject)promptDoc.get(i);
                    DynamicObject tempDo = selectedDo.getDynamicObject(2);
                    if (tempDo == null) continue;
                    AgentSkill skill = new AgentSkill(tempDo.getPkValue() + "", tempDo.getString("name"), tempDo.getString("number"), tempDo.getString("desc"));
                    agentSkillList.add(skill);
                }
            }
            promptJo.put("list", agentSkillList);
        }
        dataJo.put(KEY_PROMPT, (Object)promptJo);
        JSONObject knowledgeJo = new JSONObject();
        if (repoDoc != null) {
            knowledgeJo.put("title", (Object)ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93", (String)"GaiAgentFormPlugin_31", (String)"ai-gai-plugin", (Object[])new Object[0]));
            knowledgeJo.put("description", (Object)ResManager.loadKDString((String)"\u9009\u62e9\u53ef\u7528\u7684\u77e5\u8bc6\u5e93\u4f5c\u4e3a\u4e0a\u4e0b\u6587\u3002", (String)"GaiAgentFormPlugin_15", (String)"ai-gai-plugin", (Object[])new Object[0]));
            ArrayList<AgentSkill> agentSkillList = new ArrayList<AgentSkill>(repoDoc.size());
            if (repoDoc != null) {
                for (int i = 0; i < repoDoc.size(); ++i) {
                    DynamicObject selectedDo = (DynamicObject)repoDoc.get(i);
                    DynamicObject tempDo = selectedDo.getDynamicObject(2);
                    if (tempDo == null) continue;
                    String type = "qa";
                    String typeName = RepoTypeEnum.getName((String)type);
                    int fileCount = tempDo.getInt("knlcount");
                    AgentSkill skill = new AgentSkill(tempDo.getPkValue() + "", tempDo.getString("name"), tempDo.getString("number"), tempDo.getString("desc"), type, typeName, fileCount);
                    agentSkillList.add(skill);
                }
            }
            knowledgeJo.put("list", agentSkillList);
            knowledgeJo.put(CUSTOM_EVENT_REPO_EDIT, this.getModel().getValue("repoautocall"));
        }
        dataJo.put("skillTitle", (Object)ResManager.loadKDString((String)"\u6280\u80fd", (String)"GaiAgentFormPlugin_32", (String)"ai-gai-plugin", (Object[])new Object[0]));
        dataJo.put("memoryTitle", (Object)ResManager.loadKDString((String)"\u8bb0\u5fc6", (String)"GaiAgentFormPlugin_34", (String)"ai-gai-plugin", (Object[])new Object[0]));
        boolean editable = true;
        if (enable || StringUtils.equalsIgnoreCase((CharSequence)agentType, (CharSequence)AgentTypeEnum.SYSTEM.getId()) || ispreset) {
            editable = false;
        }
        dataJo.put(KEY_EDITABLE, (Object)editable);
        JSONObject configJo = new JSONObject();
        boolean repoEditable = editable;
        if (!enable && StringUtils.equalsIgnoreCase((CharSequence)agentName, (CharSequence)"query_entity")) {
            repoEditable = true;
        }
        configJo.put(KEY_REPO_EDITABLE, (Object)repoEditable);
        dataJo.put("config", (Object)configJo);
        dataJo.put(KEY_REPO, (Object)knowledgeJo);
        Map<String, Object> customData = GaiAgentFormPlugin.buildResult(ResultActionType.agentEdit.name(), dataJo);
        this.agentEditSetData(customData);
    }

    private Object[] getSelectedIdArr(String skillType) {
        Object[] pkArr = new Object[]{};
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection selectedDoc = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_TOOL)) {
            selectedDoc = dataEntity.getDynamicObjectCollection("gai_agent_tool");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_PROCESS)) {
            selectedDoc = dataEntity.getDynamicObjectCollection("gai_agent_process");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_PROMPT)) {
            selectedDoc = dataEntity.getDynamicObjectCollection("gai_agent_prompt");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_REPO)) {
            selectedDoc = dataEntity.getDynamicObjectCollection("gai_agent_repo");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_OPENAPI)) {
            selectedDoc = dataEntity.getDynamicObjectCollection("gai_agent_openapi");
        }
        if (selectedDoc != null) {
            pkArr = new Object[selectedDoc.size()];
            for (int i = 0; i < selectedDoc.size(); ++i) {
                DynamicObject tempDo = ((DynamicObject)selectedDoc.get(i)).getDynamicObject(2);
                if (tempDo == null) continue;
                pkArr[i] = tempDo.getPkValue();
            }
        }
        return pkArr;
    }

    private String getBillFormId(String skillType) {
        String billFormId = GaiFormIdEnum.GAI_TOOL.getId();
        if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_TOOL)) {
            billFormId = GaiFormIdEnum.GAI_TOOL.getId();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_PROCESS)) {
            billFormId = GaiFormIdEnum.GAI_PROCESS.getId();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_PROMPT)) {
            billFormId = GaiFormIdEnum.GAI_PROMPT.getId();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_REPO)) {
            billFormId = "aikm_knl_manager";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)KEY_OPENAPI)) {
            billFormId = "openapi_apilist";
        }
        return billFormId;
    }

    private void showPictureSelector() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(GaiFormIdEnum.GAI_PICTURE_DLG.getId());
        fsp.setCustomParam(KEY_PICTURE, this.getModel().getValue(KEY_PICTURE));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_PICTURE));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        String billFormId = this.getBillFormId(KEY_TOOL);
        ArrayList<Long> idArrs = new ArrayList<Long>();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_TOOL, (CharSequence)actionId)) {
            if (returnData instanceof DynamicObject) {
                DynamicObject dynamicObject = (DynamicObject)returnData;
                long toolId = dynamicObject.getLong("id");
                String source = dynamicObject.getString("source");
                String toolName = dynamicObject.getString("name");
                if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId("gai_tool_detail");
                    fsp.setCustomParam("id", (Object)toolId);
                    fsp.setCaption(toolName);
                    fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(fsp);
                } else {
                    FormShowParameter lsp = new FormShowParameter();
                    lsp.setCustomParam("toolId", (Object)toolId);
                    lsp.setFormId(TOOL_EDIT_FORM_ID);
                    lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    lsp.setShowTitle(true);
                    this.getView().showForm(lsp);
                }
            } else {
                JSONArray toolArray = (JSONArray)returnData;
                if (toolArray != null) {
                    DynamicObjectCollection toolDoc = this.getModel().getDataEntity(true).getDynamicObjectCollection("gai_agent_tool");
                    toolDoc.clear();
                    for (int i = 0; i < toolArray.size(); ++i) {
                        JSONObject toolJo = toolArray.getJSONObject(i);
                        idArrs.add(toolJo.getLongValue("toolId"));
                    }
                    Map doArrs = BusinessDataServiceHelper.loadFromCache((Object[])idArrs.toArray(new Object[0]), (String)billFormId);
                    if (doArrs != null && !doArrs.isEmpty()) {
                        for (int i = 0; i < toolArray.size(); ++i) {
                            JSONObject toolJo = toolArray.getJSONObject(i);
                            JSONObject jo = new JSONObject();
                            jo.put("toolId", (Object)toolJo.getString("toolId"));
                            if (toolJo.getString("operationId") != null) {
                                jo.put("operations", (Object)toolJo.getString("operationId"));
                                jo.put("operationName", (Object)toolJo.getString("operationName"));
                                jo.put("operationDescription", (Object)toolJo.getString("operationDescription"));
                            }
                            DynamicObject dynamicObject = new DynamicObject(toolDoc.getDynamicObjectType());
                            dynamicObject.set("selected_tag", (Object)jo.toJSONString());
                            dynamicObject.set(KEY_TOOL, doArrs.get(toolJo.getLong("toolId")));
                            toolDoc.add((Object)dynamicObject);
                        }
                        this.getModel().updateEntryCache(toolDoc);
                        this.getView().updateView("gai_agent_tool");
                    }
                }
                this.refreshAgentEditData();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_PICTURE, (CharSequence)actionId)) {
            JSONObject dataJo = (JSONObject)returnData;
            if (dataJo != null) {
                String picture = dataJo.getString(KEY_PICTURE);
                String background = dataJo.getString(KEY_BACKGROUND);
                if (StringUtils.isNotEmpty((CharSequence)background)) {
                    background = String.format("#%s", background);
                }
                this.getModel().setValue(KEY_PICTURE, (Object)picture);
                this.getModel().setValue("bgcolor", (Object)background);
            }
        } else if ("agreementClose".equals(actionId)) {
            this.getView().getPageCache().remove("showAgreement");
            CustomControl customControl = (CustomControl)this.getControl("gpt_gai");
            if (returnData == null) {
                return;
            }
            String chatSessionId = this.getChatSessionId();
            GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
            if ("userAgree".equals(returnData)) {
                gaiInitConfig.setUserAgree(true);
            } else if ("userDisagree".equals(returnData)) {
                gaiInitConfig.setUserAgree(false);
            }
            Map resultMap = ResultVoHelper.buildUserAgree((GaiInitConfig)gaiInitConfig);
            log.info("agreementClose resultMap:{}", (Object)JSONObject.toJSONString((Object)resultMap));
            customControl.setData((Object)resultMap);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)actionId, (CharSequence)SELECT_TEMPLATE_CALLBACK_ACTION_ID)) {
            if (returnData != null) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows.isEmpty()) {
                    return;
                }
                StringBuilder toolStr = new StringBuilder();
                String roleTag = (String)this.getModel().getValue("roledesc_tag");
                if (StringUtils.isNotEmpty((CharSequence)roleTag) && roleTag.trim().length() > 0) {
                    toolStr.append(roleTag).append("\r\n\r\n");
                }
                for (ListSelectedRow selectedRow : selectedRows) {
                    Object templatePk = selectedRow.getPrimaryKeyValue();
                    DynamicObject templateDo = BusinessDataServiceHelper.loadSingle((Object)templatePk, (String)GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
                    String templateTag = templateDo.getString("prompt_tag");
                    String templateName = templateDo.getString("name");
                    toolStr.append("#####").append(templateName).append("#####").append("\r\n");
                    toolStr.append(templateTag).append("\r\n\r\n");
                }
                this.getModel().setValue("roledesc_tag", (Object)toolStr);
            }
            this.getView().updateView();
        } else if ("simpleChatResult".equals(actionId)) {
            if (event.getReturnData() != null) {
                JSONObject resultJo = (JSONObject)event.getReturnData();
                this.getModel().setValue("roledesc_tag", (Object)resultJo.getString("message"));
                this.getView().updateView();
            }
        } else if (returnData instanceof ListSelectedRowCollection) {
            String skillType = actionId;
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                Object[] idArr = new Object[listSelectedRowCollection.size()];
                for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                    ListSelectedRow listSelectedRow = listSelectedRowCollection.get(i);
                    idArr[i] = listSelectedRow.getPrimaryKeyValue();
                }
                this.skillEntrySetData(skillType, idArr);
                if (this.getToolsCount() > 30) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)String.format("\u5de5\u5177\u96c6\u4e2d\u914d\u7f6e\u7684\u5de5\u5177\u548c\u4efb\u52a1\u6d41\u603b\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7%s\u4e2a", 30), (String)"GaiAgentFormPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void skillEntrySetData(String skillType, Object[] idArr) {
        String billFormId;
        DynamicObject[] doArr;
        String entryKey = "gai_agent_" + skillType;
        this.getModel().deleteEntryData(entryKey);
        if (idArr != null && idArr.length > 0 && (doArr = BusinessDataServiceHelper.load((Object[])idArr, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)(billFormId = this.getBillFormId(skillType))).getDynamicObjectType())) != null && doArr.length > 0) {
            int i;
            DynamicObject[] arr = new DynamicObject[doArr.length];
            for (i = 0; i < doArr.length; ++i) {
                for (int j = 0; j < idArr.length; ++j) {
                    if (!doArr[i].getString("id").equals(idArr[j].toString())) continue;
                    arr[j] = doArr[i];
                }
            }
            this.getModel().batchCreateNewEntryRow(entryKey, arr.length);
            for (i = 0; i < arr.length; ++i) {
                DynamicObject skillDo = arr[i];
                this.getModel().setValue(skillType, (Object)skillDo, i);
            }
        }
        this.refreshAgentEditData();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    /*
     * Unable to fully structure code
     */
    public void customEvent(CustomEventArgs e) {
        block32: {
            block31: {
                super.customEvent(e);
                controlKey = e.getKey();
                eventName = e.getEventName();
                args = e.getEventArgs();
                if (!"gpt_gai".equals(controlKey)) break block31;
                chatSessionId = this.getChatSessionId();
                context = FlowCacheData.getContext((String)chatSessionId);
                requestActionType = RequestActionType.valueOf((String)eventName);
                requestData = JSON.parseObject((String)args);
                switch (1.$SwitchMap$kd$ai$gai$core$enuz$RequestActionType[requestActionType.ordinal()]) {
                    case 1: {
                        fileMetadata = (FileMetadata)JSONObject.parseObject((String)args, FileMetadata.class);
                        this.saveFile(fileMetadata);
                        break;
                    }
                    case 2: {
                        skillId = Long.parseLong(requestData.getOrDefault((Object)"skillId", (Object)StrUtils.longAsString((Long)0L)).toString());
                        skill = new Skill();
                        skill.setId(String.valueOf(skillId));
                        skill.setType(Skill.Type.AGENT);
                        skill.setSkillSrc(SkillSrcEnum.USER);
                        GaiUtils.refreshBizPageId((Context)context, (IFormView)this.getView(), (Long)10000L);
                        this.cacheAgentInfo(chatSessionId, String.valueOf(skillId));
                        context.setCurrentSkill(skill);
                        FlowCacheData.putContext((String)context.getChatSessionId(), (Context)context);
                        input = (String)requestData.getOrDefault((Object)"input", (Object)"");
                        chatMessage = new ChatMessage();
                        chatMessage.setSkillId(skillId);
                        chatMessage.setSkillType(Skill.Type.AGENT);
                        chatMessage.setUserInput(input);
                        chatMessage.setChatSessionId(chatSessionId);
                        chatMessage.setInParaMap(null);
                        HandlerFactory.runHandler((Context)context, (Message)chatMessage);
                        break;
                    }
                    case 3: {
                        this.initAgentPlaygroud();
                        break;
                    }
                    case 4: {
                        this.initGaiInitConfig();
                        break;
                    }
                    case 5: {
                        runId = Long.parseLong(requestData.getString("runId"));
                        traceId = TraceUtil.getAgentTraceIdByRunId((String)chatSessionId, (long)runId);
                        traceLogs = MonitorServiceHelper.queryTraceLogs((long)traceId);
                        queryTraceLogs = ResultVoHelper.buildResult((String)ResultActionType.queryTraceLogs.name(), (Object)traceLogs, (Context)context);
                        this.playgroundSetData(queryTraceLogs);
                        break;
                    }
                    case 6: {
                        formAnnotation = (FormAnnotation)JSONObject.parseObject((String)args, FormAnnotation.class);
                        AnnotationService.showFormByAnnotation((IFormView)this.getView(), (FormAnnotation)formAnnotation);
                        break;
                    }
                    case 7: {
                        this.showNotification(requestData);
                        break;
                    }
                    case 8: {
                        this.showAgreement();
                        break;
                    }
                    case 9: {
                        ChatService.agentCancel((String)chatSessionId, (long)0L);
                        context = FlowCacheData.getContext((String)chatSessionId);
                        taskId = requestData.getString("taskId");
                        flowId = requestData.getString("flowId");
                        FlowUtils.stopChat((Context)context, (String)taskId, (String)flowId);
                        break;
                    }
                    case 10: {
                        GaiUtils.newContextInAgentPlayground((IFormView)this.getView());
                        chatSessionId = this.getChatSessionId();
                        dataJo = new JSONObject();
                        timestamp = requestData.getString("timestamp");
                        if (StringUtils.isNotEmpty((CharSequence)timestamp)) {
                            dataJo.put("timestamp", (Object)timestamp);
                        }
                        dataJo.put("id", (Object)chatSessionId);
                        resultMap = ResultVoHelper.buildResult((String)ResultActionType.newChat.name(), (Object)dataJo, (Context)context);
                        this.playgroundSetData(resultMap);
                        break;
                    }
                    case 11: {
                        this.openTraceData(chatSessionId);
                        break;
                    }
                    case 12: {
                        item = (ContextData.Item)JSON.parseObject((String)String.valueOf(requestData), ContextData.Item.class);
                        AbstractGaiAssistantPlugin.preview(this.getView(), item);
                        return;
                    }
                }
                break block32;
            }
            if (!"agent_edit".equalsIgnoreCase(controlKey)) break block32;
            requestData = JSON.parseObject((String)args);
            var6_8 = eventName;
            var7_10 = -1;
            switch (var6_8.hashCode()) {
                case -1247175120: {
                    if (!var6_8.equals("addSkill")) break;
                    var7_10 = 0;
                    break;
                }
                case 802825478: {
                    if (!var6_8.equals("delSkill")) break;
                    var7_10 = 1;
                    break;
                }
                case -1584365908: {
                    if (!var6_8.equals("viewSkill")) break;
                    var7_10 = 2;
                    break;
                }
                case 393950441: {
                    if (!var6_8.equals("repoAutoCallEdit")) break;
                    var7_10 = 3;
                    break;
                }
                case -1701504337: {
                    if (!var6_8.equals("agentEdit")) break;
                    var7_10 = 4;
                }
            }
            switch (var7_10) {
                case 0: {
                    skillType = requestData.getString("skillType");
                    this.showSkillF7(skillType);
                    break;
                }
                case 1: {
                    skillType = requestData.getString("skillType");
                    skillIds = requestData.getString("skillIds");
                    skillIdList = Arrays.asList(StringUtils.split((String)skillIds, (String)","));
                    this.delSkill(skillType, skillIdList);
                    break;
                }
                case 2: {
                    skillType = requestData.getString("skillType");
                    skillId = requestData.getString("skillId");
                    billFormId = this.getBillFormId(skillType);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)"tool")) ** GOTO lbl130
                    id = skillId.split("_");
                    this.showToolSkill(id[0], billFormId, this.getView());
                    ** GOTO lbl137
lbl130:
                    // 1 sources

                    if (!StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)"repo")) ** GOTO lbl133
                    this.showRepo(skillId, billFormId, this.getView());
                    ** GOTO lbl137
lbl133:
                    // 1 sources

                    if (StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)"openapi")) {
                        this.showOpenApi(skillId, billFormId, this.getView());
                    } else {
                        new ShowBillAction(billFormId, ShowType.MainNewTabPage, skillId, OperationStatus.VIEW).operate(this.getView());
                    }
                }
lbl137:
                // 5 sources

                case 3: {
                    repoAutoCall = requestData.getString("repoautocall");
                    this.getModel().setValue("repoautocall", (Object)repoAutoCall);
                }
                case 4: {
                    this.refreshAgentEditData();
                    break;
                }
            }
        }
    }

    private void showOpenApi(Object pk, String billFormId, IFormView view) {
        DynamicObject openApi = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billFormId);
        if (openApi != null) {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            BaseShowParameter fsp = new BaseShowParameter();
            fsp.setFormId("openapi_apilist");
            fsp.setPkId(pk);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setParentPageId(parentPageId);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private void showToolSkill(Object pk, String billFormId, IFormView view) {
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billFormId);
        if (tool != null) {
            String source = tool.getString("source");
            if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("gai_tool_detail");
                fsp.setCustomParam("id", pk);
                String toolName = tool.getString("name");
                fsp.setCaption(toolName);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
            } else {
                String toolType = tool.getString("tool_type");
                if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                    BillShowParameter bsp = new BillShowParameter();
                    bsp.setPkId(pk);
                    bsp.setFormId("gai_tool");
                    String toolName = tool.getString("name");
                    bsp.setCaption(toolName);
                    bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    bsp.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)bsp);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                    FormShowParameter lsp = new FormShowParameter();
                    lsp.setCustomParam("toolId", tool.getPkValue());
                    String toolName = tool.getString("name");
                    lsp.setCaption(toolName);
                    lsp.setFormId(TOOL_EDIT_FORM_ID);
                    lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    lsp.setStatus(OperationStatus.EDIT);
                    this.getView().showForm(lsp);
                }
            }
        }
    }

    private void showRepo(Object pk, String billFormId, IFormView view) {
        DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billFormId);
        if (repo != null) {
            String kmentityId = repo.getString("kmentityid");
            MainEntityType qaKMEntityType = EntityMetadataCache.getDataEntityTypeById((String)kmentityId);
            String name = qaKMEntityType.getName();
            ListShowParameter bsp = new ListShowParameter();
            bsp.setFormId("aikm_templatelist");
            bsp.setBillFormId(name);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            bsp.setListFilterParameter(listFilterParameter);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    private void delSkill(String skillType, List<String> skillIdList) {
        String entryKey = "gai_agent_" + skillType;
        if (skillType.equalsIgnoreCase("Tool")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection selectedDoc = dataEntity.getDynamicObjectCollection("gai_agent_tool");
            if (selectedDoc != null) {
                Iterator iterator = selectedDoc.iterator();
                while (iterator.hasNext()) {
                    DynamicObject doc = (DynamicObject)iterator.next();
                    String selected_tag = doc.getString("selected_tag");
                    if (selected_tag != null && selected_tag.length() > 0) {
                        String operationId = JSONObject.parseObject((String)selected_tag).getString("operations");
                        String toolId = JSONObject.parseObject((String)selected_tag).getString("toolId");
                        if (skillIdList == null || !skillIdList.contains(toolId + (operationId != null ? "_" + operationId : ""))) continue;
                        iterator.remove();
                        continue;
                    }
                    if (skillIdList == null || !skillIdList.contains(doc.getString("id"))) continue;
                    iterator.remove();
                }
            }
            this.refreshAgentEditData();
        } else {
            Object[] selectedIdArr = this.getSelectedIdArr(skillType);
            this.getModel().deleteEntryData(entryKey);
            ArrayList<Long> pkIdList = new ArrayList<Long>(selectedIdArr.length);
            if (selectedIdArr != null) {
                for (Object id : selectedIdArr) {
                    if (skillIdList == null || skillIdList.contains(String.valueOf(id))) continue;
                    pkIdList.add((Long)id);
                }
            }
            this.skillEntrySetData(skillType, pkIdList.toArray());
        }
    }

    private void showAgreement() {
        String pageId = this.getView().getPageCache().get("showAgreement");
        if (kd.bos.util.StringUtils.isNotEmpty((String)pageId)) {
            return;
        }
        this.getView().getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gai_privacy_agreement");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "agreementClose"));
        fsp.setCustomParam("agreementType", (Object)"userAgreement");
        this.getView().showForm(fsp);
    }

    private void showNotification(JSONObject requestData) {
        String method = (String)requestData.getOrDefault((Object)"method", (Object)TipsTypeEnum.SHOW_TIP_NOTIFICATION.getId());
        int duration = (Integer)requestData.getOrDefault((Object)"duration", (Object)"3500");
        String msg = requestData.getString("msg");
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_TIP_NOTIFICATION.getId())) {
            this.getView().showTipNotification(msg, Integer.valueOf(duration));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_SUCCESS_NOTIFICATION.getId())) {
            this.getView().showSuccessNotification(msg, Integer.valueOf(duration));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_ERROR_NOTIFICATION.getId())) {
            this.getView().showErrorNotification(msg);
        }
    }

    private void saveFile(FileMetadata fileMetadata) {
        fileMetadata.setPurpose(PurposeEnum.USER.getId());
        String name = fileMetadata.getName();
        if ((name.toLowerCase().endsWith("jpg") || name.toLowerCase().endsWith("png") || name.toLowerCase().endsWith("jpeg")) && fileMetadata.getFileSize() > 0xA00000L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u7247\u6587\u4ef6\u5927\u5c0f\u4e0d\u5141\u8bb8\u8d85\u8fc710M\u3002", (String)"GaiAgentFormPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        if (fileMetadata.getFileSize() > 0x9600000L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u666e\u901a\u6587\u4ef6\u5927\u5c0f\u4e0d\u5141\u8bb8\u8d85\u8fc7150M\u3002", (String)"GaiAgentFormPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        String chatSessionId = this.getChatSessionId();
        Context context = FlowCacheData.getContext((String)chatSessionId);
        fileMetadata.setId(chatSessionId);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setName(fileMetadata.getName());
        fileInfo.setFileSize(fileMetadata.getFileSize());
        fileInfo.setFileType(fileMetadata.getFileType());
        fileInfo.setFileUrl(fileMetadata.getFileUrl());
        fileInfo = FileService.save((FileInfo)fileInfo);
        fileMetadata.setFileId(StrUtils.longAsString((Long)fileInfo.getId()));
        fileMetadata.setFileUrl(fileInfo.getFileUrl());
        fileMetadata.setPreviewUrl(fileInfo.getPreviewUrl());
        PushMsgService.pushResult((Context)context, (String)ResultActionType.saveFileResult.name(), (Object)fileMetadata);
    }

    private void openTraceData(String chatSessionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_log_view");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
        showParameter.setCustomParam("origin", (Object)"session");
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4f1a\u8bdd\u8be6\u60c5-%s", (String)"GaiAgentFormPlugin_37", (String)"ai-gai-plugin", (Object[])new Object[0]), chatSessionId.substring(0, 8)));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void playgroundSetData(Map<String, Object> customData) {
        CustomControl customControl = (CustomControl)this.getControl("gpt_gai");
        customControl.setData(customData);
    }

    private void agentEditSetData(Map<String, Object> customData) {
        CustomControl customControl = (CustomControl)this.getControl(CUSTOM_CONTROL_AGENT_EDIT);
        customControl.setData(customData);
    }

    private void cacheAssistantInfo(String chatSessionId, String assistantId) {
        IAppCache appCache;
        if (!StringUtils.isEmpty((CharSequence)chatSessionId) && (appCache = EngineCache.getAppCache((String)chatSessionId)) != null) {
            appCache.put("_chat_session_assistant_cache_", (Object)assistantId);
        }
    }

    private void cacheAgentInfo(String chatSessionId, String agentId) {
        IAppCache appCache;
        if (!StringUtils.isEmpty((CharSequence)chatSessionId) && (appCache = EngineCache.getAppCache((String)chatSessionId)) != null) {
            appCache.put("_chat_session_agent_cache_", (Object)agentId);
        }
    }

    public static Map<String, Object> buildResult(String resultActionType, Object data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("type", resultActionType);
        dataMap.put("data", data);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("time", System.currentTimeMillis() + "");
        map.put("actionList", Collections.singletonList(dataMap));
        map.put("requestId", UUID.randomUUID().toString());
        return map;
    }
}

