/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.cache.SessionCache;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GaiAgentListPlugin
extends AbstractListPlugin {
    public static final String KEY_TBL_SYNC = "sync";
    public static final String KEY_NEW_AGENT = "newagent";
    public static Map<String, String> mapLlm = new HashMap<String, String>(16);

    public static List<ComboItem> createLlmComboItem() {
        List serviceList = AiccService.getLlmList();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(serviceList.size());
        for (Map service : serviceList) {
            boolean isLimit = (Boolean)service.get("limit");
            if (isLimit) continue;
            ComboItem comboItem = new ComboItem();
            if (!Boolean.TRUE.equals(service.get("active"))) continue;
            comboItem.setCaption(new LocaleString(service.get("name") + ResManager.loadKDString((String)"\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09", (String)"GaiAgentFormPlugin_36", (String)"ai-gai-plugin", (Object[])new Object[0])));
            comboItem.setValue((String)service.get("number"));
            list.add(comboItem);
        }
        return list;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        DynamicObject[] agentDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_AGENT.getId(), (String)"id,picture", (QFilter[])new QFilter("picture", "like", (Object)"/kingdee/%").toArray());
        if (agentDoArr != null && agentDoArr.length > 0) {
            for (DynamicObject agentDo : agentDoArr) {
                AgentService.checkPictureIfPreset((DynamicObject)agentDo);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Delete delete;
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Delete && (listSelectedData = (delete = (Delete)source).getListSelectedData()) != null && listSelectedData.size() > 0) {
            Object[] pkArray = listSelectedData.getPrimaryKeyValues();
            ArrayList<Long> usedAgentIdList = new ArrayList<Long>(3);
            DynamicObjectCollection skillDoArr = QueryServiceHelper.query((String)GaiFormIdEnum.GAI_SKILL.getId(), (String)"id,skillid", (QFilter[])new QFilter("skilltype", "=", (Object)Skill.Type.AGENT.name()).and("skillid", "in", Arrays.asList(pkArray)).toArray());
            if (skillDoArr != null) {
                for (DynamicObject skillDo : skillDoArr) {
                    usedAgentIdList.add(skillDo.getLong("skillid"));
                }
            }
            DynamicObject[] usedAgentDoArr = BusinessDataServiceHelper.load((Object[])usedAgentIdList.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_AGENT.getId()).getDynamicObjectType());
            ArrayList<String> numberList = new ArrayList<String>(3);
            if (usedAgentDoArr != null) {
                for (DynamicObject usedAgentDo : usedAgentDoArr) {
                    numberList.add(usedAgentDo.getString("number"));
                }
            }
            if (CollectionUtils.isNotEmpty(numberList)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"Common_DELETE_1", (String)"ai-gai-plugin", (Object[])new Object[0]), StringUtils.join((Object[])numberList.toArray(), (String)",")), Integer.valueOf(10000));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"refresh", (CharSequence)actionId)) {
            String lastNewAgentId = SessionCache.get().get("LAST_ADD_AGENT_ID");
            SessionCache.get().remove("LAST_ADD_AGENT_ID");
            if (lastNewAgentId != null && lastNewAgentId.length() > 0) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId(GaiFormIdEnum.GAI_AGENT.getId());
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setStatus(OperationStatus.EDIT);
                billShowParameter.setPkId((Object)Long.parseLong(lastNewAgentId));
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
            ((IListView)this.getView()).refresh();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }
}

