/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.ai.gai.core.enuz.agent.AgentPictureEnum;
import kd.ai.gai.core.service.agent.PictureAvatarService;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiAgentPictureDlgFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String KEY_PICTURE = "picture";
    private static final String KEY_BACKGROUND = "background";
    private static final String KEY_CUSTOM_PICTURE = "custompicture";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String CACHE_KEY_RETURN_DATA = "returnData";
    private static final String KEY_PICTURE_RADIO_GROUP = "pictureradiogroup";
    private static final String KEY_IMG_PREFIX = "img_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_CANCEL, KEY_BTN_OK});
        for (AgentPictureEnum agentPictureEnum : AgentPictureEnum.values()) {
            Control image = this.getControl(String.format("%s%s", KEY_IMG_PREFIX, agentPictureEnum.getId()));
            if (!(image instanceof ISuportClick)) continue;
            ((ISuportClick)image).addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)controlKey, (CharSequence)KEY_BTN_CANCEL)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String selectedPicture = (String)fsp.getCustomParam(KEY_PICTURE);
            this.getModel().setValue(KEY_CUSTOM_PICTURE, (Object)selectedPicture);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)controlKey, (CharSequence)KEY_BTN_OK)) {
            String pictureId = (String)this.getModel().getValue(KEY_PICTURE_RADIO_GROUP);
            String picture = null;
            String background = AgentPictureEnum.LIGHT_BLUE.getBackground();
            if (StringUtils.isNotEmpty((CharSequence)pictureId)) {
                AgentPictureEnum agentPictureEnum = AgentPictureEnum.fromId((String)pictureId);
                picture = agentPictureEnum.getPicture();
                picture = PictureAvatarService.uploadPresetPicture2ImageServer((String)picture);
                background = agentPictureEnum.getBackground();
            } else {
                picture = (String)this.getModel().getValue(KEY_CUSTOM_PICTURE);
            }
            JSONObject dataJo = new JSONObject();
            dataJo.put(KEY_PICTURE, (Object)picture);
            dataJo.put(KEY_BACKGROUND, (Object)background);
            this.getPageCache().put(CACHE_KEY_RETURN_DATA, JSONObject.toJSONString((Object)dataJo));
            this.getView().close();
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)controlKey, (CharSequence)KEY_IMG_PREFIX)) {
            this.getModel().setValue(KEY_PICTURE_RADIO_GROUP, (Object)controlKey.replace(KEY_IMG_PREFIX, ""));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_CUSTOM_PICTURE)) {
            String customPicture;
            String string = customPicture = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            if (StringUtils.isNotEmpty((CharSequence)customPicture)) {
                this.getModel().setValue(KEY_PICTURE_RADIO_GROUP, null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isCustomPicture = true;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String selectedPicture = (String)fsp.getCustomParam(KEY_PICTURE);
        AgentPictureEnum[] agentPictureEnums = AgentPictureEnum.values();
        if (agentPictureEnums != null && agentPictureEnums.length > 0) {
            for (AgentPictureEnum agentPictureEnum : agentPictureEnums) {
                String picture = agentPictureEnum.getPicture();
                Image image = (Image)this.getView().getControl(String.format("%s%s", KEY_IMG_PREFIX, agentPictureEnum.getId()));
                image.setUrl(picture);
                if (!StringUtils.contains((CharSequence)selectedPicture, (CharSequence)picture)) continue;
                this.getModel().setValue(KEY_PICTURE_RADIO_GROUP, (Object)agentPictureEnum.getId());
                isCustomPicture = false;
            }
        }
        if (isCustomPicture && StringUtils.isNotEmpty((CharSequence)selectedPicture)) {
            this.getModel().setValue(KEY_CUSTOM_PICTURE, (Object)selectedPicture);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        String returnData = this.getPageCache().get(CACHE_KEY_RETURN_DATA);
        JSONObject dataJo = null;
        if (StringUtils.isNotEmpty((CharSequence)returnData)) {
            dataJo = JSON.parseObject((String)returnData);
        }
        this.getView().returnDataToParent((Object)dataJo);
    }
}

