/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaiMCPToolDetailFormPlugin
extends AbstractFormPlugin {
    private static final Logger log = LoggerFactory.getLogger(GaiMCPToolDetailFormPlugin.class);
    private static final String INPUTTREE = "inputtree";
    private static final String OUTPUTTREE = "outputtree";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        long toolId = null != fsp.getCustomParam("toolId") ? (Long)fsp.getCustomParam("toolId") : 0L;
        JSONObject configJo = (JSONObject)fsp.getCustomParam("configJo");
        JSONObject apiInfo = (JSONObject)fsp.getCustomParam("apiInfoJo");
        this.getModel().setValue("api_name", (Object)apiInfo.getString("name"));
        this.getModel().setValue("api_description", (Object)apiInfo.getString("description"));
        JSONObject inputParams = apiInfo.getJSONObject("inputParams");
        this.buildInputParamTree(inputParams, INPUTTREE, -1);
        JSONObject outputParams = JSONObject.parseObject((String)"{\"isError\":{\"type\":\"boolean\",\"description\":\"\u63a5\u53e3\u6267\u884c\u662f\u5426\u9519\u8bef true-\u662f false-\u5426\"},\"content\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"required\":[\"text\"],\"properties\":{\"text\":{\"type\":\"string\",\"description\":\"\u63a5\u53e3\u6267\u884c\u7ed3\u679c\"}}}}}");
        this.buildOutputParamTree(outputParams, OUTPUTTREE, -1);
    }

    private void buildInputParamTree(JSONObject inputParams, String entryKey, int paranRow) {
        if (inputParams == null) {
            return;
        }
        Set entries = inputParams.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject paramObject;
            JSONObject inputParam = (JSONObject)entry.getValue();
            String type = inputParam.getString("type");
            if (type.equals("array")) {
                paramObject = inputParam.getJSONObject("items");
                type = paramObject.getString("type");
                if ("number".equals(type)) {
                    type = "float";
                }
                type = "array<" + type + ">";
            } else {
                paramObject = inputParam;
            }
            if ("number".equals(type)) {
                type = "float";
            }
            String name = (String)entry.getKey();
            int newEntryRow = 0;
            newEntryRow = paranRow != -1 ? this.getModel().insertEntryRow(entryKey, paranRow) : this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue("api_in_var_name", (Object)name, newEntryRow);
            this.getModel().setValue("api_in_var_type", (Object)type, newEntryRow);
            this.getModel().setValue("api_in_var_desc", (Object)paramObject.getString("description"), newEntryRow);
            if (!paramObject.containsKey((Object)"properties")) continue;
            JSONObject properties = paramObject.getJSONObject("properties");
            this.buildInputParamTree(properties, entryKey, newEntryRow);
        }
    }

    private void buildOutputParamTree(JSONObject outputParams, String entryKey, int paranRow) {
        if (outputParams == null) {
            return;
        }
        Set entries = outputParams.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject paramObject;
            JSONObject inputParam = (JSONObject)entry.getValue();
            String type = inputParam.getString("type");
            if (type.equals("array")) {
                paramObject = inputParam.getJSONObject("items");
                type = paramObject.getString("type");
                if ("number".equals(type)) {
                    type = "float";
                }
                type = "array<" + type + ">";
            } else {
                paramObject = inputParam;
            }
            if ("number".equals(type)) {
                type = "float";
            }
            String name = (String)entry.getKey();
            int newEntryRow = 0;
            newEntryRow = paranRow != -1 ? this.getModel().insertEntryRow(entryKey, paranRow) : this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue("api_out_var_name", (Object)name, newEntryRow);
            this.getModel().setValue("api_out_var_type", (Object)type, newEntryRow);
            this.getModel().setValue("api_out_var_desc", (Object)paramObject.getString("description"), newEntryRow);
            if (!paramObject.containsKey((Object)"properties")) continue;
            JSONObject properties = paramObject.getJSONObject("properties");
            this.buildOutputParamTree(properties, entryKey, newEntryRow);
        }
    }
}

