/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.openapi.v3.models.HttpMethod;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;

public class GaiToolAddApiPlugin
extends AbstractBillPlugIn {
    private static final String FORM_ID = "gai_tool_add_api";
    private static final String inputoperation = "in_oper_column";
    private static final String outputoperation = "out_oper_column";
    private static final String KEY_METHOD = "api_method";
    private static final String KEY_IN_VAR_TYPE = "api_in_var_type";
    private static final String KEY_IN_VAR_PARAM_WAY = "api_in_var_param_way";
    private static final String KEY_IN_VAR_DESC = "api_in_var_desc";
    private static final String KEY_OUT_VAR_DESC = "api_out_var_desc";
    private static final String KEY_IN_VAR_NAME = "api_in_var_name";
    private static final String KEY_OUT_VAR_NAME = "api_out_var_name";
    private static final String KEY_OUT_VAR_TYPE = "api_out_var_type";
    private static final String KEY_IN_VAR_DEFAULT = "api_in_var_default";
    private static final String INPUTTREE = "inputtree";
    private static final String OUTPUTTREE = "outputtree";
    private static final String btnok = "btnok";
    private static final String DELETEENTRYINPUT = "deleteentryinput";
    private static final String DELETEENTRYOUTPUT = "deleteentryoutput";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getControl(btnok);
        btnok.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"content_type"});
        this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u6dfb\u52a0\u63a5\u53e3", (String)"GaiToolAddApiPlugin_14", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue("base_info", (Object)ResManager.loadKDString((String)"\u57fa\u7840\u4fe1\u606f", (String)"GaiToolAddApiPlugin_15", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue("input_var", (Object)ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570", (String)"GaiToolAddApiPlugin_16", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue("output_var", (Object)ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"GaiToolAddApiPlugin_17", (String)"ai-gai-plugin", (Object[])new Object[0]));
        JSONObject apiInfo = (JSONObject)this.getView().getFormShowParameter().getCustomParam("apiInfo");
        if (null != apiInfo) {
            String source = apiInfo.getString("source");
            if (!StringUtils.isEmpty((CharSequence)source) && ToolConstant.ToolSource.KINGDEE.getSource().equalsIgnoreCase(source)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel", INPUTTREE, OUTPUTTREE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap", "buttonap1", inputoperation, outputoperation});
            }
            String method = apiInfo.getString("method");
            this.getModel().setValue("api_name", (Object)apiInfo.getString("name"));
            this.getModel().setValue("api_description", (Object)apiInfo.getString("description"));
            this.getModel().setValue("api_url", (Object)apiInfo.getString("location"));
            this.getModel().setValue(KEY_METHOD, (Object)method);
            this.getModel().setValue("test_status", (Object)apiInfo.getString("testStatus"));
            this.getModel().setValue("enable", (Object)apiInfo.getString("enable"));
            this.getModel().setValue("content_type", (Object)apiInfo.getString("contentType"));
            this.setParamWay(method);
            if (StringUtils.isNotEmpty((CharSequence)method) && HttpMethod.POST.name().equals(method)) {
                this.selectPostMethod();
            } else {
                this.selectGetMethod();
            }
            JSONObject inputParams = apiInfo.getJSONObject("inputParams");
            this.buildInputParamTree(inputParams, INPUTTREE, -1);
            JSONObject outputParams = apiInfo.getJSONObject("outputParams");
            this.buildOutputParamTree(outputParams, OUTPUTTREE, -1);
        } else {
            this.getModel().createNewEntryRow(INPUTTREE);
            this.getModel().createNewEntryRow(OUTPUTTREE);
        }
    }

    private void buildInputParamTree(JSONObject inputParams, String entryKey, int paranRow) {
        Set entries = inputParams.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject paramObject;
            JSONObject inputParam = (JSONObject)entry.getValue();
            String type = inputParam.getString("type");
            String paramWay = inputParam.getString("paramWay");
            if (type.equals("array")) {
                paramObject = inputParam.getJSONObject("items");
                type = paramObject.getString("type");
                if ("number".equals(type)) {
                    type = "float";
                }
                type = "array<" + type + ">";
            } else {
                paramObject = inputParam;
            }
            if ("number".equals(type)) {
                type = "float";
            }
            String name = (String)entry.getKey();
            int newEntryRow = 0;
            newEntryRow = paranRow != -1 ? this.getModel().insertEntryRow(entryKey, paranRow) : this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(KEY_IN_VAR_NAME, (Object)name, newEntryRow);
            this.getModel().setValue(KEY_IN_VAR_TYPE, (Object)type, newEntryRow);
            this.getModel().setValue(KEY_IN_VAR_DESC, (Object)paramObject.getString("desc"), newEntryRow);
            this.getModel().setValue(KEY_IN_VAR_DEFAULT, (Object)paramObject.getString("default"), newEntryRow);
            this.getModel().setValue(KEY_IN_VAR_PARAM_WAY, (Object)paramWay, newEntryRow);
            if (!paramObject.containsKey((Object)"properties")) continue;
            JSONObject properties = paramObject.getJSONObject("properties");
            this.buildInputParamTree(properties, entryKey, newEntryRow);
        }
    }

    private void buildOutputParamTree(JSONObject outputParams, String entryKey, int paranRow) {
        Set entries = outputParams.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject paramObject;
            JSONObject inputParam = (JSONObject)entry.getValue();
            String type = inputParam.getString("type");
            if (type.equals("array")) {
                paramObject = inputParam.getJSONObject("items");
                type = paramObject.getString("type");
                if ("number".equals(type)) {
                    type = "float";
                }
                type = "array<" + type + ">";
            } else {
                paramObject = inputParam;
            }
            if ("number".equals(type)) {
                type = "float";
            }
            String name = (String)entry.getKey();
            int newEntryRow = 0;
            newEntryRow = paranRow != -1 ? this.getModel().insertEntryRow(entryKey, paranRow) : this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(KEY_OUT_VAR_NAME, (Object)name, newEntryRow);
            this.getModel().setValue(KEY_OUT_VAR_TYPE, (Object)type, newEntryRow);
            this.getModel().setValue(KEY_OUT_VAR_DESC, (Object)paramObject.getString("desc"), newEntryRow);
            if (!paramObject.containsKey((Object)"properties")) continue;
            JSONObject properties = paramObject.getJSONObject("properties");
            this.buildOutputParamTree(properties, entryKey, newEntryRow);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.lowerCase((String)key).equals(btnok)) {
            if (this.checkRequiredParam()) {
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)this.getModel().getValue("api_url")))) {
                this.setReturnData();
            }
            this.getView().close();
        }
    }

    private boolean checkRequiredParam() {
        int i;
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("api_name");
        if (name.size() == 0 || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
            String message = ResManager.loadKDString((String)"\u63a5\u53e3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("api_description")))) {
            String message = ResManager.loadKDString((String)"\u63a5\u53e3\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_13", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("api_url")))) {
            String message = ResManager.loadKDString((String)"\u63a5\u53e3\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_METHOD)))) {
            String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_12", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if (this.getModel().getEntryEntity(INPUTTREE).size() > 0) {
            for (i = 0; i < this.getModel().getEntryEntity(INPUTTREE).size(); ++i) {
                if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_IN_VAR_NAME, i)))) {
                    String message = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    return true;
                }
                if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_IN_VAR_TYPE, i)))) {
                    String message = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    return true;
                }
                if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_IN_VAR_DESC, i)))) {
                    String message = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    return true;
                }
                if (!StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_IN_VAR_PARAM_WAY, i)))) continue;
                String message = ResManager.loadKDString((String)"\u8f93\u5165\u4f20\u5165\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return true;
            }
        }
        if (this.getModel().getEntryEntity(OUTPUTTREE).size() > 0) {
            for (i = 0; i < this.getModel().getEntryEntity(OUTPUTTREE).size(); ++i) {
                if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_OUT_VAR_NAME, i)))) {
                    String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    return true;
                }
                if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_OUT_VAR_TYPE, i)))) {
                    String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                    return true;
                }
                if (!StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue(KEY_OUT_VAR_DESC, i)))) continue;
                String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolAddApiPlugin_11", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return true;
            }
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        super.beforeDoOperation(eventArgs);
        String opKey = ((FormOperate)eventArgs.getSource()).getOperateKey();
        if (opKey.equals("insertentryinput")) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(INPUTTREE);
            int[] rows = treeEntryGrid.getSelectRows();
            String type = (String)this.getModel().getValue(KEY_IN_VAR_TYPE, rows[rows.length - 1]);
            if (StringUtils.isEmpty((CharSequence)type)) {
                String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u6570\u7c7b\u578b", (String)"GaiToolAddApiPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                eventArgs.setCancelMessage(message);
                eventArgs.setCancel(true);
            } else if (!StringUtils.lowerCase((String)type).contains("object")) {
                String message = ResManager.loadKDString((String)"\u57fa\u672c\u7c7b\u578b\u5b57\u6bb5\u4e0d\u5141\u8bb8\u521b\u5efa\u5b50\u5c42\u7ea7", (String)"GaiToolAddApiPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                eventArgs.setCancelMessage(message);
                eventArgs.setCancel(true);
            }
        } else if (opKey.equals("insertentryoutput")) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(OUTPUTTREE);
            int[] rows = treeEntryGrid.getSelectRows();
            String type = (String)this.getModel().getValue(KEY_OUT_VAR_TYPE, rows[rows.length - 1]);
            if (StringUtils.isEmpty((CharSequence)type)) {
                String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u6570\u7c7b\u578b", (String)"GaiToolAddApiPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                eventArgs.setCancelMessage(message);
                eventArgs.setCancel(true);
            } else if (!StringUtils.lowerCase((String)type).contains("object")) {
                String message = ResManager.loadKDString((String)"\u57fa\u672c\u7c7b\u578b\u5b57\u6bb5\u4e0d\u5141\u8bb8\u521b\u5efa\u5b50\u5c42\u7ea7", (String)"GaiToolAddApiPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                eventArgs.setCancelMessage(message);
                eventArgs.setCancel(true);
            }
        } else if (opKey.equals(DELETEENTRYINPUT)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(INPUTTREE);
            int[] rows = treeEntryGrid.getSelectRows();
            DynamicObjectCollection inputArrays = this.getModel().getEntryEntity(INPUTTREE);
            HashMap<Long, List<DynamicObject>> pidMap = new HashMap<Long, List<DynamicObject>>(inputArrays.size());
            for (DynamicObject input : inputArrays) {
                if (null == pidMap.get(input.getLong("pid"))) {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                    list.add(input);
                    pidMap.put(input.getLong("pid"), list);
                    continue;
                }
                ((List)pidMap.get(input.getLong("pid"))).add(input);
            }
            DynamicObject deleteObj = (DynamicObject)inputArrays.get(rows[rows.length - 1]);
            if (0L != deleteObj.getLong("pid") && ((List)pidMap.get(deleteObj.getLong("pid"))).size() == 1) {
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u7236\u8282\u70b9\u4e0b\u552f\u4e00\u5b50\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"GaiToolAddApiPlugin_18", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                eventArgs.setCancelMessage(message);
                eventArgs.setCancel(true);
            } else {
                ArrayList<Integer> deleteRows = new ArrayList<Integer>();
                this.deleteChildTree(pidMap, deleteObj, deleteRows);
                int[] deleteRowArray = deleteRows.stream().sorted(Comparator.reverseOrder()).mapToInt(Integer::intValue).toArray();
                this.getModel().deleteEntryRows(INPUTTREE, deleteRowArray);
            }
        } else if (opKey.equals(DELETEENTRYOUTPUT)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(OUTPUTTREE);
            int[] rows = treeEntryGrid.getSelectRows();
            DynamicObjectCollection outputArrays = this.getModel().getEntryEntity(OUTPUTTREE);
            HashMap<Long, List<DynamicObject>> pidMap = new HashMap<Long, List<DynamicObject>>(outputArrays.size());
            for (DynamicObject output : outputArrays) {
                if (null == pidMap.get(output.getLong("pid"))) {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                    list.add(output);
                    pidMap.put(output.getLong("pid"), list);
                    continue;
                }
                ((List)pidMap.get(output.getLong("pid"))).add(output);
            }
            Iterator deleteObj = (DynamicObject)outputArrays.get(rows[rows.length - 1]);
            if (0L != deleteObj.getLong("pid") && ((List)pidMap.get(deleteObj.getLong("pid"))).size() == 1) {
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u7236\u8282\u70b9\u4e0b\u552f\u4e00\u5b50\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"GaiToolAddApiPlugin_18", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                eventArgs.setCancelMessage(message);
                eventArgs.setCancel(true);
            } else {
                ArrayList<Integer> deleteRows = new ArrayList<Integer>();
                this.deleteChildTree(pidMap, (DynamicObject)deleteObj, deleteRows);
                int[] deleteRowArray = deleteRows.stream().sorted(Comparator.reverseOrder()).mapToInt(Integer::intValue).toArray();
                this.getModel().deleteEntryRows(OUTPUTTREE, deleteRowArray);
            }
        }
    }

    private void deleteChildTree(Map<Long, List<DynamicObject>> pidMap, DynamicObject deleteObj, List<Integer> deleteRows) {
        if (pidMap.get(deleteObj.getLong("id")) != null) {
            List<DynamicObject> list = pidMap.get(deleteObj.getLong("id"));
            for (int i = list.size() - 1; i >= 0; --i) {
                DynamicObject input = list.get(i);
                List<DynamicObject> childList = pidMap.get(input.getLong("id"));
                if (null != childList) {
                    this.deleteChildTree(pidMap, input, deleteRows);
                    continue;
                }
                deleteRows.add(input.getInt(1) - 1);
            }
        }
        deleteRows.add(deleteObj.getInt(1) - 1);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = ((FormOperate)eventArgs.getSource()).getOperateKey();
        if (opKey.equals("insertentryinput")) {
            String method = (String)this.getModel().getValue(KEY_METHOD);
            if (HttpMethod.POST.name().equals(method)) {
                DynamicObjectCollection inputArrays = this.getModel().getEntryEntity(INPUTTREE);
                this.getModel().setValue(KEY_IN_VAR_PARAM_WAY, (Object)"body");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        TreeEntryGrid inputtreeEntryGrid = (TreeEntryGrid)this.getControl(INPUTTREE);
        TreeEntryGrid outputtreeEntryGrid = (TreeEntryGrid)this.getControl(OUTPUTTREE);
        DynamicObjectCollection inputEntry = this.getModel().getEntryEntity(INPUTTREE);
        DynamicObjectCollection outputEntry = this.getModel().getEntryEntity(OUTPUTTREE);
        String newValue = data.getNewValue().toString();
        switch (propertyName) {
            case "api_method": {
                if (StringUtils.isNotEmpty((CharSequence)newValue) && HttpMethod.POST.name().equals(newValue)) {
                    this.selectPostMethod();
                } else {
                    this.selectGetMethod();
                }
                this.setParamWay(newValue);
                break;
            }
            case "api_in_var_type": {
                if (StringUtils.isNotEmpty((CharSequence)newValue) && ("object".equals(newValue.toLowerCase()) || "array<object>".equals(newValue.toLowerCase()))) {
                    int[] rows = inputtreeEntryGrid.getSelectRows();
                    int newEntryRow = this.getModel().insertEntryRow(INPUTTREE, rows[0]);
                    this.getModel().setValue(KEY_IN_VAR_PARAM_WAY, (Object)"body", rows[0]);
                    this.getModel().setValue(KEY_IN_VAR_PARAM_WAY, (Object)"body", newEntryRow);
                    inputtreeEntryGrid.expand(rows[0]);
                    break;
                }
                if (null == data.getOldValue() || !StringUtils.isNotEmpty((CharSequence)data.getOldValue().toString()) || !"object".equals(data.getOldValue().toString()) && !"array<object>".equals(data.getOldValue().toString())) break;
                int[] rows = inputtreeEntryGrid.getSelectRows();
                DynamicObjectCollection inputArrays = this.getModel().getEntryEntity(INPUTTREE);
                HashMap<Long, List<DynamicObject>> pidMap = new HashMap<Long, List<DynamicObject>>(inputArrays.size());
                for (DynamicObject input : inputArrays) {
                    if (null == pidMap.get(input.getLong("pid"))) {
                        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                        list.add(input);
                        pidMap.put(input.getLong("pid"), list);
                        continue;
                    }
                    ((List)pidMap.get(input.getLong("pid"))).add(input);
                }
                DynamicObject deleteObj = (DynamicObject)inputArrays.get(rows[rows.length - 1]);
                ArrayList<Integer> deleteRows = new ArrayList<Integer>();
                this.deleteChildTree(pidMap, deleteObj, deleteRows);
                int[] deleteRowArray = deleteRows.stream().filter(v -> !v.equals(rows[rows.length - 1])).sorted(Comparator.reverseOrder()).mapToInt(Integer::intValue).toArray();
                this.getModel().deleteEntryRows(INPUTTREE, deleteRowArray);
                break;
            }
            case "api_out_var_type": {
                if (StringUtils.isNotEmpty((CharSequence)newValue) && ("object".equals(newValue.toLowerCase()) || "array<object>".equals(newValue.toLowerCase()))) {
                    int[] rows = outputtreeEntryGrid.getSelectRows();
                    int newEntryRow = this.getModel().insertEntryRow(OUTPUTTREE, rows[0]);
                    outputtreeEntryGrid.expand(rows[0]);
                    break;
                }
                if (null == data.getOldValue() || !StringUtils.isNotEmpty((CharSequence)data.getOldValue().toString()) || !"object".equals(data.getOldValue().toString()) && !"array<object>".equals(data.getOldValue().toString())) break;
                int[] rows = outputtreeEntryGrid.getSelectRows();
                DynamicObjectCollection inputArrays = this.getModel().getEntryEntity(OUTPUTTREE);
                HashMap<Long, List<DynamicObject>> pidMap = new HashMap<Long, List<DynamicObject>>(inputArrays.size());
                for (DynamicObject input : inputArrays) {
                    if (null == pidMap.get(input.getLong("pid"))) {
                        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                        list.add(input);
                        pidMap.put(input.getLong("pid"), list);
                        continue;
                    }
                    ((List)pidMap.get(input.getLong("pid"))).add(input);
                }
                Iterator deleteObj = (DynamicObject)inputArrays.get(rows[rows.length - 1]);
                ArrayList<Integer> deleteRows = new ArrayList<Integer>();
                this.deleteChildTree(pidMap, (DynamicObject)deleteObj, deleteRows);
                int[] deleteRowArray = deleteRows.stream().filter(v -> !v.equals(rows[rows.length - 1])).sorted(Comparator.reverseOrder()).mapToInt(Integer::intValue).toArray();
                this.getModel().deleteEntryRows(OUTPUTTREE, deleteRowArray);
                break;
            }
        }
    }

    private void selectGetMethod() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"content_type"});
        this.getModel().setValue("content_type", (Object)"x-www-form-urlencoded");
        this.setParamTypeItem();
    }

    private void selectPostMethod() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"content_type"});
        this.getModel().setValue("content_type", (Object)"application/json");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INPUTTREE);
        if (entryEntity.size() > 0) {
            this.getModel().setValue(KEY_IN_VAR_PARAM_WAY, (Object)"body");
        }
        ComboEdit paramWayEdit = (ComboEdit)this.getControl(KEY_IN_VAR_TYPE);
        DynamicObjectCollection inputEntity = this.getModel().getEntryEntity(INPUTTREE);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem stringItem = new ComboItem();
        stringItem.setValue("string");
        stringItem.setCaption(new LocaleString("String"));
        comboItemList.add(stringItem);
        ComboItem integerItem = new ComboItem();
        integerItem.setValue("integer");
        integerItem.setCaption(new LocaleString("Integer"));
        comboItemList.add(integerItem);
        ComboItem floatItem = new ComboItem();
        floatItem.setValue("float");
        floatItem.setCaption(new LocaleString("Float"));
        comboItemList.add(floatItem);
        ComboItem booleanItem = new ComboItem();
        booleanItem.setValue("boolean");
        booleanItem.setCaption(new LocaleString("Boolean"));
        comboItemList.add(booleanItem);
        ComboItem objectItem = new ComboItem();
        objectItem.setValue("object");
        objectItem.setCaption(new LocaleString("Object"));
        comboItemList.add(objectItem);
        ComboItem arraystringItem = new ComboItem();
        arraystringItem.setValue("array<string>");
        arraystringItem.setCaption(new LocaleString("Array<String>"));
        comboItemList.add(arraystringItem);
        ComboItem arrayintegerItem = new ComboItem();
        arrayintegerItem.setValue("array<integer>");
        arrayintegerItem.setCaption(new LocaleString("Array<Integer>"));
        comboItemList.add(arrayintegerItem);
        ComboItem arrayfloatItem = new ComboItem();
        arrayfloatItem.setValue("array<float>");
        arrayfloatItem.setCaption(new LocaleString("Array<Float>"));
        comboItemList.add(arrayfloatItem);
        ComboItem arraybooleanItem = new ComboItem();
        arraybooleanItem.setValue("array<boolean>");
        arraybooleanItem.setCaption(new LocaleString("Array<Boolean>"));
        comboItemList.add(arraybooleanItem);
        ComboItem arrayobjectItem = new ComboItem();
        arrayobjectItem.setValue("array<object>");
        arrayobjectItem.setCaption(new LocaleString("Array<Object>"));
        comboItemList.add(arrayobjectItem);
        paramWayEdit.setComboItems(comboItemList);
    }

    protected void setParamWay(String paramType) {
        ComboEdit paramWayEdit = (ComboEdit)this.getControl(KEY_IN_VAR_PARAM_WAY);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        if (HttpMethod.POST.name().equals(paramType)) {
            ComboItem postItem = new ComboItem();
            postItem.setValue("body");
            postItem.setCaption(new LocaleString("body"));
            comboItemList.add(postItem);
        } else {
            ComboItem queryItem = new ComboItem();
            queryItem.setValue("query");
            queryItem.setCaption(new LocaleString("query"));
            comboItemList.add(queryItem);
            ComboItem pathItem = new ComboItem();
            pathItem.setValue("path");
            pathItem.setCaption(new LocaleString("path"));
            comboItemList.add(pathItem);
            ComboItem headerItem = new ComboItem();
            headerItem.setValue("header");
            headerItem.setCaption(new LocaleString("header"));
            comboItemList.add(headerItem);
        }
        paramWayEdit.setComboItems(comboItemList);
    }

    protected void setParamTypeItem() {
        ComboEdit paramWayEdit = (ComboEdit)this.getControl(KEY_IN_VAR_TYPE);
        DynamicObjectCollection inputEntity = this.getModel().getEntryEntity(INPUTTREE);
        if (inputEntity.size() > 0) {
            this.getModel().setValue(KEY_IN_VAR_PARAM_WAY, (Object)"query");
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem stringItem = new ComboItem();
        stringItem.setValue("string");
        stringItem.setCaption(new LocaleString("String"));
        comboItemList.add(stringItem);
        ComboItem integerItem = new ComboItem();
        integerItem.setValue("integer");
        integerItem.setCaption(new LocaleString("Integer"));
        comboItemList.add(integerItem);
        ComboItem floatItem = new ComboItem();
        floatItem.setValue("float");
        floatItem.setCaption(new LocaleString("Float"));
        comboItemList.add(floatItem);
        ComboItem booleanItem = new ComboItem();
        booleanItem.setValue("boolean");
        booleanItem.setCaption(new LocaleString("Boolean"));
        comboItemList.add(booleanItem);
        paramWayEdit.setComboItems(comboItemList);
    }

    private void openAPIPreset(Boolean ispreset) {
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"api_name", "api_description", "api_url", KEY_METHOD, "content_type", INPUTTREE, "buttonap", OUTPUTTREE, "buttonap1"});
        }
    }

    private void setReturnData() {
        JSONObject apiInfo = new JSONObject();
        apiInfo.put("method", this.getModel().getValue(KEY_METHOD));
        apiInfo.put("name", (Object)((OrmLocaleValue)this.getModel().getValue("api_name")).getLocaleValue());
        apiInfo.put("testStatus", (Object)"");
        String readlocation = ((String)this.getModel().getValue("api_url")).replaceAll("/", "_");
        apiInfo.put("operationId", (Object)(this.getModel().getValue(KEY_METHOD) + readlocation));
        apiInfo.put("description", this.getModel().getValue("api_description"));
        apiInfo.put("enable", (Object)"0");
        apiInfo.put("location", this.getModel().getValue("api_url"));
        apiInfo.put("contentType", this.getModel().getValue("content_type"));
        JSONObject inputParams = new JSONObject();
        DynamicObjectCollection inputArrays = this.getModel().getEntryEntity(INPUTTREE);
        this.buildParamJson(inputParams, inputArrays, KEY_IN_VAR_TYPE, KEY_IN_VAR_DESC, KEY_IN_VAR_NAME, KEY_IN_VAR_PARAM_WAY, KEY_IN_VAR_DEFAULT);
        apiInfo.put("inputParams", (Object)inputParams);
        DynamicObjectCollection outputArrays = this.getModel().getEntryEntity(OUTPUTTREE);
        JSONObject outputParams = new JSONObject();
        this.buildParamJson(outputParams, outputArrays, KEY_OUT_VAR_TYPE, KEY_OUT_VAR_DESC, KEY_OUT_VAR_NAME, null, null);
        apiInfo.put("outputParams", (Object)outputParams);
        apiInfo.put("enable", this.getModel().getValue("enable"));
        apiInfo.put("testStatus", this.getModel().getValue("test_status"));
        this.getView().returnDataToParent((Object)apiInfo);
    }

    private void buildParamJson(JSONObject inputParams, DynamicObjectCollection inputArrays, String typeKey, String descKey, String nameKey, String paramWayKey, String defaultKey) {
        HashMap<Long, JSONObject> inputTreeMap = new HashMap<Long, JSONObject>();
        for (DynamicObject in : inputArrays) {
            JSONObject treeLeave;
            JSONObject inputParam = new JSONObject();
            String paramType = in.getString(typeKey);
            if (StringUtils.isEmpty((CharSequence)paramType)) continue;
            if (StringUtils.lowerCase((String)paramType).contains("array")) {
                inputParam.put("type", (Object)"array");
                Object items = new JSONObject();
                String itemsType = StringUtils.lowerCase((String)paramType).replace("array<", "").replace(">", "");
                items.put("type", (Object)itemsType);
                items.put("desc", (Object)in.getString(descKey));
                treeLeave = items;
                inputParam.put("items", items);
            } else {
                treeLeave = inputParam;
                inputParam.put("type", (Object)paramType);
                inputParam.put("desc", (Object)in.getString(descKey));
            }
            if (StringUtils.isNotEmpty((CharSequence)paramWayKey)) {
                inputParam.put("paramWay", (Object)in.getString(paramWayKey));
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)defaultKey) && !inputParam.getString("type").contains("array") && !inputParam.getString("type").contains("object")) {
                    switch (inputParam.getString("type")) {
                        case "string": {
                            inputParam.put("default", (Object)in.getString(defaultKey));
                            break;
                        }
                        case "integer": {
                            inputParam.put("default", (Object)in.getInt(defaultKey));
                            break;
                        }
                        case "float": {
                            inputParam.put("default", (Object)((Number)in.get(defaultKey)));
                            inputParam.put("type", (Object)"number");
                            break;
                        }
                        case "boolean": {
                            inputParam.put("default", (Object)in.getBoolean(defaultKey));
                            break;
                        }
                    }
                }
            }
            catch (ClassCastException e) {
                String message = ResManager.loadKDString((String)"\u53c2\u6570\u9ed8\u8ba4\u503c\u4e0e\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"GaiToolAddApiPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
            }
            if (in.getLong("pid") != 0L) {
                JSONObject parent = (JSONObject)inputTreeMap.get(in.getLong("pid"));
                JSONObject properties = parent.getJSONObject("properties");
                if (null == properties) {
                    properties = new JSONObject();
                }
                properties.put(in.getString(nameKey), (Object)inputParam);
                parent.put("properties", (Object)properties);
            } else {
                inputParams.put(in.getString(nameKey), (Object)inputParam);
            }
            inputTreeMap.put(in.getLong("id"), treeLeave);
        }
    }
}

