/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.plugin.agent.tool.list.IToolCardListListener;
import kd.ai.gai.plugin.agent.tool.list.ToolCardListConfig;
import kd.ai.gai.plugin.agent.tool.list.ToolRadioButtonAp;
import kd.ai.gai.plugin.list.RadioButtonFilterEvent;
import kd.ai.gai.plugin.utils.PopAppUtils;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ActiveViewEvent;
import kd.bos.form.control.events.ActiveViewListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiToolBillListPlugin
extends AbstractListPlugin
implements ActiveViewListener,
IToolCardListListener,
BeforeBindDataListener {
    private static final Log logger = LogFactory.getLog(GaiToolBillListPlugin.class);
    private static final String CURRENT_RADIO_BUTTON_FILTER_CACHE_KEY = "CURRENT_RADIO_BUTTON_FILTER";
    private static final String CURRENT_SELECTE_ROW_CACHE = "card_current_selected_row_pk";
    private static final String CARD_DELETE_CONFIRM_ID = "CARD_DELETE_CONFIRM_ID";
    private static final String TOOL_BASIC_INFO_FORM_ID = "gai_tool_info";
    private static final String TOOL_EDIT_FORM_ID = "gai_tool_edit";
    private static final String TOOL_CREATE_FORM_ID = "gai_tool_create_select";
    private static final String CURRENT_TOOL_GROUP_BUTTON_FILTER_CACHE_KEY = "CURRENT_TOOL_GROUP_BUTTON_FILTER_CACHE_KEY";
    protected static final String CTL_CUSTOMCONTROLAP = "groupcustomcontrolap";
    private static final int MAX_GROUP_SIZE = 7;
    private static final String CURRENT_TOOL_GROUP_BUTTON_MORE_CACHE_KEY = "CURRENT_TOOL_GROUP_BUTTON_MORE_CACHE_KEY";
    private static final String TOOL_GROUP_SELECT_COMPONENT_NAME = "tag_select";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("createtime desc");
        list.setDefaultView("gridview");
        String curListMode = this.getPageCache().get("ListMode");
        if (!StringUtils.isEmpty((CharSequence)curListMode) && StringUtils.equalsIgnoreCase((CharSequence)curListMode, (CharSequence)"Card")) {
            this.initCtlCustomControl();
        }
    }

    private void initCtlCustomControl() {
        String filterGroupCache = this.getPageCache().get(CURRENT_TOOL_GROUP_BUTTON_MORE_CACHE_KEY);
        JSONArray groups = null;
        groups = !StringUtils.isEmpty((CharSequence)filterGroupCache) ? JSONArray.parseArray((String)filterGroupCache) : new JSONArray(0);
        if (groups.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_CUSTOMCONTROLAP});
        }
        JSONObject data = new JSONObject();
        data.put("timestamp", (Object)System.currentTimeMillis());
        data.put("type", (Object)"init");
        JSONObject dataJo = new JSONObject();
        data.put("data", (Object)dataJo);
        dataJo.put("component", (Object)TOOL_GROUP_SELECT_COMPONENT_NAME);
        JSONObject params = new JSONObject();
        dataJo.put("params", (Object)params);
        params.put("options", (Object)groups);
        params.put("type", (Object)"border");
        params.put("invokeKey", (Object)"check_tool_group");
        this.sendToVue(data);
    }

    public void activeView(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getView().equals("cardview")) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("gai_tool");
            lsp.setFormId("gai_list_tool");
            lsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().close();
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container billlist = (Container)this.getView().getControl("cardflexpanelap2");
        billlist.addClickListener((ClickListener)this);
        Label disable = (Label)this.getView().getControl("lbl_dd_disable");
        disable.addClickListener((ClickListener)this);
        Label delete = (Label)this.getView().getControl("lbl_dd_delete");
        delete.addClickListener((ClickListener)this);
        delete.addItemClickListener((ItemClickListener)this);
        Label enable = (Label)this.getControl("labelap2");
        enable.addClickListener((ClickListener)this);
        BillList list = (BillList)this.getControl("billlistap");
        list.addActiveViewListener((ActiveViewListener)this);
        list.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        super.beforeDoOperation(eventArgs);
        String opKey = ((FormOperate)eventArgs.getSource()).getOperateKey();
        if (StringUtils.lowerCase((String)opKey).equals("addtool")) {
            eventArgs.setCancel(Boolean.TRUE.booleanValue());
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(TOOL_CREATE_FORM_ID);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setShowTitle(true);
            lsp.setCloseCallBack(new CloseCallBack(this.getClass().getName(), "create_tool_callback"));
            this.getView().showForm(lsp);
        } else if (StringUtils.lowerCase((String)opKey).equals("new")) {
            eventArgs.setCancel(Boolean.TRUE.booleanValue());
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(TOOL_CREATE_FORM_ID);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setShowTitle(true);
            lsp.setCloseCallBack(new CloseCallBack(this.getClass().getName(), "create_tool_callback"));
            this.getView().showForm(lsp);
        } else if (StringUtils.lowerCase((String)opKey).equals("enable")) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> errorList = new ArrayList<DynamicObject>();
            for (ListSelectedRow selectedRow : selectedRows) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedRow.getPrimaryKeyValue(), (String)"gai_tool");
                String toolType = dynamicObject.getString("tool_type");
                if (toolType.equals("restful_api") || toolType.equals(ToolConstant.ToolType.MCP_TOOL.getType())) {
                    boolean enable = false;
                    String configTag = dynamicObject.getString("config_tag");
                    if (StringUtils.isNotEmpty((CharSequence)configTag)) {
                        JSONObject jsonObject = JSONObject.parseObject((String)configTag);
                        JSONArray apiList = jsonObject.getJSONArray("apiList");
                        if (apiList != null) {
                            for (int i = 0; i < apiList.size(); ++i) {
                                JSONObject api = apiList.getJSONObject(i);
                                if (!"1".equals(api.getString("enable"))) continue;
                                enable = true;
                                dynamicObject.set("enable", (Object)"1");
                                updateList.add(dynamicObject);
                                break;
                            }
                            if (enable) continue;
                            errorList.add(dynamicObject);
                            continue;
                        }
                        errorList.add(dynamicObject);
                        continue;
                    }
                    errorList.add(dynamicObject);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) continue;
            }
            if (errorList.size() > 0) {
                String name = errorList.stream().map(v -> v.getString("name")).collect(Collectors.joining(", "));
                String message = ResManager.loadKDString((String)"%s\u542f\u7528\u5931\u8d25\uff0c\u5de5\u5177\u4e0b\u65e0\u542f\u7528\u63a5\u53e3\u3002", (String)"GaiToolBillListPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(message, name));
                eventArgs.setCancel(true);
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        } else if (StringUtils.lowerCase((String)opKey).equals("disableop")) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object focusRowPkId = billList.getFocusRowPkId();
            if (focusRowPkId != null) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)focusRowPkId, (String)"gai_tool");
                dynamicObject.set("enable", (Object)EnableEnum.NO.getKeyStr());
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"GaiToolBillListPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.lowerCase((String)opKey).equals("copy")) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedRow.getPrimaryKeyValue(), (String)"gai_tool");
                FormShowParameter lsp = new FormShowParameter();
                lsp.setCustomParam("toolId", (Object)dynamicObject.getLong("id"));
                lsp.setCustomParam("isCopy", (Object)"1");
                String toolName = dynamicObject.getString("name");
                lsp.setCaption(toolName);
                lsp.setFormId(TOOL_EDIT_FORM_ID);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                lsp.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm(lsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"edit_tool_basic_info_callback", (CharSequence)actionId)) {
            String type;
            JSONObject toolInfo = (JSONObject)returnData;
            if (null != toolInfo && StringUtils.isNotEmpty((CharSequence)(type = toolInfo.getString("radiogroupfield")))) {
                if (type.equals("open_api") && toolInfo.getString("confirm").equals("ok")) {
                    BillShowParameter bsp = new BillShowParameter();
                    bsp.setFormId("gai_tool");
                    bsp.setCustomParam("toolbasicinfo", (Object)toolInfo);
                    bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    bsp.setStatus(OperationStatus.ADDNEW);
                    this.getView().showForm((FormShowParameter)bsp);
                } else if (toolInfo.getString("confirm").equals("ok")) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId(TOOL_EDIT_FORM_ID);
                    fsp.setCustomParam("toolbasicinfo", (Object)toolInfo);
                    fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(fsp);
                } else if (toolInfo.getString("confirm").equals("edit")) {
                    FormShowParameter lsp = new FormShowParameter();
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_tool");
                    dynamicObject.set("picture", (Object)toolInfo.getString("picture"));
                    DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)toolInfo.getString("app"), (String)"bos_devportal_bizapp");
                    dynamicObject.set("app", (Object)appObject);
                    dynamicObject.set("name", (Object)toolInfo.getString("name"));
                    dynamicObject.set("description", (Object)toolInfo.getString("description"));
                    dynamicObject.set("tool_type", (Object)toolInfo.getString("radiogroupfield"));
                    lsp.setCustomParam("toolObject", (Object)dynamicObject);
                    lsp.setFormId(TOOL_BASIC_INFO_FORM_ID);
                    lsp.getOpenStyle().setShowType(ShowType.Modal);
                    lsp.setShowTitle(true);
                    lsp.setCloseCallBack(new CloseCallBack(this.getClass().getName(), "edit_tool_basic_info_callback"));
                    this.getView().showForm(lsp);
                }
            }
            ((IListView)this.getView()).refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)CARD_DELETE_CONFIRM_ID, (CharSequence)callBackId)) {
            int value = messageBoxClosedEvent.getResult().getValue();
            if (value == MessageBoxResult.Yes.getValue()) {
                long toolId;
                DynamicObject dynamicObject;
                String pk = this.getPageCache().get(CURRENT_SELECTE_ROW_CACHE);
                logger.info(ResManager.loadKDString((String)"\u5de5\u5177\u5361\u7247\u5217\u8868\u5220\u9664\uff0c", (String)"GaiToolBillListPlugin_13885613", (String)"ai-gai-plugin", (Object[])new Object[0]) + "pk" + ResManager.loadKDString((String)"\uff1a", (String)"GaiToolBillListPlugin_13885612", (String)"ai-gai-plugin", (Object[])new Object[0]) + "{}", (Object)pk);
                if (!StringUtils.isEmpty((CharSequence)pk) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)(toolId = Long.parseLong(pk)), (String)"gai_tool")) != null) {
                    String message;
                    String toolType = dynamicObject.getString("tool_type");
                    if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)"agent_preset")) {
                        String message2 = ResManager.loadKDString((String)"\u9884\u7f6e\u5de5\u5177\u4e0d\u80fd\u5220\u9664\u3002", (String)"GaiToolBillListPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(message2);
                        return;
                    }
                    Boolean ispreset = dynamicObject.getBoolean("ispreset");
                    if (ispreset.booleanValue()) {
                        String message3 = ResManager.loadKDString((String)"\u9884\u7f6e\u5de5\u5177\u4e0d\u80fd\u5220\u9664\u3002", (String)"GaiToolBillListPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(message3);
                        return;
                    }
                    String source = dynamicObject.getString("source");
                    if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                        String message4 = ResManager.loadKDString((String)"\u9884\u7f6e\u5de5\u5177\u4e0d\u80fd\u5220\u9664\u3002", (String)"GaiToolBillListPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(message4);
                        return;
                    }
                    if (this.toolIsRefByAgent(toolId)) {
                        return;
                    }
                    DeleteServiceHelper helper = new DeleteServiceHelper();
                    OperateOption option = OperateOption.create();
                    OperationResult result = helper.deleteOperate("gai_tool", new Object[]{Long.parseLong(pk)}, option);
                    if (result.isSuccess()) {
                        message = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"GaiToolBillListPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(message, Integer.valueOf(3000));
                    } else {
                        message = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25 :{}", (String)"GaiToolBillListPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
                        logger.info(message, (Object)result.toString());
                        String errorMsg = this.parseErrorMsg(result.toString());
                        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                            this.getView().showErrorNotification(errorMsg);
                        } else {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"GaiToolBillListPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]));
                        }
                    }
                    BillList list = (BillList)this.getControl("billlistap");
                    list.refresh();
                }
            } else if (value == MessageBoxResult.Cancel.getValue()) {
                // empty if block
            }
        }
    }

    private String parseErrorMsg(String result) {
        JSONObject errorItem;
        JSONArray allErrorInfo;
        JSONObject item;
        String errorMsg = "";
        if (!StringUtils.isEmpty((CharSequence)result) && (item = JSONObject.parseObject((String)result)) != null && item.containsKey((Object)"allErrorInfo") && (allErrorInfo = item.getJSONArray("allErrorInfo")) != null && !allErrorInfo.isEmpty() && (errorItem = allErrorInfo.getJSONObject(0)) != null) {
            errorMsg = errorItem.getString("message");
        }
        return errorMsg;
    }

    private boolean toolIsRefByAgent(long toolId) {
        String toolProp = String.format("%s.%s", "gai_agent_tool", "tool");
        QFilter filter = new QFilter(toolProp, "=", (Object)toolId);
        DynamicObject assistant = BusinessDataServiceHelper.loadSingle((String)"gai_agent", (String)("id,number,name," + toolProp), (QFilter[])new QFilter[]{filter});
        if (assistant != null) {
            String name = assistant.getString("name");
            String msg = String.format(ResManager.loadKDString((String)"\u667a\u80fd\u4f53", (String)"GaiToolBillListPlugin_13885615", (String)"ai-gai-plugin", (Object[])new Object[0]) + "%s" + ResManager.loadKDString((String)"\u5df2\u5173\u8054\u8be5\u5de5\u5177\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"GaiToolBillListPlugin_13885614", (String)"ai-gai-plugin", (Object[])new Object[0]), name);
            this.getView().showTipNotification(msg, Integer.valueOf(3000));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"cardflexpanelap2")) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow listSelectedRow = list.getCurrentSelectedRowInfo();
            if (listSelectedRow != null) {
                Object pkId = listSelectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_tool");
                String source = dynamicObject.getString("source");
                String toolType = dynamicObject.getString("tool_type");
                String toolName = dynamicObject.getString("name");
                if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                        FormShowParameter fsp = new FormShowParameter();
                        fsp.setFormId("gai_tool_detail");
                        fsp.setCustomParam("id", pkId);
                        fsp.setCaption(toolName);
                        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        this.getView().showForm(fsp);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
                        HashMap<String, Object> customParams = new HashMap<String, Object>();
                        customParams.put("toolId", dynamicObject.getPkValue());
                        PopAppUtils.showFormOnlyOnce(this.getView(), TOOL_EDIT_FORM_ID, toolName, customParams, pkId);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                    BillShowParameter bsp = new BillShowParameter();
                    bsp.setPkId(pkId);
                    bsp.setFormId("gai_tool");
                    bsp.setCaption(toolName);
                    bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    bsp.setStatus(OperationStatus.EDIT);
                    this.getView().showForm((FormShowParameter)bsp);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                    FormShowParameter lsp = new FormShowParameter();
                    lsp.setCustomParam("toolId", dynamicObject.getPkValue());
                    lsp.setCaption(toolName);
                    lsp.setFormId(TOOL_EDIT_FORM_ID);
                    lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    lsp.setStatus(OperationStatus.EDIT);
                    this.getView().showForm(lsp);
                }
            }
            list.selectRows(new int[0]);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"lbl_dd_disable")) {
            BillList list = (BillList)this.getControl("billlistap");
            list.setOrderBy("createtime desc");
            list.clearSelection();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"lbl_dd_delete")) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow listSelectedRow = list.getCurrentSelectedRowInfo();
            list.clearSelection();
            Object pk = listSelectedRow.getPrimaryKeyValue();
            int rowKey = listSelectedRow.getRowKey();
            this.getPageCache().put(CURRENT_SELECTE_ROW_CACHE, String.valueOf(pk));
            list.selectRows(rowKey);
            list.refresh();
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CARD_DELETE_CONFIRM_ID, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u5f20\u5355\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c", (String)"GaiToolBillListPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"GaiToolBillListPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"labelap2")) {
            BillList list = (BillList)this.getControl("billlistap");
            list.setOrderBy("createtime desc");
            list.clearSelection();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"copy")) {
            String type;
            String source;
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            int count = selectedRows.size();
            if (count == 0) {
                evt.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GaiToolBillListPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (count > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"GaiToolBillListPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListSelectedRow row = selectedRows.get(0);
            Object pk = row.getPrimaryKeyValue();
            DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"gai_tool");
            String toolType = tool.getString("tool_type");
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5de5\u5177\u4e0d\u652f\u6301\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"GaiToolBillListPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(Boolean.TRUE.booleanValue());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)(source = tool.getString("source")), (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5de5\u5177\u4e0d\u652f\u6301\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"GaiToolBillListPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(Boolean.TRUE.booleanValue());
            }
            if ((type = tool.getString("tool_type")).equals(ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"OPEN API\u5de5\u5177\u4e0d\u652f\u6301\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"GaiToolBillListPlugin_11", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(true);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String toolName;
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object pkId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_tool");
        String source = dynamicObject.getString("source");
        String toolType = dynamicObject.getString("tool_type");
        if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            toolName = dynamicObject.getString("name");
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("id", dynamicObject.getPkValue());
                PopAppUtils.showFormOnlyOnce(this.getView(), "gai_tool_detail", toolName, customParams, pkId);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("toolId", dynamicObject.getPkValue());
                PopAppUtils.showFormOnlyOnce(this.getView(), TOOL_EDIT_FORM_ID, toolName, customParams, pkId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            toolName = dynamicObject.getString("name");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("id", dynamicObject.getPkValue());
            PopAppUtils.showFormOnlyOnce(this.getView(), "gai_tool", toolName, customParams, pkId);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            toolName = dynamicObject.getString("name");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("toolId", dynamicObject.getPkValue());
            PopAppUtils.showFormOnlyOnce(this.getView(), TOOL_EDIT_FORM_ID, toolName, customParams, pkId);
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.selectRows(new int[0]);
    }

    @Override
    public void onInitCardListConfig(ToolCardListConfig config) {
        BarItemAp newItem = new BarItemAp();
        newItem.setId("carditem_new");
        newItem.setKey("carditem_new");
        newItem.setOperationKey("new");
        String addTool = ResManager.loadKDString((String)"\u65b0\u589e\u5de5\u5177", (String)"GaiToolBillListPlugin_15", (String)"ai-gai-plugin", (Object[])new Object[0]);
        newItem.setName(new LocaleString(addTool));
        config.getBarItems().add(newItem);
        String allType = ResManager.loadKDString((String)"\u5168\u90e8", (String)"GaiToolBillListPlugin_12", (String)"ai-gai-plugin", (Object[])new Object[0]);
        ToolRadioButtonAp radioButtonAp = new ToolRadioButtonAp("radio_btn_all", new LocaleString(allType), "");
        config.getFilterRadioButtonGroup().addButton(radioButtonAp);
        radioButtonAp = new ToolRadioButtonAp("radio_btn_internal_mcp", new LocaleString(ToolConstant.ToolType.INTERNAL_MCP.getTypeName()), "");
        config.getFilterRadioButtonGroup().addButton(radioButtonAp);
        radioButtonAp = new ToolRadioButtonAp("radio_btn_mcp", new LocaleString(ToolConstant.ToolType.MCP_TOOL.getTypeName()), "");
        config.getFilterRadioButtonGroup().addButton(radioButtonAp);
        radioButtonAp = new ToolRadioButtonAp("radio_btn_restful_api", new LocaleString(ToolConstant.ToolType.RESTFUL_API.getTypeName()), "");
        config.getFilterRadioButtonGroup().addButton(radioButtonAp);
        radioButtonAp = new ToolRadioButtonAp("radio_btn_cosmic_action", new LocaleString(ToolConstant.ToolType.COSMIC_ACTION.getTypeName()), "");
        config.getFilterRadioButtonGroup().addButton(radioButtonAp);
        config.getFilterRadioButtonGroup().setCurrentCheckButtonKey("radio_btn_all");
        config.getToolGroupButtonGroup().addButtons(this.createGroupButtons());
        config.getToolGroupButtonGroup().setCurrentCheckButtonKey("allgroup");
    }

    @Override
    public void onRadioButtonCheckFilter(RadioButtonFilterEvent radioButtonFilterEvent) {
        String key = radioButtonFilterEvent.getCurrentCheckKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"radio_btn_all")) {
            this.getPageCache().remove(CURRENT_RADIO_BUTTON_FILTER_CACHE_KEY);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"radio_btn_internal_mcp")) {
            QFilter filter = new QFilter("tool_type", "=", (Object)ToolConstant.ToolType.INTERNAL_MCP.getType());
            this.cacheToolTypeButtonFilter(filter);
            radioButtonFilterEvent.getFilters().add(filter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"radio_btn_mcp")) {
            QFilter mcpFilter = new QFilter("tool_type", "=", (Object)ToolConstant.ToolType.MCP_TOOL.getType());
            this.cacheToolTypeButtonFilter(mcpFilter);
            radioButtonFilterEvent.getFilters().add(mcpFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"radio_btn_restful_api")) {
            QFilter restfulFilter = new QFilter("tool_type", "=", (Object)ToolConstant.ToolType.RESTFUL_API.getType());
            this.cacheToolTypeButtonFilter(restfulFilter);
            radioButtonFilterEvent.getFilters().add(restfulFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"radio_btn_cosmic_action")) {
            QFilter cosmicActionFilter = new QFilter("tool_type", "=", (Object)ToolConstant.ToolType.COSMIC_ACTION.getType());
            this.cacheToolTypeButtonFilter(cosmicActionFilter);
            radioButtonFilterEvent.getFilters().add(cosmicActionFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"allgroup")) {
            this.getPageCache().remove(CURRENT_TOOL_GROUP_BUTTON_FILTER_CACHE_KEY);
            this.initCtlCustomControl();
        } else {
            this.initCtlCustomControl();
            String groupId = radioButtonFilterEvent.getCurrentCheckKey();
            QFilter groupFilter = new QFilter("group", "=", (Object)Long.parseLong(groupId));
            radioButtonFilterEvent.getFilters().add(groupFilter);
            this.cacheToolGroupButtonFilter(groupFilter);
        }
    }

    @Override
    public void onClearCheckButton() {
        this.getPageCache().remove(CURRENT_TOOL_GROUP_BUTTON_FILTER_CACHE_KEY);
    }

    private void setCustomFilter(SetFilterEvent e) {
        String toolGroupCache;
        String toolTypeCache = this.getPageCache().get(CURRENT_RADIO_BUTTON_FILTER_CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)toolTypeCache)) {
            QFilter filter = QFilter.fromSerializedString((String)toolTypeCache);
            e.getQFilters().add(filter);
        }
        if (!StringUtils.isEmpty((CharSequence)(toolGroupCache = this.getPageCache().get(CURRENT_TOOL_GROUP_BUTTON_FILTER_CACHE_KEY)))) {
            QFilter filter = QFilter.fromSerializedString((String)toolGroupCache);
            e.getQFilters().add(filter);
        }
    }

    private void cacheToolTypeButtonFilter(QFilter filter) {
        this.getPageCache().put(CURRENT_RADIO_BUTTON_FILTER_CACHE_KEY, filter.toSerializedString());
    }

    private void cacheToolGroupButtonFilter(QFilter filter) {
        this.getPageCache().put(CURRENT_TOOL_GROUP_BUTTON_FILTER_CACHE_KEY, filter.toSerializedString());
    }

    private List<ToolRadioButtonAp> createGroupButtons() {
        QFilter filter = new QFilter("parent", "=", (Object)0L);
        Map groups = BusinessDataServiceHelper.loadFromCache((String)"gai_tool_group", (QFilter[])new QFilter[]{filter});
        ArrayList<ToolRadioButtonAp> buttonAps = new ArrayList<ToolRadioButtonAp>(0);
        ToolRadioButtonAp button = null;
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        margin.setBottom("12px");
        style.setMargin(margin);
        ToolRadioButtonAp allGroupButton = new ToolRadioButtonAp("allgroup", new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GaiToolBillListPlugin_13885616", (String)"ai-gai-plugin", (Object[])new Object[0])), "");
        allGroupButton.setId("allgroup");
        allGroupButton.setRadius("16px");
        allGroupButton.setFontSize(14);
        allGroupButton.setStyle(style);
        buttonAps.add(allGroupButton);
        int count = 0;
        JSONArray moreGroups = new JSONArray(0);
        for (Map.Entry entry : groups.entrySet()) {
            ++count;
            button = new ToolRadioButtonAp(((DynamicObject)entry.getValue()).getString("number"), new LocaleString(((DynamicObject)entry.getValue()).getString("name")), "");
            button.setId(((DynamicObject)entry.getValue()).getString("number"));
            button.setName(new LocaleString(((DynamicObject)entry.getValue()).getString("name")));
            button.setKey(String.valueOf(((DynamicObject)entry.getValue()).getLong("id")));
            button.setRadius("16px");
            button.setFontSize(14);
            button.setStyle(style);
            if (count <= 7) {
                buttonAps.add(button);
                continue;
            }
            JSONObject group = new JSONObject();
            group.put("label", (Object)((DynamicObject)entry.getValue()).getString("name"));
            group.put("value", (Object)String.valueOf(((DynamicObject)entry.getValue()).getLong("id")));
            moreGroups.add((Object)group);
        }
        if (this.getPageCache() != null) {
            this.getPageCache().put(CURRENT_TOOL_GROUP_BUTTON_MORE_CACHE_KEY, moreGroups.toJSONString());
        }
        return buttonAps;
    }

    protected void sendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    public void setFilter(SetFilterEvent e) {
        String curListMode = this.getPageCache().get("ListMode");
        if (!StringUtils.isEmpty((CharSequence)curListMode) && StringUtils.equalsIgnoreCase((CharSequence)curListMode, (CharSequence)"Card")) {
            List filters = e.getQFilters();
            ArrayList<QFilter> newFilters = new ArrayList<QFilter>(0);
            if (filters != null) {
                for (QFilter item : filters) {
                    String property = item.getProperty();
                    if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)"enable") || StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)"createtime")) continue;
                    newFilters.add(item);
                }
                e.getQFilters().clear();
                e.getQFilters().addAll(newFilters);
                this.setCustomFilter(e);
                logger.info("tools filters:{}", (Object)JSONObject.toJSONString((Object)e.getQFilters()));
            }
        }
        logger.info("tools filters:{}", (Object)JSONObject.toJSONString((Object)e.getQFilters()));
        super.setFilter(e);
    }

    private static String getHost() {
        String host = RequestContext.get().getClientFullContextPath();
        if (!StringUtils.isEmpty((CharSequence)host) && host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BillListDataProvider());
    }

    public static class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            rows.stream().forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    String source = dynamicObject.getString("source");
                    if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                        String url = GaiToolBillListPlugin.getHost() + "/kingdee/gai/images/pc/tool/gai_tool_kingdee_square.png";
                        DynamicObject creator = dynamicObject.getDynamicObject("creator");
                        if (creator != null) {
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            DynamicObject newCreator = (DynamicObject)cloneUtils.clone((IDataEntityBase)creator);
                            newCreator.set("picturefield", (Object)url);
                            newCreator.set("name", (Object)ToolConstant.ToolSource.KINGDEE.getName());
                            dynamicObject.set("creator", (Object)newCreator);
                        } else {
                            DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"picturefield");
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            DynamicObject newCreator = (DynamicObject)cloneUtils.clone((IDataEntityBase)currentUser);
                            newCreator.set("picturefield", (Object)url);
                            newCreator.set("name", (Object)ToolConstant.ToolSource.KINGDEE.getName());
                            dynamicObject.set("creator", (Object)newCreator);
                        }
                        String picture = dynamicObject.getString("picture");
                        if (!StringUtils.isEmpty((CharSequence)picture) && picture.startsWith("/kingdee")) {
                            String toolPicture = GaiToolBillListPlugin.getHost() + picture;
                            dynamicObject.set("picture", (Object)toolPicture);
                        }
                    } else if (StringUtils.isEmpty((CharSequence)source) || StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.CUSTOMIZE.getSource())) {
                        DynamicObject creator = dynamicObject.getDynamicObject("creator");
                        if (creator != null) {
                            Object uid = creator.getPkValue();
                            DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user", (String)"id,name,picturefield");
                            String pictureUrl = bosUser.getString("picturefield");
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            DynamicObject newCreator = (DynamicObject)cloneUtils.clone((IDataEntityBase)creator);
                            newCreator.set("picturefield", (Object)pictureUrl);
                            dynamicObject.set("creator", (Object)newCreator);
                        } else {
                            DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"picturefield");
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            DynamicObject newCreator = (DynamicObject)cloneUtils.clone((IDataEntityBase)currentUser);
                            String url = GaiToolBillListPlugin.getHost() + "/kingdee/gai/images/pc/tool/gai_tool_customize.png";
                            newCreator.set("picturefield", (Object)url);
                            newCreator.set("name", (Object)"");
                            dynamicObject.set("creator", (Object)newCreator);
                        }
                    }
                }
            });
            return rows;
        }
    }
}

