/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import kd.ai.gai.core.service.agent.CosmicActionService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiToolCosmicActionTestFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiToolCosmicActionTestFormPlugin.class);
    public static final String BTN_CANCEL = "btncancel";
    public static final String BTN_OK = "btnok";
    public static final String BTN_TEST = "bartest";
    private static final String KEY_INPUT_ENTITY = "input_entryentity";
    private static final String COSMIC_ACTION_CONFIG_CACHE = "_cosmic_action_config_cache_";
    public static final String CONTROL_RESULT_CODE_EDIT = "codeeditap";
    public static final String COSMIC_ACTION_TEST_CACHE = "cosmic_action_test_cache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL, BTN_TEST});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bartest": {
                this.testCosmicAction();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String configTag = (String)formShowParameter.getCustomParam("config");
        this.getPageCache().put(COSMIC_ACTION_CONFIG_CACHE, configTag);
        JSONObject config = JSONObject.parseObject((String)configTag);
        JSONArray inputParams = config.getJSONArray("inputParams");
        this.showInputOutputParams(inputParams);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String callbackData = this.getPageCache().get(COSMIC_ACTION_TEST_CACHE);
        JSONObject data = JSONObject.parseObject((String)callbackData);
        this.getView().returnDataToParent((Object)data);
    }

    private void showInputOutputParams(JSONArray params) {
        this.getModel().deleteEntryData(KEY_INPUT_ENTITY);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(KEY_INPUT_ENTITY);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(KEY_INPUT_ENTITY).getDynamicObjectType();
        if (params != null && !params.isEmpty()) {
            for (int i = 0; i < params.size(); ++i) {
                JSONObject param = params.getJSONObject(i);
                String varName = param.getString("paramName");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set(String.format("%s_%s", KEY_INPUT_ENTITY, "name"), (Object)varName);
                billEntityCollection.add((Object)dynamicObject);
            }
            this.getModel().updateEntryCache(billEntityCollection);
            this.getView().updateView(KEY_INPUT_ENTITY);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testCosmicAction() {
        String configTag = this.getPageCache().get(COSMIC_ACTION_CONFIG_CACHE);
        JSONObject config = JSONObject.parseObject((String)configTag);
        Long toolId = config.getLong("toolId");
        DynamicObject toolDO = null;
        if (toolId != null) {
            toolDO = BusinessDataServiceHelper.loadSingle((Object)toolId, (String)"gai_tool");
            toolDO.set("test_status", (Object)"0");
        }
        try {
            JSONArray inputParams = this.buildRequestParameters();
            JSONArray configParams = config.getJSONArray("configParams");
            JSONArray outputParams = config.getJSONArray("outputParams");
            logger.info("cosmic action test config : {}", (Object)configTag);
            logger.info("cosmic action test input params : {},config params : {}", (Object)JSONObject.toJSONString((Object)inputParams), (Object)JSONObject.toJSONString((Object)configParams));
            BaseResult br = CosmicActionService.call((JSONObject)config, (JSONArray)inputParams, (JSONArray)outputParams, (JSONArray)configParams, null, (Long)0L, (Long)0L);
            logger.info("cosmic action test result : {}", (Object)JSONObject.toJSONString((Object)br));
            CodeEdit codeEdit = (CodeEdit)this.getControl(CONTROL_RESULT_CODE_EDIT);
            codeEdit.setText(JSONObject.toJSONString((Object)br, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty}));
            this.getPageCache().put(COSMIC_ACTION_TEST_CACHE, JSONObject.toJSONString((Object)br));
            if (br.getStatus().booleanValue() && toolDO != null) {
                toolDO.set("test_status", (Object)"1");
            }
            if (toolDO == null) return;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (toolDO == null) throw throwable;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{toolDO});
                throw throwable;
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{toolDO});
        return;
    }

    private JSONArray buildRequestParameters() {
        EntryGrid grid = (EntryGrid)this.getControl(KEY_INPUT_ENTITY);
        DynamicObject[] dynamicObjects = grid.getEntryData().getDataEntitys();
        JSONArray parameters = new JSONArray();
        for (DynamicObject object : dynamicObjects) {
            String paramName = object.getString(String.format("%s_name", KEY_INPUT_ENTITY));
            String paramValue = object.getString(String.format("%s_bigval_tag", KEY_INPUT_ENTITY));
            JSONObject parameter = new JSONObject();
            parameter.put("paramName", (Object)paramName);
            parameter.put("paramValue", (Object)paramValue);
            parameters.add((Object)parameter);
        }
        return parameters;
    }
}

