/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Components;
import kd.ai.gai.core.agent.tool.openapi.v3.models.OpenAPI;
import kd.ai.gai.core.agent.tool.util.FastJsonUtil;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.agent.tool.util.ToolUtils;
import kd.ai.gai.core.domain.dto.agent.ToolAPIInfo;
import kd.ai.gai.core.domain.dto.agent.ToolParam;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Hyperlink;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GaiToolDetailFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiToolDetailFormPlugin.class);
    public static final String BTN_SAVE = "barsave";
    public static final String BTN_TEST = "bartest";
    public static final String CONTROL_PICTURE = "picturefield";
    public static final String CONTROL_LABEL_NAME = "labeltoolname";
    public static final String CONTROL_LABEL_NUMBER = "labeltoolnumber";
    public static final String CONTROL_LABEL_CLOUD = "labelcloud";
    public static final String CONTROL_LABEL_APP = "labelapp";
    public static final String CONTROL_LABEL_DESC = "labeldesc";
    public static final String CONTROL_LABEL_ILLUSTRATE = "labelillustrate";
    private static final String KEY_INPUT_ENTITY = "input_entryentity";
    private static final String KEY_OUTPUT_ENTITY = "output_entryentity";
    private static final String KEY_CONFIG_ENTITY = "config_entryentity";
    private static final String KEY_VAR_INPUT_PREFIX = "input";
    private static final String KEY_VAR_OUTPUT_PREFIX = "output";
    private static final String KEY_VAR_NAME = "paramname";
    private static final String KEY_VAR_TYPE = "paramtype";
    private static final String KEY_VAR_DESC = "paramdesc";
    private static final String KEY_CONFIG_VAR_NAME = "configparamname";
    private static final String KEY_CONFIG_VAR_VALUE = "configparamvalue";
    private static final String KEY_CONFIG_VAR_DESC = "configparamdesc";
    private static final String CONTROL_PANEL_OPENAPI_HEADER = "flexpanelheader";
    private static final String CONTROL_PANEL_OPENAPI_AUTHORIZE = "authorizeap";
    private static final String CONTROL_PANEL_COSMIC_ACTION_CONFIG = "flexpanelconfig";
    private static final String CONTROL_AUTH_TYPE_SELECTOR = "auth_selector";
    private static final String CONTROL_SERVICE_AUTH_AP = "serviceauth_ap";
    private static final String CONTROL_OPENAPI_AP = "openapi_ap";
    private static final String CONTROL_COSMIC_ACCESS_TOKEN_AP = "cosmic_at_ap";
    private static final String CONTROL_KEY_HEADER_SELECTOR = "key_selector";
    private static final String CONTROL_PARAM_NAME = "param_name";
    private static final String CONTROL_PARAM_VALUE = "param_value";
    private static final String CONTROL_CLIENT_ID = "client_id";
    private static final String CONTROL_CLIENT_SECRET = "client_secret";
    private static final String CONTROL_AUTHORIZATION_URL = "authorization_url";
    private static final String CONTROL_TOKEN_URL = "token_url";
    private static final String CONTROL_SCOPE = "scope";
    private static final String CONTROL_COSMIC_CLIENT_ID = "cosmic_client_id";
    private static final String CONTROL_COSMIC_CLIENT_SECRET = "cosmic_client_secret";
    private static final String CONTROL_COSMIC_USERNAME = "cosmic_username";
    private static final String CONTROL_COSMIC_ACCOUNTID = "cosmic_accountid";
    private static final String CONTROL_COSMIC_ACCESS_TOKEN_URL = "cosmic_token_url";
    private static final String CONTROL_HEADER_ENTIRY = "header_entryentity";
    private static final String CACHE_TOOL_TYPE = "_cache_tool_type_";
    private static final String CACHE_TOOL_ID = "_cache_tool_id_";
    private static final String CONTROL_TOOL_ILLUSTRATE = "viewtool";
    private static final String OPENAPI_TEST_CACHE_PRE = "_openapi_test_cache_pre_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{CONTROL_TOOL_ILLUSTRATE});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barsave": {
                this.save();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GaiToolDetailFormPlugin_13885617", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "bartest": {
                this.toolTest();
            }
        }
    }

    public void save() {
        JSONArray headers;
        JSONObject authConfig;
        String authType;
        String toolType = this.getPageCache().get(CACHE_TOOL_TYPE);
        String toolId = this.getPageCache().get(CACHE_TOOL_ID);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(toolId), (String)"gai_tool");
        String configTag = dynamicObject.getString("config_tag");
        JSONObject config = JSONObject.parseObject((String)configTag);
        JSONObject authObj = new JSONObject();
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
            authType = config.getString("authtype");
            config.put("authtype", (Object)authType);
            authObj.put("authtype", (Object)authType);
            if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                authConfig = this.buildServiceAuthFields();
                authObj.put("serviceConfig", (Object)authConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                authConfig = this.buildOAuthFields();
                authObj.put("oauthConfig", (Object)authConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                this.selectCosmicAccessToken();
                authConfig = this.buildCosmicAccessTokenAuthFields();
                authObj.put("cosmicAccessTokenConfig", (Object)authConfig);
            }
            headers = this.buildOpenAPIHeaderParams();
            authObj.put("headerList", (Object)headers);
            JSONArray apiList = config.getJSONArray("apiList");
            this.updateApiTestStatus(apiList);
            if (this.checkApiTestSuccess()) {
                dynamicObject.set("enable", (Object)String.valueOf(1));
            }
            JSONArray bodyParmas = config.getJSONArray("bodyParamList");
            authObj.put("bodyParamList", (Object)bodyParmas);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
            JSONArray configParams = this.buildCustomActionConfigParams();
            authObj.put("configParams", (Object)configParams);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
            authType = config.getString("authtype");
            config.put("authtype", (Object)authType);
            authObj.put("authtype", (Object)authType);
            if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                authConfig = this.buildServiceAuthFields();
                authObj.put("serviceConfig", (Object)authConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                authConfig = this.buildOAuthFields();
                authObj.put("oauthConfig", (Object)authConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                this.selectCosmicAccessToken();
                authConfig = this.buildCosmicAccessTokenAuthFields();
                authObj.put("cosmicAccessTokenConfig", (Object)authConfig);
            }
            headers = this.buildOpenAPIHeaderParams();
            authObj.put("headerList", (Object)headers);
        }
        String configJson = JSON.toJSONString((Object)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        String press = FastJsonUtil.removeWhitespaceAndNewlines((String)configJson);
        dynamicObject.set("config_tag", (Object)press);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        ToolUtils.updateToolAuthInfo((DynamicObject)dynamicObject, (JSONObject)authObj);
    }

    private boolean checkApiTestSuccess() {
        String cacheStr = this.getPageCache().get(OPENAPI_TEST_CACHE_PRE);
        Map statusMap = StringUtils.isEmpty((CharSequence)cacheStr) ? null : (Map)JSONObject.parseObject((String)cacheStr, Map.class);
        Boolean success = Boolean.TRUE;
        if (statusMap != null && !statusMap.isEmpty()) {
            for (Map.Entry entry : statusMap.entrySet()) {
                if (entry.getValue() != null && !StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getValue()), (CharSequence)String.valueOf(0))) continue;
                success = Boolean.FALSE;
                break;
            }
        }
        return success;
    }

    private void updateApiTestStatus(JSONArray apiList) {
        Map statusMap;
        String cacheStr = this.getPageCache().get(OPENAPI_TEST_CACHE_PRE);
        Map map = statusMap = StringUtils.isEmpty((CharSequence)cacheStr) ? null : (Map)JSONObject.parseObject((String)cacheStr, Map.class);
        if (apiList != null && !apiList.isEmpty()) {
            for (int i = 0; i < apiList.size(); ++i) {
                JSONObject api = apiList.getJSONObject(i);
                String operationId = api.getString("operationId");
                if (statusMap == null || statusMap.isEmpty()) continue;
                String status = (String)statusMap.get(operationId);
                api.put("testStatus", (Object)status);
            }
        }
    }

    public void toolTest() {
        String toolType = this.getPageCache().get(CACHE_TOOL_TYPE);
        String toolId = this.getPageCache().get(CACHE_TOOL_ID);
        this.save();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(toolId), (String)"gai_tool");
        String configTag = dynamicObject.getString("config_tag");
        JSONObject configJsonObj = JSONObject.parseObject((String)configTag);
        configJsonObj.put("toolId", (Object)toolId);
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
            ToolUtils.handlerOpenAPIAuthInfo((Object)Long.parseLong(toolId), (JSONObject)configJsonObj);
            configTag = configJsonObj.toString();
            this.openApiToolTest(configTag);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
            ToolUtils.handlerCosmicToolAuthInfo((Object)Long.parseLong(toolId), (JSONObject)configJsonObj);
            configTag = configJsonObj.toString();
            this.cosmicActionToolTest(configTag);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) {
            ToolUtils.handlerOpenAPIAuthInfo((Object)Long.parseLong(toolId), (JSONObject)configJsonObj);
            configTag = configJsonObj.toString();
            this.restfulApiToolTest(configTag);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
            // empty if block
        }
    }

    private void cosmicActionToolTest(String configTag) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_tool_action_test");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("config", (Object)configTag);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestCosmicActionCallback"));
        this.getView().showForm(parameter);
    }

    private void openApiToolTest(String configTag) {
        JSONObject swagger = JSONObject.parseObject((String)configTag);
        JSONArray apiList = swagger.getJSONArray("apiList");
        if (apiList != null && !apiList.isEmpty()) {
            JSONObject api = apiList.getJSONObject(0);
            String swaggerConfig = swagger.getString("swaggerSchema");
            OpenAPI openAPI = OpenAPIUtils.parserSwaggerConfig((String)swaggerConfig);
            Map operationParamMap = OpenAPIUtils.parseOperationParam((OpenAPI)openAPI);
            String operationId = api.getString("operationId");
            OperationParam operation = (OperationParam)operationParamMap.get(operationId);
            String operationJson = JSONObject.toJSONString((Object)operation);
            Components components = openAPI.getComponents();
            String componentsJson = JSONObject.toJSONString((Object)components);
            JSONArray headers = swagger.getJSONArray("headerList");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("gai_tool_api_test");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("operation", (Object)operationJson);
            parameter.setCustomParam("config", (Object)configTag);
            parameter.setCustomParam("components", (Object)componentsJson);
            String headerJson = headers.toJSONString();
            parameter.setCustomParam("headers", (Object)headerJson);
            parameter.setCustomParam("toolType", (Object)ToolConstant.ToolType.THIRD_OPENAPI.getType());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestApiCallback"));
            this.getView().showForm(parameter);
        }
    }

    private void restfulApiToolTest(String configTag) {
        JSONObject swagger = JSONObject.parseObject((String)configTag);
        JSONArray apiList = swagger.getJSONArray("apiList");
        if (apiList != null && !apiList.isEmpty()) {
            JSONObject api = apiList.getJSONObject(0);
            String operationId = api.getString("operationId");
            OperationParam operation = OpenAPIUtils.parserSingleRestfulOperationParam((JSONObject)swagger, (String)operationId);
            String operationJson = JSONObject.toJSONString((Object)operation);
            JSONArray headers = swagger.getJSONArray("headerList");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("gai_tool_api_test");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("operation", (Object)operationJson);
            parameter.setCustomParam("config", (Object)configTag);
            parameter.setCustomParam("components", (Object)"");
            String headerJson = headers.toJSONString();
            parameter.setCustomParam("headers", (Object)headerJson);
            parameter.setCustomParam("toolType", (Object)ToolConstant.ToolType.RESTFUL_API.getType());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestApiCallback"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject data;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (action.equals("afterTestApiCallback") && (data = (JSONObject)closedCallBackEvent.getReturnData()) != null) {
            HashMap<String, String> statusMap;
            String errorCode = data.getString("errCode");
            String operationId = data.getString("operationId");
            String cacheStr = this.getPageCache().get(OPENAPI_TEST_CACHE_PRE);
            HashMap<String, String> hashMap = statusMap = StringUtils.isEmpty((CharSequence)cacheStr) ? null : (HashMap<String, String>)JSONObject.parseObject((String)cacheStr, Map.class);
            if (statusMap == null) {
                statusMap = new HashMap<String, String>(0);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"0")) {
                statusMap.put(operationId, String.valueOf(1));
            } else {
                statusMap.put(operationId, String.valueOf(0));
            }
            this.getPageCache().put(OPENAPI_TEST_CACHE_PRE, JSONObject.toJSONString(statusMap));
        }
    }

    private String getHost() {
        String host = RequestContext.get().getClientFullContextPath();
        if (!StringUtils.isEmpty((CharSequence)host) && host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_tool");
        if (dynamicObject != null) {
            String name = dynamicObject.getString("name");
            String number = dynamicObject.getString("number");
            String desc = dynamicObject.getString("description");
            String illustrate = dynamicObject.getString("illustrate");
            String picture = dynamicObject.getString("picture");
            DynamicObject cloudObj = dynamicObject.getDynamicObject("cloud");
            DynamicObject appObj = dynamicObject.getDynamicObject("app");
            String source = dynamicObject.getString("source");
            if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                if (!StringUtils.isEmpty((CharSequence)picture) && picture.startsWith("/kingdee")) {
                    String toolPicture = this.getHost() + picture;
                    this.getModel().setValue(CONTROL_PICTURE, (Object)toolPicture);
                }
            } else {
                this.getModel().setValue(CONTROL_PICTURE, (Object)picture);
            }
            Label nameEl = (Label)this.getControl(CONTROL_LABEL_NAME);
            nameEl.setText(name);
            this.getModel().setValue("official", (Object)ResManager.loadKDString((String)"\u91d1\u8776\u5b98\u65b9", (String)"GaiToolDetailFormPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            Label numberEl = (Label)this.getControl(CONTROL_LABEL_NUMBER);
            numberEl.setText(number);
            Label cloudEl = (Label)this.getControl(CONTROL_LABEL_CLOUD);
            if (cloudObj != null) {
                cloudEl.setText(cloudObj.getString("name"));
            }
            Label appEl = (Label)this.getControl(CONTROL_LABEL_APP);
            if (appObj != null) {
                appEl.setText(appObj.getString("name"));
            }
            Label descEl = (Label)this.getControl(CONTROL_LABEL_DESC);
            descEl.setText(desc);
            Label illustrateEl = (Label)this.getControl(CONTROL_LABEL_ILLUSTRATE);
            illustrateEl.setText(illustrate);
            String configTag = dynamicObject.getString("config_tag");
            String toolType = dynamicObject.getString("tool_type");
            this.showParams(configTag, toolType, dynamicObject.getPkValue());
            this.getPageCache().put(CACHE_TOOL_TYPE, toolType);
            this.getPageCache().put(CACHE_TOOL_ID, String.valueOf(pkId));
        }
    }

    private void showParams(String config, String toolType, Object toolId) {
        JSONObject swaggerConfig = JSONObject.parseObject((String)config);
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PANEL_COSMIC_ACTION_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_PANEL_OPENAPI_AUTHORIZE});
            String authType = swaggerConfig.getString("authtype");
            ToolUtils.handlerOpenAPIAuthInfo((Object)toolId, (JSONObject)swaggerConfig);
            if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.NO_AUTH.getType())) {
                this.selectNOauth();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                this.selectServiceAuth();
                this.showServiceAuthFields(swaggerConfig.getJSONObject("serviceConfig"));
                this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_KEY_HEADER_SELECTOR});
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                this.selectOAuth();
                this.showOAuthFields(swaggerConfig.getJSONObject("oauthConfig"));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                this.selectCosmicAccessToken();
                this.showCosmicAccessTokenAuthFields(swaggerConfig.getJSONObject("cosmicAccessTokenConfig"));
            }
            this.getModel().setValue(CONTROL_AUTH_TYPE_SELECTOR, (Object)authType);
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_AUTH_TYPE_SELECTOR});
            JSONArray headers = swaggerConfig.getJSONArray("headerList");
            this.showHeaders(headers);
            JSONArray apiList = swaggerConfig.getJSONArray("apiList");
            this.putAPITestCache(apiList);
            if (apiList != null && !apiList.isEmpty()) {
                JSONObject api = apiList.getJSONObject(0);
                JSONArray inputParams = api.getJSONArray("inputParams");
                ToolAPIInfo info = new ToolAPIInfo();
                info.setInputParams(GaiToolDetailFormPlugin.transformOpenAPIToolParam(inputParams));
                JSONArray outputParams = api.getJSONArray("outputParams");
                info.setOutputParams(GaiToolDetailFormPlugin.transformOpenAPIToolParam(outputParams));
                this.showInputOutputTreeParams(toolType, info);
            }
            this.showHyperLink(swaggerConfig);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PANEL_OPENAPI_HEADER, CONTROL_PANEL_OPENAPI_AUTHORIZE});
            if (swaggerConfig != null) {
                JSONObject ca = JSONObject.parseObject((String)config);
                ToolUtils.handlerCosmicToolAuthInfo((Object)toolId, (JSONObject)ca);
                List apiInfos = ToolUtils.parserToolAPIList((String)config, (String)toolType, (String[])new String[0]);
                if (!apiInfos.isEmpty()) {
                    ToolAPIInfo info = (ToolAPIInfo)apiInfos.get(0);
                    this.showInputOutputTreeParams(toolType, info);
                }
                JSONArray configParams = ca.getJSONArray("configParams");
                this.showCustomActionConfigParams(configParams);
                this.showHyperLink(ca);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PANEL_COSMIC_ACTION_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_PANEL_OPENAPI_AUTHORIZE});
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PANEL_OPENAPI_HEADER, "flexpaneloutput", "flexpaneloutputtitle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TEST});
            }
            if (swaggerConfig != null) {
                List apiInfos;
                String authType = swaggerConfig.getString("authtype");
                ToolUtils.handlerOpenAPIAuthInfo((Object)toolId, (JSONObject)swaggerConfig);
                if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.NO_AUTH.getType())) {
                    this.selectNOauth();
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                    this.selectServiceAuth();
                    this.showServiceAuthFields(swaggerConfig.getJSONObject("serviceConfig"));
                    this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_KEY_HEADER_SELECTOR});
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                    this.selectOAuth();
                    this.showOAuthFields(swaggerConfig.getJSONObject("oauthConfig"));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                    this.selectCosmicAccessToken();
                    this.showCosmicAccessTokenAuthFields(swaggerConfig.getJSONObject("cosmicAccessTokenConfig"));
                }
                this.getModel().setValue(CONTROL_AUTH_TYPE_SELECTOR, (Object)authType);
                this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_AUTH_TYPE_SELECTOR});
                JSONArray headers = swaggerConfig.getJSONArray("headerList");
                this.showHeaders(headers);
                JSONArray apiList = swaggerConfig.getJSONArray("apiList");
                if (apiList != null && !apiList.isEmpty() && !(apiInfos = ToolUtils.parserToolAPIList((String)config, (String)toolType, (String[])new String[0])).isEmpty()) {
                    ToolAPIInfo info = (ToolAPIInfo)apiInfos.get(0);
                    this.showInputOutputTreeParams(toolType, info);
                }
                this.showHyperLink(swaggerConfig);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
            List apiInfos;
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PANEL_OPENAPI_HEADER, CONTROL_PANEL_OPENAPI_AUTHORIZE});
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PANEL_COSMIC_ACTION_CONFIG});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TEST});
            JSONArray apiList = swaggerConfig.getJSONArray("apiList");
            if (apiList != null && !apiList.isEmpty() && !(apiInfos = ToolUtils.parserToolAPIList((String)config, (String)toolType, (String[])new String[0])).isEmpty()) {
                ToolAPIInfo info = (ToolAPIInfo)apiInfos.get(0);
                this.showInputOutputTreeParams(toolType, info);
            }
            this.showHyperLink(swaggerConfig);
        }
    }

    private void showHyperLink(JSONObject config) {
        String linkUrl = config.getString("linkUrl");
        if (StringUtils.isEmpty((CharSequence)linkUrl)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_TOOL_ILLUSTRATE});
        } else {
            Hyperlink hyperlink = (Hyperlink)this.getControl(CONTROL_TOOL_ILLUSTRATE);
            hyperlink.setUrl(linkUrl);
        }
    }

    private void putAPITestCache(JSONArray operations) {
        if (operations != null && !operations.isEmpty()) {
            HashMap<String, String> statusMap = new HashMap<String, String>(0);
            for (int i = 0; i < operations.size(); ++i) {
                JSONObject operation = operations.getJSONObject(i);
                String operationId = operation.getString("operationId");
                String status = operation.getString("testStatus");
                statusMap.put(operationId, status);
            }
            this.getPageCache().put(OPENAPI_TEST_CACHE_PRE, JSONObject.toJSONString(statusMap));
        }
    }

    private void showHeaders(JSONArray headers) {
        this.getModel().deleteEntryData(CONTROL_HEADER_ENTIRY);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(CONTROL_HEADER_ENTIRY);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(CONTROL_HEADER_ENTIRY).getDynamicObjectType();
        if (headers != null && !headers.isEmpty()) {
            for (int i = 0; i < headers.size(); ++i) {
                JSONObject parameter = headers.getJSONObject(i);
                String name = parameter.getString("key");
                String value = parameter.getString("value");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set("headerkey", (Object)name);
                dynamicObject.set("headervalue", (Object)value);
                billEntityCollection.add((Object)dynamicObject);
            }
            this.getModel().updateEntryCache(billEntityCollection);
            this.getView().updateView(CONTROL_HEADER_ENTIRY);
        }
    }

    private void showServiceAuthFields(JSONObject serviceConfig) {
        this.getModel().setValue(CONTROL_KEY_HEADER_SELECTOR, serviceConfig.get((Object)"location"));
        this.getModel().setValue(CONTROL_PARAM_NAME, serviceConfig.get((Object)"paramName"));
        this.getModel().setValue(CONTROL_PARAM_VALUE, serviceConfig.get((Object)"paramValue"));
    }

    private JSONArray buildOpenAPIHeaderParams() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_HEADER_ENTIRY);
        DynamicObject[] dynamicObjects = entryGrid.getEntryData().getDataEntitys();
        JSONArray headers = new JSONArray();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String key = dynamicObject.getString("headerkey");
                if (StringUtils.isEmpty((CharSequence)key)) continue;
                String value = dynamicObject.getString("headervalue");
                JSONObject item = new JSONObject();
                item.put("key", (Object)key.trim());
                item.put("value", (Object)value);
                headers.add((Object)item);
            }
        }
        return headers;
    }

    private JSONArray buildCustomActionConfigParams() {
        DynamicObject[] entites;
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CONFIG_ENTITY);
        JSONArray params = new JSONArray();
        for (DynamicObject dynamicObject : entites = entryGrid.getEntryData().getDataEntitys()) {
            String varName = dynamicObject.getString(KEY_CONFIG_VAR_NAME);
            String configValue = dynamicObject.getString(KEY_CONFIG_VAR_VALUE);
            String configDesc = dynamicObject.getString(KEY_CONFIG_VAR_DESC);
            JSONObject param = new JSONObject();
            param.put("configName", (Object)varName);
            param.put("configValue", (Object)configValue);
            param.put("configDesc", (Object)configDesc);
            params.add((Object)param);
        }
        return params;
    }

    private JSONObject buildServiceAuthFields() {
        JSONObject serviceConfig = new JSONObject();
        serviceConfig.put("location", this.getModel().getValue(CONTROL_KEY_HEADER_SELECTOR));
        serviceConfig.put("paramName", this.getModel().getValue(CONTROL_PARAM_NAME));
        serviceConfig.put("paramValue", this.getModel().getValue(CONTROL_PARAM_VALUE));
        return serviceConfig;
    }

    private void showOAuthFields(JSONObject oauthConfig) {
        this.getModel().setValue(CONTROL_CLIENT_ID, oauthConfig.get((Object)CONTROL_CLIENT_ID));
        this.getModel().setValue(CONTROL_CLIENT_SECRET, oauthConfig.get((Object)CONTROL_CLIENT_SECRET));
        this.getModel().setValue(CONTROL_SCOPE, oauthConfig.get((Object)CONTROL_SCOPE));
        this.getModel().setValue(CONTROL_AUTHORIZATION_URL, oauthConfig.get((Object)CONTROL_AUTHORIZATION_URL));
        this.getModel().setValue(CONTROL_TOKEN_URL, oauthConfig.get((Object)CONTROL_TOKEN_URL));
    }

    private JSONObject buildOAuthFields() {
        JSONObject oauthConfig = new JSONObject();
        oauthConfig.put(CONTROL_CLIENT_ID, this.getModel().getValue(CONTROL_CLIENT_ID));
        oauthConfig.put(CONTROL_CLIENT_SECRET, this.getModel().getValue(CONTROL_CLIENT_SECRET));
        oauthConfig.put(CONTROL_SCOPE, this.getModel().getValue(CONTROL_SCOPE));
        oauthConfig.put(CONTROL_AUTHORIZATION_URL, this.getModel().getValue(CONTROL_AUTHORIZATION_URL));
        oauthConfig.put(CONTROL_TOKEN_URL, this.getModel().getValue(CONTROL_TOKEN_URL));
        return oauthConfig;
    }

    private void showCosmicAccessTokenAuthFields(JSONObject cosmicConfig) {
        this.getModel().setValue(CONTROL_COSMIC_CLIENT_ID, cosmicConfig.get((Object)CONTROL_CLIENT_ID));
        this.getModel().setValue(CONTROL_COSMIC_CLIENT_SECRET, cosmicConfig.get((Object)CONTROL_CLIENT_SECRET));
        this.getModel().setValue(CONTROL_COSMIC_USERNAME, cosmicConfig.get((Object)"username"));
        this.getModel().setValue(CONTROL_COSMIC_ACCOUNTID, cosmicConfig.get((Object)"accountId"));
        this.getModel().setValue(CONTROL_COSMIC_ACCESS_TOKEN_URL, cosmicConfig.get((Object)CONTROL_TOKEN_URL));
    }

    private JSONObject buildCosmicAccessTokenAuthFields() {
        JSONObject cosmicConfig = new JSONObject();
        cosmicConfig.put(CONTROL_CLIENT_ID, this.getModel().getValue(CONTROL_COSMIC_CLIENT_ID));
        cosmicConfig.put(CONTROL_CLIENT_SECRET, this.getModel().getValue(CONTROL_COSMIC_CLIENT_SECRET));
        cosmicConfig.put("username", this.getModel().getValue(CONTROL_COSMIC_USERNAME));
        cosmicConfig.put("accountId", this.getModel().getValue(CONTROL_COSMIC_ACCOUNTID));
        cosmicConfig.put(CONTROL_TOKEN_URL, this.getModel().getValue(CONTROL_COSMIC_ACCESS_TOKEN_URL));
        return cosmicConfig;
    }

    private void selectNOauth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
    }

    private void selectOAuth() {
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OPENAPI_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
    }

    private void selectServiceAuth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_SERVICE_AUTH_AP});
    }

    private void selectCosmicAccessToken() {
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP});
    }

    private void showCustomActionConfigParams(JSONArray params) {
        this.getModel().deleteEntryData(KEY_CONFIG_ENTITY);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(KEY_CONFIG_ENTITY);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(KEY_CONFIG_ENTITY).getDynamicObjectType();
        if (params != null && !params.isEmpty()) {
            for (int i = 0; i < params.size(); ++i) {
                JSONObject param = params.getJSONObject(i);
                String varName = param.getString("configName");
                String varType = param.getString("configValue");
                String varDesc = param.getString("configDesc");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set(KEY_CONFIG_VAR_NAME, (Object)varName);
                dynamicObject.set(KEY_CONFIG_VAR_VALUE, (Object)varType);
                dynamicObject.set(KEY_CONFIG_VAR_DESC, (Object)varDesc);
                billEntityCollection.add((Object)dynamicObject);
            }
            this.getModel().updateEntryCache(billEntityCollection);
            this.getView().updateView(KEY_CONFIG_ENTITY);
        }
    }

    private void showInputOutputTreeParams(String type, ToolAPIInfo apiInfo) {
        DynamicObjectType dynamicObjectType;
        List inputParams = apiInfo.getInputParams();
        List outputParams = apiInfo.getOutputParams();
        if (CollectionUtils.isNotEmpty((Collection)inputParams)) {
            dynamicObjectType = this.getModel().getEntryEntity(KEY_INPUT_ENTITY).getDynamicObjectType();
            inputParams.stream().forEach(param -> {
                DynamicObject row = this.buildAPIBodyDynamicObjectRow(KEY_INPUT_ENTITY, (ToolParam)param, dynamicObjectType);
                this.buildAPIEntryEntity(row, KEY_INPUT_ENTITY, (ToolParam)param, dynamicObjectType);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)outputParams)) {
            dynamicObjectType = this.getModel().getEntryEntity(KEY_OUTPUT_ENTITY).getDynamicObjectType();
            outputParams.stream().forEach(param -> {
                DynamicObject row = this.buildAPIBodyDynamicObjectRow(KEY_OUTPUT_ENTITY, (ToolParam)param, dynamicObjectType);
                this.buildAPIEntryEntity(row, KEY_OUTPUT_ENTITY, (ToolParam)param, dynamicObjectType);
            });
        }
    }

    private DynamicObject buildAPIBodyDynamicObjectRow(String entryKey, ToolParam param, DynamicObjectType dynamicObjectType) {
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        String paramName = KEY_INPUT_ENTITY.equals(entryKey) ? "inputparamname" : "outputparamname";
        String paramType = KEY_INPUT_ENTITY.equals(entryKey) ? "inputparamtype" : "outputparamtype";
        String desc = KEY_INPUT_ENTITY.equals(entryKey) ? "inputparamdesc" : "outputparamdesc";
        dynamicObject.set(paramName, (Object)param.getName());
        dynamicObject.set(paramType, (Object)param.getType());
        dynamicObject.set(desc, (Object)param.getDescription());
        return dynamicObject;
    }

    private void buildAPIEntryEntity(DynamicObject parentRow, String entryKey, ToolParam param, DynamicObjectType dynamicObjectType) {
        if (CollectionUtils.isNotEmpty((Collection)param.getSubParams())) {
            this.getModel().createNewEntryRow(entryKey, parentRow);
            param.getSubParams().stream().forEach(subParam -> {
                DynamicObject subRow = this.buildAPIBodyDynamicObjectRow(entryKey, (ToolParam)subParam, dynamicObjectType);
                subRow.set("Pid", parentRow.get("Id"));
                if (CollectionUtils.isNotEmpty((Collection)subParam.getSubParams())) {
                    this.buildAPIEntryEntity(subRow, entryKey, (ToolParam)subParam, dynamicObjectType);
                } else {
                    this.getModel().createNewEntryRow(entryKey, subRow);
                }
            });
        } else {
            this.getModel().createNewEntryRow(entryKey, parentRow);
        }
    }

    private static List<ToolParam> transformOpenAPIToolParam(JSONArray params) {
        ArrayList<ToolParam> toolParams = new ArrayList<ToolParam>(0);
        if (params != null && !params.isEmpty()) {
            for (int i = 0; i < params.size(); ++i) {
                JSONObject param = params.getJSONObject(i);
                String varName = param.getString("paramName");
                String varType = param.getString("paramType");
                String varDesc = param.getString("paramDesc");
                ToolParam toolParam = new ToolParam(varName, varType, varDesc);
                toolParams.add(toolParam);
            }
        }
        return toolParams;
    }
}

