/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.ToolPageCache;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.agent.tool.model.ImageParam;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.enuz.agent.CtrlStrategyEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.agent.MCPService;
import kd.ai.mcp.spec.McpSchema;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaiToolEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String FORM_ID = "gai_tool_edit";
    private static final String entryentity = "headerentryentity";
    private static final String CONTROL_SERVICE_AUTH_AP = "serviceauth_ap";
    private static final String TOOL_CONFIG_CACHE = "gai_tool_config";
    private static final String CONTROL_OPENAPI_AP = "openapi_ap";
    private static final String CONTROL_COSMIC_ACCESS_TOKEN_AP = "cosmic_at_ap";
    private static final String authContainer = "authinfo";
    private static final String apilistContainer = "apilistcontainer";
    private static final String headerContainer = "headercontainer";
    private static final String actionContainer = "actioncontainer";
    private static final String actionVarContainer = "actionvarcontainer";
    private static final String FLEX_API_CONFIG = "apiconfig";
    private static final String FLEX_MCP = "flexmcp";
    private static final String FLEX_MCP_EMPTY = "flex_mcp_empty";
    private static final String FLEX_MCP_NOT_EMPTY = "flex_mcp_not_empty";
    private static final String buttonaddapi = "buttonap";
    private static final String btneditapi = "editapi";
    private static final String TOOL_BASIC_INFO_FORM_ID = "gai_tool_info";
    private static final String TOOL_APP_API_FORM_ID = "gai_tool_add_api";
    private static final String TOOL_EDIT_CALLBACK_KEY = "gai_tool_edit_callback";
    private static final String apientryentity = "apientryentity";
    private static final String INPUTTREE = "inputtree";
    private static final String OUTPUTTREE = "outputtree";
    private static final String charSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String MCP_TOOL_ENTRY_ENTITY = "mcptoolentryentity";
    private static final String btntestapi = "operation_test";
    private static final String btntestapiok = "test_ok";
    private static final String btntestingapi = "testing";
    private static final String btntestapifail = "test_fail";
    private static final String deleteapi = "deleteapi";
    private static final Logger log = LoggerFactory.getLogger(GaiToolEditPlugin.class);
    private ToolPageCache cache;
    private static final String SYNC_TOOL = "synctool";
    private static final String ADD_API = "addapi";
    private static final String ADD_OPEN_API = "addopenapi";
    private static final String btnmcptestapi = "mcp_operation_test";
    private static final String btnmcptestapiok = "mcp_test_ok";
    private static final String btnmcptestingapi = "mcp_testing";
    private static final String btnmcptestapifail = "mcp_test_fail";
    private static final String CACHE_KEY_PREFIX = "toolname_images_cache";
    private static final String BTN_SYNC_TOOL = "advconbaritemap12";
    private static final Gson gson = new Gson();
    private static final String TOOL_SOURCE_CACHE = "_tool_source_cache_";

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new ToolPageCache(this.getView().getPageId());
        }
    }

    public ToolPageCache getCache() {
        return this.cache;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnaddapi = (Button)this.getControl(buttonaddapi);
        btnaddapi.addClickListener((ClickListener)this);
        Button btnEditapi = (Button)this.getControl(btneditapi);
        btnEditapi.addClickListener((ClickListener)this);
        Button btndeleteapi = (Button)this.getControl(deleteapi);
        btndeleteapi.addClickListener((ClickListener)this);
        Control btntestapi = this.getControl(btntestapi);
        ((ISuportClick)btntestapi).addClickListener((ClickListener)this);
        Control btntestapifail = this.getControl(btntestapifail);
        ((ISuportClick)btntestapifail).addClickListener((ClickListener)this);
        Control btntestapiok = this.getControl(btntestapiok);
        ((ISuportClick)btntestapiok).addClickListener((ClickListener)this);
        Control btntestingapi = this.getControl(btntestingapi);
        ((ISuportClick)btntestingapi).addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        CardEntry cardEntry = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ToolConstant.ToolType[] toolTypes;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP, CONTROL_OPENAPI_AP});
        Long toolId = (Long)this.getView().getFormShowParameter().getCustomParam("toolId");
        if (null != toolId) {
            this.initToolData(toolId);
        } else {
            String type = (String)this.getView().getFormShowParameter().getCustomParam("toolType");
            this.getPageCache().put(TOOL_SOURCE_CACHE, ToolConstant.ToolSource.CUSTOMIZE.getSource());
            String typeName = Arrays.stream(ToolConstant.ToolType.values()).filter(v -> v.getType().equals(type)).findFirst().get().getTypeName();
            String number = this.generateNumber();
            this.getModel().setValue("tool_number", (Object)number);
            this.getModel().setValue("tool_type", (Object)typeName);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP, "advconbaritemap3"});
            if (type.equals("cosmic_action")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{authContainer, "advconap"});
            } else if (type.equals(ToolConstant.ToolType.MCP_TOOL.getType()) || type.equals(ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_MCP_NOT_EMPTY, BTN_SYNC_TOOL, ADD_OPEN_API, CONTROL_SERVICE_AUTH_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP, CONTROL_OPENAPI_AP, actionContainer, actionVarContainer, "api_entity_container", "baractiontest"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP, CONTROL_OPENAPI_AP, actionContainer, actionVarContainer, "api_entity_container", "baractiontest"});
            }
            if (type.equals(ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"auth_selector"});
            }
            if (type.equals(ToolConstant.ToolType.MCP_TOOL.getType())) {
                List<ComboItem> paramItems = this.getMCPAuthComboItem();
                ComboEdit inputSourceParam = (ComboEdit)this.getControl("auth_selector");
                inputSourceParam.setComboItems(paramItems);
            }
        }
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u5de5\u5177\u5185\u6682\u65e0\u63a5\u53e3\uff0c\u8bf7\u5148\u6dfb\u52a0", (String)"GaiToolEditPlugin_25", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue("picture_title", (Object)ResManager.loadKDString((String)"\u5de5\u5177\u6807\u8bc6", (String)"GaiToolEditPlugin_28", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"tool_type"});
        String toolType = (String)this.getModel().getValue("tool_type");
        for (ToolConstant.ToolType type : toolTypes = ToolConstant.ToolType.values()) {
            if (!type.getTypeName().equals(toolType)) continue;
            toolType = type.getType();
            break;
        }
        if (ToolConstant.ToolType.COSMIC_ACTION.getType().equals(toolType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{authContainer, FLEX_MCP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{actionContainer, actionVarContainer});
        }
        if (!ToolConstant.ToolType.RESTFUL_API.getType().equals(toolType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{apilistContainer, headerContainer, "too_url"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_MCP});
        }
        if (!ToolConstant.ToolType.MCP_TOOL.getType().equals(toolType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap2", BTN_SYNC_TOOL, "mcp_url"});
            this.getModel().setValue("textfield2", (Object)ResManager.loadKDString((String)"\u5de5\u5177\u5185\u6682\u65e0\u63a5\u53e3\uff0c\u8bf7\u5148\u6dfb\u52a0", (String)"GaiToolEditPlugin_25", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        if (!ToolConstant.ToolType.INTERNAL_MCP.getType().equals(toolType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap21", "tool_cloud", ADD_OPEN_API});
            this.getModel().setValue("textfield2", (Object)ResManager.loadKDString((String)"\u6682\u65e0\u63a5\u53e3\uff0c\u8bf7\u5148\u540c\u6b65", (String)"GaiToolEditPlugin_26", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }

    private void handleImageForSelectedProgramme() {
        String name = ((OrmLocaleValue)this.getModel().getValue("tool_name")).getLocaleValue();
        Optional<String> cachedImage = this.getImageFromCache(name);
        if (cachedImage.isPresent()) {
            this.getModel().setValue("picture", (Object)cachedImage.get());
            return;
        }
        Optional images = ImageParam.createImages((String)name, (String)"tool");
        images.ifPresent(imagePath -> {
            this.saveImageToCache(name, (String)imagePath);
            this.getModel().setValue("picture", imagePath);
        });
    }

    private Optional<String> getImageFromCache(String programmeName) {
        String cacheContent = this.getPageCache().get(CACHE_KEY_PREFIX);
        if (StringUtils.isEmpty((CharSequence)cacheContent)) {
            return Optional.empty();
        }
        try {
            Map imageMap = (Map)gson.fromJson(cacheContent, new TypeToken<HashMap<String, String>>(){}.getType());
            return Optional.ofNullable(imageMap.get(programmeName));
        }
        catch (Exception e) {
            log.error("Failed to deserialize image cache: cache_key={}, error={}", new Object[]{CACHE_KEY_PREFIX, e.getMessage(), e});
            return Optional.empty();
        }
    }

    private void saveImageToCache(String toolName, String imagePath) {
        Map<String, String> imageMap;
        String cacheContent = this.getPageCache().get(CACHE_KEY_PREFIX);
        if (StringUtils.isEmpty((CharSequence)cacheContent)) {
            imageMap = new HashMap<String, String>();
        } else {
            try {
                imageMap = (Map)gson.fromJson(cacheContent, new TypeToken<HashMap<String, String>>(){}.getType());
            }
            catch (Exception e) {
                log.error("Failed to deserialize image cache while saving: cache_key={}, error={}", new Object[]{CACHE_KEY_PREFIX, e.getMessage(), e});
                imageMap = new HashMap();
            }
        }
        imageMap.put(toolName, imagePath);
        this.getPageCache().put(CACHE_KEY_PREFIX, gson.toJson(imageMap));
    }

    private DynamicObject buildToolInfo() {
        ToolConstant.ToolType[] toolTypes;
        String picture = (String)this.getModel().getValue("picture");
        String toolType = (String)this.getModel().getValue("tool_type");
        for (ToolConstant.ToolType type : toolTypes = ToolConstant.ToolType.values()) {
            if (!type.getTypeName().equals(toolType)) continue;
            toolType = type.getType();
            break;
        }
        String number = (String)this.getModel().getValue("tool_number");
        OrmLocaleValue description = (OrmLocaleValue)this.getModel().getValue("tool_description");
        DynamicObject cloud = (DynamicObject)this.getModel().getValue("tool_cloud");
        DynamicObject group = (DynamicObject)this.getModel().getValue("tool_group");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("tool_name");
        OrmLocaleValue illustrate = (OrmLocaleValue)this.getModel().getValue("illustrate");
        String url = (String)this.getModel().getValue("too_url");
        String mcpUrl = (String)this.getModel().getValue("mcp_url");
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_tool");
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("ctrlstrategy", (Object)CtrlStrategyEnum.ALL.getId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("picture", (Object)picture);
        dynamicObject.set("source", (Object)"customize");
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("org", (Object)BusinessDataServiceHelper.loadSingle((Object)RequestContext.getOrCreate().getOrgId(), (String)"bos_org"));
        dynamicObject.set("group", (Object)group);
        dynamicObject.set("cloud", (Object)cloud);
        if (null != this.getModel().getValue("serviceapp")) {
            DynamicObject appObject = (DynamicObject)this.getModel().getValue("serviceapp");
            String appid = appObject.getString("id");
            this.getPageCache().put("tool_app_id_" + dynamicObject.getString("number"), appid);
            dynamicObject.set("app", (Object)appObject);
            DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)appid, (String)"bos_devportal_bizapp");
            this.getModel().setValue("tool_cloud", (Object)app.getDynamicObject("bizcloud"));
            dynamicObject.set("cloud", (Object)app.getDynamicObject("bizcloud"));
        }
        dynamicObject.set("tool_type", (Object)toolType);
        dynamicObject.set("description", (Object)description);
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("illustrate", (Object)illustrate);
        JSONObject config = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(TOOL_CONFIG_CACHE + dynamicObject.getString("number")))) {
            config = JSONObject.parseObject((String)this.getPageCache().get(TOOL_CONFIG_CACHE + dynamicObject.getString("number")));
        }
        config.put("url", (Object)(StringUtils.isNotEmpty((CharSequence)url) ? url : mcpUrl));
        config.put("authtype", (Object)AuthType.NO_AUTH.getType());
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryentity);
        if (entryentity.size() > 0) {
            JSONArray headerlist = new JSONArray();
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryentity.get(i);
                JSONObject headerParam = new JSONObject();
                headerParam.put("key", (Object)entity.getString("header_key"));
                headerParam.put("value", (Object)entity.getString("header_value"));
                headerlist.add((Object)headerParam);
            }
            config.put("headerList", (Object)headerlist);
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("picture")))) {
            this.handleImageForSelectedProgramme();
        }
        dynamicObject.set("config_tag", (Object)config.toJSONString());
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("enable", (Object)0);
        this.getPageCache().put(TOOL_CONFIG_CACHE + dynamicObject.getString("number"), config.toJSONString());
        this.getModel().setValue("tool_detail", (Object)dynamicObject);
        return dynamicObject;
    }

    private void buildHeader(JSONObject swagger) {
        int i;
        JSONArray headerList = swagger.getJSONArray("headerList");
        if (null == headerList || headerList.size() == 0) {
            return;
        }
        int size = this.getModel().getEntryEntity(entryentity).size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                this.getModel().deleteEntryRow(entryentity, i);
            }
        }
        this.getModel().batchCreateNewEntryRow(entryentity, headerList.size());
        for (i = 0; i < headerList.size(); ++i) {
            JSONObject header = headerList.getJSONObject(i);
            this.getModel().setValue("header_key", (Object)header.getString("key"), i);
            this.getModel().setValue("header_value", (Object)header.getString("value"), i);
        }
    }

    private String generateNumber() {
        StringBuilder number = new StringBuilder("tool-");
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 8; ++i) {
            int index = random.nextInt(charSet.length());
            number.append(charSet.charAt(index));
        }
        return number.toString();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        HashMap<String, String> properties;
        HashMap customProperties;
        CardEntry cardEntry;
        HashMap customProperties2;
        CardEntry cardEntry2;
        String testStatus;
        String propertyName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        JSONObject configTag = new JSONObject();
        String configTagStr = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
        if (StringUtils.isEmpty((CharSequence)configTagStr)) {
            String url = (String)this.getModel().getValue("too_url");
            String mcpUrl = (String)this.getModel().getValue("mcp_url");
            configTag.put("url", (Object)(StringUtils.isNotEmpty((CharSequence)url) ? url : mcpUrl));
            configTag.put("authtype", (Object)AuthType.NO_AUTH.getType());
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryentity);
            if (entryentity.size() > 0) {
                JSONArray headerlist = new JSONArray();
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject entity = (DynamicObject)entryentity.get(i);
                    JSONObject headerParam = new JSONObject();
                    headerParam.put("key", (Object)entity.getString("header_key"));
                    headerParam.put("value", (Object)entity.getString("header_value"));
                    headerlist.add((Object)headerParam);
                }
                configTag.put("headerList", (Object)headerlist);
            }
        } else {
            configTag = JSONObject.parseObject((String)configTagStr);
        }
        if (propertyName.equals("auth_selector") && null != data.getNewValue()) {
            switch (data.getNewValue().toString()) {
                case "oauth": {
                    JSONObject oauthConfig;
                    this.selectOAuth();
                    if (configTag.containsKey((Object)"oauthConfig")) {
                        oauthConfig = JSONObject.parseObject((String)configTag.getString("oauthConfig"));
                        this.getModel().setValue("client_id", (Object)oauthConfig.getString("client_id"));
                        this.getModel().setValue("client_secret", (Object)oauthConfig.getString("client_secret"));
                        this.getModel().setValue("token_url", (Object)oauthConfig.getString("token_url"));
                        this.getModel().setValue("scope", (Object)oauthConfig.getString("scope"));
                        this.getModel().setValue("authorization_url", (Object)oauthConfig.getString("authorization_url"));
                        break;
                    }
                    configTag.remove((Object)"cosmicAccessTokenConfig");
                    configTag.remove((Object)"serviceConfig");
                    oauthConfig = new JSONObject();
                    oauthConfig.put("client_id", this.getModel().getValue("client_id"));
                    oauthConfig.put("client_secret", this.getModel().getValue("client_secret"));
                    oauthConfig.put("token_url", this.getModel().getValue("token_url"));
                    oauthConfig.put("scope", this.getModel().getValue("scope"));
                    oauthConfig.put("authorization_url", this.getModel().getValue("authorization_url"));
                    configTag.put("oauthConfig", (Object)oauthConfig);
                    break;
                }
                case "cosmic_access_token": {
                    JSONObject cosmicAccessTokenConfig;
                    this.selectCosmicAccessToken();
                    if (configTag.containsKey((Object)"cosmicAccessTokenConfig")) {
                        cosmicAccessTokenConfig = JSONObject.parseObject((String)configTag.getString("cosmicAccessTokenConfig"));
                        this.getModel().setValue("cosmic_client_id", (Object)cosmicAccessTokenConfig.getString("client_id"));
                        this.getModel().setValue("cosmic_client_secret", (Object)cosmicAccessTokenConfig.getString("client_secret"));
                        this.getModel().setValue("cosmic_username", (Object)cosmicAccessTokenConfig.getString("username"));
                        this.getModel().setValue("cosmic_accountid", (Object)cosmicAccessTokenConfig.getString("accountId"));
                        this.getModel().setValue("cosmic_token_url", (Object)cosmicAccessTokenConfig.getString("token_url"));
                        break;
                    }
                    configTag.remove((Object)"oauthConfig");
                    configTag.remove((Object)"serviceConfig");
                    cosmicAccessTokenConfig = new JSONObject();
                    cosmicAccessTokenConfig.put("client_id", this.getModel().getValue("cosmic_client_id"));
                    cosmicAccessTokenConfig.put("client_secret", this.getModel().getValue("cosmic_client_secret"));
                    cosmicAccessTokenConfig.put("username", this.getModel().getValue("cosmic_username"));
                    cosmicAccessTokenConfig.put("accountId", this.getModel().getValue("cosmic_accountid"));
                    cosmicAccessTokenConfig.put("token_url", this.getModel().getValue("cosmic_token_url"));
                    configTag.put("cosmicAccessTokenConfig", (Object)cosmicAccessTokenConfig);
                    break;
                }
                case "service": {
                    JSONObject serviceConfig;
                    this.selectServiceAuth();
                    if (configTag.containsKey((Object)"serviceConfig")) {
                        serviceConfig = JSONObject.parseObject((String)configTag.getString("serviceConfig"));
                        this.getModel().setValue("key_selector", (Object)serviceConfig.getString("location"));
                        this.getModel().setValue("param_name", (Object)serviceConfig.getString("paramName"));
                        this.getModel().setValue("param_value", (Object)serviceConfig.getString("paramValue"));
                        break;
                    }
                    configTag.remove((Object)"oauthConfig");
                    configTag.remove((Object)"cosmicAccessTokenConfig");
                    serviceConfig = new JSONObject();
                    serviceConfig.put("location", this.getModel().getValue("key_selector"));
                    serviceConfig.put("paramName", this.getModel().getValue("param_name"));
                    serviceConfig.put("paramValue", this.getModel().getValue("param_value"));
                    configTag.put("serviceConfig", (Object)serviceConfig);
                    break;
                }
                default: {
                    this.selectNOauth();
                }
            }
            configTag.put("authtype", (Object)data.getNewValue().toString());
        } else if (propertyName.equals("cosmic_client_id") && null != data.getNewValue()) {
            configTag.getJSONObject("cosmicAccessTokenConfig").put("client_id", data.getNewValue());
        } else if (propertyName.equals("cosmic_client_secret") && null != data.getNewValue()) {
            configTag.getJSONObject("cosmicAccessTokenConfig").put("client_secret", data.getNewValue());
        } else if (propertyName.equals("cosmic_username") && null != data.getNewValue()) {
            configTag.getJSONObject("cosmicAccessTokenConfig").put("username", data.getNewValue());
        } else if (propertyName.equals("cosmic_accountid") && null != data.getNewValue()) {
            configTag.getJSONObject("cosmicAccessTokenConfig").put("accountId", data.getNewValue());
        } else if (propertyName.equals("cosmic_token_url") && null != data.getNewValue()) {
            configTag.getJSONObject("cosmicAccessTokenConfig").put("token_url", data.getNewValue());
        } else if (propertyName.equals("client_id") && null != data.getNewValue()) {
            configTag.getJSONObject("oauthConfig").put("client_id", data.getNewValue());
        } else if (propertyName.equals("client_secret") && null != data.getNewValue()) {
            configTag.getJSONObject("oauthConfig").put("client_secret", data.getNewValue());
        } else if (propertyName.equals("token_url") && null != data.getNewValue()) {
            configTag.getJSONObject("oauthConfig").put("token_url", data.getNewValue());
        } else if (propertyName.equals("scope") && null != data.getNewValue()) {
            configTag.getJSONObject("oauthConfig").put("scope", data.getNewValue());
        } else if (propertyName.equals("authorization_url") && null != data.getNewValue()) {
            configTag.getJSONObject("oauthConfig").put("authorization_url", data.getNewValue());
        } else if (propertyName.equals("key_selector") && null != data.getNewValue()) {
            configTag.getJSONObject("serviceConfig").put("location", data.getNewValue());
        } else if (propertyName.equals("param_name") && null != data.getNewValue()) {
            configTag.getJSONObject("serviceConfig").put("paramName", data.getNewValue());
        } else if (propertyName.equals("param_value") && null != data.getNewValue()) {
            configTag.getJSONObject("serviceConfig").put("paramValue", data.getNewValue());
        } else if (propertyName.equals("mcp_url") && null != data.getNewValue()) {
            configTag.put("url", data.getNewValue());
        } else if (propertyName.equals("url") && null != data.getNewValue()) {
            configTag.put("url", data.getNewValue());
        } else if (propertyName.equals("enable") && ((Boolean)data.getNewValue()).booleanValue()) {
            int selectRow = data.getRowIndex();
            testStatus = ((DynamicObject)this.getModel().getEntryEntity(apientryentity).get(selectRow)).getString("test_status");
            if (testStatus.equals("1")) {
                String message = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0capi\u6d4b\u8bd5\u4e0d\u901a\u8fc7\u3002", (String)"GaiToolEditPlugin_11", (String)"ai-gai-plugin", (Object[])new Object[0]);
                ((DynamicObject)this.getModel().getEntryEntity(apientryentity).get(selectRow)).set("enable", (Object)false);
                this.getView().showErrorNotification(message);
            } else if (!StringUtils.equalsIgnoreCase((CharSequence)testStatus, (CharSequence)"0")) {
                ((DynamicObject)this.getModel().getEntryEntity(apientryentity).get(selectRow)).set("enable", (Object)false);
                this.getView().updateView("enable", selectRow);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u6d4b\u8bd5\u901a\u8fc7\u540e\u624d\u80fd\u542f\u7528\u3002", (String)"GaiToolEditPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]));
            } else {
                cardEntry2 = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
                customProperties2 = new HashMap();
                HashMap<String, String> properties2 = new HashMap<String, String>();
                properties2.put("bc", "#f2f6ff");
                customProperties2.put("apicardcontainer", properties2);
                cardEntry2.setCustomProperties(cardEntry2.getKey(), selectRow, customProperties2);
            }
        } else if (propertyName.equals("enable") && !((Boolean)data.getNewValue()).booleanValue()) {
            int selectRow = data.getRowIndex();
            cardEntry = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
            customProperties = new HashMap();
            properties = new HashMap<String, String>();
            properties.put("bc", "#FAFAFA");
            customProperties.put("apicardcontainer", properties);
            cardEntry.setCustomProperties(cardEntry.getKey(), selectRow, customProperties);
        } else if (propertyName.equals("mcptool_enable") && ((Boolean)data.getNewValue()).booleanValue()) {
            int selectRow = data.getRowIndex();
            testStatus = ((DynamicObject)this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY).get(selectRow)).getString("mcptool_test_status");
            if (!StringUtils.equalsIgnoreCase((CharSequence)testStatus, (CharSequence)"0")) {
                ((DynamicObject)this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY).get(selectRow)).set("mcptool_enable", (Object)false);
                this.getView().updateView("mcptool_enable", selectRow);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u6d4b\u8bd5\u901a\u8fc7\u540e\u624d\u80fd\u542f\u7528\u3002", (String)"GaiToolEditPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]));
            } else {
                cardEntry2 = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
                customProperties2 = new HashMap();
                HashMap<String, String> properties3 = new HashMap<String, String>();
                properties3.put("bc", "#f2f6ff");
                customProperties2.put("mcpapicardcontainer", properties3);
                cardEntry2.setCustomProperties(cardEntry2.getKey(), selectRow, customProperties2);
            }
        } else if (propertyName.equals("mcptool_enable") && !((Boolean)data.getNewValue()).booleanValue()) {
            int selectRow = data.getRowIndex();
            cardEntry = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
            customProperties = new HashMap();
            properties = new HashMap();
            properties.put("bc", "#FAFAFA");
            customProperties.put("mcpapicardcontainer", properties);
            cardEntry.setCustomProperties(cardEntry.getKey(), selectRow, customProperties);
        } else if (propertyName.equals("tool_name") && null != data.getNewValue() && StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("picture")))) {
            this.handleImageForSelectedProgramme();
        }
        this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configTag.toJSONString());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (action.equals("edit_api_callback") && null != returnData) {
            JSONObject apiInfo = (JSONObject)returnData;
            if (null != apiInfo) {
                int selectRow = Integer.parseInt(this.getPageCache().get("editapi_row"));
                String configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
                JSONObject configJson = JSONObject.parseObject((String)configTag);
                if (null == configJson) {
                    configJson = new JSONObject();
                }
                JSONArray apiList = configJson.getJSONArray("apiList");
                Boolean isChanged = false;
                if (null == apiList) {
                    apiList = new JSONArray();
                    apiList.add((Object)apiInfo);
                    isChanged = true;
                } else if (this.checkApiChanged(apiInfo, selectRow, apiList)) {
                    apiList.set(selectRow, (Object)apiInfo);
                    isChanged = true;
                }
                if (isChanged.booleanValue()) {
                    configJson.put("apiList", (Object)apiList);
                    int size = this.getModel().getEntryEntity(apientryentity).size();
                    for (int i = 0; i < size; ++i) {
                        this.getModel().deleteEntryRow(apientryentity, 0);
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_empty_container"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"api_entity_container", "advconbaritemap3"});
                    this.buildRESTfulApiList(configJson, false);
                    this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configJson.toJSONString());
                }
            }
        } else if (action.equals("add_api_callback") && null != returnData) {
            JSONObject apiInfo = (JSONObject)returnData;
            if (null != apiInfo) {
                JSONArray apiList;
                String configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
                JSONObject configJson = JSONObject.parseObject((String)configTag);
                if (null == configJson) {
                    configJson = new JSONObject();
                }
                if (null == (apiList = configJson.getJSONArray("apiList"))) {
                    apiList = new JSONArray();
                    apiList.add((Object)apiInfo);
                } else {
                    for (int i = 0; i < apiList.size(); ++i) {
                        JSONObject api = apiList.getJSONObject(i);
                        if (!api.getString("operationId").equals(apiInfo.getString("operationId"))) continue;
                        String message = ResManager.loadKDString((String)"\u65b0\u589e\u7684api\u8def\u5f84\u548c\u8bf7\u6c42\u65b9\u6cd5\u5df2\u5b58\u5728\uff01", (String)"GaiToolEditPlugin_13", (String)"ai-gai-plugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    apiList.add((Object)apiInfo);
                }
                configJson.put("apiList", (Object)apiList);
                int size = this.getModel().getEntryEntity(apientryentity).size();
                for (int i = 0; i < size; ++i) {
                    this.getModel().deleteEntryRow(apientryentity, 0);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_empty_container"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"api_entity_container", "advconbaritemap3"});
                this.buildRESTfulApiList(configJson, false);
                this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configJson.toJSONString());
                this.getView().getModel().setDataChanged(true);
            }
        } else if (action.equals("afterTestApiCallback")) {
            JSONObject data = (JSONObject)closedCallBackEvent.getReturnData();
            if (data != null) {
                int row;
                String errorCode = data.getString("errCode");
                String operationId = data.getString("operationId");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(apientryentity);
                DynamicObject selectData = null;
                for (row = 0; row < entryEntity.size(); ++row) {
                    DynamicObject v2 = (DynamicObject)entryEntity.get(row);
                    if (!v2.getString("operationId").equals(operationId)) continue;
                    selectData = v2;
                    break;
                }
                if (null == selectData) {
                    ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, row, new String[]{btntestapi, btntestapiok, btntestingapi});
                    ((CardEntry)this.getControl(apientryentity)).setChildVisible(true, row, new String[]{"apistatusfail", btntestapifail});
                    String message = ResManager.loadKDString((String)"\u6d4b\u8bd5\u63a5\u53e3\u5f02\u5e38\u3002", (String)"GaiToolEditPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                } else {
                    JSONObject config = JSONObject.parseObject((String)this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number")));
                    JSONArray apiList = config.getJSONArray("apiList");
                    for (int i = 0; i < apiList.size(); ++i) {
                        JSONObject apiJSON = apiList.getJSONObject(i);
                        if (!apiJSON.getString("operationId").equals(operationId)) continue;
                        if (StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"0")) {
                            this.getModel().setValue("test_status", (Object)"0", row);
                            apiJSON.put("testStatus", (Object)"0");
                            ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, row, new String[]{"apistatusfail", btntestapi, btntestapifail, btntestingapi});
                            ((CardEntry)this.getControl(apientryentity)).setChildVisible(true, row, new String[]{"apistatus_ok", btntestapiok});
                            ((CardEntry)this.getControl(apientryentity)).setChildEnable(true, row, new String[]{"enable"});
                        } else {
                            this.getModel().setValue("test_status", (Object)"1", row);
                            apiJSON.put("testStatus", (Object)"1");
                            ((CardEntry)this.getControl(apientryentity)).setChildVisible(true, row, new String[]{"apistatusfail", btntestapifail});
                            ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, row, new String[]{"apistatus_ok", btntestapi, btntestapiok, btntestingapi});
                        }
                        apiList.set(i, (Object)apiJSON);
                    }
                    config.put("apiList", (Object)apiList);
                    this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), config.toJSONString());
                }
            } else {
                Integer apiRow = Integer.valueOf(this.getPageCache().get("test_api_row"));
                String testApiStatus = this.getPageCache().get("test_api_status");
                ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, apiRow.intValue(), new String[]{btntestingapi});
                ((CardEntry)this.getControl(apientryentity)).setChildVisible(true, apiRow.intValue(), new String[]{testApiStatus});
            }
        } else if (action.equals("afterTestMcpToolCallback")) {
            JSONObject data = (JSONObject)closedCallBackEvent.getReturnData();
            if (data != null) {
                int row;
                String errorCode = data.getString("errCode");
                String operationId = data.getString("operationId");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY);
                DynamicObject selectData = null;
                for (row = 0; row < entryEntity.size(); ++row) {
                    DynamicObject v3 = (DynamicObject)entryEntity.get(row);
                    if (!v3.getString("mcptool_operationId").equals(operationId)) continue;
                    selectData = v3;
                    break;
                }
                if (null == selectData) {
                    String message = ResManager.loadKDString((String)"\u6d4b\u8bd5\u5de5\u5177\u5f02\u5e38\u3002", (String)"GaiToolEditPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(message);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"0")) {
                    this.getModel().setValue("mcptool_test_status", (Object)0, row);
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, row, new String[]{"mcptool_status_fail", btnmcptestapi, btnmcptestapifail, btnmcptestingapi});
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, row, new String[]{"mcptool_status_ok", btnmcptestapiok});
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildEnable(true, row, new String[]{"enable"});
                } else if (StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"1")) {
                    this.getModel().setValue("mcptool_test_status", (Object)1, row);
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, row, new String[]{"mcptool_status_fail", btnmcptestapifail});
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, row, new String[]{"mcptool_status_ok", btnmcptestapi, btnmcptestapiok, btnmcptestingapi});
                }
            } else {
                EntryGrid entryGrid = (EntryGrid)this.getControl(MCP_TOOL_ENTRY_ENTITY);
                int row = entryGrid.getEntryState().getFocusRow();
                ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, row, new String[]{btnmcptestapi});
                ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, row, new String[]{btnmcptestapiok, btnmcptestingapi, btnmcptestingapi});
            }
        } else if (action.equals("select_openapi_callback") && null != returnData) {
            JSONArray apiList;
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)returnData;
            ArrayList apiIds = new ArrayList(0);
            selectRows.forEach(rowx -> apiIds.add(rowx.getPrimaryKeyValue()));
            List apis = BusinessDataServiceHelper.loadFromCache((Object[])apiIds.toArray(), (String)"openapi_apilist").values().stream().collect(Collectors.toList());
            JSONArray apiArrays = new JSONArray();
            for (DynamicObject api : apis) {
                JSONObject apiInfo = new JSONObject();
                String method = api.getString("httpmethod").equals("0") ? "GET" : "POST";
                apiInfo.put("method", (Object)method);
                apiInfo.put("name", (Object)api.getLocaleString("name").getLocaleValue());
                apiInfo.put("testStatus", (Object)"");
                String readlocation = api.getString("urlformat").replaceAll("/", "_");
                apiInfo.put("operationId", (Object)(method + readlocation));
                apiInfo.put("description", (Object)api.getString("discription"));
                apiInfo.put("enable", (Object)"0");
                apiInfo.put("location", (Object)api.getString("urlformat"));
                apiInfo.put("contentType", (Object)(method.equals("GET") ? "x-www-form-urlencoded" : "application/json"));
                apiInfo.put("enable", this.getModel().getValue("enable"));
                apiInfo.put("testStatus", this.getModel().getValue("test_status"));
                apiInfo.put("openApiId", (Object)api.getLong("id"));
                apiArrays.add((Object)apiInfo);
            }
            String configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
            JSONObject configJson = JSONObject.parseObject((String)configTag);
            if (null == configJson) {
                configJson = new JSONObject();
            }
            if (null == (apiList = configJson.getJSONArray("apiList"))) {
                apiList = new JSONArray();
                apiList.addAll((Collection)apiArrays);
            } else {
                for (int i = 0; i < apiList.size(); ++i) {
                    JSONObject api = apiList.getJSONObject(i);
                    List operationId = apiArrays.stream().map(v -> ((JSONObject)v).getString("openApiId")).collect(Collectors.toList());
                    if (!operationId.contains(api.getString("openApiId"))) continue;
                    apiList.remove((Object)api);
                }
                apiList.addAll((Collection)apiArrays);
            }
            configJson.put("apiList", (Object)apiList);
            int size = this.getModel().getEntryEntity(apientryentity).size();
            for (int i = 0; i < size; ++i) {
                this.getModel().deleteEntryRow(apientryentity, 0);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_empty_container"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_MCP_NOT_EMPTY, ADD_OPEN_API});
            this.getModel().deleteEntryData(MCP_TOOL_ENTRY_ENTITY);
            this.buildInternalMCPToolList(configJson);
            this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configJson.toJSONString());
            this.getView().getModel().setDataChanged(true);
        }
    }

    private boolean checkApiChanged(JSONObject apiInfo, int selectRow, JSONArray apiList) {
        JSONObject apiOldData = apiList.getJSONObject(selectRow);
        boolean change = false;
        Set entries = apiInfo.entrySet();
        for (Map.Entry entry : entries) {
            if (null != apiOldData.get(entry.getKey()) && entry.getValue().equals(apiOldData.get(entry.getKey()))) continue;
            change = true;
            break;
        }
        return change;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.lowerCase((String)key).equals(btneditapi)) {
            String configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
            int selectRow = this.getModel().getEntryCurrentRowIndex(apientryentity);
            this.getPageCache().put("editapi_row", selectRow + "");
            JSONArray apiList = JSONObject.parseObject((String)configTag).getJSONArray("apiList");
            JSONObject apiInfo = apiList.getJSONObject(selectRow);
            apiInfo.put("source", (Object)this.getPageCache().get(TOOL_SOURCE_CACHE));
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(TOOL_APP_API_FORM_ID);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setCustomParam("apiInfo", (Object)apiInfo);
            lsp.setShowTitle(false);
            lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "edit_api_callback"));
            this.getView().showForm(lsp);
        } else if (StringUtils.lowerCase((String)key).equals(deleteapi)) {
            int selectRow = this.getModel().getEntryCurrentRowIndex(apientryentity);
            String deleteOperationid = ((DynamicObject)this.getModel().getEntryEntity(apientryentity).get(selectRow)).getString("operationid");
            this.getModel().deleteEntryRow(apientryentity, selectRow);
            String configTag = "";
            DynamicObject toolDetail = (DynamicObject)this.getModel().getValue("tool_detail");
            if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"))) {
                configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
            } else if (null != toolDetail && null != toolDetail.getPkValue()) {
                if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"))) {
                    configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"));
                } else {
                    DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolDetail.getPkValue(), (String)"gai_tool");
                    configTag = tool.getString("config_tag");
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fdd\u5b58\u540e\u6d4b\u8bd5", (String)"GaiToolEditPlugin_29", (String)"ai-gai-plugin", (Object[])new Object[0]));
                return;
            }
            JSONObject configJo = JSONObject.parseObject((String)configTag);
            JSONArray apiList = configJo.getJSONArray("apiList");
            List deleteApis = apiList.stream().filter(v -> ((JSONObject)v).getString("operationId").equals(deleteOperationid)).map(v -> (JSONObject)v).collect(Collectors.toList());
            apiList.removeAll(deleteApis);
            configJo.put("apiList", (Object)apiList.toJSONString());
            this.getPageCache().put(TOOL_CONFIG_CACHE + toolDetail.getString("number"), configJo.toJSONString());
            if (this.getModel().getEntryEntity(apientryentity).size() == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_entity_container"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"api_empty_container"});
            }
        } else if (StringUtils.lowerCase((String)key).equals(btntestapifail) || StringUtils.lowerCase((String)key).equals(btntestapiok) || StringUtils.lowerCase((String)key).equals(btntestapi)) {
            int selectRow = this.getModel().getEntryCurrentRowIndex(apientryentity);
            ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, selectRow, new String[]{btntestapifail, btntestapiok, btntestapi});
            ((CardEntry)this.getControl(apientryentity)).setChildVisible(true, selectRow, new String[]{btntestingapi});
            this.getPageCache().put("test_api_row", selectRow + "");
            this.getPageCache().put("test_api_status", key);
            this.operaTestApi();
        } else if (StringUtils.lowerCase((String)key).equals(btntestingapi)) {
            this.operaTestApi();
        }
    }

    private void showAddApiForm() {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId(TOOL_APP_API_FORM_ID);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "add_api_callback"));
        this.getView().showForm(lsp);
    }

    private void showOpenAPISelectList() {
        ListShowParameter lsp = new ListShowParameter();
        String billFormId = "openapi_apilist";
        lsp.setBillFormId(billFormId);
        lsp.setShowApproved(true);
        lsp.setFormId("bos_listf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        lsp.setMultiSelect(Boolean.TRUE.booleanValue());
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700");
        inlineStyleCss.setWidth("1200");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        DynamicObject cloud = (DynamicObject)this.getModel().getValue("tool_cloud");
        if (null != cloud) {
            QFilter qFilter = new QFilter("appid.bizcloud.Id", "=", (Object)cloud.getString("id")).and(new QFilter("version", "=", (Object)"2"));
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            lsp.setListFilterParameter(listFilterParameter);
        }
        lsp.setLookUp(true);
        lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "select_openapi_callback"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldName = e.getKey();
        if ("auth_selector".equals(fieldName)) {
            String authtype = (String)e.getValue();
            String toolType = (String)this.getModel().getValue("tool_type");
            if (ToolConstant.ToolType.MCP_TOOL.getType().equals(toolType) && !AuthType.SERVICE.getType().equals(authtype) && !AuthType.COSMIC_ACCESS_TOKEN.getType().equals(authtype) && !AuthType.NO_AUTH.getType().equals(authtype)) {
                this.getView().updateView(fieldName);
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u9274\u6743\u65b9\u5f0f", (String)"GaiToolEditPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (eventArgs.getOperateKey().equals(SYNC_TOOL)) {
            DynamicObjectCollection mcpEntryEntity = this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY);
            if (mcpEntryEntity != null && !mcpEntryEntity.isEmpty()) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(SYNC_TOOL, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u91cd\u65b0\u540c\u6b65\uff1f", (String)"GaiToolEditPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
            } else {
                this.syncTool();
            }
        } else if (eventArgs.getOperateKey().equals(ADD_API)) {
            this.showAddApiForm();
        } else if (eventArgs.getOperateKey().equals(ADD_OPEN_API)) {
            this.showOpenAPISelectList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int value;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)SYNC_TOOL, (CharSequence)callBackId) && (value = messageBoxClosedEvent.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.syncTool();
        }
        if (StringUtils.equals((CharSequence)"bar_close", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put("confirmClose", "1");
            this.getView().close();
        }
    }

    private void syncTool() {
        try {
            String configTag = "";
            if (null != this.getModel().getValue("tool_detail")) {
                DynamicObject toolDetail = (DynamicObject)this.getModel().getValue("tool_detail");
                DynamicObject tool = BusinessDataServiceHelper.loadSingleFromCache((Object)toolDetail.getPkValue(), (String)"gai_tool");
                configTag = tool.getString("config_tag");
            }
            if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"))) {
                configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
            }
            if (StringUtils.isEmpty((CharSequence)configTag)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"URL\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolInfoPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
                return;
            }
            JSONObject configJo = JSONObject.parseObject((String)configTag);
            Map<String, Boolean> nameEnableMap = this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY).stream().collect(Collectors.toMap(v -> v.getString("mcptool_name"), v -> v.getBoolean("mcptool_enable")));
            this.buildAuthInfo(configJo);
            JSONArray apiListJa = new JSONArray();
            McpSchema.ListToolsResult listToolsResult = MCPService.getService().toolsList(configJo.toJSONString());
            int apiCount = 0;
            if (listToolsResult != null && CollectionUtils.isNotEmpty((Collection)listToolsResult.tools())) {
                apiCount = listToolsResult.tools().size();
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_MCP_EMPTY});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_MCP_NOT_EMPTY, BTN_SYNC_TOOL});
                List toolList = listToolsResult.tools();
                this.getModel().deleteEntryData(MCP_TOOL_ENTRY_ENTITY);
                this.getModel().batchCreateNewEntryRow(MCP_TOOL_ENTRY_ENTITY, toolList.size());
                for (int row = 0; row < toolList.size(); ++row) {
                    McpSchema.Tool mcpTool = (McpSchema.Tool)toolList.get(row);
                    this.getModel().setValue("mcptool_operationid", (Object)mcpTool.name(), row);
                    this.getModel().setValue("mcptool_name", (Object)mcpTool.name(), row);
                    this.getModel().setValue("mcptool_test_status", (Object)(nameEnableMap.getOrDefault(mcpTool.name(), Boolean.FALSE) != false ? "0" : ""), row);
                    this.getModel().setValue("mcptool_description", (Object)mcpTool.description(), row);
                    if (nameEnableMap.getOrDefault(mcpTool.name(), Boolean.FALSE).booleanValue()) {
                        ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, row, new String[]{btnmcptestapiok, "mcptool_status_ok"});
                        ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, row, new String[]{btnmcptestapi, "mcptool_status_fail", btnmcptestapifail, btnmcptestingapi});
                    } else {
                        ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, row, new String[]{btnmcptestapi});
                        ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, row, new String[]{"mcptool_status_ok", "mcptool_status_fail", btnmcptestapiok, btnmcptestapifail, btnmcptestingapi});
                    }
                    this.getModel().setValue("mcptool_enable", (Object)nameEnableMap.getOrDefault(mcpTool.name(), Boolean.FALSE), row);
                    JSONObject apiInfoJo = new JSONObject();
                    apiInfoJo.put("testStatus", (Object)(nameEnableMap.getOrDefault(mcpTool.name(), Boolean.FALSE) != false ? "0" : ""));
                    apiInfoJo.put("enable", (Object)nameEnableMap.getOrDefault(mcpTool.name(), Boolean.FALSE));
                    apiInfoJo.put("name", (Object)mcpTool.name());
                    apiInfoJo.put("operationId", (Object)mcpTool.name());
                    apiInfoJo.put("description", (Object)mcpTool.description());
                    McpSchema.JsonSchema inputSchema = mcpTool.inputSchema();
                    try {
                        String inputParamsStr = new ObjectMapper().writeValueAsString((Object)inputSchema.properties());
                        JSONObject jsonObject = JSONObject.parseObject((String)inputParamsStr);
                        this.checkMCPParams(jsonObject);
                        apiInfoJo.put("inputParams", (Object)jsonObject);
                        if (StringUtils.contains((CharSequence)mcpTool.name(), (CharSequence)"{id}")) {
                            apiInfoJo.put("inputParams", (Object)JSONObject.parseObject((String)("{\"id\":{\"description\":\"id" + ResManager.loadKDString((String)"\u5c5e\u6027", (String)"GaiToolEditPlugin_13885618", (String)"ai-gai-plugin", (Object[])new Object[0]) + "\",\"type\":\"string\"}}")));
                        }
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                    apiListJa.add((Object)apiInfoJo);
                    if (inputSchema.properties() == null) continue;
                    Map properties = inputSchema.properties();
                    Set propertiesSet = properties.keySet();
                    for (int p = 0; p < 5; ++p) {
                        if (p < propertiesSet.size()) {
                            if (p == 4 && propertiesSet.size() > 5) {
                                this.getModel().setValue("mcp_api_var_" + p, (Object)"...", row);
                                continue;
                            }
                            String paramName = propertiesSet.toArray(new String[0])[p];
                            this.getModel().setValue("mcp_api_var_" + p, (Object)paramName, row);
                            continue;
                        }
                        ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, row, new String[]{"mcp_api_var_" + p});
                    }
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_MCP_EMPTY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_MCP_NOT_EMPTY});
            }
            this.resetApiCount(FLEX_MCP, apiCount);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)String.format("\u6210\u529f\u540c\u6b65%s\u4e2a\u63a5\u53e3", apiListJa.size()), (String)"GaiToolEditPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]));
            configJo.put("apiList", (Object)apiListJa);
            this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configJo.toJSONString());
        }
        catch (Exception e) {
            log.info("toolslist error:{}", (Object)e.getMessage(), (Object)e);
            String message = ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5Client\u4e0eServer\u7684\u7f51\u7edc\u662f\u5426\u4e92\u901a\u53caMCP Server\u662f\u5426\u6b63\u5e38\uff1a%s", (String)"GaiMCPServerPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
            String detailMessage = "";
            if (null != e.getMessage()) {
                String[] split = e.getMessage().split(":");
                detailMessage = split.length > 0 ? split[split.length - 1] : e.getMessage();
            }
            this.getView().showErrorNotification(String.format(message, detailMessage));
        }
    }

    private void resetApiCount(String flexKey, int apiCount) {
        String title = ResManager.loadKDString((String)"\u63a5\u53e3\u5217\u8868(%s\u4e2a)", (String)"GaiToolEditPlugin_13", (String)"ai-gai-plugin", (Object[])new Object[0]);
        title = String.format(title, apiCount);
        HashMap<String, String> text = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> text1 = new HashMap<String, HashMap<String, String>>();
        text.put("zh_CN", title);
        text.put("en_US", title);
        text1.put("text", text);
        this.getView().updateControlMetadata(flexKey, text1);
    }

    private void initToolFieldVisiable(String toolType) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"basicinfocontainer", "picture", "tool_type", "tool_number", "tool_name", "tool_description", "tool_group", "too_url", "mcp_url", "tool_cloud", "auth_selector", "illustrate"});
        if (ToolConstant.ToolType.RESTFUL_API.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{entryentity, "param_name", "key_selector"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"add_header", "delete_header", "advconbaritemap3", deleteapi});
            HashMap<String, Boolean> deleteapi = new HashMap<String, Boolean>(0);
            deleteapi.put("vi", Boolean.FALSE);
            this.getView().updateControlMetadata(deleteapi, deleteapi);
            HashMap editapi = new HashMap(0);
            HashMap<String, String> data = new HashMap<String, String>(0);
            editapi.put("text", data);
            data.put("zh_CN", "\u67e5\u770b");
            this.getView().updateControlMetadata(btneditapi, editapi);
        } else if (ToolConstant.ToolType.MCP_TOOL.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SYNC_TOOL});
            this.getView().setEnable(Boolean.FALSE, new String[]{"key_selector", "param_name"});
        } else if (ToolConstant.ToolType.INTERNAL_MCP.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADD_OPEN_API, "buttonap21"});
        }
    }

    private void initToolData(Long toolId) {
        JSONObject configJson;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)toolId, (String)"gai_tool");
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("isCopy"))) && "1".equals(this.getView().getFormShowParameter().getCustomParam("isCopy"))) {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_tool");
            newDynamicObject.set("status", (Object)"C");
            newDynamicObject.set("enable", (Object)0);
            newDynamicObject.set("number", (Object)this.generateNumber());
            newDynamicObject.set("createtime", (Object)new Date());
            newDynamicObject.set("modifytime", (Object)new Date());
            newDynamicObject.set("ctrlstrategy", (Object)CtrlStrategyEnum.ALL.getId());
            newDynamicObject.set("picture", (Object)dynamicObject.getString("picture"));
            newDynamicObject.set("source", (Object)dynamicObject.getString("source"));
            newDynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newDynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDynamicObject.set("ispreset", (Object)dynamicObject.getBoolean("ispreset"));
            newDynamicObject.set("org", (Object)dynamicObject.getDynamicObject("org"));
            newDynamicObject.set("app", (Object)dynamicObject.getDynamicObject("app"));
            newDynamicObject.set("tool_type", (Object)dynamicObject.getString("tool_type"));
            newDynamicObject.set("description", (Object)dynamicObject.getString("description"));
            newDynamicObject.set("name", (Object)(dynamicObject.getString("name") + "_copy"));
            newDynamicObject.set("config_tag", (Object)dynamicObject.getString("config_tag"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynamicObject});
            dynamicObject = newDynamicObject;
        }
        this.getModel().setValue("tool_detail", (Object)dynamicObject);
        String picture = dynamicObject.getString("picture");
        OrmLocaleValue name = (OrmLocaleValue)dynamicObject.getLocaleString("name");
        OrmLocaleValue illustrate = (OrmLocaleValue)dynamicObject.getLocaleString("illustrate");
        String number = dynamicObject.getString("number");
        String description = dynamicObject.getString("description");
        String toolType = dynamicObject.getString("tool_type");
        String source = dynamicObject.getString("source");
        this.getPageCache().put(TOOL_SOURCE_CACHE, source);
        DynamicObject app = dynamicObject.getDynamicObject("app");
        DynamicObject cloud = dynamicObject.getDynamicObject("cloud");
        DynamicObject groupDo = dynamicObject.getDynamicObject("group");
        if (groupDo != null) {
            this.getModel().setValue("tool_group", (Object)groupDo);
        }
        Boolean ispreset = null == dynamicObject.get("ispreset") ? false : dynamicObject.getBoolean("ispreset");
        this.getModel().setValue("tool_description", (Object)description);
        this.getModel().setValue("tool_name", (Object)name);
        this.getModel().setValue("picture", (Object)picture);
        this.getModel().setValue("tool_type", (Object)ToolConstant.ToolType.valueOf((String)toolType.toUpperCase()).getTypeName());
        this.getModel().setValue("tool_number", (Object)number);
        this.getModel().setValue("tool_cloud", (Object)cloud);
        this.getModel().setValue("illustrate", (Object)illustrate);
        if (null != app) {
            DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)app.getPkValue(), (String)"bos_devportal_bizapp");
            this.getModel().setValue("serviceapp", (Object)appObject);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"tool_app", "baractiontest"});
        String configTag = dynamicObject.getString("config_tag");
        if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
            this.initToolFieldVisiable(toolType);
            this.getPageCache().put("kingdee_tool_origin_picture_cache", picture);
            this.getModel().setValue("picture", (Object)(GaiToolEditPlugin.getHost() + picture));
            QFilter filter = new QFilter("toolid", "=", (Object)toolId);
            DynamicObject authDo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_auth", (String)"id,toolid,auth_tag", (QFilter[])new QFilter[]{filter});
            if (null != authDo) {
                configTag = authDo.getString("auth_tag");
            }
        }
        if (ToolConstant.ToolType.RESTFUL_API.getType().equals(StringUtils.lowerCase((String)toolType))) {
            configJson = JSONObject.parseObject((String)configTag);
            this.buildRESTfulApiList(configJson, ispreset);
            this.getPageCache().put(TOOL_CONFIG_CACHE + dynamicObject.getString("number"), configTag);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baractiontest", FLEX_MCP});
        } else if (ToolConstant.ToolType.COSMIC_ACTION.getType().equals(StringUtils.lowerCase((String)toolType))) {
            int newEntryRow;
            int in;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{authContainer, FLEX_MCP, "tool_url"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tool_app", "baractiontest"});
            JSONObject actionConfig = JSONObject.parseObject((String)configTag);
            if (null != actionConfig.get((Object)"app")) {
                DynamicObject appObject = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (QFilter[])new QFilter("id", "=", (Object)actionConfig.getString("app")).toArray());
                this.getModel().setValue("serviceapp", (Object)appObject);
            }
            this.getModel().setValue("servicename", (Object)actionConfig.getString("serviceName"));
            this.getModel().setValue("actionname", (Object)actionConfig.getString("action"));
            JSONArray inputParams = actionConfig.getJSONArray("inputParams") == null ? new JSONArray(0) : actionConfig.getJSONArray("inputParams");
            JSONArray outputParams = actionConfig.getJSONArray("outputParams") == null ? new JSONArray(0) : actionConfig.getJSONArray("outputParams");
            for (in = 0; in < inputParams.size(); ++in) {
                JSONObject inputParam = inputParams.getJSONObject(in);
                newEntryRow = this.getModel().createNewEntryRow(INPUTTREE);
                this.getModel().setValue("input_var_name", (Object)inputParam.getString("paramName"), newEntryRow);
                this.getModel().setValue("input_var_type", (Object)inputParam.getString("paramType"), newEntryRow);
                this.getModel().setValue("input_var_desc", (Object)inputParam.getString("paramDesc"), newEntryRow);
            }
            for (in = 0; in < outputParams.size(); ++in) {
                JSONObject outputParam = outputParams.getJSONObject(in);
                newEntryRow = this.getModel().createNewEntryRow(OUTPUTTREE);
                this.getModel().setValue("output_var_name", (Object)outputParam.getString("paramName"), newEntryRow);
                this.getModel().setValue("output_var_type", (Object)outputParam.getString("paramType"), newEntryRow);
                this.getModel().setValue("output_var_desc", (Object)outputParam.getString("paramDesc"), newEntryRow);
            }
            this.cosmicActionPreset(ispreset);
        } else if (ToolConstant.ToolType.MCP_TOOL.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{actionContainer, actionVarContainer, btnmcptestapiok, btnmcptestapifail, btnmcptestingapi});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{authContainer, FLEX_MCP, "tool_url"});
            configJson = JSONObject.parseObject((String)configTag);
            this.buildMCPToolList(configJson);
        } else if (ToolConstant.ToolType.INTERNAL_MCP.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{actionVarContainer, btnmcptestapiok, btnmcptestapifail, btnmcptestingapi, BTN_SYNC_TOOL, "servicename", "actionname"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_MCP});
            configJson = JSONObject.parseObject((String)configTag);
            this.buildInternalMCPToolList(configJson);
            this.getView().setEnable(Boolean.FALSE, new String[]{"auth_selector"});
        }
    }

    private static String getHost() {
        String host = RequestContext.get().getClientFullContextPath();
        if (!StringUtils.isEmpty((CharSequence)host) && host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    private void buildMCPToolList(JSONObject configJson) {
        if (StringUtils.isNotEmpty((CharSequence)configJson.getString("url"))) {
            this.getModel().setValue("mcp_url", (Object)configJson.getString("url"));
        }
        JSONArray apiList = configJson.getJSONArray("apiList");
        int apiCount = 0;
        if (null != apiList && !apiList.isEmpty()) {
            apiCount = apiList.size();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_MCP_EMPTY});
            for (int i = 0; i < apiList.size(); ++i) {
                JSONObject apiInfo = apiList.getJSONObject(i);
                String apiname = StringUtils.isNotEmpty((CharSequence)apiInfo.getString("name")) ? apiInfo.getString("name") : apiInfo.getString("operationId");
                String apidescription = apiInfo.getString("description");
                String testStatus = apiInfo.getString("testStatus");
                String enable = apiInfo.getString("enable");
                JSONObject inputParams = apiInfo.getJSONObject("inputParams");
                List<Object> paramterNames = new ArrayList();
                if (null != inputParams && inputParams.size() > 0) {
                    paramterNames = inputParams.keySet().stream().collect(Collectors.toList());
                }
                int newEntryRow = this.getModel().createNewEntryRow(MCP_TOOL_ENTRY_ENTITY);
                this.getModel().setValue("inputparamtitle1", (Object)ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570", (String)"GaiToolEditPlugin_16", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("mcptool_status_ok", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5\u901a\u8fc7", (String)"GaiToolEditPlugin_18", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("mcptool_status_fail", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25", (String)"GaiToolEditPlugin_19", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("mcptool_name", (Object)apiname, newEntryRow);
                this.getModel().setValue("mcptool_operationid", (Object)apiInfo.getString("operationId"), newEntryRow);
                this.getModel().setValue("mcptool_description", (Object)apidescription, newEntryRow);
                this.getModel().setValue("mcptool_test_status", (Object)testStatus, newEntryRow);
                CardEntry cardEntry = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
                HashMap customProperties = new HashMap();
                HashMap<String, String> properties = new HashMap<String, String>();
                if (StringUtils.isEmpty((CharSequence)enable) || enable.equals("0")) {
                    properties.put("bc", "#FAFAFA");
                } else {
                    properties.put("bc", "#f2f6ff");
                }
                customProperties.put("mcpapicardcontainer", properties);
                cardEntry.setCustomProperties(cardEntry.getKey(), newEntryRow, customProperties);
                if (StringUtils.isEmpty((CharSequence)testStatus)) {
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, newEntryRow, new String[]{"mcptool_status_ok", "mcptool_status_fail", btnmcptestapi, btnmcptestapifail, btnmcptestapiok, btnmcptestingapi});
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, newEntryRow, new String[]{btnmcptestapi});
                } else if (testStatus.equals("0")) {
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, newEntryRow, new String[]{"mcptool_status_fail", btnmcptestapi, btnmcptestapifail, btnmcptestapiok, btnmcptestingapi});
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, newEntryRow, new String[]{"mcptool_status_ok", btnmcptestapiok});
                } else {
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, newEntryRow, new String[]{"mcptool_status_ok", btnmcptestapi, btnmcptestapifail, btnmcptestapiok, btnmcptestingapi});
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, newEntryRow, new String[]{"mcptool_status_fail", btnmcptestapifail});
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)enable, (CharSequence)EnableEnum.YES.getKeyStr())) {
                    this.getModel().setValue("mcptool_enable", (Object)true, newEntryRow);
                } else {
                    this.getModel().setValue("mcptool_enable", (Object)false, newEntryRow);
                }
                for (int p = 0; p < 5; ++p) {
                    if (p < paramterNames.size()) {
                        if (p == 4 && paramterNames.size() > 5) {
                            this.getModel().setValue("mcp_api_var_" + p, (Object)"...", newEntryRow);
                            continue;
                        }
                        String paramName = (String)paramterNames.get(p);
                        this.getModel().setValue("mcp_api_var_" + p, (Object)paramName, newEntryRow);
                        continue;
                    }
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, newEntryRow, new String[]{"mcp_api_var_" + p});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_entity_container", BTN_SYNC_TOOL, FLEX_MCP_NOT_EMPTY});
        }
        this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configJson.toJSONString());
        this.resetApiCount(FLEX_MCP, apiCount);
        this.showAuthInfo(configJson);
        List<ComboItem> paramItems = this.getMCPAuthComboItem();
        ComboEdit inputSourceParam = (ComboEdit)this.getControl("auth_selector");
        inputSourceParam.setComboItems(paramItems);
    }

    private void buildInternalMCPToolList(JSONObject configJson) {
        JSONArray apiList = configJson.getJSONArray("apiList");
        int apiCount = 0;
        if (null != apiList && !apiList.isEmpty()) {
            apiCount = apiList.size();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_MCP_EMPTY});
            for (int i = 0; i < apiList.size(); ++i) {
                JSONObject apiInfo = apiList.getJSONObject(i);
                String apiname = StringUtils.isNotEmpty((CharSequence)apiInfo.getString("name")) ? apiInfo.getString("name") : apiInfo.getString("operationId");
                String apidescription = StringUtils.isNotEmpty((CharSequence)apiInfo.getString("description")) ? apiInfo.getString("description") : " ";
                Long apiId = apiInfo.getLong("openApiId");
                DynamicObject customapi = BusinessDataServiceHelper.loadSingleFromCache((Object)apiId, (String)"openapi_customapi");
                List<Object> paramterNames = new ArrayList();
                if (null != customapi && customapi.getDynamicObjectCollection("bodyentryentity").size() > 0) {
                    DynamicObjectCollection bodyentryentity = customapi.getDynamicObjectCollection("bodyentryentity");
                    paramterNames = bodyentryentity.stream().map(v -> v.getString("paramname")).collect(Collectors.toList());
                }
                int newEntryRow = this.getModel().createNewEntryRow(MCP_TOOL_ENTRY_ENTITY);
                this.getModel().setValue("mcptool_name", (Object)apiname, newEntryRow);
                this.getModel().setValue("mcptool_operationid", (Object)apiInfo.getString("operationId"), newEntryRow);
                this.getModel().setValue("mcptool_description", (Object)apidescription, newEntryRow);
                ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, newEntryRow, new String[]{"mcptool_status_ok", "mcptool_status_fail", "labelap1", "mcptool_enable", "viewmcp", btnmcptestapi, btnmcptestapifail, btnmcptestapiok, btnmcptestingapi});
                CardEntry cardEntry = (CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY);
                HashMap customProperties = new HashMap();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("bc", "#f2f6ff");
                customProperties.put("mcpapicardcontainer", properties);
                cardEntry.setCustomProperties(cardEntry.getKey(), newEntryRow, customProperties);
                for (int p = 0; p < 5; ++p) {
                    if (p < paramterNames.size()) {
                        if (p == 4 && paramterNames.size() > 5) {
                            this.getModel().setValue("mcp_api_var_" + p, (Object)"...", newEntryRow);
                            continue;
                        }
                        String paramName = (String)paramterNames.get(p);
                        this.getModel().setValue("mcp_api_var_" + p, (Object)paramName, newEntryRow);
                        continue;
                    }
                    ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, newEntryRow, new String[]{"mcp_api_var_" + p});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_entity_container", FLEX_MCP_NOT_EMPTY, ADD_OPEN_API});
        }
        this.getPageCache().put(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"), configJson.toJSONString());
        this.resetApiCount(FLEX_MCP, apiCount);
        this.showAuthInfo(configJson);
    }

    private void buildRESTfulApiList(JSONObject configJson, Boolean ispreset) {
        JSONArray apiList = configJson.getJSONArray("apiList");
        if (StringUtils.isNotEmpty((CharSequence)configJson.getString("url"))) {
            this.getModel().setValue("too_url", (Object)configJson.getString("url"));
        }
        int apiCount = 0;
        if (null != apiList && apiList.size() > 0) {
            apiCount = apiList.size();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_empty_container"});
            for (int i = 0; i < apiList.size(); ++i) {
                JSONObject apiInfo = apiList.getJSONObject(i);
                String apiname = StringUtils.isNotEmpty((CharSequence)apiInfo.getString("name")) ? apiInfo.getString("name") : apiInfo.getString("operationId");
                String apidescription = apiInfo.getString("description");
                String testStatus = apiInfo.getString("testStatus");
                String enable = apiInfo.getString("enable");
                JSONObject inputParams = apiInfo.getJSONObject("inputParams");
                List paramterNames = inputParams.keySet().stream().collect(Collectors.toList());
                int newEntryRow = this.getModel().createNewEntryRow(apientryentity);
                this.getModel().setValue("inputparamtitle", (Object)ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570", (String)"GaiToolEditPlugin_16", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"GaiToolEditPlugin_17", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("textfield11", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"GaiToolEditPlugin_17", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("textfield111", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"GaiToolEditPlugin_17", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("apistatus_ok", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5\u901a\u8fc7", (String)"GaiToolEditPlugin_18", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("apistatusfail", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25", (String)"GaiToolEditPlugin_19", (String)"ai-gai-plugin", (Object[])new Object[0]), newEntryRow);
                this.getModel().setValue("apiname", (Object)apiname, newEntryRow);
                this.getModel().setValue("operationid", (Object)apiInfo.getString("operationId"), newEntryRow);
                this.getModel().setValue("apidescription", (Object)apidescription, newEntryRow);
                this.getModel().setValue("test_status", (Object)testStatus, newEntryRow);
                CardEntry cardEntry = (CardEntry)this.getControl(apientryentity);
                HashMap customProperties = new HashMap();
                HashMap<String, String> properties = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((CharSequence)enable) && enable.equals("1")) {
                    properties.put("bc", "#f2f6ff");
                } else {
                    properties.put("bc", "#FAFAFA");
                }
                customProperties.put("apicardcontainer", properties);
                cardEntry.setCustomProperties(cardEntry.getKey(), newEntryRow, customProperties);
                if (testStatus.equals("0")) {
                    this.getModel().setValue("enable", (Object)(!StringUtils.isEmpty((CharSequence)enable) && !enable.equals("0") ? 1 : 0), newEntryRow);
                    ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, newEntryRow, new String[]{"apistatusfail", btntestapi, btntestapifail, btntestingapi});
                } else if (StringUtils.isNotEmpty((CharSequence)testStatus)) {
                    ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, newEntryRow, new String[]{"apistatus_ok", btntestapi, btntestapiok, btntestingapi});
                    this.getModel().setValue("enable", (Object)false, newEntryRow);
                } else {
                    ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, newEntryRow, new String[]{"apistatusfail", "apistatus_ok", btntestapifail, btntestapiok, btntestingapi});
                    this.getModel().setValue("enable", (Object)false, newEntryRow);
                }
                for (int p = 0; p < 5; ++p) {
                    if (p < paramterNames.size()) {
                        if (p == 4 && paramterNames.size() > 5) {
                            this.getModel().setValue("api_var_" + p, (Object)"...", newEntryRow);
                            continue;
                        }
                        String paramName = (String)paramterNames.get(p);
                        this.getModel().setValue("api_var_" + p, (Object)paramName, newEntryRow);
                        continue;
                    }
                    ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, newEntryRow, new String[]{"api_var_" + p});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"api_entity_container", "advconbaritemap3"});
        }
        this.resetApiCount(FLEX_API_CONFIG, apiCount);
        this.showAuthInfo(configJson);
        this.buildHeader(configJson);
        this.apiPreset(ispreset);
    }

    private void cosmicActionPreset(Boolean ispreset) {
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baritemap"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"serviceapp", "servicename", "actionname", INPUTTREE, OUTPUTTREE, "advcontoolbarap4", "advcontoolbarap5"});
        }
    }

    private void apiPreset(Boolean ispreset) {
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{btneditapi, deleteapi, "buttonap1", authContainer});
        }
    }

    private void showAuthInfo(JSONObject configTag) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{actionVarContainer, actionContainer});
        if (StringUtils.isNotEmpty((CharSequence)configTag.getString("authtype"))) {
            String authtype = configTag.getString("authtype");
            this.getModel().setValue("auth_selector", (Object)authtype);
            switch (authtype) {
                case "oauth": {
                    this.selectOAuth();
                    JSONObject oauthConfig = JSONObject.parseObject((String)configTag.getString("oauthConfig"));
                    this.getModel().setValue("client_id", (Object)oauthConfig.getString("client_id"));
                    this.getModel().setValue("client_secret", (Object)oauthConfig.getString("client_secret"));
                    this.getModel().setValue("token_url", (Object)oauthConfig.getString("token_url"));
                    this.getModel().setValue("scope", (Object)oauthConfig.getString("scope"));
                    this.getModel().setValue("authorization_url", (Object)oauthConfig.getString("authorization_url"));
                    break;
                }
                case "cosmic_access_token": {
                    this.selectCosmicAccessToken();
                    JSONObject cosmicAccessTokenConfig = JSONObject.parseObject((String)configTag.getString("cosmicAccessTokenConfig"));
                    this.getModel().setValue("cosmic_client_id", (Object)cosmicAccessTokenConfig.getString("client_id"));
                    this.getModel().setValue("cosmic_client_secret", (Object)cosmicAccessTokenConfig.getString("client_secret"));
                    this.getModel().setValue("cosmic_username", (Object)cosmicAccessTokenConfig.getString("username"));
                    this.getModel().setValue("cosmic_accountid", (Object)cosmicAccessTokenConfig.getString("accountId"));
                    this.getModel().setValue("cosmic_token_url", (Object)cosmicAccessTokenConfig.getString("token_url"));
                    break;
                }
                case "service": {
                    this.selectServiceAuth();
                    JSONObject serviceConfig = JSONObject.parseObject((String)configTag.getString("serviceConfig"));
                    this.getModel().setValue("key_selector", (Object)serviceConfig.getString("location"));
                    this.getModel().setValue("param_name", (Object)serviceConfig.getString("paramName"));
                    this.getModel().setValue("param_value", (Object)serviceConfig.getString("paramValue"));
                    break;
                }
                default: {
                    this.selectNOauth();
                    break;
                }
            }
        } else {
            this.selectNOauth();
        }
    }

    private void buildAuthInfo(JSONObject configJo) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{actionVarContainer, actionContainer});
        String authType = (String)this.getModel().getValue("auth_selector");
        if (StringUtils.isNotEmpty((CharSequence)authType)) {
            configJo.put("authtype", (Object)authType);
            switch (authType) {
                case "oauth": {
                    JSONObject oauthConfig = new JSONObject();
                    oauthConfig.put("client_id", this.getModel().getValue("client_id"));
                    oauthConfig.put("client_secret", this.getModel().getValue("client_secret"));
                    oauthConfig.put("token_url", this.getModel().getValue("token_url"));
                    oauthConfig.put("scope", this.getModel().getValue("scope"));
                    oauthConfig.put("authorization_url", this.getModel().getValue("authorization_url"));
                    configJo.put("oauthConfig", (Object)oauthConfig);
                    break;
                }
                case "cosmic_access_token": {
                    JSONObject cosmicAccessTokenConfig = new JSONObject();
                    cosmicAccessTokenConfig.put("client_id", this.getModel().getValue("cosmic_client_id"));
                    cosmicAccessTokenConfig.put("client_secret", this.getModel().getValue("cosmic_client_secret"));
                    cosmicAccessTokenConfig.put("username", this.getModel().getValue("cosmic_username"));
                    cosmicAccessTokenConfig.put("accountId", this.getModel().getValue("cosmic_accountid"));
                    cosmicAccessTokenConfig.put("token_url", this.getModel().getValue("cosmic_token_url"));
                    configJo.put("cosmicAccessTokenConfig", (Object)cosmicAccessTokenConfig);
                    break;
                }
                case "service": {
                    this.selectServiceAuth();
                    JSONObject serviceConfig = new JSONObject();
                    serviceConfig.put("location", this.getModel().getValue("key_selector"));
                    serviceConfig.put("paramName", this.getModel().getValue("param_name"));
                    serviceConfig.put("paramValue", this.getModel().getValue("param_value"));
                    configJo.put("serviceConfig", (Object)serviceConfig);
                    break;
                }
                default: {
                    this.selectNOauth();
                    break;
                }
            }
        } else {
            configJo.put("authtype", (Object)"noauth");
            this.selectNOauth();
        }
    }

    private void selectOAuth() {
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OPENAPI_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
    }

    private void selectNOauth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
    }

    private void selectServiceAuth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_SERVICE_AUTH_AP});
    }

    private void selectCosmicAccessToken() {
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        String opKey;
        super.beforeDoOperation(eventArgs);
        switch (opKey = ((FormOperate)eventArgs.getSource()).getOperateKey()) {
            case "save": {
                DynamicObject tool;
                if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("tool_Number")))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u5177\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_13885619", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)((OrmLocaleValue)this.getModel().getValue("tool_name")).getLocaleValue())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u5177\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_13885620", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)((OrmLocaleValue)this.getModel().getValue("tool_description")).getLocaleValue())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_13885621", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    return;
                }
                if (null == this.getModel().getValue("tool_detail")) {
                    tool = this.buildToolInfo();
                } else {
                    tool = (DynamicObject)this.getModel().getValue("tool_detail");
                    tool = BusinessDataServiceHelper.loadSingleFromCache((Object)tool.getPkValue(), (String)"gai_tool");
                }
                if (this.updateToolField(tool, true)) {
                    return;
                }
                String source = tool.getString("source");
                boolean isKingdee = false;
                if (!StringUtils.isEmpty((CharSequence)source) && StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)ToolConstant.ToolSource.KINGDEE.getSource())) {
                    String originStr = this.getPageCache().get("kingdee_tool_origin_picture_cache");
                    tool.set("picture", (Object)originStr);
                    isKingdee = true;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tool});
                if (isKingdee) {
                    DynamicObject authDo = null;
                    long toolId = tool.getLong("id");
                    QFilter filter = new QFilter("toolid", "=", (Object)toolId);
                    authDo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_auth", (String)"id,toolid,auth_tag", (QFilter[])new QFilter[]{filter});
                    if (authDo == null) {
                        authDo = BusinessDataServiceHelper.newDynamicObject((String)"gai_tool_auth");
                        authDo.set("toolid", (Object)toolId);
                        authDo.set("number", (Object)String.format("%s-auth", tool.getString("number")));
                        authDo.set("name", (Object)String.format("%s-auth", tool.getString("name")));
                        authDo.set("status", (Object)"C");
                        authDo.set("enable", (Object)"1");
                        authDo.set("auth_tag", (Object)tool.getString("config_tag"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{authDo});
                    } else {
                        authDo.set("auth_tag", (Object)tool.getString("config_tag"));
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{authDo});
                    }
                }
                this.getModel().setValue("tool_detail", (Object)tool);
                this.getPageCache().put(TOOL_CONFIG_CACHE + tool.getString("number"), tool.getString("config_tag"));
                String message = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GaiToolEditPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().getModel().setDataChanged(false);
                this.getView().showSuccessNotification(message);
                break;
            }
            case "cosmicactiontest": {
                break;
            }
            case "testapi": {
                int selectRow = this.getModel().getEntryCurrentRowIndex(apientryentity);
                String testStatus = ((DynamicObject)this.getModel().getEntryEntity(apientryentity).get(selectRow)).getString("test_status");
                ((CardEntry)this.getControl(apientryentity)).setChildVisible(false, selectRow, new String[]{btntestapifail, btntestapiok, btntestapi});
                ((CardEntry)this.getControl(apientryentity)).setChildVisible(true, selectRow, new String[]{btntestingapi});
                this.getPageCache().put("test_api_row", selectRow + "");
                if (StringUtils.isEmpty((CharSequence)testStatus)) {
                    this.getPageCache().put("test_api_status", btntestapi);
                } else if (testStatus.equals("0")) {
                    this.getPageCache().put("test_api_status", btntestapiok);
                } else {
                    this.getPageCache().put("test_api_status", btntestapifail);
                }
                this.operaTestApi();
                break;
            }
            case "testmcp": {
                int selectRow = this.getModel().getEntryCurrentRowIndex(MCP_TOOL_ENTRY_ENTITY);
                ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(false, selectRow, new String[]{btnmcptestapifail, btnmcptestapiok, btnmcptestapi});
                ((CardEntry)this.getControl(MCP_TOOL_ENTRY_ENTITY)).setChildVisible(true, selectRow, new String[]{btnmcptestingapi});
                this.openTestMCP();
                break;
            }
            case "viewmcp": {
                int selectRow = this.getModel().getEntryCurrentRowIndex(MCP_TOOL_ENTRY_ENTITY);
                this.viewMCP();
                break;
            }
        }
    }

    private boolean updateToolField(DynamicObject tool, boolean isSave) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("tool_app_id_" + tool.getString("number")))) {
            String appId = this.getPageCache().get("tool_app_id_" + tool.getString("number"));
            DynamicObject appObject = BusinessDataServiceHelper.loadSingle((Object)appId, (String)"bos_devportal_bizapp");
            tool.set("app", (Object)appObject);
        }
        String toolType = tool.getString("tool_type");
        String toolNumber = (String)this.getModel().getValue("tool_number");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("tool_name");
        OrmLocaleValue illustrate = (OrmLocaleValue)this.getModel().getValue("illustrate");
        String picture = (String)this.getModel().getValue("picture");
        DynamicObject group = (DynamicObject)this.getModel().getValue("tool_group");
        DynamicObject cloud = (DynamicObject)this.getModel().getValue("tool_cloud");
        String url = (String)this.getModel().getValue("too_url");
        String mcpUrl = (String)this.getModel().getValue("mcp_url");
        tool.set("group", (Object)group);
        tool.set("cloud", (Object)cloud);
        tool.set("number", (Object)toolNumber);
        tool.set("description", this.getModel().getValue("tool_description"));
        tool.set("name", (Object)name);
        tool.set("illustrate", (Object)illustrate);
        if (StringUtils.isEmpty((CharSequence)picture)) {
            this.handleImageForSelectedProgramme();
        }
        tool.set("picture", this.getModel().getValue("picture"));
        String configTag = tool.getString("config_tag");
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(TOOL_CONFIG_CACHE + tool.getString("number")))) {
            configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + tool.getString("number"));
        }
        JSONObject config = JSONObject.parseObject((String)configTag);
        if (ToolConstant.ToolType.COSMIC_ACTION.getType().equals(toolType)) {
            if (isSave && this.checkRequiredParam()) {
                return true;
            }
            if (null != this.getModel().getValue("serviceapp")) {
                config.put("app", (Object)((DynamicObject)this.getModel().getValue("serviceapp")).getString("id"));
                config.put("appId", (Object)((DynamicObject)this.getModel().getValue("serviceapp")).getString("number"));
                DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)this.getModel().getValue("serviceapp")).getString("id"), (String)"bos_devportal_bizapp");
                tool.set("cloud", (Object)appObject.getDynamicObject("bizcloud"));
            }
            config.put("action", this.getModel().getValue("actionname"));
            config.put("serviceName", this.getModel().getValue("servicename"));
            DynamicObjectCollection inputArrays = this.getModel().getEntryEntity(INPUTTREE);
            JSONArray inputParams = new JSONArray();
            this.buildParamJson(inputParams, inputArrays, "input_var_type", "input_var_desc", "input_var_name");
            config.put("inputParams", (Object)inputParams);
            DynamicObjectCollection outputArrays = this.getModel().getEntryEntity(OUTPUTTREE);
            JSONArray outputParams = new JSONArray();
            this.buildParamJson(outputParams, outputArrays, "output_var_type", "output_var_desc", "output_var_name");
            config.put("outputParams", (Object)outputParams);
        } else if (ToolConstant.ToolType.RESTFUL_API.getType().equals(toolType)) {
            this.buildAuthInfo(config);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(apientryentity);
            Map<String, DynamicObject> entryMap = entryEntity.stream().collect(Collectors.toMap(v -> v.getString("operationId"), v -> v));
            JSONArray apiList = config.getJSONArray("apiList");
            if (null != apiList && apiList.size() > 0) {
                int disableCount = 0;
                for (int j = 0; j < apiList.size(); ++j) {
                    JSONObject jsonObject = apiList.getJSONObject(j);
                    DynamicObject dynamicObject = entryMap.get(jsonObject.getString("operationId"));
                    if (null == dynamicObject) continue;
                    jsonObject.put("testStatus", (Object)dynamicObject.getString("test_status"));
                    jsonObject.put("enable", (Object)(dynamicObject.getBoolean("enable") ? "1" : "0"));
                    if (dynamicObject.getBoolean("enable")) continue;
                    ++disableCount;
                }
                if (disableCount == apiList.size()) {
                    tool.set("enable", (Object)EnableEnum.NO.getKeyStr());
                }
            }
            config.put("apiList", (Object)apiList);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryentity);
            if (entryentity.size() > 0) {
                JSONArray headerlist = new JSONArray();
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject entity = (DynamicObject)entryentity.get(i);
                    JSONObject headerParam = new JSONObject();
                    headerParam.put("key", (Object)entity.getString("header_key"));
                    headerParam.put("value", (Object)entity.getString("header_value"));
                    headerlist.add((Object)headerParam);
                }
                config.put("headerList", (Object)headerlist);
            }
            config.put("url", (Object)url);
        } else if (ToolConstant.ToolType.MCP_TOOL.getType().equals(toolType)) {
            this.buildAuthInfo(config);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY);
            Map<String, DynamicObject> entryMap = entryEntity.stream().collect(Collectors.toMap(v -> v.getString("mcptool_operationid"), v -> v));
            JSONArray apiList = config.getJSONArray("apiList");
            if (null != apiList && apiList.size() > 0) {
                int disableCount = 0;
                for (int j = 0; j < apiList.size(); ++j) {
                    JSONObject jsonObject = apiList.getJSONObject(j);
                    this.checkMCPAPIParams(jsonObject);
                    DynamicObject dynamicObject = entryMap.get(jsonObject.getString("operationId"));
                    if (null == dynamicObject) continue;
                    jsonObject.put("testStatus", (Object)dynamicObject.getString("mcptool_test_status"));
                    jsonObject.put("enable", (Object)(dynamicObject.getBoolean("mcptool_enable") ? "1" : "0"));
                    if (dynamicObject.getBoolean("mcptool_enable")) continue;
                    ++disableCount;
                }
                if (disableCount == apiList.size()) {
                    tool.set("enable", (Object)EnableEnum.NO.getKeyStr());
                }
                config.put("apiList", (Object)apiList);
            }
            config.put("url", (Object)mcpUrl);
        } else if (ToolConstant.ToolType.INTERNAL_MCP.getType().equals(toolType)) {
            this.buildAuthInfo(config);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MCP_TOOL_ENTRY_ENTITY);
            Map<String, DynamicObject> entryMap = entryEntity.stream().collect(Collectors.toMap(v -> v.getString("mcptool_operationid"), v -> v));
            JSONArray apiList = config.getJSONArray("apiList");
            if (null != apiList && apiList.size() > 0) {
                config.put("apiList", (Object)apiList);
            }
        }
        tool.set("config_tag", (Object)config.toJSONString());
        tool.set("modifytime", (Object)new Date());
        return false;
    }

    private void viewMCP() {
        String configTag = "";
        DynamicObject toolDetail = (DynamicObject)this.getModel().getValue("tool_detail");
        if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"))) {
            configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
        } else if (null != toolDetail && null != toolDetail.getPkValue()) {
            if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"))) {
                configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"));
            } else {
                DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolDetail.getPkValue(), (String)"gai_tool");
                configTag = tool.getString("config_tag");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fdd\u5b58\u540e\u6d4b\u8bd5", (String)"GaiToolEditPlugin_29", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        int selectRow = this.getModel().getEntryCurrentRowIndex(MCP_TOOL_ENTRY_ENTITY);
        JSONObject configJo = JSONObject.parseObject((String)configTag);
        JSONArray apiList = configJo.getJSONArray("apiList");
        JSONObject apiInfo = apiList.getJSONObject(selectRow);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(GaiFormIdEnum.GAI_MCP_TOOL_DETAIL.getId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("toolId", null != toolDetail && null != toolDetail.getPkValue() ? toolDetail.getPkValue() : null);
        parameter.setCustomParam("configJo", (Object)configJo);
        parameter.setCustomParam("apiInfoJo", (Object)apiInfo);
        this.getView().showForm(parameter);
    }

    private void openTestMCP() {
        String configTag = "";
        DynamicObject toolDetail = (DynamicObject)this.getModel().getValue("tool_detail");
        if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"))) {
            configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
        } else if (null != toolDetail && null != toolDetail.getPkValue()) {
            if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"))) {
                configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"));
            } else {
                DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolDetail.getPkValue(), (String)"gai_tool");
                configTag = tool.getString("config_tag");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fdd\u5b58\u540e\u6d4b\u8bd5", (String)"GaiToolEditPlugin_29", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        int selectRow = this.getModel().getEntryCurrentRowIndex(MCP_TOOL_ENTRY_ENTITY);
        JSONObject configJo = JSONObject.parseObject((String)configTag);
        this.buildAuthInfo(configJo);
        JSONArray apiList = configJo.getJSONArray("apiList");
        JSONObject apiInfo = apiList.getJSONObject(selectRow);
        this.checkMCPAPIParams(apiInfo);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(GaiFormIdEnum.GAI_TOOL_MCP_TEST.getId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("toolId", null != toolDetail && null != toolDetail.getPkValue() ? toolDetail.getPkValue() : null);
        parameter.setCustomParam("configJo", (Object)configJo);
        parameter.setCustomParam("apiInfoJo", (Object)apiInfo);
        parameter.setCustomParam("toolType", (Object)ToolConstant.ToolType.MCP_TOOL.getType());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestMcpToolCallback"));
        this.getView().showForm(parameter);
    }

    private void operaTestApi() {
        String configTag = "";
        DynamicObject toolDetail = (DynamicObject)this.getModel().getValue("tool_detail");
        if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"))) {
            configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
        } else if (null != toolDetail && null != toolDetail.getPkValue()) {
            if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"))) {
                configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"));
            } else {
                DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolDetail.getPkValue(), (String)"gai_tool");
                configTag = tool.getString("config_tag");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fdd\u5b58\u540e\u6d4b\u8bd5", (String)"GaiToolEditPlugin_29", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        int selectRow = this.getModel().getEntryCurrentRowIndex(apientryentity);
        JSONObject configJo = JSONObject.parseObject((String)configTag);
        this.buildAuthInfo(configJo);
        JSONArray apiList = configJo.getJSONArray("apiList");
        JSONArray headerList = configJo.getJSONArray("headerList") == null ? new JSONArray() : configJo.getJSONArray("headerList");
        JSONObject apiInfo = apiList.getJSONObject(selectRow);
        String operationId = apiInfo.getString("operationId");
        this.testApi(operationId, configTag, headerList);
    }

    private boolean checkRequiredParam() {
        if (this.getModel().getEntryEntity(INPUTTREE).size() > 0) {
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("input_var_name")))) {
                String message = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return true;
            }
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("input_var_type")))) {
                String message = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return true;
            }
        }
        if (this.getModel().getEntryEntity(OUTPUTTREE).size() > 0) {
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("output_var_name")))) {
                String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return true;
            }
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("output_var_type")))) {
                String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return true;
            }
        }
        if (null == this.getModel().getValue("serviceapp")) {
            String message = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_31", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("servicename")))) {
            String message = ResManager.loadKDString((String)"\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolEditPlugin_30", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        return false;
    }

    private JSONObject buildServiceAuthFields() {
        JSONObject serviceConfig = new JSONObject();
        serviceConfig.put("location", this.getModel().getValue("key_selector"));
        serviceConfig.put("paramName", this.getModel().getValue("param_name"));
        serviceConfig.put("paramValue", this.getModel().getValue("param_value"));
        return serviceConfig;
    }

    private JSONObject buildOAuthFields() {
        JSONObject oauthConfig = new JSONObject();
        oauthConfig.put("client_id", this.getModel().getValue("client_id"));
        oauthConfig.put("client_secret", this.getModel().getValue("client_secret"));
        oauthConfig.put("scope", this.getModel().getValue("scope"));
        oauthConfig.put("authorization_url", this.getModel().getValue("authorization_url"));
        oauthConfig.put("token_url", this.getModel().getValue("token_url"));
        return oauthConfig;
    }

    private JSONObject buildCosmicAccessTokenAuthFields() {
        JSONObject cosmicConfig = new JSONObject();
        cosmicConfig.put("client_id", this.getModel().getValue("cosmic_client_id"));
        cosmicConfig.put("client_secret", this.getModel().getValue("cosmic_client_secret"));
        cosmicConfig.put("username", this.getModel().getValue("cosmic_username"));
        cosmicConfig.put("accountId", this.getModel().getValue("cosmic_accountid"));
        cosmicConfig.put("token_url", this.getModel().getValue("cosmic_token_url"));
        return cosmicConfig;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (StringUtils.isNotEmpty((CharSequence)((String)this.getModel().getValue("tool_number")))) {
            this.setReturnData();
        }
        boolean dataChanged = this.getView().getModel().getDataChanged();
        String confirmClose = this.getPageCache().get("confirmClose");
        if (dataChanged && (StringUtils.isEmpty((CharSequence)confirmClose) || confirmClose.equals("0"))) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"GaiToolEditPlugin_14", (String)"ai-gai-plugin", (Object[])new Object[0]);
            String msg1 = ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"GaiToolEditPlugin_15", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg + "\n" + msg1, MessageBoxOptions.YesNo, confirmCallBackListener);
            e.setCancel(true);
        } else {
            this.getPageCache().put("confirmClose", "0");
        }
    }

    private void setReturnData() {
        this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
    }

    private void buildParamJson(JSONArray inputParams, DynamicObjectCollection inputArrays, String typeKey, String descKey, String nameKey) {
        HashMap<Long, JSONObject> inputTreeMap = new HashMap<Long, JSONObject>();
        for (DynamicObject in : inputArrays) {
            JSONObject inputParam = new JSONObject();
            inputParam.put("paramDesc", (Object)in.getString(descKey));
            inputParam.put("paramName", (Object)in.getString(nameKey));
            String type = in.getString(typeKey);
            if (type.contains("array")) {
                inputParam.put("paramType", (Object)"array");
                type = type.replace("array<", "").replace(">", "");
                JSONObject items = new JSONObject();
                items.put("paramType", (Object)type);
                inputParam.put("items", (Object)items);
            } else {
                inputParam.put("paramType", (Object)type);
            }
            if (in.getLong("pid") != 0L) {
                JSONObject parent = (JSONObject)inputTreeMap.get(in.getLong("pid"));
                JSONArray properties = parent.getJSONArray("properties");
                if (null == properties) {
                    properties = new JSONArray();
                }
                properties.add((Object)inputParam);
                parent.put("properties", (Object)properties);
            } else {
                inputParams.add((Object)inputParam);
            }
            inputTreeMap.put(in.getLong("id"), inputParam);
        }
    }

    private void testApi(String operationId, String toolConfig, JSONArray headerList) {
        OperationParam operationParam = OpenAPIUtils.parserSingleRestfulOperationParam((String)toolConfig, (String)operationId);
        String operationJson = JSONObject.toJSONString((Object)operationParam);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_tool_api_test");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("operation", (Object)operationJson);
        parameter.setCustomParam("config", (Object)toolConfig);
        parameter.setCustomParam("components", (Object)"");
        String headerJson = headerList.toJSONString();
        parameter.setCustomParam("headers", (Object)headerJson);
        parameter.setCustomParam("toolType", (Object)ToolConstant.ToolType.RESTFUL_API.getType());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestApiCallback"));
        this.getView().showForm(parameter);
    }

    private void cosmicActionToolTest() {
        String configTag = "";
        DynamicObject toolDetail = (DynamicObject)this.getModel().getValue("tool_detail");
        if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"))) {
            configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number"));
        } else if (null != toolDetail && null != toolDetail.getPkValue()) {
            if (null != this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"))) {
                configTag = this.getPageCache().get(TOOL_CONFIG_CACHE + toolDetail.getString("number"));
            } else {
                DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolDetail.getPkValue(), (String)"gai_tool");
                configTag = tool.getString("config_tag");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fdd\u5b58\u540e\u6d4b\u8bd5", (String)"GaiToolEditPlugin_29", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        String toolType = (String)this.getModel().getValue("tool_type");
        if (!StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getTypeName())) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_tool_action_test");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("config", (Object)configTag);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestCosmicActionCallback"));
        this.getView().showForm(parameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baractiontest": {
                this.cosmicActionToolTest();
                break;
            }
        }
    }

    private List<ComboItem> getMCPAuthComboItem() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(2);
        ComboItem noauthcomboItem = new ComboItem();
        noauthcomboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u9274\u6743", (String)"GaiToolEditPlugin_13875456", (String)"ai-gai-plugin", (Object[])new Object[0])));
        noauthcomboItem.setValue("noauth");
        list.add(noauthcomboItem);
        ComboItem servicecomboItem = new ComboItem();
        servicecomboItem.setCaption(new LocaleString("Service\uff08API Key\uff09"));
        servicecomboItem.setValue("service");
        list.add(servicecomboItem);
        return list;
    }

    private void checkMCPParams(JSONObject params) {
        Set entries = params.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject param = (JSONObject)entry.getValue();
            if (param.containsKey((Object)"type")) continue;
            param.put("type", (Object)"string");
        }
    }

    private void checkMCPAPIParams(JSONObject params) {
        JSONObject inputParams = params.getJSONObject("inputParams");
        Set entries = inputParams.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject param = (JSONObject)entry.getValue();
            if (param.containsKey((Object)"type")) continue;
            param.put("type", (Object)"string");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (this.getModel().getValue("tool_type").equals(ToolConstant.ToolType.INTERNAL_MCP.getTypeName())) {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            JSONObject cogfig = JSONObject.parseObject((String)this.getPageCache().get(TOOL_CONFIG_CACHE + this.getModel().getValue("tool_number")));
            JSONObject api = cogfig.getJSONArray("apiList").getJSONObject(e.getRowIndex());
            Long openApiId = api.getLong("openApiId");
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("openapi_apilist");
            bsp.setPkId((Object)openApiId);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setParentPageId(parentPageId);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }
}

