/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiToolEnableOperationPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        ArrayList<ExtendedDataEntity> passDataEntitys = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : e.getSelectedRows()) {
            if (!this.canEnableTool(dataEntity)) continue;
            passDataEntitys.add(dataEntity);
        }
        e.getSelectedRows().clear();
        if (passDataEntitys.isEmpty()) {
            e.cancel = true;
        } else {
            e.getSelectedRows().addAll(passDataEntitys);
        }
    }

    private boolean canEnableTool(ExtendedDataEntity dataEntity) {
        Object toolId = dataEntity.getDataEntity().getPkValue();
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolId, (String)"gai_tool");
        if (tool != null) {
            String configTag;
            JSONObject config;
            String toolType = tool.getString("tool_type");
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
                return Boolean.TRUE;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType()) && (config = JSONObject.parseObject((String)(configTag = tool.getString("config_tag")))) != null) {
                JSONArray apiList = config.getJSONArray("apiList");
                Boolean flag = Boolean.TRUE;
                if (apiList.isEmpty()) {
                    String message = ResManager.loadKDString((String)"API\u52fe\u9009\u7684\u53ef\u7528\u63a5\u53e3\u6d4b\u8bd5\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u542f\u7528\u8be5\u5de5\u5177\u3002", (String)"GaiToolEnableOperationPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.addErrMessage(dataEntity, message);
                    return Boolean.FALSE;
                }
                int enableCount = 0;
                for (int i = 0; i < apiList.size(); ++i) {
                    JSONObject operation = apiList.getJSONObject(i);
                    String operationId = operation.getString("operationId");
                    int status = operation.getIntValue("testStatus");
                    int enable = operation.getIntValue("enable");
                    if (enable == 1) {
                        ++enableCount;
                    }
                    if (enable != 1 || status == 1) continue;
                    String message = ResManager.loadKDString((String)"API\u52fe\u9009\u7684\u53ef\u7528\u63a5\u53e3(%s)\u6d4b\u8bd5\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u542f\u7528\u8be5\u5de5\u5177\u3002", (String)"GaiToolEnableOperationPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.addErrMessage(dataEntity, String.format(message, operationId));
                    flag = Boolean.FALSE;
                }
                if (enableCount == 0) {
                    String message = ResManager.loadKDString((String)"API\u52fe\u9009\u7684\u53ef\u7528\u63a5\u53e3\u6d4b\u8bd5\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u542f\u7528\u8be5\u5de5\u5177\u3002", (String)"GaiToolEnableOperationPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.addErrMessage(dataEntity, message);
                    flag = Boolean.FALSE;
                }
                return flag;
            }
        }
        return Boolean.TRUE;
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "BeforeExecuteOperationTransactionSample", "is test pass", errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

