/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.ParamConfigEnum;
import kd.ai.gai.core.service.config.GaiParamConfigService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiToolInfoPlugin
extends AbstractFormPlugin {
    private static final String FORM_ID = "gai_tool_info";
    private static final String TOOL_INFO_CALLBACK_KEY = "gai_tool_info_callback";
    private static final String TOOL_EDIT_FORM_ID = "gai_tool_edit";
    private static final String entryentity = "entryentity";
    private static final String btnok = "btnok";
    private static final String btncancel = "btncancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getControl(btnok);
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getControl(btncancel);
        btncancel.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        if (propertyName.equals("radiogroupfield") && null != data.getNewValue() && data.getNewValue().toString().equals("restful_api")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"app"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tool_url", "headercontainer"});
        } else if (propertyName.equals("radiogroupfield") && null != data.getNewValue() && data.getNewValue().toString().equals("cosmic_action")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"headercontainer", "tool_url"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"app"});
        } else if (propertyName.equals("radiogroupfield") && null != data.getNewValue() && data.getNewValue().toString().equals(ToolConstant.ToolType.MCP_TOOL.getType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"app", "headercontainer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tool_url"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"app"});
        JSONObject tool = (JSONObject)this.getView().getFormShowParameter().getCustomParam("toolObject");
        this.getModel().setValue("tool_title_info", (Object)ResManager.loadKDString((String)"\u5de5\u5177\u7c7b\u578b", (String)"GaiToolInfoPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue("base_info", (Object)ResManager.loadKDString((String)"\u57fa\u7840\u4fe1\u606f", (String)"GaiToolInfoPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]));
        this.getModel().setValue("header_list", (Object)ResManager.loadKDString((String)"Header\u53c2\u6570\u5217\u8868", (String)"GaiToolInfoPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]));
        if (null != tool) {
            this.initToolData(tool);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"headercontainer"});
            if (this.mcpToolEnable()) {
                this.getModel().setValue("radiogroupfield", (Object)ToolConstant.ToolType.MCP_TOOL.getType());
                this.getView().updateView("radiogroupfield");
            } else {
                this.getModel().setValue("radiogroupfield", (Object)ToolConstant.ToolType.RESTFUL_API.getType());
                this.getView().updateView("radiogroupfield");
                this.getView().setVisible(Boolean.TRUE, new String[]{"tool_url", "headercontainer"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"radio_mcp"});
            }
        }
    }

    private boolean mcpToolEnable() {
        String mcpToolEnable = GaiParamConfigService.getConfigValue((String)ParamConfigEnum.MCP_TOOL_ENABLE.getId());
        return StringUtils.equalsIgnoreCase((CharSequence)mcpToolEnable, (CharSequence)EnableEnum.YES.getKeyStr());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.lowerCase((String)key).equals(btnok)) {
            if (this.checkRequiredParam()) {
                return;
            }
            this.getModel().setValue("confirm", (Object)"ok");
            this.setReturnData();
            this.getView().close();
        } else if (StringUtils.lowerCase((String)key).equals(btncancel)) {
            this.getModel().setValue("confirm", (Object)"cancel");
            this.getView().close();
        }
    }

    private boolean checkServerIpIsInvalidate() {
        String serverStr = (String)this.getModel().getValue("tool_url");
        if (StringUtils.isBlank((CharSequence)serverStr)) {
            return Boolean.FALSE;
        }
        Boolean isValidate = Boolean.FALSE;
        if (OpenAPIUtils.containsInternalIP((String)serverStr)) {
            isValidate = Boolean.TRUE;
        }
        return isValidate;
    }

    private boolean checkRequiredParam() {
        String toolType = (String)this.getModel().getValue("radiogroupfield");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (name.size() == 0 || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
            String message = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolInfoPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        OrmLocaleValue description = (OrmLocaleValue)this.getModel().getValue("description");
        if (description.size() == 0 || StringUtils.isEmpty((CharSequence)description.getLocaleValue())) {
            String message = ResManager.loadKDString((String)"\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolInfoPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("radiogroupfield")))) {
            String message = ResManager.loadKDString((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolInfoPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if ((StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) && StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("tool_url")))) {
            String message = ResManager.loadKDString((String)"URL\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiToolInfoPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return true;
        }
        if ((StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) && this.checkServerIpIsInvalidate()) {
            this.getView().showTipNotification("\u4e0d\u652f\u6301\u8bbf\u95ee\u5185\u7f51IP\u6bb5", Integer.valueOf(3000));
            return true;
        }
        return false;
    }

    private void initToolData(JSONObject toolObject) {
        String configTag;
        Long toolId = toolObject.getLong("id");
        this.getModel().setValue("tool_id", (Object)toolId);
        String picture = toolObject.getString("picture");
        String name = toolObject.getJSONObject("name").getString("zh_CN");
        String description = toolObject.getJSONObject("description").getString("zh_CN");
        String toolType = toolObject.getString("tool_type");
        if (!this.mcpToolEnable() && !StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"radio_mcp"});
        }
        if (null != toolId && 0L != toolId) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"radiogroupfield"});
        } else {
            this.getModel().setValue("confirm", (Object)"cancel");
        }
        if (null != toolObject.get((Object)"app")) {
            JSONObject app = toolObject.getJSONObject("app");
            DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)app.getString("id"), (String)"bos_devportal_bizapp");
            this.getModel().setValue("app", (Object)appObject);
        }
        this.getModel().setValue("description", (Object)description);
        this.getModel().setValue("name", (Object)name);
        this.getModel().setValue("picture", (Object)picture);
        this.getModel().setValue("radiogroupfield", (Object)"restful_api");
        JSONObject groupJo = toolObject.getJSONObject("group");
        if (groupJo != null) {
            this.getModel().setValue("group", (Object)groupJo.getLong("id"));
        }
        if (ToolConstant.ToolType.RESTFUL_API.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getModel().setValue("form_model", (Object)"long");
            configTag = toolObject.getString("config_tag");
            if (StringUtils.isNotEmpty((CharSequence)configTag)) {
                JSONObject configJson = JSONObject.parseObject((String)configTag);
                this.buildHeader(configJson);
                String url = configJson.getString("url");
                this.getModel().setValue("tool_url", (Object)url);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"app"});
        } else if (ToolConstant.ToolType.THIRD_OPENAPI.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getModel().setValue("form_model", (Object)"short");
            configTag = toolObject.getString("config_tag");
            JSONObject swagger = JSONObject.parseObject((String)configTag);
            this.buildHeader(swagger);
            if (StringUtils.isNotEmpty((CharSequence)swagger.getString("swaggerSchema"))) {
                JSONObject swaggerConfig = JSONObject.parseObject((String)swagger.getString("swaggerSchema"));
                JSONArray serverArrays = swaggerConfig.getJSONArray("servers");
                String url = "/";
                if (serverArrays != null && !serverArrays.isEmpty()) {
                    url = serverArrays.getString(0);
                }
                this.getModel().setValue("tool_url", (Object)url);
            }
        } else if (ToolConstant.ToolType.MCP_TOOL.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getModel().setValue("form_model", (Object)"short");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
            this.getModel().setValue("radiogroupfield", (Object)ToolConstant.ToolType.MCP_TOOL.getType());
            this.getView().setVisible(Boolean.FALSE, new String[]{"app", "headercontainer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tool_url"});
            configTag = toolObject.getString("config_tag");
            if (StringUtils.isNotEmpty((CharSequence)configTag)) {
                JSONObject configJson = JSONObject.parseObject((String)configTag);
                String url = configJson.getString("url");
                this.getModel().setValue("tool_url", (Object)url);
            }
        } else if (ToolConstant.ToolType.COSMIC_ACTION.getType().equals(StringUtils.lowerCase((String)toolType))) {
            this.getModel().setValue("form_model", (Object)"short");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"headercontainer", "tool_url"});
            this.getModel().setValue("radiogroupfield", (Object)"cosmic_action");
            this.getView().setVisible(Boolean.TRUE, new String[]{"app"});
        }
    }

    private void buildHeader(JSONObject swagger) {
        JSONArray headerList = swagger.getJSONArray("headerList");
        if (null == headerList || headerList.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(entryentity, headerList.size());
        for (int i = 0; i < headerList.size(); ++i) {
            JSONObject header = headerList.getJSONObject(i);
            this.getModel().setValue("header_key", (Object)header.getString("key"), i);
            this.getModel().setValue("header_value", (Object)header.getString("value"), i);
        }
    }

    private void setReturnData() {
        DynamicObjectCollection entryentity;
        JSONObject renturnData = new JSONObject();
        String description = ((OrmLocaleValue)this.getModel().getValue("description")).getLocaleValue();
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        String picture = (String)this.getModel().getValue("picture");
        String type = (String)this.getModel().getValue("radiogroupfield");
        String url = (String)this.getModel().getValue("tool_url");
        renturnData.put("description", (Object)description);
        renturnData.put("name", (Object)name);
        renturnData.put("picture", (Object)picture);
        renturnData.put("radiogroupfield", (Object)type);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            renturnData.put("tool_url", (Object)url);
        }
        if ((entryentity = this.getModel().getEntryEntity(entryentity)).size() > 0) {
            JSONArray headerlist = new JSONArray();
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryentity.get(i);
                JSONObject headerParam = new JSONObject();
                headerParam.put("key", (Object)entity.getString("header_key"));
                headerParam.put("value", (Object)entity.getString("header_value"));
                headerlist.add((Object)headerParam);
            }
            renturnData.put("headerList", (Object)headerlist);
        }
        if (null != this.getModel().getValue("app")) {
            String appid = ((DynamicObject)this.getModel().getValue("app")).getString("id");
            DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)appid, (String)"bos_devportal_bizapp");
            renturnData.put("tool_cloud", (Object)appObject.getDynamicObject("bizcloud").getString("name"));
            renturnData.put("tool_app", (Object)appObject.getString("name"));
            renturnData.put("app", (Object)appid);
        }
        renturnData.put("confirm", this.getModel().getValue("confirm"));
        if (null != this.getModel().getValue("group")) {
            renturnData.put("group", (Object)((DynamicObject)this.getModel().getValue("group")).getLong("id"));
            renturnData.put("groupName", (Object)((DynamicObject)this.getModel().getValue("group")).getString("name"));
        }
        this.getView().returnDataToParent((Object)renturnData);
    }
}

