/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.gai.core.agent.tool.ToolPageCache;
import kd.ai.gai.core.domain.dto.agent.BaseAPI;
import kd.ai.gai.core.domain.dto.agent.MCPTool;
import kd.ai.gai.core.service.agent.MCPService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiToolMCPTestFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiToolMCPTestFormPlugin.class);
    private ToolPageCache cache;
    public static final String CONTROL_RESULT_CODE_EDIT = "codeeditap";
    public static final String CONTROL_REQUEST_BODY = "request_body";
    public static final String API_TEST_CACHE = "_api_test_cache_pre";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject config = (JSONObject)formShowParameter.getCustomParam("configJo");
        logger.info("API Test Config:{}", (Object)config.toJSONString());
        JSONObject apiInfo = (JSONObject)formShowParameter.getCustomParam("apiInfoJo");
        JSONObject inputParams = apiInfo.getJSONObject("inputParams");
        JSONObject initParamsJo = new JSONObject();
        if (inputParams != null) {
            for (String key : inputParams.keySet()) {
                JSONObject itemJo = inputParams.getJSONObject(key);
                String itemType = itemJo.getString("type");
                Object defaultValue = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)itemType, (CharSequence)"object")) {
                    defaultValue = new JSONObject();
                } else if ("array".equalsIgnoreCase(itemType)) {
                    defaultValue = new JSONArray();
                } else if ("integer".equalsIgnoreCase(itemType)) {
                    defaultValue = 0;
                } else if ("number".equalsIgnoreCase(itemType)) {
                    defaultValue = 0;
                } else if ("boolean".equalsIgnoreCase(itemType)) {
                    defaultValue = false;
                } else if ("string".equalsIgnoreCase(itemType)) {
                    defaultValue = "";
                }
                initParamsJo.put(key, defaultValue);
            }
        }
        CodeEdit body = (CodeEdit)this.getControl(CONTROL_REQUEST_BODY);
        body.setText(JSONObject.toJSONString((Object)initParamsJo, (boolean)true));
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if ("test".equalsIgnoreCase(operateKey)) {
            this.callApi();
        }
    }

    private void callApi() {
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            long toolId = null != formShowParameter.getCustomParam("toolId") ? (Long)formShowParameter.getCustomParam("toolId") : 0L;
            JSONObject configJo = (JSONObject)formShowParameter.getCustomParam("configJo");
            JSONObject apiInfoJo = (JSONObject)formShowParameter.getCustomParam("apiInfoJo");
            CodeEdit codeEdit = (CodeEdit)this.getControl(CONTROL_RESULT_CODE_EDIT);
            codeEdit.setText("");
            String url = configJo.getString("url");
            String operationId = apiInfoJo.getString("operationId");
            String toolConfig = configJo.toJSONString();
            CodeEdit bodyEdit = (CodeEdit)this.getControl(CONTROL_REQUEST_BODY);
            String requestBody = bodyEdit.getText();
            JSONObject arguments = JSONObject.parseObject((String)requestBody);
            HashMap headers = new HashMap(1);
            logger.info("url:{}, headers:{}", (Object)url, headers);
            JSONObject data = new JSONObject();
            data.put("operationId", (Object)operationId);
            String errCode = "1";
            MCPTool mcpTool = new MCPTool();
            JSONObject toolParams = new JSONObject();
            toolParams.put("operationId", (Object)operationId);
            toolParams.put("parameters", (Object)arguments);
            mcpTool.setToolId(Long.valueOf(toolId));
            mcpTool.setToolParams(toolParams);
            BaseResult baseResult = MCPService.getService().callApi(toolConfig, (BaseAPI)mcpTool);
            if (baseResult.getData() instanceof JSONObject) {
                JSONObject baData = (JSONObject)baseResult.getData();
                if (baData.keySet().size() > 0) {
                    String text = JSONObject.toJSONString((Object)baData, (boolean)true);
                    codeEdit.setText(text);
                    errCode = baData.getBoolean("isError") != false ? "1" : "0";
                }
            } else {
                String baData = (String)baseResult.getData();
                if (StringUtils.isNotEmpty((CharSequence)baData)) {
                    String text = JSONObject.toJSONString((Object)JSONObject.parseObject((String)baData), (boolean)true);
                    codeEdit.setText(text);
                    errCode = JSONObject.parseObject((String)baData).getBoolean("isError") != false ? "1" : "0";
                }
            }
            data.put("errCode", (Object)errCode);
            this.getPageCache().put(API_TEST_CACHE, data.toJSONString());
        }
        catch (Exception e) {
            logger.info("toolscall error:{}", (Object)e.getMessage(), (Object)e);
            String message = ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5Client\u4e0eServer\u7684\u7f51\u7edc\u662f\u5426\u4e92\u901a\u53caMCP Server\u662f\u5426\u6b63\u5e38\uff1a%s", (String)"GaiMCPServerPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
            String[] split = e.getMessage().split(":");
            String detailMessage = split.length > 0 ? split[split.length - 1] : e.getMessage();
            this.getView().showErrorNotification(String.format(message, detailMessage));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String cache = this.getPageCache().get(API_TEST_CACHE);
        JSONObject data = StringUtils.isNotEmpty((CharSequence)cache) ? JSONObject.parseObject((String)cache) : null;
        this.getView().returnDataToParent((Object)data);
    }
}

