/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.CtlSchemaInfo;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.metadata.form.control.CustomControlAp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiToolSelectCustomPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log logger = LogFactory.getLog(GaiToolSelectCustomPlugin.class);
    private static final String FORM_ID = "gai_tool_select_custom";
    private static final String lastpage = "last_page";
    private static final String nextpage = "next_page";
    private static final String alltype = "all_type";
    private static final String inmcp = "internal_mcp";
    private static final String outmcp = "mcp_tool";
    private static final String restfulapi = "restful_api";
    private static final String cosmicaction = "cosmic_action";
    private static final String allgroup = "all_group";
    private static final String secondFilter = "second_filter";
    private static final String groupFilter = "group_filter";
    private static final String groupPanelap = "group_panelap";
    private static final String pagecount = "page_count";
    private static final String typecombo = "type_combo";
    private static final String TOOL_BASIC_INFO_FORM_ID = "gai_tool_info";
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    protected static final String CTL_GROUP_CUSTOM = "group_custom";
    private static final String CUSTOM_EVENT_SELECT_TOOL = "select_tool";
    private static final String CUSTOM_EVENT_REMOVE_TOOL = "remove_tool";
    private static final String CUSTOM_EVENT_SEARCH_TOOL = "search_tool";
    private static final String CUSTOM_EVENT_CHECK_TOOL = "check_tool";
    private static final String CUSTOM_EVENT_SELECT_GROUP = "group_select";
    private static final String CACHE_KEY_TOOL_LIST = "toolListData";
    private static final String CACHE_KEY_SELECT_CONFIG = "selectedToolConfig";
    private static final String CACHE_KEY_KEYWORD_QFIELTER = "KeywordQFilterCache";
    private static final String CACHE_KEY_TYPE_QFIELTER = "TypeQFilterCache";
    private static final String CACHE_KEY_GROUP_QFIELTER = "GroupQFilterCache";
    private static final String CACHE_KEY_APP_QFIELTER = "AppQFilterCache";
    private static final String CACHE_KEY_PAGE = "pageCache";
    private static final String CACHE_KEY_SIZE = "sizeCache";
    private static final String ctlSchema = "ai-common-components";
    private static final String isvId = "kingdee";
    private static final String moduleId = "gai";
    private static boolean IS_PROCESS = false;
    private static final List<String> allTypeArray = Arrays.asList("all_type", "internal_mcp", "mcp_tool", "restful_api", "cosmic_action");
    private static List<String> allGroupArray = new ArrayList<String>();
    private Boolean finishSelected = true;

    public void initialize() {
        this.getView().addCustomControls(new String[]{groupPanelap});
        super.initialize();
    }

    private List<Map<String, Object>> createGroups() {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(0);
        List<ButtonAp> buttonAps = this.createGroupButtons();
        buttonAps.stream().forEach(buttonAp -> items.add(buttonAp.createControl()));
        CustomControlAp customControlAp = new CustomControlAp();
        customControlAp.setId(CTL_GROUP_CUSTOM);
        customControlAp.setKey(CTL_GROUP_CUSTOM);
        customControlAp.setParentId(groupPanelap);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        style.setMargin(margin);
        customControlAp.setStyle(style);
        CtlSchemaInfo ctlSchemaInfo = new CtlSchemaInfo(ctlSchema, ctlSchema, isvId, moduleId);
        customControlAp.setCtlSchemaInfo(ctlSchemaInfo);
        items.add(customControlAp.createControl());
        return items;
    }

    private List<ButtonAp> createGroupButtons() {
        QFilter filter = new QFilter("parent", "=", (Object)0L);
        Map groups = BusinessDataServiceHelper.loadFromCache((String)"gai_tool_group", (QFilter[])new QFilter[]{filter});
        ArrayList<ButtonAp> buttonAps = new ArrayList<ButtonAp>(0);
        ButtonAp button = null;
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("10px");
        style.setMargin(margin);
        Padding padding = new Padding();
        padding.setRight("16px");
        padding.setLeft("16px");
        style.setPadding(padding);
        if (!allGroupArray.contains(allgroup)) {
            allGroupArray.add(allgroup);
        }
        ButtonAp allGroupButton = new ButtonAp();
        allGroupButton.setId(allgroup);
        allGroupButton.setName(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GaiToolSelectCustomPlugin_13885624", (String)"ai-gai-plugin", (Object[])new Object[0])));
        allGroupButton.setKey(allgroup);
        allGroupButton.setHeight(new LocaleString("28px"));
        allGroupButton.setParentId(groupPanelap);
        allGroupButton.setForeColor("#212121");
        allGroupButton.setBackColor("#F5F8FE");
        allGroupButton.setRadius("16px");
        allGroupButton.setStyle(style);
        buttonAps.add(allGroupButton);
        int i = 0;
        for (Map.Entry entry : groups.entrySet()) {
            if (i == 7) break;
            button = new ButtonAp();
            button.setId(((DynamicObject)entry.getValue()).getString("number"));
            button.setName(new LocaleString(((DynamicObject)entry.getValue()).getString("name")));
            button.setKey(((DynamicObject)entry.getValue()).getString("number"));
            button.setParentId(groupPanelap);
            button.setForeColor("#212121");
            button.setBackColor("#F5F8FE");
            button.setRadius("16px");
            button.setStyle(style);
            buttonAps.add(button);
            if (!allGroupArray.contains(((DynamicObject)entry.getValue()).getString("number"))) {
                allGroupArray.add(((DynamicObject)entry.getValue()).getString("number"));
            }
            ++i;
        }
        return buttonAps;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", groupPanelap);
        mapHead.put("items", this.createGroups());
        e.getItems().add(mapHead);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container groupFilterContainer = (Container)this.getView().getControl(groupPanelap);
        List<ButtonAp> buttonAps = this.createGroupButtons();
        buttonAps.stream().forEach(buttonAp -> groupFilterContainer.getItems().add(buttonAp.buildRuntimeControl()));
        this.getView().createControlIndex(groupFilterContainer.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (allGroupArray.contains(e.getKey())) {
            Button button = new Button();
            button.setKey(e.getKey());
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        JSONArray selectedToolConfig = (JSONArray)parameter.getCustomParam("selected_tool_config");
        IS_PROCESS = null != parameter.getCustomParam("is_process") && ((Boolean)parameter.getCustomParam("is_process")).booleanValue();
        this.getView().setEnable(Boolean.FALSE, new String[]{lastpage});
        this.setSelectedButtonColor(alltype);
        this.setSelectedButtonColor(allgroup);
        if (null != selectedToolConfig) {
            this.getPageCache().put(CACHE_KEY_SELECT_CONFIG, selectedToolConfig.toJSONString());
        }
        this.buildGroupCombo();
        this.searchByType("all");
    }

    private void buildGroupCombo() {
        QFilter filter = new QFilter("parent", "=", (Object)0L);
        Map groups = BusinessDataServiceHelper.loadFromCache((String)"gai_tool_group", (QFilter[])new QFilter[]{filter});
        if (groups.size() > 7) {
            JSONObject initData = new JSONObject();
            JSONObject data = new JSONObject();
            data.put("component", (Object)"tag_select");
            JSONObject params = new JSONObject();
            params.put("invokeKey", (Object)CUSTOM_EVENT_SELECT_GROUP);
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            for (Map.Entry entry : groups.entrySet()) {
                if (i < 7) {
                    ++i;
                    continue;
                }
                JSONObject param = new JSONObject();
                param.put("label", (Object)((DynamicObject)entry.getValue()).getString("name"));
                param.put("value", (Object)((DynamicObject)entry.getValue()).getString("number"));
                jsonArray.add((Object)param);
            }
            params.put("options", (Object)jsonArray);
            data.put("params", (Object)params);
            initData.put("type", (Object)"init");
            initData.put("data", (Object)data);
            initData.put("timestamp", (Object)new Date().getTime());
            CustomControl custom = (CustomControl)this.getView().getControl(CTL_GROUP_CUSTOM);
            custom.setData((Object)initData);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTL_GROUP_CUSTOM});
        }
    }

    protected void sendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        switch (eventName) {
            case "search_tool": {
                this.refreshData();
                break;
            }
            case "select_tool": {
                JSONObject params = JSONObject.parseObject((String)eventArgs);
                Long toolId = params.getLong("toolId");
                String operationId = params.getString("operationId");
                String btnId = params.getString("btnId");
                this.buildSelectedToolConfig(toolId, operationId, btnId);
                if (!IS_PROCESS) break;
                this.getView().close();
                break;
            }
            case "remove_tool": {
                JSONObject removeParams = JSONObject.parseObject((String)eventArgs);
                this.removeSelectedToolConfig(removeParams);
                break;
            }
            case "check_tool": {
                JSONObject checkparams = JSONObject.parseObject((String)eventArgs);
                this.openToolDetail(checkparams.getLong("toolId"));
                break;
            }
            case "group_select": {
                String number = eventArgs;
                this.searchByGroup(number, allGroupArray);
                break;
            }
        }
    }

    private void refreshData() {
        JSONArray selectedToolConfig = null;
        if (null != this.getPageCache().get(CACHE_KEY_SELECT_CONFIG)) {
            selectedToolConfig = JSONArray.parseArray((String)this.getPageCache().get(CACHE_KEY_SELECT_CONFIG));
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_KEYWORD_QFIELTER))) {
            qFilter.and(this.getKeywordFilter());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_TYPE_QFIELTER))) {
            qFilter.and(this.getTypeFilter());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_APP_QFIELTER))) {
            qFilter.and(new QFilter("app", "=", (Object)this.getPageCache().get(CACHE_KEY_APP_QFIELTER)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_GROUP_QFIELTER))) {
            qFilter.and(new QFilter("group", "=", (Object)this.getPageCache().get(CACHE_KEY_GROUP_QFIELTER)));
        }
        JSONArray array = this.buildEntryData(qFilter, selectedToolConfig);
        this.sendToVue(array);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)lastpage)) {
            int page = this.getPage();
            if (--page == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{lastpage});
            }
            this.getPageCache().put(CACHE_KEY_PAGE, String.valueOf(page));
            this.refreshData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)nextpage)) {
            int page = this.getPage();
            if (++page > 0) {
                this.getView().setEnable(Boolean.TRUE, new String[]{lastpage});
            }
            this.getPageCache().put(CACHE_KEY_PAGE, String.valueOf(page));
            this.refreshData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)alltype)) {
            this.resetPage();
            this.setSelectedButtonColor(alltype);
            for (String unselectedKey : allTypeArray) {
                if (StringUtils.equalsIgnoreCase((CharSequence)unselectedKey, (CharSequence)alltype)) continue;
                this.setUnSelectedButtonColor(unselectedKey);
            }
            this.clearSecondFilter();
            this.getView().setVisible(Boolean.TRUE, new String[]{secondFilter, groupFilter});
            this.searchByType("all");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)inmcp) || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)cosmicaction)) {
            this.resetPage();
            this.setSelectedButtonColor(key);
            for (String unselectedKey : allTypeArray) {
                if (StringUtils.equalsIgnoreCase((CharSequence)unselectedKey, (CharSequence)key)) continue;
                this.setUnSelectedButtonColor(unselectedKey);
            }
            this.clearSecondFilter();
            this.getView().setVisible(Boolean.TRUE, new String[]{secondFilter});
            this.searchByType(key);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)outmcp) || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)restfulapi)) {
            this.resetPage();
            this.setSelectedButtonColor(key);
            for (String unselectedKey : allTypeArray) {
                if (StringUtils.equalsIgnoreCase((CharSequence)unselectedKey, (CharSequence)key)) continue;
                this.setUnSelectedButtonColor(unselectedKey);
            }
            this.setSelectedButtonColor(allgroup);
            for (String unselectedKey : allGroupArray) {
                if (StringUtils.equalsIgnoreCase((CharSequence)unselectedKey, (CharSequence)allgroup)) continue;
                this.setUnSelectedButtonColor(unselectedKey);
            }
            this.clearSecondFilter();
            this.getView().setVisible(Boolean.TRUE, new String[]{secondFilter, groupFilter});
            this.setSelectedButtonColor(allgroup);
            this.searchByType(key);
        } else if (allgroup.equalsIgnoreCase(key) || allGroupArray.contains(key)) {
            this.buildGroupCombo();
            allGroupArray.add(allgroup);
            this.searchByGroup(key, allGroupArray);
        }
    }

    private void searchByGroup(String key, List<String> allGroupArray) {
        this.setSelectedButtonColor(key);
        for (String unselectedKey : allGroupArray) {
            if (StringUtils.equalsIgnoreCase((CharSequence)unselectedKey, (CharSequence)key)) continue;
            this.setUnSelectedButtonColor(unselectedKey);
        }
        this.resetPage();
        JSONArray selectedToolConfig = null;
        if (null != this.getPageCache().get(CACHE_KEY_SELECT_CONFIG)) {
            selectedToolConfig = JSONArray.parseArray((String)this.getPageCache().get(CACHE_KEY_SELECT_CONFIG));
        }
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)allgroup)) {
            this.getPageCache().remove(CACHE_KEY_GROUP_QFIELTER);
        } else {
            String groupNumber = key.replace("btn_", "");
            DynamicObject toolGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_group", (String)"id", (QFilter[])new QFilter("number", "=", (Object)groupNumber).toArray());
            if (null == toolGroup) {
                this.sendToVue(new JSONArray());
                return;
            }
            qfilter.and(new QFilter("group", "=", (Object)toolGroup.getLong("id")));
            this.getPageCache().put(CACHE_KEY_GROUP_QFIELTER, toolGroup.getString("id"));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_KEYWORD_QFIELTER))) {
            qfilter.and(this.getKeywordFilter());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_TYPE_QFIELTER))) {
            QFilter typeQFilter = this.getTypeFilter();
            qfilter.and(typeQFilter);
        }
        JSONArray jsonArray = this.buildEntryData(qfilter, selectedToolConfig);
        this.sendToVue(jsonArray);
    }

    private void clearSecondFilter() {
        this.getPageCache().remove(CACHE_KEY_TYPE_QFIELTER);
        this.getPageCache().remove(CACHE_KEY_APP_QFIELTER);
        this.getPageCache().remove(CACHE_KEY_GROUP_QFIELTER);
    }

    private void setSelectedButtonColor(String btnkey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#FFFFFF");
        map.put("bc", "#5582F3");
        map.put("rd", "16px");
        this.getView().updateControlMetadata(btnkey, map);
        this.getView().updateView(btnkey);
    }

    private void setUnSelectedButtonColor(String btnkey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#212121");
        map.put("bc", "#F5F8FE");
        map.put("rd", "16px");
        this.getView().updateControlMetadata(btnkey, map);
        this.getView().updateView(btnkey);
    }

    private int getPage() {
        if (null == this.getPageCache().get(CACHE_KEY_PAGE)) {
            this.getPageCache().put(CACHE_KEY_PAGE, String.valueOf(0));
            return 0;
        }
        return Integer.parseInt(this.getPageCache().get(CACHE_KEY_PAGE));
    }

    private int getSize() {
        if (null == this.getPageCache().get(CACHE_KEY_SIZE)) {
            this.getPageCache().put(CACHE_KEY_SIZE, String.valueOf(10));
            return 10;
        }
        return Integer.parseInt(this.getPageCache().get(CACHE_KEY_SIZE));
    }

    private JSONArray buildEntryData(QFilter qFilter, JSONArray selectedArray) {
        DynamicObject[] dynamicObjects;
        String url = GaiToolSelectCustomPlugin.getHost() + "/kingdee/gai/images/pc/tool/gai_tool_kingdee_square.png";
        int size = this.getSize();
        int page = this.getPage();
        Map<Object, Object> selectedToolMap = new HashMap();
        if (null != selectedArray && selectedArray.size() > 0) {
            this.getPageCache().put(CACHE_KEY_SELECT_CONFIG, selectedArray.toJSONString());
            selectedToolMap = selectedArray.stream().collect(Collectors.toMap(v -> ((JSONObject)v).getLong("toolId"), v -> (JSONObject)v));
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)"gai_tool", (String)"id,name,number,tool_type,picture,description,config_tag", (QFilter[])qFilter.toArray(), (String)String.format("%s desc, id desc", "modifytime"), (int)page, (int)size)).length < this.getSize()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{nextpage});
        } else if (BusinessDataServiceHelper.load((String)"gai_tool", (String)"id", (QFilter[])qFilter.toArray(), (String)String.format("%s desc, id desc", "modifytime"), (int)(page + 1), (int)size).length == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{nextpage});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{nextpage});
        }
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String enable;
            String operationId;
            JSONObject api;
            JSONObject apiInfo;
            int j;
            JSONArray apiList;
            Set selectedOperationIds;
            String picture;
            JSONObject toolObject = new JSONObject();
            DynamicObject tool = dynamicObjects[i];
            String type = tool.getString("tool_type");
            JSONObject configTag = null;
            if (StringUtils.isNotEmpty((CharSequence)tool.getString("config_tag"))) {
                configTag = JSONObject.parseObject((String)tool.getString("config_tag"));
            }
            JSONObject selectedInfo = null;
            if (selectedToolMap.size() > 0 && selectedToolMap.containsKey(tool.getLong("id"))) {
                selectedInfo = (JSONObject)selectedToolMap.get(tool.getLong("id"));
            }
            String string = picture = StringUtils.isNotEmpty((CharSequence)tool.getString("picture")) ? tool.getString("picture") : url;
            if (picture.contains("/kingdee/gai/images/pc/tool/") && !picture.contains(GaiToolSelectCustomPlugin.getHost())) {
                picture = GaiToolSelectCustomPlugin.getHost() + picture;
            }
            toolObject.put("toolPicture", (Object)picture);
            toolObject.put("toolName", (Object)tool.getString("name"));
            toolObject.put("toolId", (Object)tool.getString("id"));
            toolObject.put("toolType", (Object)type);
            toolObject.put("toolNumber", (Object)tool.getString("number"));
            toolObject.put("toolDescription", (Object)tool.getString("description"));
            JSONArray apiArray = new JSONArray();
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) {
                toolObject.put("selected", null);
                selectedOperationIds = null;
                if (selectedInfo != null) {
                    selectedOperationIds = Arrays.stream(selectedInfo.getString("operations").split(",")).collect(Collectors.toSet());
                }
                if (configTag != null && null != (apiList = configTag.getJSONArray("apiList")) && apiList.size() > 0) {
                    for (j = 1; j <= apiList.size(); ++j) {
                        apiInfo = new JSONObject();
                        api = apiList.getJSONObject(j - 1);
                        operationId = api.getString("operationId");
                        enable = api.getString("enable");
                        if (!"1".equals(enable)) continue;
                        apiInfo.put("apiName", (Object)(StringUtils.isNotEmpty((CharSequence)api.getString("name")) ? api.getString("name") : operationId));
                        apiInfo.put("apiDescription", (Object)api.getString("description"));
                        apiInfo.put("operationId", (Object)api.getString("operationId"));
                        apiInfo.put("selected", (Object)(null != selectedOperationIds && selectedOperationIds.contains(operationId) ? 1 : 0));
                        apiArray.add((Object)apiInfo);
                    }
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
                toolObject.put("selected", null);
                selectedOperationIds = null;
                if (selectedInfo != null) {
                    selectedOperationIds = Arrays.stream(selectedInfo.getString("operations").split(",")).collect(Collectors.toSet());
                }
                if (configTag != null && null != (apiList = configTag.getJSONArray("apiList")) && apiList.size() > 0) {
                    for (j = 1; j <= apiList.size(); ++j) {
                        apiInfo = new JSONObject();
                        api = apiList.getJSONObject(j - 1);
                        operationId = api.getString("operationId");
                        enable = api.getString("enable");
                        if (!"1".equals(enable)) continue;
                        apiInfo.put("apiName", (Object)(StringUtils.isNotEmpty((CharSequence)api.getString("name")) ? api.getString("name") : operationId));
                        apiInfo.put("apiDescription", (Object)api.getString("description"));
                        apiInfo.put("operationId", (Object)api.getString("operationId"));
                        apiInfo.put("selected", (Object)(null != selectedOperationIds && selectedOperationIds.contains(operationId) ? 1 : 0));
                        apiArray.add((Object)apiInfo);
                    }
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                toolObject.put("selected", null);
                selectedOperationIds = null;
                if (selectedInfo != null) {
                    selectedOperationIds = Arrays.stream(selectedInfo.getString("operations").split(",")).collect(Collectors.toSet());
                }
                if (configTag != null && null != (apiList = configTag.getJSONArray("apiList")) && apiList.size() > 0) {
                    for (j = 1; j <= apiList.size(); ++j) {
                        apiInfo = new JSONObject();
                        api = apiList.getJSONObject(j - 1);
                        operationId = api.getString("openApiId");
                        apiInfo.put("apiName", (Object)(StringUtils.isNotEmpty((CharSequence)api.getString("name")) ? api.getString("name") : operationId));
                        apiInfo.put("apiDescription", (Object)api.getString("description"));
                        apiInfo.put("operationId", (Object)api.getString("openApiId"));
                        apiInfo.put("selected", (Object)(null != selectedOperationIds && selectedOperationIds.contains(operationId) ? 1 : 0));
                        apiArray.add((Object)apiInfo);
                    }
                }
            } else {
                toolObject.put("selected", (Object)(selectedInfo != null ? 1 : 0));
            }
            toolObject.put("apiCount", (Object)apiArray.size());
            toolObject.put("apiList", (Object)apiArray);
            resultArray.add((Object)toolObject);
        }
        this.getPageCache().put(CACHE_KEY_TOOL_LIST, resultArray.toJSONString());
        return resultArray;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.finishSelected.booleanValue()) {
            this.setReturnData();
        }
    }

    private void setReturnData() {
        if (null != this.getPageCache().get(CACHE_KEY_SELECT_CONFIG)) {
            String selectedToolConfig = this.getPageCache().get(CACHE_KEY_SELECT_CONFIG);
            JSONArray jsonArray = JSONArray.parseArray((String)selectedToolConfig);
            JSONArray returnData = new JSONArray();
            if (null != jsonArray && jsonArray.size() > 0) {
                List toolIdList = jsonArray.stream().map(v -> ((JSONObject)v).getLong("toolId")).collect(Collectors.toList());
                Map toolMap = BusinessDataServiceHelper.loadFromCache((String)"gai_tool", (String)"tool_type,config_tag", (QFilter[])new QFilter("id", "in", toolIdList).toArray());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject apiObject;
                    List apis;
                    List operations;
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    Long toolId = jsonObject.getLong("toolId");
                    DynamicObject dynamicObject = (DynamicObject)toolMap.get(toolId);
                    String type = dynamicObject.getString("tool_type");
                    String configTag = dynamicObject.getString("config_tag");
                    jsonObject.put("type", (Object)type);
                    if (StringUtils.lowerCase((String)type).equals(ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                        Object in2;
                        jsonObject.remove((Object)"operations");
                        JSONObject inputParams = new JSONObject();
                        JSONObject outputParams = new JSONObject();
                        JSONObject configJson = JSONObject.parseObject((String)configTag);
                        JSONArray inputs = configJson.getJSONArray("inputParams");
                        for (Object in2 : inputs) {
                            JSONObject inputParam = new JSONObject();
                            JSONObject input = (JSONObject)in2;
                            inputParam.put("type", (Object)input.getString("paramType"));
                            inputParam.put("desc", (Object)input.getString("paramDesc"));
                            inputParams.put(input.getString("paramName"), (Object)inputParam);
                        }
                        JSONArray outputs = configJson.getJSONArray("outputParams");
                        in2 = outputs.iterator();
                        while (in2.hasNext()) {
                            Object out = in2.next();
                            JSONObject outputParam = new JSONObject();
                            JSONObject output = (JSONObject)out;
                            outputParam.put("type", (Object)output.getString("paramType"));
                            outputParam.put("desc", (Object)output.getString("paramDesc"));
                            outputParams.put(output.getString("paramName"), (Object)outputParam);
                        }
                        jsonObject.put("outputParams", (Object)outputParams);
                        jsonObject.put("inputParams", (Object)inputParams);
                        returnData.add((Object)jsonObject);
                        continue;
                    }
                    if (StringUtils.lowerCase((String)type).equals(ToolConstant.ToolType.RESTFUL_API.getType())) {
                        operations = Arrays.stream(jsonObject.getString("operations").split(",")).collect(Collectors.toList());
                        apis = JSONObject.parseObject((String)configTag).getJSONArray("apiList").stream().filter(v -> operations.contains(((JSONObject)v).getString("operationId"))).map(v -> (JSONObject)v).collect(Collectors.toList());
                        for (JSONObject api : apis) {
                            apiObject = new JSONObject();
                            apiObject.put("toolId", (Object)toolId);
                            apiObject.put("type", (Object)restfulapi);
                            apiObject.put("operationId", (Object)api.getString("operationId"));
                            apiObject.put("inputParams", (Object)api.getJSONObject("inputParams"));
                            apiObject.put("outputParams", (Object)api.getJSONObject("outputParams"));
                            apiObject.put("operationName", (Object)api.getString("name"));
                            apiObject.put("operationDescription", (Object)api.getString("description"));
                            returnData.add((Object)apiObject);
                        }
                        continue;
                    }
                    if (StringUtils.lowerCase((String)type).equals(ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                        JSONObject configJson = JSONObject.parseObject((String)configTag);
                        String swagger = configJson.getString("swaggerSchema");
                        JSONObject swaggerJson = JSONObject.parseObject((String)swagger);
                        JSONObject paths = swaggerJson.getJSONObject("paths");
                        Set entries = paths.entrySet();
                        ArrayList<String> methods = new ArrayList<String>(Arrays.asList("post", "put", "get"));
                        JSONArray apilist = new JSONArray();
                        for (Map.Entry entity : entries) {
                            JSONObject entityValue = (JSONObject)entity.getValue();
                            Set entrySet = entityValue.entrySet();
                            for (Map.Entry apientity : entrySet) {
                                String description;
                                JSONObject outputParams;
                                JSONObject inputParams;
                                JSONObject apiObject2;
                                String operationId;
                                String key = (String)apientity.getKey();
                                if (!methods.contains(key)) continue;
                                JSONObject apiEntity = (JSONObject)apientity.getValue();
                                if (key.equals("post") || key.equals("put")) {
                                    JSONArray parameters;
                                    operationId = apiEntity.getString("operationId");
                                    apiObject2 = new JSONObject();
                                    apiObject2.put("operationId", (Object)operationId);
                                    inputParams = new JSONObject();
                                    outputParams = new JSONObject();
                                    JSONObject requestBody = apiEntity.getJSONObject("requestBody");
                                    if (null != requestBody) {
                                        List paramterNames = requestBody.keySet().stream().filter(v -> !v.equals("description") && !v.equals("required")).collect(Collectors.toList());
                                        for (String paramName : paramterNames) {
                                            String description2 = requestBody.getString("description");
                                            JSONObject inputParam = new JSONObject();
                                            inputParam.put("type", (Object)"String");
                                            inputParam.put("desc", (Object)description2);
                                            inputParams.put(paramName, (Object)inputParam);
                                        }
                                    }
                                    if (null != (parameters = apiEntity.getJSONArray("parameters"))) {
                                        for (int k = 0; k < parameters.size(); ++k) {
                                            JSONObject inputParam = new JSONObject();
                                            JSONObject input = parameters.getJSONObject(k);
                                            String inputParamType = input.getJSONObject("schema").getString("type");
                                            String name = input.getString("name");
                                            String description3 = input.getString("description");
                                            inputParam.put("type", (Object)inputParamType);
                                            inputParam.put("desc", (Object)description3);
                                            inputParams.put(name, (Object)inputParam);
                                        }
                                    }
                                    if (null != apiEntity.getJSONObject("responses") && null != apiEntity.getJSONObject("responses").getJSONObject("200")) {
                                        JSONObject responses = apiEntity.getJSONObject("responses").getJSONObject("200");
                                        List responsesNames = responses.keySet().stream().filter(v -> !v.equals("description")).collect(Collectors.toList());
                                        for (String paramName : responsesNames) {
                                            description = responses.getString("description");
                                            JSONObject outputParam = new JSONObject();
                                            outputParam.put("type", (Object)"String");
                                            outputParam.put("desc", (Object)description);
                                            outputParams.put(paramName, (Object)outputParam);
                                        }
                                    }
                                    apiObject2.put("inputParams", (Object)inputParams);
                                    apiObject2.put("outputParams", (Object)outputParams);
                                    apilist.add((Object)apiObject2);
                                    continue;
                                }
                                operationId = apiEntity.getString("operationId");
                                apiObject2 = new JSONObject();
                                apiObject2.put("operationId", (Object)operationId);
                                inputParams = new JSONObject();
                                outputParams = new JSONObject();
                                JSONArray parameters = apiEntity.getJSONArray("parameters");
                                if (null != parameters) {
                                    for (int k = 0; k < parameters.size(); ++k) {
                                        JSONObject inputParam = new JSONObject();
                                        JSONObject input = parameters.getJSONObject(k);
                                        String inputParamType = input.getJSONObject("schema").getString("type");
                                        String name = input.getString("name");
                                        description = input.getString("description");
                                        inputParam.put("type", (Object)inputParamType);
                                        inputParam.put("desc", (Object)description);
                                        inputParams.put(name, (Object)inputParam);
                                    }
                                }
                                apiObject2.put("inputParams", (Object)inputParams);
                                apiObject2.put("outputParams", (Object)outputParams);
                                apilist.add((Object)apiObject2);
                            }
                        }
                        jsonObject.put("apiList", (Object)apilist);
                        returnData.add((Object)jsonObject);
                        continue;
                    }
                    if (StringUtils.lowerCase((String)type).equals(ToolConstant.ToolType.MCP_TOOL.getType())) {
                        operations = Arrays.stream(jsonObject.getString("operations").split(",")).collect(Collectors.toList());
                        apis = JSONObject.parseObject((String)configTag).getJSONArray("apiList").stream().filter(v -> operations.contains(((JSONObject)v).getString("operationId"))).map(v -> (JSONObject)v).collect(Collectors.toList());
                        for (JSONObject api : apis) {
                            apiObject = new JSONObject();
                            apiObject.put("toolId", (Object)toolId);
                            apiObject.put("type", (Object)ToolConstant.ToolType.MCP_TOOL.getType());
                            apiObject.put("operationId", (Object)api.getString("operationId"));
                            apiObject.put("inputParams", (Object)api.getJSONObject("inputParams"));
                            apiObject.put("outputParams", (Object)api.getJSONObject("outputParams"));
                            apiObject.put("operationName", (Object)api.getString("name"));
                            apiObject.put("operationDescription", (Object)api.getString("description"));
                            returnData.add((Object)apiObject);
                        }
                        continue;
                    }
                    if (!StringUtils.lowerCase((String)type).equals(ToolConstant.ToolType.INTERNAL_MCP.getType())) continue;
                    operations = Arrays.stream(jsonObject.getString("operations").split(",")).collect(Collectors.toList());
                    apis = JSONObject.parseObject((String)configTag).getJSONArray("apiList").stream().filter(v -> operations.contains(((JSONObject)v).getString("openApiId"))).map(v -> (JSONObject)v).collect(Collectors.toList());
                    for (JSONObject api : apis) {
                        apiObject = new JSONObject();
                        apiObject.put("toolId", (Object)toolId);
                        apiObject.put("type", (Object)ToolConstant.ToolType.INTERNAL_MCP.getType());
                        apiObject.put("operationId", (Object)api.getString("openApiId"));
                        apiObject.put("inputParams", (Object)api.getJSONObject("inputParams"));
                        apiObject.put("outputParams", (Object)api.getJSONObject("outputParams"));
                        apiObject.put("operationName", (Object)api.getString("name"));
                        apiObject.put("operationDescription", (Object)api.getString("description"));
                        returnData.add((Object)apiObject);
                    }
                }
            }
            this.getView().returnDataToParent((Object)returnData);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        DynamicObject toolInfo;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"edit_tool_basic_info_callback", (CharSequence)actionId) && null != (toolInfo = (DynamicObject)returnData)) {
            String type = toolInfo.getString("radiogroupfield");
            if (type.equals("open_api") && toolInfo.getString("confirm").equals("ok")) {
                BillShowParameter bsp = new BillShowParameter();
                bsp.setFormId("gai_tool");
                bsp.setCustomParam("toolbasicinfo", (Object)toolInfo);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm((FormShowParameter)bsp);
            } else if (toolInfo.getString("confirm").equals("ok")) {
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else if (toolInfo.getString("confirm").equals("edit")) {
                FormShowParameter lsp = new FormShowParameter();
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_tool");
                dynamicObject.set("picture", (Object)toolInfo.getString("picture"));
                dynamicObject.set("name", (Object)toolInfo.getString("name"));
                dynamicObject.set("description", (Object)toolInfo.getString("description"));
                dynamicObject.set("tool_type", (Object)toolInfo.getString("radiogroupfield"));
                lsp.setCustomParam("toolObject", (Object)dynamicObject);
                lsp.setFormId(TOOL_BASIC_INFO_FORM_ID);
                lsp.getOpenStyle().setShowType(ShowType.Modal);
                lsp.setShowTitle(true);
                lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "edit_tool_basic_info_callback"));
                this.getView().showForm(lsp);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("addnewtool".equals(e.getOperateKey())) {
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(TOOL_BASIC_INFO_FORM_ID);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setShowTitle(true);
            lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "edit_tool_basic_info_callback"));
            this.getView().showForm(lsp);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Button lastPage = (Button)this.getView().getControl(lastpage);
        lastPage.addClickListener((ClickListener)this);
        Button nextPage = (Button)this.getView().getControl(nextpage);
        nextPage.addClickListener((ClickListener)this);
        Button allType = (Button)this.getView().getControl(alltype);
        allType.addClickListener((ClickListener)this);
        Button inMcp = (Button)this.getView().getControl(inmcp);
        inMcp.addClickListener((ClickListener)this);
        Button outMcp = (Button)this.getView().getControl(outmcp);
        outMcp.addClickListener((ClickListener)this);
        Button restfulApi = (Button)this.getView().getControl(restfulapi);
        restfulApi.addClickListener((ClickListener)this);
        Button cosmicAction = (Button)this.getView().getControl(cosmicaction);
        cosmicAction.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData data = e.getChangeSet()[0];
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)typecombo)) {
            this.resetPage();
            String type = (String)this.getModel().getValue(typecombo);
            this.searchByType(type);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)pagecount)) {
            String size = (String)this.getModel().getValue(pagecount);
            this.getPageCache().put(CACHE_KEY_SIZE, size);
            this.resetPage();
            this.refreshData();
        }
    }

    private void searchByType(String type) {
        JSONArray selectedToolConfig = null;
        if (null != this.getPageCache().get(CACHE_KEY_SELECT_CONFIG)) {
            selectedToolConfig = JSONArray.parseArray((String)this.getPageCache().get(CACHE_KEY_SELECT_CONFIG));
        }
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_KEYWORD_QFIELTER))) {
            qfilter.and(this.getKeywordFilter());
        }
        if (StringUtils.isNotEmpty((CharSequence)type) && !type.equals("all")) {
            QFilter typeQFilter = new QFilter("tool_type", "=", (Object)type);
            qfilter.and(typeQFilter);
            this.getPageCache().put(CACHE_KEY_TYPE_QFIELTER, typeQFilter.toString());
        } else {
            this.getPageCache().remove(CACHE_KEY_TYPE_QFIELTER);
        }
        JSONArray jsonArray = this.buildEntryData(qfilter, selectedToolConfig);
        this.sendToVue(jsonArray);
    }

    private void resetPage() {
        this.getPageCache().put(CACHE_KEY_PAGE, "0");
        this.getView().setEnable(Boolean.FALSE, new String[]{lastpage});
        this.getView().setEnable(Boolean.TRUE, new String[]{nextpage});
    }

    private QFilter getTypeFilter() {
        String s = this.getPageCache().get(CACHE_KEY_TYPE_QFIELTER);
        QFilter qFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            String[] ors;
            for (String filterStr : ors = s.replaceAll("\\(", "").replaceAll("\\)", "").split("OR")) {
                String qcp;
                String[] split;
                if (s.contains("like")) {
                    split = filterStr.split("like");
                    qcp = "like";
                } else {
                    split = filterStr.split("=");
                    qcp = "=";
                }
                if (null == qFilter) {
                    qFilter = new QFilter(split[0], qcp, (Object)split[1].replaceAll("'", "").trim());
                    continue;
                }
                qFilter.or(split[0], qcp, (Object)split[1].replaceAll("'", "").trim());
            }
        }
        return qFilter;
    }

    private QFilter getKeywordFilter() {
        String s = this.getPageCache().get(CACHE_KEY_KEYWORD_QFIELTER);
        QFilter qFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            String[] ors;
            for (String filterStr : ors = s.replaceAll("\\(", "").replaceAll("\\)", "").split("OR")) {
                String qcp;
                String[] split;
                if (s.contains("like")) {
                    split = filterStr.split("like");
                    qcp = "like";
                } else {
                    split = filterStr.split("=");
                    qcp = "=";
                }
                if (null == qFilter) {
                    qFilter = new QFilter(split[0], qcp, (Object)split[1].replaceAll("'", "").trim());
                    continue;
                }
                qFilter.or(split[0], qcp, (Object)split[1].replaceAll("'", "").trim());
            }
        }
        return qFilter;
    }

    private static String getHost() {
        String host = RequestContext.get().getClientFullContextPath();
        if (!StringUtils.isEmpty((CharSequence)host) && host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    private void buildSelectedToolConfig(Long toolId, String operationId, String btnId) {
        JSONArray selectedArray;
        String selectedToolConfig = this.getPageCache().get(CACHE_KEY_SELECT_CONFIG);
        if (IS_PROCESS) {
            selectedToolConfig = null;
        }
        if (StringUtils.isNotEmpty((CharSequence)selectedToolConfig)) {
            selectedArray = JSONArray.parseArray((String)selectedToolConfig);
            List configList = selectedArray.stream().filter(v -> ((JSONObject)v).getLong("toolId").equals(toolId)).map(v -> (JSONObject)v).collect(Collectors.toList());
            if (null != configList && configList.size() > 0) {
                String operations = ((JSONObject)configList.get(0)).getString("operations");
                ((JSONObject)configList.get(0)).put("operations", (Object)(StringUtils.isNotEmpty((CharSequence)operations) ? operations + "," + operationId : operationId));
            } else {
                JSONObject config = new JSONObject();
                config.put("toolId", (Object)toolId);
                config.put("operations", (Object)operationId);
                selectedArray.add((Object)config);
            }
        } else {
            selectedArray = new JSONArray();
            JSONObject config = new JSONObject();
            config.put("toolId", (Object)toolId);
            config.put("operations", (Object)operationId);
            selectedArray.add((Object)config);
        }
        this.getPageCache().put(CACHE_KEY_SELECT_CONFIG, selectedArray.toJSONString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("selected", (Object)Boolean.TRUE);
        jsonObject.put("btnId", (Object)btnId);
        this.sendToVue(jsonObject);
    }

    private void removeSelectedToolConfig(JSONObject params) {
        Long toolId = params.getLong("toolId");
        String btnId = params.getString("btnId");
        String operationId = params.getString("operationId");
        String selectedToolConfig = this.getPageCache().get(CACHE_KEY_SELECT_CONFIG);
        if (StringUtils.isNotEmpty((CharSequence)selectedToolConfig)) {
            JSONArray selectedArray = JSONArray.parseArray((String)selectedToolConfig);
            List configList = selectedArray.stream().filter(v -> ((JSONObject)v).getLong("toolId").equals(toolId)).map(v -> (JSONObject)v).collect(Collectors.toList());
            if (null != configList && configList.size() > 0 && StringUtils.isNotEmpty((CharSequence)operationId) && StringUtils.isNotEmpty((CharSequence)((JSONObject)configList.get(0)).getString("operations"))) {
                String operations = ((JSONObject)configList.get(0)).getString("operations");
                if (operations.equals(operationId)) {
                    selectedArray.remove(configList.get(0));
                } else {
                    operations = operations.replace(operationId + ",", "");
                    ((JSONObject)configList.get(0)).put("operations", (Object)operations);
                }
            }
            this.getPageCache().put(CACHE_KEY_SELECT_CONFIG, selectedArray.toJSONString());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("selected", (Object)Boolean.FALSE);
        jsonObject.put("btnId", (Object)btnId);
        this.sendToVue(jsonObject);
    }

    private void openToolDetail(Long toolId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)toolId, (String)"gai_tool");
        this.getView().returnDataToParent((Object)dynamicObject);
        this.finishSelected = false;
        this.getView().close();
    }

    public void search(SearchEnterEvent event) {
        this.resetPage();
        String text = event.getText();
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_TYPE_QFIELTER))) {
            qfilter.and(this.getTypeFilter());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_APP_QFIELTER))) {
            qfilter.and(new QFilter("app", "=", (Object)this.getPageCache().get(CACHE_KEY_APP_QFIELTER)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_KEY_GROUP_QFIELTER))) {
            qfilter.and(new QFilter("group", "=", (Object)Long.parseLong(this.getPageCache().get(CACHE_KEY_GROUP_QFIELTER))));
        }
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            QFilter keywordQfilter = new QFilter("number", "like", (Object)("%" + text + "%")).or(new QFilter("name", "like", (Object)("%" + text + "%")));
            qfilter.and(keywordQfilter);
            this.getPageCache().put(CACHE_KEY_KEYWORD_QFIELTER, keywordQfilter.toString());
        } else {
            this.getPageCache().remove(CACHE_KEY_KEYWORD_QFIELTER);
        }
        JSONArray selectedToolConfig = null;
        if (null != this.getPageCache().get(CACHE_KEY_SELECT_CONFIG)) {
            selectedToolConfig = JSONArray.parseArray((String)this.getPageCache().get(CACHE_KEY_SELECT_CONFIG));
        }
        JSONArray jsonArray = this.buildEntryData(qfilter, selectedToolConfig);
        this.sendToVue(jsonArray);
    }
}

