/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool.list;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.plugin.agent.tool.list.IToolCardListListener;
import kd.ai.gai.plugin.agent.tool.list.ToolCardListConfig;
import kd.ai.gai.plugin.agent.tool.list.ToolRadioButtonAp;
import kd.ai.gai.plugin.agent.tool.list.ToolRadioButtonGroup;
import kd.ai.gai.plugin.common.FormPulginUtil;
import kd.ai.gai.plugin.control.RadioButtonAp;
import kd.ai.gai.plugin.list.RadioButtonFilterEvent;
import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ActiveViewEvent;
import kd.bos.form.control.events.ActiveViewListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.QueryExceedMaxCountEvent;
import kd.bos.list.events.QueryExceedMaxCountListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class GaiToolCardListPlugin
extends AbstractListPlugin
implements ActiveViewListener,
SearchEnterListener,
QueryExceedMaxCountListener,
PagerClickListener {
    private IToolCardListListener iCardListListener;
    private static final Log logger = LogFactory.getLog(GaiToolCardListPlugin.class);
    private static final String CUSTOM_EVENT_CHECK_GROUP = "check_tool_group";
    private static final String CardMode_MoreGroupFilter = "CardMode_MoreGroupFilter";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    private IToolCardListListener getCardListListener() {
        if (this.iCardListListener != null) {
            return this.iCardListListener;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof IToolCardListListener)) continue;
            this.iCardListListener = (IToolCardListListener)plugin;
            break;
        }
        return this.iCardListListener;
    }

    private IToolCardListListener getCardListListener(ListShowParameter listShowParameter) {
        List pluginList = listShowParameter.getFormConfig().getPlugins();
        for (Plugin plugin : pluginList) {
            try {
                Class<?> clazz = Class.forName(plugin.getClassName());
                if (!IToolCardListListener.class.isAssignableFrom(clazz)) continue;
                IToolCardListListener listener = (IToolCardListListener)TypesContainer.createInstance(clazz);
                return listener;
            }
            catch (ClassNotFoundException ex) {
                logger.error((Throwable)ex);
            }
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        CustomControl control = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("formId", formId);
        control.setData(data);
    }

    private ToolCardListConfig getDefaultConfig() {
        ToolCardListConfig cardListConfig = new ToolCardListConfig();
        cardListConfig.setBarItems(new ArrayList<BarItemAp>());
        cardListConfig.setFilterRadioButtonGroup(new ToolRadioButtonGroup());
        cardListConfig.setToolGroupButtonGroup(new ToolRadioButtonGroup());
        return cardListConfig;
    }

    private ToolCardListConfig getCardListConfig() {
        String sConfig = this.getPageCache().get("CardListConfig");
        if (StringUtils.isNotEmpty((String)sConfig)) {
            return (ToolCardListConfig)JSON.parseObject((String)sConfig, ToolCardListConfig.class);
        }
        ToolCardListConfig cardListConfig = this.getDefaultConfig();
        cardListConfig.setTitle(this.getView().getFormShowParameter().getFormConfig().getCaption());
        IToolCardListListener iCardListListener = this.getCardListListener();
        if (iCardListListener != null) {
            iCardListListener.onInitCardListConfig(cardListConfig);
        }
        this.setCardListConfig(cardListConfig);
        return cardListConfig;
    }

    private void setCardListConfig(ToolCardListConfig config) {
        this.getPageCache().put("CardListConfig", JSON.toJSONString((Object)config));
    }

    private ToolCardListConfig getCardListConfig(ListShowParameter listShowParameter) {
        ToolCardListConfig cardListConfig = this.getDefaultConfig();
        cardListConfig.setTitle(listShowParameter.getFormConfig().getCaption());
        IToolCardListListener iCardListListener = this.getCardListListener(listShowParameter);
        if (iCardListListener != null) {
            iCardListListener.onInitCardListConfig(cardListConfig);
        }
        return cardListConfig;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getControl("billlistap");
        list.addActiveViewListener((ActiveViewListener)this);
        list.addQueryExceedMaxCountListener((QueryExceedMaxCountListener)this);
        list.addPagerClickListener((PagerClickListener)this);
        Search search = (Search)this.getView().getControl("card_searchap");
        search.addEnterListener((SearchEnterListener)this);
        ToolCardListConfig config = this.getCardListConfig();
        ArrayList<String> filterBtnKeys = new ArrayList<String>(0);
        List<ToolRadioButtonAp> radioButtonApList = config.getFilterRadioButtonGroup().getButtonApList();
        for (RadioButtonAp radioButtonAp : radioButtonApList) {
            filterBtnKeys.add(radioButtonAp.getKey());
        }
        this.addClickListeners(filterBtnKeys.toArray(new String[0]));
        ArrayList<String> toolGroupFilterBtnKeys = new ArrayList<String>(0);
        List<ToolRadioButtonAp> list2 = config.getToolGroupButtonGroup().getButtonApList();
        for (RadioButtonAp radioButtonAp : list2) {
            toolGroupFilterBtnKeys.add(radioButtonAp.getKey());
        }
        this.addClickListeners(toolGroupFilterBtnKeys.toArray(new String[0]));
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        ToolCardListConfig config = this.getCardListConfig((ListShowParameter)e.getSource());
        HashMap<String, String> mapTitle = new HashMap<String, String>();
        mapTitle.put("id", "card_lbl_title");
        mapTitle.put("caption", (String)config.getTitle());
        e.getItems().add(mapTitle);
        ToolbarAp toolbarAp = new ToolbarAp();
        toolbarAp.setId("mytoolbarap");
        toolbarAp.setKey("mytoolbarap");
        List<BarItemAp> barItemApList = config.getBarItems();
        for (BarItemAp barItemAp : barItemApList) {
            toolbarAp.getItems().add(barItemAp);
        }
        HashMap<String, String> mapToolBar = new HashMap<String, String>();
        mapToolBar.put("id", "card_toolbarap");
        mapToolBar.put("items", (String)toolbarAp.createControl().get("items"));
        e.getItems().add(mapToolBar);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setId("myflexpanelap");
        flexPanelAp.setKey("myflexpanelap");
        List<ToolRadioButtonAp> radioButtonApList = config.getFilterRadioButtonGroup().getButtonApList();
        for (RadioButtonAp radioButtonAp : radioButtonApList) {
            flexPanelAp.getItems().add(radioButtonAp);
        }
        HashMap<String, String> mapfilterButton = new HashMap<String, String>();
        mapfilterButton.put("id", "card_filterbtn_container");
        mapfilterButton.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(mapfilterButton);
        List<ToolRadioButtonAp> list = config.getToolGroupButtonGroup().getButtonApList();
        ArrayList<Map> items = new ArrayList<Map>(0);
        for (RadioButtonAp radioButtonAp : list) {
            items.add(radioButtonAp.createControl());
        }
        HashMap<String, Object> groupfilterButton = new HashMap<String, Object>();
        groupfilterButton.put("id", "groupflexap");
        groupfilterButton.put("items", items);
        e.getItems().add(groupfilterButton);
    }

    public void onGetControl(OnGetControlArgs e) {
        ToolRadioButtonAp toolGroupButtonAp;
        ToolRadioButtonAp radioButtonAp;
        super.onGetControl(e);
        ToolCardListConfig config = this.getCardListConfig();
        BarItemAp barItemAp = config.getBarItem(e.getKey());
        if (barItemAp != null) {
            Button button = new Button();
            button.setKey(barItemAp.getKey());
            button.setOperationKey(barItemAp.getOperationKey());
            button.addItemClickListener((ItemClickListener)this);
            button.setView(this.getView());
            e.setControl((Control)button);
        }
        if ((radioButtonAp = config.getRadioButton(e.getKey())) != null) {
            Button button = new Button();
            button.setKey(radioButtonAp.getKey());
            button.setOperationKey(radioButtonAp.getOperationKey());
            button.setView(this.getView());
            e.setControl((Control)button);
        }
        if ((toolGroupButtonAp = config.getToolGroupButton(e.getKey())) != null) {
            Button button = new Button();
            button.setKey(toolGroupButtonAp.getKey());
            button.setOperationKey(toolGroupButtonAp.getOperationKey());
            button.setView(this.getView());
            e.setControl((Control)button);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getCurrentListMode() == null) {
            BillList list = (BillList)this.getControl("billlistap");
            if (list.getDefaultView() != null && list.getDefaultView().equals("gridview")) {
                this.switchListMode(ListMode.List);
            } else {
                this.switchListMode(ListMode.Card);
            }
        }
    }

    public void click(EventObject evt) {
        ToolRadioButtonAp toolGroupButtonAp;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        ToolCardListConfig config = this.getCardListConfig();
        ToolRadioButtonAp radioButtonAp = config.getRadioButton(key);
        if (radioButtonAp != null) {
            List<ToolRadioButtonAp> radioButtonApList = config.getFilterRadioButtonGroup().getButtonApList();
            config.getFilterRadioButtonGroup().setCurrentCheckButtonKey(radioButtonAp.getKey(), radioButtonApList);
            this.setCardListConfig(config);
            this.setCardFilter();
            BillList list = (BillList)this.getControl("billlistap");
            list.setOrderBy("createtime desc");
            list.refresh();
            ToolRadioButtonGroup radioButtonGroup = config.getFilterRadioButtonGroup();
            config.getFilterRadioButtonGroup().updateControlMetadata(this.getView(), radioButtonGroup);
        }
        if ((toolGroupButtonAp = config.getToolGroupButton(key)) != null) {
            List<ToolRadioButtonAp> radioButtonApList = config.getToolGroupButtonGroup().getButtonApList();
            config.getToolGroupButtonGroup().setCurrentCheckButtonKey(toolGroupButtonAp.getKey(), radioButtonApList);
            this.setCardListConfig(config);
            this.setCardFilter();
            BillList list = (BillList)this.getControl("billlistap");
            list.setOrderBy("createtime desc");
            list.refresh();
            ToolRadioButtonGroup radioButtonGroup = config.getToolGroupButtonGroup();
            config.getToolGroupButtonGroup().updateControlMetadata(this.getView(), radioButtonGroup);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        if (StringUtils.isNotEmpty((String)searchEnterEvent.getText())) {
            QFilter qFilter = QFilter.ftlike((String)searchEnterEvent.getText(), (String[])searchEnterEvent.getFieldNames().toArray(new String[0]));
            this.getPageCache().put("CardMode_QuickSearchFilter", qFilter.toSerializedString());
        } else {
            this.getPageCache().remove("CardMode_QuickSearchFilter");
        }
        this.setCardFilter();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("createtime desc");
        list.refresh();
    }

    public void activeView(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getView().equals("gridview")) {
            this.switchListMode(ListMode.List);
        } else {
            this.switchListMode(ListMode.Card);
        }
    }

    private ListMode getCurrentListMode() {
        String curListMode = this.getPageCache().get("ListMode");
        if (StringUtils.isNotEmpty((String)curListMode)) {
            return ListMode.valueOf(curListMode);
        }
        return null;
    }

    private void setCurrentListMode(ListMode listMode) {
        this.getPageCache().put("ListMode", listMode.name());
    }

    private void switchListMode(ListMode listMode) {
        ListMode curMode = this.getCurrentListMode();
        if (curMode != null && curMode == listMode) {
            return;
        }
        this.setCurrentListMode(listMode);
        switch (listMode) {
            case List: {
                ListView listView = (ListView)this.getView();
                String billFormId = listView.getBillFormId();
                if (GaiFormIdEnum.GAI_TOOL.getId().equalsIgnoreCase(billFormId)) {
                    ListShowParameter lsp = new ListShowParameter();
                    lsp.setBillFormId(billFormId);
                    lsp.setFormId("bos_templatetreelist");
                    lsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                this.setListModePageInfo(curMode == null);
                this.setListModeStyle();
                break;
            }
            case Card: {
                this.setCardFilter();
                this.setCardModePageInfo(curMode == null);
                this.setCardModeStyle();
            }
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("createtime desc");
        list.refresh();
    }

    private void setCardModePageInfo(boolean bFirstLoad) {
        BillList list = (BillList)this.getControl("billlistap");
        int pageRow = 12;
        int pageIndex = 1;
        if (!bFirstLoad) {
            this.getPageCache().put("List-pageIndex", String.valueOf(list.getEntryState().getCurrentPageIndex()));
            this.getPageCache().put("List-pageRow", String.valueOf(list.getEntryState().getPageRows()));
            if (this.getPageCache().get("Card-pageIndex") != null) {
                pageIndex = Integer.parseInt(this.getPageCache().get("Card-pageIndex"));
                pageRow = Integer.parseInt(this.getPageCache().get("Card-pageRow"));
            }
        }
        list.getEntryState().setPageRows(pageRow);
        list.getEntryState().setCurrentPageIndex(Integer.valueOf(pageIndex));
    }

    private void setListModePageInfo(boolean bFirstLoad) {
        BillList list = (BillList)this.getControl("billlistap");
        int pageRow = 10;
        int pageIndex = 1;
        if (bFirstLoad) {
            pageRow = list.getEntryState().getPageRows();
        } else {
            this.getPageCache().put("Card-pageIndex", String.valueOf(list.getEntryState().getCurrentPageIndex()));
            this.getPageCache().put("Card-pageRow", String.valueOf(list.getEntryState().getPageRows()));
            if (this.getPageCache().get("List-pageIndex") != null) {
                pageIndex = Integer.parseInt(this.getPageCache().get("List-pageIndex"));
                pageRow = Integer.parseInt(this.getPageCache().get("List-pageRow"));
            }
        }
        list.getEntryState().setPageRows(pageRow);
        list.getEntryState().setCurrentPageIndex(Integer.valueOf(pageIndex));
    }

    private void setListModeStyle() {
        StringBuilder sbStyle = new StringBuilder();
        sbStyle.append("${ background-color: #E2E7EF; }");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_container_all", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${ display:none; }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_card_header", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${}");
        FormPulginUtil.setCustomStyle(this.getView(), "flexpanelap", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${}");
        FormPulginUtil.setCustomStyle(this.getView(), "billlistap", sbStyle.toString());
    }

    private void setCardModeStyle() {
        StringBuilder sbStyle = new StringBuilder();
        sbStyle.append("${ background-image: linear-gradient(180deg, var(--theme-color-level3) 0%, #FFFFFF 50%); }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_container_all", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${}");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_card_header", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${ display:none; }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "flexpanelap", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("$+div{ margin-top:-8px; margin-right:54px;}\n");
        sbStyle.append("$ { margin-left: 28px;\nmargin-right: 40px; }\n");
        sbStyle.append("$ div.x-Dtok1y>div { background-color: transparent!important; }\n");
        sbStyle.append("$ div.x-Dtok1y>div._17unDfqU { height: 100%; }\n");
        sbStyle.append("$ div.x-Dtok1y>div._17unDfqU>div { height: 100%; }\n");
        sbStyle.append("$ div#view-container {  height: 100%; }\n");
        sbStyle.append("$ div.x-Dtok1y>div.oCkmDxX5 > div:first-of-type { visibility: hidden; }\n");
        sbStyle.append("$ .x-Dtok1y:last-of-type { flex-direction: column-reverse; }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "billlistap", sbStyle.toString());
    }

    public void queryExceedMaxCount(QueryExceedMaxCountEvent queryExceedMaxCountEvent) {
        this.setCardFilter();
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        this.setCardFilter();
    }

    private void setCardFilter() {
        String moreGroupFilterString;
        ToolRadioButtonAp currentCheckBtn;
        if (this.getCurrentListMode() != ListMode.Card) {
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.getQueryFilterParameter().getQFilters().clear();
        String quickSearchFilterString = this.getPageCache().get("CardMode_QuickSearchFilter");
        if (StringUtils.isNotEmpty((String)quickSearchFilterString)) {
            QFilter quickSearchFilter = QFilter.fromSerializedString((String)quickSearchFilterString);
            list.getQueryFilterParameter().getQFilters().add(quickSearchFilter);
        }
        list.getClientQueryFilterParameter().getQFilters().clear();
        ToolCardListConfig config = this.getCardListConfig();
        RadioButtonFilterEvent radioButtonFilterEvent = new RadioButtonFilterEvent((Object)config.getRadioButton(config.getFilterRadioButtonGroup().getCurrentCheckButtonKey()));
        radioButtonFilterEvent.setFilters(new ArrayList<QFilter>());
        radioButtonFilterEvent.setCurrentCheckKey(config.getFilterRadioButtonGroup().getCurrentCheckButtonKey());
        this.getCardListListener().onRadioButtonCheckFilter(radioButtonFilterEvent);
        if (!radioButtonFilterEvent.getFilters().isEmpty()) {
            list.getClientQueryFilterParameter().getQFilters().addAll(radioButtonFilterEvent.getFilters());
        }
        if ((currentCheckBtn = config.getToolGroupButton(config.getToolGroupButtonGroup().getCurrentCheckButtonKey())) != null) {
            RadioButtonFilterEvent toolGroupButtonFilterEvent = new RadioButtonFilterEvent((Object)currentCheckBtn);
            toolGroupButtonFilterEvent.setFilters(new ArrayList<QFilter>());
            toolGroupButtonFilterEvent.setCurrentCheckKey(config.getToolGroupButtonGroup().getCurrentCheckButtonKey());
            if ("allgroup".equalsIgnoreCase(config.getToolGroupButtonGroup().getCurrentCheckButtonKey())) {
                this.getPageCache().remove(CardMode_MoreGroupFilter);
            }
            this.getCardListListener().onRadioButtonCheckFilter(toolGroupButtonFilterEvent);
            if (!toolGroupButtonFilterEvent.getFilters().isEmpty()) {
                list.getClientQueryFilterParameter().getQFilters().addAll(toolGroupButtonFilterEvent.getFilters());
            }
        }
        if (!StringUtils.isEmpty((String)(moreGroupFilterString = this.getPageCache().get(CardMode_MoreGroupFilter)))) {
            QFilter groupFilter = new QFilter("group", "=", (Object)Long.parseLong(moreGroupFilterString));
            list.getClientQueryFilterParameter().getQFilters().add(groupFilter);
        }
    }

    private void switchFilterButton(String currentToolTypeKey, ToolCardListConfig config) {
        if ("radio_btn_mcp".equalsIgnoreCase(currentToolTypeKey) || "radio_btn_restful_api".equalsIgnoreCase(currentToolTypeKey)) {
            this.getPageCache().remove(CardMode_MoreGroupFilter);
            ToolRadioButtonAp allGroupBtn = config.getToolGroupButton("allgroup");
            config.getToolGroupButtonGroup().setCurrentCheckButtonKey(allGroupBtn.getKey(), config.getToolGroupButtonGroup().getButtonApList());
            config.getToolGroupButtonGroup().getButtonApList().stream().forEach(item -> FormPulginUtil.setCustomStyle(this.getView(), item.getKey(), item.getCustomeStyles()));
            ToolRadioButtonGroup radioButtonGroup = config.getToolGroupButtonGroup();
            config.getToolGroupButtonGroup().updateControlMetadata(this.getView(), radioButtonGroup);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String groupKey = evt.getEventArgs();
        switch (eventName) {
            case "check_tool_group": {
                this.filterByMoreGroup(groupKey);
                break;
            }
        }
    }

    private void filterByMoreGroup(String groupKey) {
        this.getPageCache().put(CardMode_MoreGroupFilter, groupKey);
        ToolCardListConfig config = this.getCardListConfig();
        if (config != null) {
            config.getToolGroupButtonGroup().setCurrentCheckButtonKey(null);
            this.getCardListListener().onClearCheckButton();
            ToolRadioButtonGroup radioButtonGroup = config.getToolGroupButtonGroup();
            List<ToolRadioButtonAp> toolGroupButtonList = radioButtonGroup.getButtonApList();
            for (ToolRadioButtonAp item : toolGroupButtonList) {
                item.setChecked(false);
            }
            radioButtonGroup.updateControlMetadata(this.getView(), radioButtonGroup);
            this.setCardListConfig(config);
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("createtime desc");
        this.setCardFilter();
        list.refresh();
    }

    private static enum ListMode {
        List,
        Card;

    }
}

