/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.card;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.SystemAgentEnum;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.plugin.card.action.ShowBillAction;
import kd.ai.gai.plugin.common.FormPulginUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class GaiCardCosmicPlugin
extends AbstractFormPlugin
implements ItemClickListener,
RowClickEventListener,
ClickListener,
HyperLinkClickListener,
ListRowClickListener {
    private static final String KEY_BUTTON_COSMIC = "btncosmic";
    private static final String KEY_FLEX_AGENTLIST = "flex_agentlist";
    private static final String KEY_VECT_LIST = "vect_list";
    private static final String KEY_VECT_CARD = "vect_card";
    private static final String KEY_BUTTONAP = "buttonap";
    private static final String KEY_ASS = "open_ass";
    private static final String KEY_CARDENTRYROWAP = "cardentryrowap";
    private static final String KEY_LABEL_AGENTLIST_TITLE = "lbl_agentlist_title";
    private static final String KEY_LABEL_ASSLIST_TITLE = "lbl_asslist_title";
    private static final String KEY_BTN_ADDASSISTANT = "btn_addassistant";
    private static final String KEY_VECTOR_BTN_ADDASSISTANT = "vector_btn_addassistant";
    private static final String KEY_FLEX_BTN_ADDASSISTANT = "flex_btn_addassistant";
    private static final String KEY_BTN_ADDAGENT = "btn_addagent";
    private static final String KEY_FLEX_ADDAGENT = "flex_addagent";
    private static final String KEY_VECTOR_ADDAGENT = "vector_addagent";
    private static final String KEY_LBL_ADDGENT = "lbl_addgent";
    private static final String KEY_LBL_ADDPROCESS = "lbl_addprocess";
    private static final String KEY_AGENTLIST = "agentlist";
    private static final String KEY_AGENTID = "agentid";
    private static final String KEY_PICTURE = "picture";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_SKILLTYPE = "skilltype";
    private static final String KEY_TYPE = "type";
    private static final String KEY_MODIFIER = "modifier";
    private static final String KEY_MODIFYTIME = "modifytime";
    private static final String KEY_AGENTCARDLIST = "agentcardlist";
    private static final String KEY_ASS_CARDLIST = "agentcardlist";
    private static final String KEY_CARD_AGENTID = "card_agentid";
    private static final String KEY_CARD_PICTURE = "card_picture";
    private static final String KEY_CARD_NUMBER = "card_number";
    private static final String KEY_CARD_NAME = "card_name";
    private static final String KEY_CARD_DESCRIPTION = "card_description";
    private static final String KEY_CARD_SKILLTYPE = "card_skilltype";
    private static final String KEY_CARD_PLUGIN = "card_plugin";
    private static final String KEY_CARD_OPERATION = "card_operation";
    private static final String KEY_CARD_PROMPT = "card_prompt";
    private static final String KEY_CARD_KNOWLEDGE = "card_knowledge";
    private static final String KEY_IMAGEAPCANGQIONG = "imageapcangqiong";
    private static final String CacheKey_LISTMODE = "listmode";
    private static final String KEY_PROCESS_FLOWSTR = "flow";
    private List<CosmicSkill> cosmicSkillList;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BUTTON_COSMIC, KEY_VECT_LIST, KEY_VECT_CARD, KEY_ASS, KEY_BUTTONAP, KEY_BTN_ADDASSISTANT, KEY_VECTOR_BTN_ADDASSISTANT, KEY_FLEX_BTN_ADDASSISTANT, KEY_LBL_ADDGENT, KEY_LBL_ADDPROCESS});
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_AGENTLIST);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BillList billList = (BillList)this.getControl("billlistap_ass");
        billList.addRowClickListener((RowClickEventListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addClickListener((ClickListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (!((BillList)evt.getSource()).getSelectedRows().isEmpty()) {
            long ass_pkId = (Long)((BillList)evt.getSource()).getSelectedRows().get(0).getPrimaryKeyValue();
            this.loadAgentCardList(ass_pkId);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (hyperLinkClickEvent.getFieldName().equals(KEY_NUMBER)) {
            this.showSelectedSkillinfo(ListMode.List);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btncosmic": {
                this.showSelectedAssInfo();
                break;
            }
            case "vect_list": {
                this.switchAgentListMode(ListMode.List);
                break;
            }
            case "vect_card": {
                this.switchAgentListMode(ListMode.Card);
                break;
            }
            case "buttonap": {
                this.showSelectedSkillinfo(ListMode.Card);
                break;
            }
        }
    }

    private void showSelectedSkillinfo(ListMode listMode) {
        String type;
        Long agentId = 0L;
        if (listMode == ListMode.Card) {
            CardEntry cardEntry = (CardEntry)this.getControl("agentcardlist");
            int[] selRowIndex = cardEntry.getSelectRows();
            if (selRowIndex.length == 0) {
                return;
            }
            agentId = cardEntry.getEntryData().getDataEntitys()[selRowIndex[0]].getLong(KEY_CARD_AGENTID);
            type = cardEntry.getEntryData().getDataEntitys()[selRowIndex[0]].getString(KEY_CARD_SKILLTYPE);
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_AGENTLIST);
            int[] selRowIndex = entryGrid.getSelectRows();
            if (selRowIndex.length == 0) {
                return;
            }
            agentId = entryGrid.getEntryData().getDataEntitys()[selRowIndex[0]].getLong(KEY_AGENTID);
            type = entryGrid.getEntryData().getDataEntitys()[selRowIndex[0]].getString(KEY_SKILLTYPE);
        }
        if (agentId == 0L) {
            return;
        }
        if (type.equals(Skill.Type.AGENT.toString())) {
            new ShowBillAction(GaiFormIdEnum.GAI_AGENT.getId(), ShowType.MainNewTabPage, agentId, OperationStatus.EDIT).operate(this.getView());
        } else {
            new ShowBillAction("gai_process", ShowType.MainNewTabPage, agentId, OperationStatus.EDIT).operate(this.getView());
        }
    }

    private void showSelectedAssInfo() {
        BillList billList = (BillList)this.getControl("billlistap_ass");
        Object pkId = billList.getSelectedRows().get(0).getPrimaryKeyValue();
        Assistant assistant = AssistantService.getOne((long)((Long)pkId));
        if (assistant != null) {
            new ShowBillAction("gai_gpt_assistant_config", ShowType.MainNewTabPage, pkId, OperationStatus.EDIT, assistant.getName()).operate(this.getView());
        }
    }

    private void switchAgentListMode(ListMode newMode) {
        ListMode oldMode = this.getListMode();
        if (oldMode != newMode) {
            this.setListMode(newMode);
            boolean bListMode = newMode == ListMode.List;
            boolean bCardMode = newMode == ListMode.Card;
            this.getView().setVisible(Boolean.valueOf(bListMode), new String[]{KEY_AGENTLIST});
            this.getView().setVisible(Boolean.valueOf(bCardMode), new String[]{"agentcardlist"});
            FormPulginUtil.setForeColor(this.getView(), KEY_VECT_LIST, bListMode ? Color.decode(this.getThemeColor()) : Color.decode("#999999"));
            FormPulginUtil.setForeColor(this.getView(), KEY_VECT_CARD, bCardMode ? Color.decode(this.getThemeColor()) : Color.decode("#999999"));
        }
    }

    public String getThemeColor() {
        Map map = UserServiceHelper.getUserThemeNumAndVerNew((Long)RequestContext.get().getCurrUserId());
        return (String)map.get("color");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshData();
        this.switchAgentListMode(ListMode.Card);
        BillList billList = (BillList)this.getControl("billlistap_ass");
        if (billList.getCurrentListAllRowCollection() != null) {
            billList.entryRowClick(Integer.valueOf(0));
            billList.selectRows(0);
            int size = billList.getCurrentListAllRowCollection().size();
            ((Label)this.getControl(KEY_LABEL_ASSLIST_TITLE)).setText("\u52a9\u624b\u5217\u8868\uff0c\u5171" + size + "\u4e2a");
        }
    }

    public void customEvent(CustomEventArgs e) {
        if (e.getKey().equals("refreshFromGridContainer")) {
            this.forceRefreshData();
        }
    }

    private void forceRefreshData() {
        this.cosmicSkillList = null;
        this.refreshData();
    }

    private void refreshData() {
        BillList billList = (BillList)this.getControl("billlistap_ass");
        billList.refreshData();
        billList.entryRowClick(Integer.valueOf(0));
        billList.selectRows(0);
    }

    private void loadAgentCardList(long assId) {
        List<CosmicSkill> cosmicSkillList = this.getCosmicSkillList(assId);
        this.getModel().deleteEntryData("agentcardlist");
        if (!cosmicSkillList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("agentcardlist", cosmicSkillList.size());
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("agentcardlist");
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get("agentcardlist");
        rows.clear();
        for (int i = 0; i < cosmicSkillList.size(); ++i) {
            CosmicSkill cosmicSkill = cosmicSkillList.get(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(KEY_CARD_AGENTID, (Object)cosmicSkill.getSkill().getId());
            String picUrl = cosmicSkill.getSkill().getPicture();
            if (StringUtils.isEmpty((CharSequence)picUrl)) {
                picUrl = this.getHost() + SystemAgentEnum.COMMON_AGENT.getPicture();
            }
            row.set(KEY_CARD_PICTURE, (Object)picUrl);
            row.set(KEY_CARD_NAME, (Object)cosmicSkill.getSkill().getName());
            row.set(KEY_CARD_DESCRIPTION, (Object)cosmicSkill.getSkill().getServiceDes());
            row.set(KEY_CARD_SKILLTYPE, (Object)cosmicSkill.getSkill().getType());
            row.set(KEY_CARD_PLUGIN, (Object)cosmicSkill.getToolCount());
            row.set(KEY_CARD_PROMPT, (Object)cosmicSkill.getPromptCount());
            row.set(KEY_CARD_KNOWLEDGE, (Object)cosmicSkill.getRepoCount());
            row.set(KEY_CARD_OPERATION, (Object)cosmicSkill.getOperationCount());
            rows.add((Object)row);
        }
        this.getModel().updateEntryCache(rows);
        this.getView().updateView("agentcardlist");
    }

    private String getHost() {
        String host = RequestContext.get().getClientFullContextPath();
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    private void setListMode(ListMode listMode) {
        this.getPageCache().put(CacheKey_LISTMODE, listMode.name());
    }

    private ListMode getListMode() {
        String sCacheValue = this.getPageCache().get(CacheKey_LISTMODE);
        if (StringUtils.isEmpty((CharSequence)sCacheValue)) {
            this.setListMode(ListMode.List);
            return ListMode.List;
        }
        return ListMode.valueOf(sCacheValue);
    }

    private void loadAgentList() {
        List<CosmicSkill> cosmicSkillList = this.getCosmicSkillList(10000L);
        this.getModel().deleteEntryData(KEY_AGENTLIST);
        if (!cosmicSkillList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_AGENTLIST, cosmicSkillList.size());
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_AGENTLIST);
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_AGENTLIST);
        rows.clear();
        for (CosmicSkill cosmicSkill : cosmicSkillList) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(KEY_AGENTID, (Object)cosmicSkill.getSkill().getId());
            String picUrl = cosmicSkill.getSkill().getPicture();
            if (StringUtils.isEmpty((CharSequence)picUrl)) {
                picUrl = this.getHost() + SystemAgentEnum.COMMON_AGENT.getPicture();
            }
            row.set(KEY_PICTURE, (Object)picUrl);
            row.set(KEY_NUMBER, (Object)cosmicSkill.getSkill().getNumber());
            row.set(KEY_NAME, (Object)cosmicSkill.getSkill().getName());
            row.set(KEY_DESCRIPTION, (Object)cosmicSkill.getSkill().getServiceDes());
            row.set(KEY_SKILLTYPE, (Object)cosmicSkill.getSkill().getType());
            rows.add((Object)row);
        }
        this.getModel().updateEntryCache(rows);
        this.getView().updateView(KEY_AGENTLIST);
    }

    private List<CosmicSkill> getCosmicSkillList(long assistantId) {
        if (this.cosmicSkillList != null) {
            return this.cosmicSkillList;
        }
        this.cosmicSkillList = new ArrayList<CosmicSkill>(10);
        List skillList = SkillService.getList((long)assistantId, null, null);
        if (skillList == null || skillList.isEmpty()) {
            this.cosmicSkillList = Collections.emptyList();
            return this.cosmicSkillList;
        }
        this.cosmicSkillList = this.convertSkillListToCosmicSkillList(skillList);
        return this.cosmicSkillList;
    }

    private Map<Long, Agent> getAgentMap(List<Skill> skillList) {
        ArrayList<Long> agentSkillIdList = new ArrayList<Long>(skillList.size());
        for (Skill skill : skillList) {
            if (skill.getType() != Skill.Type.AGENT) continue;
            agentSkillIdList.add(Long.parseLong(skill.getId()));
        }
        List<Agent> agentList = this.getAgentList(agentSkillIdList);
        HashMap<Long, Agent> mapAgent = new HashMap<Long, Agent>(agentList.size());
        ListIterator<Agent> listIterator = agentList.listIterator();
        while (listIterator.hasNext()) {
            Agent agent = listIterator.next();
            mapAgent.put(agent.getAgentId(), agent);
        }
        return mapAgent;
    }

    private List<Agent> getAgentList(List<Long> agentIdList) {
        PageQuery query = new PageQuery();
        query.setPageSize(Integer.valueOf(-1));
        query.setIdList(agentIdList);
        PageResult agentPageResult = AgentService.getAgentPage((PageQuery)query);
        List agentList = Collections.emptyList();
        if (agentPageResult.getList() != null) {
            agentList = agentPageResult.getList();
        }
        return agentList;
    }

    private List<CosmicSkill> getProcessCosmicSkill(List<Skill> skillList) {
        List processSkillList = skillList.stream().filter(skill -> skill.getType() == Skill.Type.PROCESS).collect(Collectors.toList());
        ArrayList<Long> processSkillIdList = new ArrayList<Long>(processSkillList.size());
        for (Skill skill2 : processSkillList) {
            processSkillIdList.add(Long.parseLong(skill2.getId()));
        }
        if (processSkillIdList.isEmpty()) {
            return Collections.emptyList();
        }
        String sSelectFields = String.format("%s,%s", "id", KEY_PROCESS_FLOWSTR);
        Map processMap = BusinessDataServiceHelper.loadFromCache((String)"gai_process", (String)sSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)processSkillIdList.toArray())});
        ArrayList<CosmicSkill> cosmicSkills = new ArrayList<CosmicSkill>(processSkillList.size());
        ListIterator skillListIterator = processSkillList.listIterator();
        while (skillListIterator.hasNext()) {
            String sFlow;
            Skill skill3 = (Skill)skillListIterator.next();
            CosmicSkill cosmicSkill = new CosmicSkill(skill3);
            DynamicObject process = processMap.getOrDefault(Long.parseLong(skill3.getId()), null);
            if (process != null && StringUtils.isNotEmpty((CharSequence)(sFlow = process.getString(KEY_PROCESS_FLOWSTR)))) {
                Flow flow = JsonUtil.fromBase64String((String)sFlow);
                List actions = flow.getActions();
                int promptCount = 0;
                int operationCount = 0;
                for (Action action : actions) {
                    if (action instanceof JavaPluginAction) {
                        ++operationCount;
                    }
                    if (!(action instanceof LLMAction)) continue;
                    ++promptCount;
                }
                cosmicSkill.setPromptCount(promptCount);
                cosmicSkill.setOperationCount(operationCount);
            }
            cosmicSkills.add(cosmicSkill);
        }
        return cosmicSkills;
    }

    private List<CosmicSkill> getAgentCosmicSkill(List<Skill> skillList) {
        List<Skill> agentSkillList = skillList.stream().filter(skill -> skill.getType() == Skill.Type.AGENT).collect(Collectors.toList());
        Map<Long, Agent> mapAgent = this.getAgentMap(agentSkillList);
        ArrayList<CosmicSkill> cosmicSkillList = new ArrayList<CosmicSkill>(agentSkillList.size());
        ListIterator<Skill> skillListIterator = agentSkillList.listIterator();
        while (skillListIterator.hasNext()) {
            Skill skill2 = skillListIterator.next();
            CosmicSkill cosmicSkill = new CosmicSkill(skill2);
            Agent agent = mapAgent.getOrDefault(Long.parseLong(skill2.getId()), null);
            if (agent != null) {
                List toolList = agent.getToolList();
                int count = toolList == null ? 0 : toolList.size();
                cosmicSkill.setToolCount(count);
                List promptList = agent.getPromptList();
                count = promptList == null ? 0 : promptList.size();
                cosmicSkill.setPromptCount(count);
                List repoList = agent.getRepoList();
                count = repoList == null ? 0 : repoList.size();
                cosmicSkill.setRepoCount(count);
            }
            cosmicSkillList.add(cosmicSkill);
        }
        return cosmicSkillList;
    }

    private List<CosmicSkill> convertSkillListToCosmicSkillList(List<Skill> skillList) {
        if (skillList == null || skillList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CosmicSkill> allSkillList = new ArrayList<CosmicSkill>(skillList.size());
        List<CosmicSkill> agentSkillList = this.getAgentCosmicSkill(skillList);
        List<CosmicSkill> processSkillList = this.getProcessCosmicSkill(skillList);
        allSkillList.addAll(agentSkillList);
        allSkillList.addAll(processSkillList);
        allSkillList.sort(Comparator.comparingInt(skill -> skill.getSkill().getOrder()));
        return allSkillList;
    }

    private static class CosmicSkill {
        Skill skill;
        int toolCount;
        int promptCount;
        int repoCount;
        int operationCount;

        public Skill getSkill() {
            return this.skill;
        }

        public void setSkill(Skill skill) {
            this.skill = skill;
        }

        public CosmicSkill(Skill skill) {
            this.skill = skill;
        }

        public int getToolCount() {
            return this.toolCount;
        }

        public void setToolCount(int toolCount) {
            this.toolCount = toolCount;
        }

        public int getPromptCount() {
            return this.promptCount;
        }

        public void setPromptCount(int promptCount) {
            this.promptCount = promptCount;
        }

        public int getRepoCount() {
            return this.repoCount;
        }

        public void setRepoCount(int repoCount) {
            this.repoCount = repoCount;
        }

        public int getOperationCount() {
            return this.operationCount;
        }

        public void setOperationCount(int operationCount) {
            this.operationCount = operationCount;
        }
    }

    private static enum ListMode {
        List,
        Card;

    }
}

