/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.card;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.plugin.card.NavigationButtonKey;
import kd.ai.gai.plugin.card.action.NavigationAction;
import kd.ai.gai.plugin.card.action.ShowBillAction;
import kd.ai.gai.plugin.card.action.ShowFormAction;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;

class NavigationCardData {
    private static final List<NavigationCardData> navigationCardDataList = new ArrayList<NavigationCardData>(4);
    private String name;
    private String desc;
    private NavigationAction cardAction;
    private Map<NavigationButtonKey, NavigationAction> mapButtonActions;
    private Map<NavigationButtonKey, String> mapButtonNames;

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setCardAction(NavigationAction cardAction) {
        this.cardAction = cardAction;
    }

    public NavigationAction getCardAction() {
        return this.cardAction;
    }

    public NavigationCardData(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public boolean isNeedShowButton() {
        return this.mapButtonActions != null && this.mapButtonActions.size() > 0;
    }

    public void addButtonAction(NavigationButtonKey key, String buttonName, NavigationAction navigationAction) {
        if (this.mapButtonActions == null) {
            this.mapButtonActions = new HashMap<NavigationButtonKey, NavigationAction>(1);
        }
        this.mapButtonActions.put(key, navigationAction);
        if (this.mapButtonNames == null) {
            this.mapButtonNames = new HashMap<NavigationButtonKey, String>(1);
        }
        this.mapButtonNames.put(key, buttonName);
    }

    public NavigationAction getButtonAction(NavigationButtonKey key) {
        if (this.mapButtonActions == null) {
            return null;
        }
        return this.mapButtonActions.getOrDefault((Object)key, null);
    }

    public Map<NavigationButtonKey, NavigationAction> getAllButtonActions() {
        return this.mapButtonActions;
    }

    public String getButtonName(NavigationButtonKey key) {
        if (this.mapButtonNames == null) {
            return "";
        }
        return this.mapButtonNames.getOrDefault((Object)key, "");
    }

    public static List<NavigationCardData> getNavigationCardDataList() {
        if (!navigationCardDataList.isEmpty()) {
            return navigationCardDataList;
        }
        NavigationCardData cardData = new NavigationCardData("Assistant Builder", ResManager.loadKDString((String)"\u65b0\u4e00\u4ee3\u667a\u80fd\u52a9\u624b\u5f00\u53d1", (String)"GaiCardNavigationPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        cardData.addButtonAction(NavigationButtonKey.BUTTONAP_ONE, ResManager.loadKDString((String)"\u65b0\u589e\u52a9\u624b", (String)"GaiCardNavigationPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]), new ShowBillAction(GaiFormIdEnum.GAI_ASS.getId(), ShowType.MainNewTabPage));
        navigationCardDataList.add(cardData);
        cardData = new NavigationCardData("Agent Builder", ResManager.loadKDString((String)"\u81ea\u4e3b\u5206\u6790\u3001\u89c4\u5212\u5e76\u8c03\u7528\u5de5\u5177\uff0c\u5b8c\u6210\u590d\u6742\u4efb\u52a1", (String)"GaiCardNavigationPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
        cardData.addButtonAction(NavigationButtonKey.BUTTONAP_ONE, ResManager.loadKDString((String)"\u65b0\u589eAI\u81ea\u4e3b\u89c4\u5212", (String)"GaiCardNavigationPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]), new ShowFormAction(GaiFormIdEnum.GAI_AGENT_BASE.getId(), ShowType.Modal));
        cardData.addButtonAction(NavigationButtonKey.BUTTONAP_TWO, ResManager.loadKDString((String)"\u65b0\u589e\u4efb\u52a1\u6d41\u7f16\u6392", (String)"GaiCardNavigationPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]), new ShowBillAction("gai_process", ShowType.MainNewTabPage));
        navigationCardDataList.add(cardData);
        cardData = new NavigationCardData("Tool Builder", ResManager.loadKDString((String)"\u7075\u6d3b\u7ec4\u88c5\u5de5\u5177\u3001\u4efb\u52a1\u6d41\u53ca\u63d0\u793a\u8bcd\uff0c\u8f93\u51fa\u7a33\u5b9a\u53ef\u63a7", (String)"GaiCardNavigationPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]));
        cardData.addButtonAction(NavigationButtonKey.BUTTONAP_ONE, ResManager.loadKDString((String)"\u65b0\u589e\u5de5\u5177", (String)"GaiCardNavigationPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]), new ShowBillAction("gai_tool", ShowType.MainNewTabPage));
        cardData.addButtonAction(NavigationButtonKey.BUTTONAP_TWO, ResManager.loadKDString((String)"\u65b0\u589e\u63d0\u793a\u8bcd", (String)"GaiCardNavigationPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]), new ShowBillAction("gai_prompt", ShowType.MainNewTabPage));
        navigationCardDataList.add(cardData);
        cardData = new NavigationCardData("Model Builder", ResManager.loadKDString((String)"\u6253\u9020\u4f01\u4e1a\u81ea\u5df1\u7684\u5927\u6a21\u578b", (String)"GaiCardNavigationPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]));
        cardData.addButtonAction(NavigationButtonKey.BUTTONAP_ONE, ResManager.loadKDString((String)"\u5b9a\u5236\u5927\u6a21\u578b", (String)"GaiCardNavigationPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]), new NavigationAction(){

            @Override
            public void operate(IFormView view) {
                view.showMessage(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85", (String)"GaiCardNavigationPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), "", MessageTypes.ComingSoon);
            }
        });
        navigationCardDataList.add(cardData);
        return navigationCardDataList;
    }

    public static NavigationCardData getNavigationCardData(String name) {
        List<NavigationCardData> cardDataList = NavigationCardData.getNavigationCardDataList();
        for (NavigationCardData data : cardDataList) {
            if (!data.getName().equals(name)) continue;
            return data;
        }
        return null;
    }
}

