/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.card.action;

import java.util.List;
import java.util.Map;
import kd.ai.gai.plugin.card.action.NavigationAction;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.portal.util.OpenPageUtils;

public class OpenMenuAction
extends NavigationAction {
    private String appId;
    private String formId;
    private Long menuId = 0L;
    private Map<String, Object> customParams;

    public OpenMenuAction(String appId, String formId) {
        this.appId = appId;
        this.formId = formId;
    }

    public OpenMenuAction(String appId, Long menuId) {
        this.appId = appId;
        this.menuId = menuId;
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, Object> customParams) {
        this.customParams = customParams;
    }

    @Override
    public void operate(IFormView view) {
        String menuId = this.getMenuId();
        if (StringUtils.isEmpty((CharSequence)menuId)) {
            return;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)this.appId);
        OpenPageUtils.openMenu((IFormView)view, (String)menuId, (String)appInfo.getId(), this.customParams);
    }

    private String getMenuId() {
        if (this.menuId > 0L) {
            return this.menuId.toString();
        }
        List menulist = AppMetadataCache.getAppMenusInfoByAppId((String)this.appId);
        if (menulist == null || menulist.size() <= 0) {
            return "";
        }
        for (AppMenuInfo menu : menulist) {
            String menuFormId = menu.getFormId();
            if (menuFormId == null || !menuFormId.equals(this.formId)) continue;
            return menu.getId();
        }
        return "";
    }
}

