/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.FlowEventService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ValidateService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.form.IFormView;

public class FlowEditingContext {
    private Map<Class<?>, Object> serviceMap = new HashMap();
    private static final ThreadLocal<FlowEditingContext> current = new ThreadLocal();

    public <T> T getService(Class<T> clazz) {
        Object serviceObj;
        T service = null;
        if (this.serviceMap.containsKey(clazz) && clazz.isInstance(serviceObj = this.serviceMap.get(clazz))) {
            service = clazz.cast(serviceObj);
        }
        return service;
    }

    private void publishService(Class<?> clazz, Object serviceImpl) {
        if (!this.serviceMap.containsKey(clazz)) {
            this.serviceMap.put(clazz, serviceImpl);
        }
    }

    private FlowEditingContext() {
    }

    public static FlowEditingContext get() {
        return current.get();
    }

    public static void initContext(IFormView processView, IFormView requestView) {
        FlowEditingContext context = current.get();
        if (context == null) {
            context = new FlowEditingContext();
            ViewService viewService = new ViewService(processView, requestView);
            ModelService modelService = new ModelService(processView);
            FlowEventService eventService = new FlowEventService();
            FlowActionService actionService = new FlowActionService();
            ValidateService validateService = new ValidateService();
            context.publishService(ViewService.class, viewService);
            context.publishService(ModelService.class, modelService);
            context.publishService(FlowEventService.class, eventService);
            context.publishService(FlowActionService.class, actionService);
            context.publishService(ValidateService.class, validateService);
            current.set(context);
        }
    }

    public static void release() {
        if (current.get() != null) {
            current.remove();
        }
    }
}

