/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.FlowConfigParamHelper;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.helper.ParamReferenceHelper;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboItem;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractFlowBatchConfigPlugin<T extends BatchAction>
extends AbstractFlowConfigPlugin<T> {
    public static final ParamTreeConfig PARAM_TREE_BATCH_INPUT_CONFIG = ParamTreeConfig.createBatchInputConfig();
    public static final ParamTreeConfig PARAM_TREE_BATCH_OUTPUT_CONFIG = ParamTreeConfig.createBatchOutputConfig();
    private static final String KEY_BATCH_LIMIT = "batchlimit";
    private static final String KEY_PARALLEL_LIMIT = "parallellimit";
    private static final String KEY_MODE = "mode";
    private static final String KEY_FLEX_BATCH = "flex_batch";

    @Override
    protected void registerParamTreeConfig() {
        this.registerParamTreeConfig(PARAM_TREE_BATCH_INPUT_CONFIG, action -> "BATCH_INPUT_GROUP", action -> ParamDirection.INPUT);
        this.registerParamTreeConfig(PARAM_TREE_BATCH_OUTPUT_CONFIG, action -> "BATCH_OUTPUT_GROUP", action -> ParamDirection.OUTPUT);
        super.registerParamTreeConfig();
    }

    @Override
    public void initData() {
        super.initData();
        BatchAction batchAction = (BatchAction)this.getAction(this.getFlow());
        this.getModel().setValue(KEY_PARALLEL_LIMIT, (Object)BigDecimal.valueOf(batchAction.getParallelLimit()));
        this.getModel().setValue(KEY_BATCH_LIMIT, (Object)BigDecimal.valueOf(batchAction.getBatchLimit()));
        this.getModel().setValue(KEY_MODE, (Object)batchAction.getMode());
    }

    @Override
    protected RefrenceDataConfig getReferenceDataConfig(String entryEntityKey) {
        if (entryEntityKey.equals(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey())) {
            RefrenceDataConfig config = super.getReferenceDataConfig(entryEntityKey);
            String mode = (String)this.getModel().getValue(KEY_MODE);
            if (BatchAction.Mode.Batch.name().equals(mode)) {
                config.setIncludeSelfNode(true);
                this.addEditingParamDefs(config);
            }
            return config;
        }
        if (entryEntityKey.equals(PARAM_TREE_BATCH_INPUT_CONFIG.getEntryEntityKey())) {
            RefrenceDataConfig config = super.getReferenceDataConfig(entryEntityKey);
            ArrayList<String> paramTypes = new ArrayList<String>(8);
            for (ParamType paramType : ParamType.values()) {
                paramTypes.add(GaiFieldTypeInitUtils.buildDisplayedArrayType((ParamType)paramType));
            }
            config.setOnlyParamTypeList(paramTypes);
            return config;
        }
        return super.getReferenceDataConfig(entryEntityKey);
    }

    private void addEditingParamDefs(RefrenceDataConfig config) {
        Flow flow = this.getFlow();
        BatchAction batchAction = (BatchAction)this.getAction(flow);
        this.saveParamTreeConfig(PARAM_TREE_BATCH_INPUT_CONFIG.getEntryEntityKey(), flow, (Action)batchAction);
        List innerParams = batchAction.getParamByGroup("BATCH_INNER_GROUP");
        config.setEditingParamList(innerParams);
    }

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        List<ComboItem> list = super.getParamTypeComboItem(entryEntityKey);
        list.removeIf(item -> !item.getValue().startsWith(ParamType.ARRAY.getDesc()));
        return list;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_MODE)) {
            if (BatchAction.Mode.Single.name().equals(this.getModel().getValue(KEY_MODE))) {
                this.getModel().deleteEntryData(PARAM_TREE_BATCH_INPUT_CONFIG.getEntryEntityKey());
                this.getModel().deleteEntryData(PARAM_TREE_BATCH_OUTPUT_CONFIG.getEntryEntityKey());
            } else {
                Flow flow = this.getFlow();
                BatchAction batchAction = (BatchAction)this.getAction(flow);
                batchAction.setMode(BatchAction.Mode.Batch.name());
                this.updateBatchOutputParams(flow, batchAction);
            }
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        return super.nodeValidate(noteType, nodeId);
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        BatchAction batchAction = (BatchAction)this.getAction(flow);
        batchAction.setMode((String)this.getModel().getValue(KEY_MODE));
        BigDecimal parallelLimit_BD = (BigDecimal)this.getModel().getValue(KEY_PARALLEL_LIMIT);
        if (parallelLimit_BD != null) {
            int parallelLimit = parallelLimit_BD.intValue();
            if (parallelLimit > 10) {
                parallelLimit = 10;
            } else if (parallelLimit < 1) {
                parallelLimit = 1;
            }
            batchAction.setParallelLimit(parallelLimit);
        } else {
            log.info("\u89e3\u6790\u201c\u6700\u5927\u5e76\u884c\u8fd0\u884c\u6570\u91cf\u201d\u4e3a\u7a7a\uff0c\u5f53\u524d\u503c\u4e0d\u53d8");
        }
        BigDecimal batchLimit_BD = (BigDecimal)this.getModel().getValue(KEY_BATCH_LIMIT);
        if (batchLimit_BD != null) {
            int batchLimit = batchLimit_BD.intValue();
            batchLimit = Math.min(batchLimit, 200);
            batchLimit = Math.max(batchLimit, 1);
            batchAction.setBatchLimit(batchLimit);
        } else {
            batchAction.setBatchLimit(200);
        }
    }

    @Override
    protected void afterSaveParamTreeConfig(ParamTreeConfig config, Flow flow, Action action) {
        BatchAction batchAction = (BatchAction)action;
        batchAction.setMode((String)this.getModel().getValue(KEY_MODE));
        if (config.getEntryEntityKey().equals(PARAM_TREE_BATCH_INPUT_CONFIG.getEntryEntityKey())) {
            action.compileParamReference(flow);
            this.saveBatchInnerParams(batchAction);
        }
        if (batchAction.isEnableBatch() && config.getEntryEntityKey().equals(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey())) {
            this.saveBatchOutputParams(batchAction);
        }
    }

    private void saveBatchInnerParams(BatchAction batchAction) {
        batchAction.clearGroupParams("BATCH_INNER_GROUP");
        List paramDefinitions = batchAction.getBatchInputParams();
        if (CollectionUtils.isNotEmpty((Collection)paramDefinitions)) {
            for (ParamDefinition paramDefinition : paramDefinitions) {
                if (!(paramDefinition instanceof ArrayParamDefinition)) continue;
                ParamDefinition itemDefinition = ((ArrayParamDefinition)paramDefinition).getItemDefinition();
                itemDefinition = ParamReferenceHelper.cloneDefinition((String)VariableBuilderFactory.getArrayItemParamName((ArrayParamDefinition)((ArrayParamDefinition)paramDefinition)), (ParamDefinition)itemDefinition);
                itemDefinition.setSource(ParamSource.DYNAMIC);
                itemDefinition.setDisplayName(VariableBuilderFactory.getArrayItemParamDisplayName((ArrayParamDefinition)((ArrayParamDefinition)paramDefinition)));
                batchAction.addParam("BATCH_INNER_GROUP", itemDefinition);
            }
            BasicParamDefinition indexDefinition = ParamDefinitionBuilder.integer((String)VariableBuilderFactory.getArrayItemIndexParamName()).asInput().makePrivate().build();
            indexDefinition.setSource(ParamSource.DYNAMIC);
            batchAction.addParam("BATCH_INNER_GROUP", (ParamDefinition)indexDefinition);
        }
    }

    private void saveBatchOutputParams(BatchAction batchAction) {
        batchAction.clearGroupParams("BATCH_OUTPUT_GROUP");
        if (!batchAction.isEnableBatch()) {
            return;
        }
        List outputDefs = batchAction.getParamByGroup(batchAction.getOutputParamGroup());
        ParamDefinitionBuilder.ObjectParamBuilder itemDefBuilder = ParamDefinitionBuilder.object((String)"outputList").asOutput().makePublic().required(true);
        for (ParamDefinition outputDef : outputDefs) {
            itemDefBuilder.property(outputDef);
        }
        ParamDefinition outputListDef = FlowConfigParamHelper.wrapperArrayParamDefinition((ParamDefinition)itemDefBuilder.build());
        batchAction.addParam("BATCH_OUTPUT_GROUP", outputListDef);
    }

    protected void loadParamTreeData(ParamTreeConfig config, List<ParamDefinition> paramDefinitionList) {
        Flow flow = this.getFlow();
        BatchAction batchAction = (BatchAction)this.getAction(flow);
        ParamTreeLoader.create(config, this.getView(), this.getModel()).loadTreeData(flow, paramDefinitionList);
        if (config.getEntryEntityKey().equals(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey())) {
            this.updateBatchOutputParams(flow, batchAction);
        }
    }

    private void updateBatchOutputParams(Flow flow, BatchAction batchAction) {
        this.saveParamTreeConfig(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), flow, (Action)batchAction);
        ParamTreeLoader.create(PARAM_TREE_BATCH_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, batchAction.getBatchOutputParams());
    }

    @Override
    protected List<ParamDefinition> getAllInputParams(Action action) {
        BatchAction batchAction = (BatchAction)action;
        List inputParams = batchAction.getInputParams();
        List batchInputParams = batchAction.getBatchInputParams();
        inputParams.addAll(batchInputParams);
        return inputParams;
    }

    @Override
    protected List<ParamDefinition> getAllOutputParams(Action action) {
        BatchAction batchAction = (BatchAction)action;
        List outputParams = batchAction.getOutputParams();
        List batchOutputParams = batchAction.getBatchOutputParams();
        outputParams.addAll(batchOutputParams);
        return outputParams;
    }
}

