/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.ParamTreeContext;
import kd.ai.gai.plugin.flow.config.param.ParamTreeBinder;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.config.param.ParamTreeRefSelector;
import kd.ai.gai.plugin.flow.config.param.ParamTreeSaver;
import kd.ai.gai.plugin.flow.config.param.ParamTreeValidator;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AbstractFlowConfigPlugin<T extends Action>
extends AbstractGaiProcessSetPlugin
implements RowClickEventListener {
    protected static final Log log = LogFactory.getLog(AbstractFlowConfigPlugin.class);
    public static final ParamTreeConfig PARAM_TREE_INPUT_CONFIG = ParamTreeConfig.createInputConfig();
    public static final ParamTreeConfig PARAM_TREE_OUTPUT_CONFIG = ParamTreeConfig.createOutputConfig();
    private final List<ParamTreeContext> paramTreeContexts = new ArrayList<ParamTreeContext>();
    protected static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    protected static final String TOOLBAR_INPUT = "toolbar_input";
    protected static final String TOOLBAR_OUTPUT = "toolbar_output";
    protected static final String KEY_INPUT_NEW_ENTRY = "input_newentry";
    protected static final String KEY_INPUT_INSERT_ENTRY = "input_insertentry";
    protected static final String KEY_INPUT_DELETE_ENTRY = "input_deleteentry";
    protected static final String KEY_OUTPUT_NEW_ENTRY = "output_newentry";
    protected static final String KEY_OUTPUT_INSERT_ENTRY = "output_insertentry";
    protected static final String KEY_OUTPUT_DELETE_ENTRY = "output_deleteentry";
    protected static final String NODE_ID = "nodeId";

    public AbstractFlowConfigPlugin() {
        this.registerParamTreeConfig();
    }

    protected void registerParamTreeConfig() {
        this.registerParamTreeConfig(PARAM_TREE_INPUT_CONFIG, Action::getInputParamGroup, action -> ParamDirection.INPUT);
        this.registerParamTreeConfig(PARAM_TREE_OUTPUT_CONFIG, Action::getOutputParamGroup, action -> ParamDirection.OUTPUT);
    }

    protected final void registerParamTreeConfig(ParamTreeConfig config, Function<Action, String> paramGroupProvider, Function<Action, ParamDirection> directionProvider) {
        this.paramTreeContexts.add(new ParamTreeContext(config, paramGroupProvider, directionProvider));
    }

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (ParamTreeContext paramTreeContext : this.paramTreeContexts) {
            ParamTreeConfig config = paramTreeContext.getConfig();
            ParamTreeRefSelector.create(config, this.getView(), this.getModel()).registerReferenceClickListener(this);
            ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey())).registerEntryRowClickListener(this);
        }
    }

    @Override
    protected void setComboItem() {
        super.setComboItem();
        for (ParamTreeContext context : this.paramTreeContexts) {
            List<ComboItem> paramTypeComboItem = this.getParamTypeComboItem(context.getConfig().getEntryEntityKey());
            ParamTreeLoader.create(context.getConfig(), this.getView(), this.getModel()).loadParamTypeComboItem(paramTypeComboItem);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean ispreset = (Boolean)this.getGaiProcessView().getModel().getValue("ispreset");
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baseinfoadv", "inputadv", "outputadv"});
        }
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey())).initBinding(this.getNeedLockColumnMap().getOrDefault(config.getEntryEntityKey(), new ArrayList(0)));
            ParamTreeLoader.create(config, this.getView(), this.getModel()).loadConstantValue();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid entryGrid = (EntryGrid)source;
            String entryKey = entryGrid.getEntryKey();
            for (ParamTreeContext context : this.paramTreeContexts) {
                ParamTreeConfig config = context.getConfig();
                ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey())).setEntryInsertVisible(entryKey, rowIndex);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            ParamTreeBinder paramTreeBinder = ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey()));
            paramTreeBinder.initBindingForNewRow(entryName, rowIndex, new ArrayList<String>(1));
            paramTreeBinder.setEntryInsertVisible(entryName, rowIndex);
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryKey = e.getEntryProp().getName();
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            ParamTreeBinder paramTreeBinder = ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey()));
            paramTreeBinder.setEntryInsertVisible(entryKey, -1);
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey())).initBinding(this.getNeedLockColumnMap().getOrDefault(config.getEntryEntityKey(), new ArrayList(0)));
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey())).initBinding(this.getNeedLockColumnMap().getOrDefault(config.getEntryEntityKey(), new ArrayList(0)));
        }
    }

    @Override
    public void initData() {
        Flow flow = this.getFlow();
        T action = this.getAction(flow);
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            String paramGroup = context.getParamGroup((Action)action);
            List<ParamDefinition> paramDefinitions = action.getParamByGroup(paramGroup);
            paramDefinitions = this.filterInitParamDefinitions(config.getEntryEntityKey(), paramDefinitions);
            ParamTreeLoader.create(config, this.getView(), this.getModel()).loadTreeData(flow, paramDefinitions);
        }
    }

    protected List<ParamDefinition> filterInitParamDefinitions(String entryEntityKey, List<ParamDefinition> paramDefinitions) {
        return paramDefinitions;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        T action = this.getAction(flow);
        for (ParamTreeContext context : this.paramTreeContexts) {
            this.saveParamTreeConfig(context, flow, (Action)action);
        }
        this.checkParamName((Action)action);
        action.setInputParamGroup(action.getInputParamGroup());
        action.setOutputParamGroup(action.getOutputParamGroup());
    }

    protected List<ParamDefinition> getAllInputParams(Action action) {
        return action.getInputParams();
    }

    protected List<ParamDefinition> getAllOutputParams(Action action) {
        return action.getOutputParams();
    }

    private void checkParamName(Action action) {
        List<ParamDefinition> inputParams = this.getAllInputParams(action);
        List<ParamDefinition> outputParams = this.getAllOutputParams(action);
        HashSet<String> inParamNameSet = new HashSet<String>(inputParams.size());
        HashSet<String> outParamNameSet = new HashSet<String>(outputParams.size());
        for (ParamDefinition inputParam : inputParams) {
            if (inParamNameSet.contains(inputParam.getName())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0\u91cd\u590d\uff1a%s", (String)"AbstractFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[]{inputParam.getName()}));
            }
            inParamNameSet.add(inputParam.getName());
        }
        for (ParamDefinition outputParam : outputParams) {
            if (outParamNameSet.contains(outputParam.getName())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0\u91cd\u590d\uff1a%s", (String)"AbstractFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[]{outputParam.getName()}));
            }
            outParamNameSet.add(outputParam.getName());
        }
    }

    protected void saveParamTreeConfig(String entityEntry, Flow flow, Action action) {
        for (ParamTreeContext context : this.paramTreeContexts) {
            if (!entityEntry.equals(context.getConfig().getEntryEntityKey())) continue;
            this.saveParamTreeConfig(context, flow, action);
            break;
        }
    }

    protected void saveParamTreeConfig(ParamTreeContext context, Flow flow, Action action) {
        ParamTreeConfig config = context.getConfig();
        String paramGroup = context.getParamGroup(action);
        ParamDirection direction = context.getParamDirection(action);
        action.clearGroupParams(paramGroup);
        ParamTreeSaver.create(config, this.getView(), this.getModel()).saveTreeData(this.getGaiProcessView(), flow, action, direction, paramGroup);
        this.afterSaveParamTreeConfig(config, flow, action);
    }

    protected void afterSaveParamTreeConfig(ParamTreeConfig config, Flow flow, Action action) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            String referenceFieldKey = ((TextEdit)evt.getSource()).getKey();
            for (ParamTreeContext context : this.paramTreeContexts) {
                if (!referenceFieldKey.equals(context.getConfig().getReferenceParam())) continue;
                T action = this.getAction(this.getFlow());
                if (action.getTransferInList() == null || action.getTransferInList().isEmpty()) {
                    IFormView flowDesignerView = this.getGaiProcessView();
                    flowDesignerView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fde\u63a5\u8f93\u5165\u8fde\u63a5\u7ebf\u3002", (String)"AbstractFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(flowDesignerView);
                    return;
                }
                ParamTreeRefSelector.create(context.getConfig(), this.getView(), this.getModel()).showReferenceTreeView((IFormPlugin)this, ((TextEdit)evt.getSource()).getKey(), context.getConfig().getReferenceParamFullPath(), this.getReferenceDataConfig(context.getConfig().getEntryEntityKey()), this.getNodeId());
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        for (ParamTreeContext context : this.paramTreeContexts) {
            int rowIndex;
            ParamTreeConfig config = context.getConfig();
            ParamTreeBinder paramTreeBinder = ParamTreeBinder.create(config, this.getView(), this.getModel(), this.needLockParamTypeAfterBind(config.getEntryEntityKey()));
            if (config.getTypeKey().equals(propertyName)) {
                rowIndex = changeData.getRowIndex();
                paramTreeBinder.handleParamTypeChanged(rowIndex);
                continue;
            }
            if (config.getIsConstantKey().equals(propertyName)) {
                rowIndex = changeData.getRowIndex();
                paramTreeBinder.handleConstantModeToggle(propertyName, rowIndex, this.getNeedLockColumnMap().getOrDefault(config.getEntryEntityKey(), new ArrayList(0)));
                continue;
            }
            if (config.getNameKey().equals(propertyName)) {
                ParamTreeValidator.create(config, this.getView(), this.getModel()).validateNodeVarName(systemVarList, propertyName, changeData, context.getParamDirection((Action)this.getAction(this.getFlow())));
                continue;
            }
            if (!config.getReferenceParam().equals(propertyName)) continue;
            rowIndex = changeData.getRowIndex();
            paramTreeBinder.handleReferenceParamChanged(changeData, rowIndex, this.getNeedLockColumnMap().getOrDefault(config.getEntryEntityKey(), new ArrayList(0)));
        }
        this.getModel().setDataChanged(true);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Flow flow = this.getFlow();
        T action = this.getAction(flow);
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            ParamTreeRefSelector.create(config, this.getView(), this.getModel()).closedCallBack(flow, (Action)action, evt, this.needChangeParamTypeOnClosedCallBack(config.getEntryEntityKey()));
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        Optional<String> errorMessage = this.check();
        if (errorMessage.isPresent()) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(errorMessage.get());
        }
        return validateInfo;
    }

    protected Optional<String> check() {
        for (ParamTreeContext context : this.paramTreeContexts) {
            ParamTreeConfig config = context.getConfig();
            Optional<String> errorMessage = ParamTreeValidator.create(config, this.getView(), this.getModel()).validateParameters();
            if (!errorMessage.isPresent()) continue;
            return errorMessage;
        }
        return Optional.empty();
    }

    protected RefrenceDataConfig getReferenceDataConfig(String entryEntityKey) {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setNodeId(this.getNodeId());
        config.setBlockNodeId(this.getAction(this.getFlow()).getBlockNodeId());
        return config;
    }

    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        return GaiFieldTypeInitUtils.createParamTypeComboItem();
    }

    protected boolean needLockParamTypeAfterBind(String entityKey) {
        return true;
    }

    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return true;
    }

    protected final IFormView getGaiProcessView() {
        return this.getNodePropertyDesigner().getFlowEditingContext().getService(ViewService.class).getDesignerView();
    }

    @Override
    protected final int getNodeId() {
        return (Integer)this.getView().getFormShowParameter().getCustomParam(NODE_ID);
    }

    protected final T getAction(Flow flow) {
        int nodeId = this.getNodeId();
        if (nodeId == flow.getStart().getId()) {
            return (T)flow.getStart();
        }
        if (nodeId == flow.getEnd().getId()) {
            return (T)flow.getEnd();
        }
        return (T)flow.findActionById(nodeId);
    }

    protected Map<String, List<String>> getNeedLockColumnMap() {
        return new HashMap<String, List<String>>(0);
    }
}

