/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.flow.FlowConfigParamHelper;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;
import kd.ai.gai.core.flow.param.helper.ParamReferenceHelper;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.config.helper.ParamDefinitionTreeHelper;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowTreeViewPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ItemClickListener,
RowClickEventListener {
    public static final String NODE_ENTRYENTITY = "entryentity";
    private static String SHOW_FROM_TREEVIEW = "select_param_treeview";
    private static final String GROUPED_REFERENCE_PARAMS_CACHE_KEY = "GROUPED_REFERENCE_PARAMS";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        ((TreeView)this.getControl(SHOW_FROM_TREEVIEW)).addTreeNodeClickListener((TreeNodeClickListener)this);
        ((CardEntry)this.getControl(NODE_ENTRYENTITY)).addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<Integer, List<RefrenceParam>> groupedParams = this.getGroupedReferenceParamsFromCache();
        if (MapUtils.isNotEmpty(groupedParams)) {
            this.getModel().batchCreateNewEntryRow(NODE_ENTRYENTITY, groupedParams.size());
            int i = 0;
            for (Map.Entry<Integer, List<RefrenceParam>> entry : groupedParams.entrySet()) {
                RefrenceParam refrenceParam = entry.getValue().get(0);
                this.getModel().setValue("node_key", (Object)refrenceParam.getNodeId(), i);
                this.getModel().setValue("node_name", (Object)refrenceParam.getNodeName(), i);
                ++i;
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(NODE_ENTRYENTITY);
        int size = entryData.size();
        int selectRowed = 0;
        if (size > 0) {
            Optional<NodeParamPath> nodeParamPath = this.getNodeParamPathFromCustomParam();
            if (nodeParamPath.isPresent()) {
                DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(NODE_ENTRYENTITY);
                int entryEntitiesSize = entryEntities.size();
                for (int i = 0; i < entryEntitiesSize; ++i) {
                    DynamicObject entryEntity = (DynamicObject)entryEntities.get(i);
                    Object nodeKey = entryEntity.get("node_key");
                    if (!nodeParamPath.get().getNodeId().equals(nodeKey)) continue;
                    selectRowed = i;
                    break;
                }
            }
            ((CardEntry)this.getControl(NODE_ENTRYENTITY)).selectRows(selectRowed);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getSource() instanceof CardEntry && NODE_ENTRYENTITY.equals(((CardEntry)evt.getSource()).getKey())) {
            int row = evt.getRow();
            this.refreshParamList(row);
        }
    }

    private void refreshParamList(int row) {
        if (row < 0) {
            return;
        }
        Object nodeIdObj = this.getModel().getValue("node_key", row);
        if (nodeIdObj == null) {
            return;
        }
        int currentNodeId = Integer.parseInt(nodeIdObj.toString());
        Map<Integer, List<RefrenceParam>> groupedParams = this.getGroupedReferenceParamsFromCache();
        List<RefrenceParam> sameNodeParams = groupedParams.get(currentNodeId);
        if (CollectionUtils.isEmpty(sameNodeParams)) {
            return;
        }
        Flow flow = this.getFlowEditingContextFromThreadLocal().getService(ModelService.class).getFlow();
        ArrayList<ParamDefinition> paramDefinitions = new ArrayList<ParamDefinition>();
        for (RefrenceParam refrenceParam : sameNodeParams) {
            Optional<ParamDefinition> paramDefinition;
            int nodeIdFromCustomParam = this.getNodeIdFromCustomParam();
            if (flow.isExistsTransfer(nodeIdFromCustomParam)) {
                Transfer transferById = flow.findTransferById(nodeIdFromCustomParam);
                nodeIdFromCustomParam = transferById.getToNodeId();
            }
            if (!(paramDefinition = FlowConfigParamHelper.findParentParamDefinition((Flow)flow, (Action)flow.findActionById(nodeIdFromCustomParam), (String)String.valueOf(currentNodeId), (String)refrenceParam.getParamName())).isPresent()) {
                paramDefinition = this.findParamFromEditingParams(currentNodeId, refrenceParam.getParamName());
            }
            paramDefinition.ifPresent(paramDefinitions::add);
        }
        if (!paramDefinitions.isEmpty()) {
            RefrenceDataConfig refrenceDataConfig = this.getReferenceDataConfigFromCustomParam();
            Optional<NodeParamPath> nodeParamPath = this.getNodeParamPathFromCustomParam();
            ParamDefinitionTreeHelper.generateParamTreeList(this.getView(), SHOW_FROM_TREEVIEW, nodeIdObj.toString(), paramDefinitions, nodeParamPath.orElse(null), refrenceDataConfig.isOnlySelectTopNode());
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key = ((Button)source).getKey();
            if ("btnok".equals(key)) {
                String treeNodeId = this.getPageCache().get("treeNodeId");
                ParamDefinition newParamDefinition = null;
                if (treeNodeId != null) {
                    Optional<ParamDefinition> paramDefinition;
                    if (treeNodeId.equals("root")) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5177\u4f53\u7684\u53c2\u6570", (String)"FlowTreeViewPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                        return;
                    }
                    NodeParamPath paramPath = ParamDefinitionTreeHelper.getNodeParamPath(this.getView(), treeNodeId);
                    Flow flow = this.getFlowEditingContextFromThreadLocal().getService(ModelService.class).getFlow();
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(NODE_ENTRYENTITY);
                    Object nodeIdObj = this.getModel().getValue("node_key", rowIndex);
                    if (nodeIdObj == null) {
                        return;
                    }
                    int nodeIdFromCustomParam = this.getNodeIdFromCustomParam();
                    if (flow.isExistsTransfer(nodeIdFromCustomParam)) {
                        Transfer transferById = flow.findTransferById(nodeIdFromCustomParam);
                        nodeIdFromCustomParam = transferById.getToNodeId();
                    }
                    if (!(paramDefinition = FlowConfigParamHelper.findParentParamDefinition((Flow)flow, (Action)flow.findActionById(nodeIdFromCustomParam), (String)paramPath.getNodeId(), (String)paramPath.getOutputParamName())).isPresent()) {
                        paramDefinition = this.findParamFromEditingParams(Integer.parseInt(paramPath.getNodeId()), paramPath.getOutputParamName());
                    }
                    if (paramDefinition.isPresent()) {
                        newParamDefinition = ParamReferenceHelper.resolveReference((String)"param", (ParamDefinition)((ParamDefinition)paramDefinition.get()), (NodeParamPath)paramPath);
                    }
                }
                this.getView().returnDataToParent(newParamDefinition);
                this.getView().close();
            } else if ("btncancel".equals(key)) {
                this.getView().close();
            }
        }
    }

    private Optional<ParamDefinition> findParamFromEditingParams(int nodeId, String paramName) {
        RefrenceDataConfig config = this.getReferenceDataConfigFromCustomParam();
        List<ParamDefinition> edittingParamList = config.getEditingParamList();
        if (nodeId == config.getNodeId() && edittingParamList != null && !edittingParamList.isEmpty()) {
            for (ParamDefinition param : edittingParamList) {
                if (!param.getName().equals(paramName)) continue;
                return Optional.of(param);
            }
        }
        return Optional.empty();
    }

    private FlowEditingContext getFlowEditingContextFromThreadLocal() {
        FlowEditingContext context = FlowEditingContext.get();
        if (context == null) {
            FlowEditingContext.initContext(this.getView().getParentView().getParentView(), this.getView());
        }
        return FlowEditingContext.get();
    }

    private Map<Integer, List<RefrenceParam>> getGroupedReferenceParamsFromCache() {
        String groupedReferenceParamsJson = this.getPageCache().get(GROUPED_REFERENCE_PARAMS_CACHE_KEY);
        if (StringUtils.isBlank((CharSequence)groupedReferenceParamsJson)) {
            FlowEditingContext flowEditingContext = this.getFlowEditingContextFromThreadLocal();
            ModelService modelService = flowEditingContext.getService(ModelService.class);
            RefrenceDataConfig refrenceDataConfig = this.getReferenceDataConfigFromCustomParam();
            int nodeId = this.getNodeIdFromCustomParam();
            ArrayList<RefrenceParam> referenceParams = new ArrayList<RefrenceParam>(8);
            referenceParams.addAll(modelService.getRefrenceParamManager().getCanRefrenceParamList(nodeId, refrenceDataConfig));
            Map groupedParams = referenceParams.stream().collect(Collectors.groupingBy(RefrenceParam::getNodeId, LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
            ArrayList entryList = new ArrayList(groupedParams.entrySet());
            Collections.reverse(entryList);
            LinkedHashMap<Integer, List<RefrenceParam>> reversedGroupedParams = new LinkedHashMap<Integer, List<RefrenceParam>>();
            entryList.forEach(entry -> {
                List cfr_ignored_0 = (List)reversedGroupedParams.put((Integer)entry.getKey(), (List<RefrenceParam>)entry.getValue());
            });
            this.getPageCache().put(GROUPED_REFERENCE_PARAMS_CACHE_KEY, JSON.toJSONString(reversedGroupedParams));
            return reversedGroupedParams;
        }
        return (Map)JSON.parseObject((String)groupedReferenceParamsJson, (TypeReference)new TypeReference<Map<Integer, List<RefrenceParam>>>(){}, (Feature[])new Feature[0]);
    }

    private int getNodeIdFromCustomParam() {
        Object nodeId = this.getView().getFormShowParameter().getCustomParam("nodeId");
        return Integer.parseInt(nodeId.toString());
    }

    private Optional<NodeParamPath> getNodeParamPathFromCustomParam() {
        Object referenceParamFullPath = this.getView().getFormShowParameter().getCustomParam("referenceParamFullPath");
        if (referenceParamFullPath == null || StringUtils.isBlank((CharSequence)referenceParamFullPath.toString())) {
            return Optional.empty();
        }
        return Optional.of(ParamPathHelper.parseFullPath((String)referenceParamFullPath.toString()));
    }

    private RefrenceDataConfig getReferenceDataConfigFromCustomParam() {
        Object referenceDataConfig = this.getView().getFormShowParameter().getCustomParam(RefrenceDataConfig.class.getSimpleName());
        return RefrenceDataConfig.parse(referenceDataConfig.toString());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String treeNodeId = (String)evt.getNodeId();
        this.getPageCache().put("treeNodeId", treeNodeId);
    }

    public void destory() {
        super.destory();
        FlowEditingContext.release();
    }
}

