/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.helper;

import java.util.Objects;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.bos.dataentity.utils.StringUtils;

public class FlowConfigEntityHelper {
    public static String getConfigEntity(ProcessNodeType processNodeType) {
        if (FlowConfigEntityHelper.isPropertyParamMode()) {
            return processNodeType.getNodeDesignerFormId();
        }
        switch (processNodeType) {
            case Llm: {
                return "gai_flow_config_llm";
            }
            case Start: {
                return "gai_flow_config_start";
            }
            case End: {
                return "gai_flow_config_end";
            }
            case CusOption: {
                return "gai_flow_config_operation";
            }
            case Message: {
                return "gai_flow_config_message";
            }
            case AskUser: {
                return "gai_flow_config_askuser";
            }
            case Repo: {
                return "gai_flow_config_repo";
            }
            case RepoReply: {
                return "gai_flow_config_reporeply";
            }
            case Loop: {
                return "gai_flow_config_loop";
            }
            case SetVariable: {
                return "gai_flow_config_loopsetv";
            }
            case BreakLoop: {
                return "gai_flow_config_loopbreak";
            }
            case Parallel: {
                return "gai_flow_config_batchproc";
            }
            case Code: {
                return "gai_flow_config_code";
            }
            case Tool: {
                return "gai_flow_cfg_batch_tool";
            }
            case Vision: {
                return "gai_flow_config_vision";
            }
            case BILLQUERY: {
                return "gai_flow_config_billquery";
            }
            case QueryEntity: {
                return "gai_flow_config_nl_query";
            }
            case BillOperate: {
                return "gai_flow_config_billop";
            }
            case BILLSave: {
                return "gai_flow_config_billsave";
            }
        }
        return processNodeType.getNodeDesignerFormId();
    }

    public static String getConfigTransfer(ProcessNodeType processNodeType) {
        if (FlowConfigEntityHelper.isPropertyParamMode()) {
            return "gai_process_transfer";
        }
        if (Objects.requireNonNull(processNodeType) == ProcessNodeType.Condition) {
            return "gai_flow_config_transfer";
        }
        return "gai_process_transfer";
    }

    public static boolean isPropertyParamMode() {
        Flow flow = FlowEditingContext.get().getService(ModelService.class).getFlow();
        String paramMode = flow.getParamMode();
        return StringUtils.isEmpty((CharSequence)paramMode) || paramMode.equals(ParamMode.PROPERTY.name());
    }
}

