/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.helper;

import java.util.Collections;
import java.util.EventObject;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamReferenceHelper;
import kd.ai.gai.plugin.flow.config.helper.ParamDefinitionTreeHelper;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ParamDefinitionTreeExaple
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREE_VIEW = "treeviewap";
    private static final String CURRENT_FLOW_NODE_ID = "node_123";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ParamDefinitionTreeHelper.generateParamTreeList(this.getView(), KEY_TREE_VIEW, CURRENT_FLOW_NODE_ID, Collections.singletonList(this.createParamDef()), null, false);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String treeNodeId = (String)evt.getNodeId();
        NodeParamPath paramPath = ParamDefinitionTreeHelper.getNodeParamPath(this.getView(), treeNodeId);
        StringBuilder message = new StringBuilder("\u70b9\u51fb\u4e86\u8282\u70b9: ");
        message.append(treeNodeId);
        message.append("\r\n\u8282\u70b9ID: ").append(paramPath.getNodeId());
        message.append("\r\n\u53c2\u6570\u540d: ").append(paramPath.getOutputParamName());
        ParamDefinition newvar = ParamReferenceHelper.resolveReference((String)"newvar", (ParamDefinition)this.createParamDef(), (NodeParamPath)paramPath);
        message.append("\r\n\u53c2\u6570\u7ed3\u6784: ").append(newvar.toDetailedString());
        this.getView().showMessage(message.toString());
    }

    private ParamDefinition createParamDef() {
        ArrayParamDefinition skillsArrayDef = ParamDefinitionBuilder.stringArray((String)"skills").build();
        ObjectParamDefinition employeeDef = ParamDefinitionBuilder.object((String)"employee").property((ParamDefinition)ParamDefinitionBuilder.string((String)"id").required(true).build()).property((ParamDefinition)ParamDefinitionBuilder.string((String)"name").required(true).build()).property((ParamDefinition)skillsArrayDef).build();
        ArrayParamDefinition employeesArrayDef = ParamDefinitionBuilder.array((String)"employees", (ParamDefinition)employeeDef).build();
        ObjectParamDefinition departmentDef = ParamDefinitionBuilder.object((String)"department").property((ParamDefinition)ParamDefinitionBuilder.string((String)"id").required(true).build()).property((ParamDefinition)ParamDefinitionBuilder.string((String)"name").required(true).build()).property((ParamDefinition)employeesArrayDef).build();
        return ParamDefinitionBuilder.array((String)"departments", (ParamDefinition)departmentDef).build();
    }
}

