/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ParamDefinitionTreeHelper {
    private static final String TREE_PATH_MAP_CACHE_KEY = "param_tree_path_map";

    public static void generateParamTreeList(IFormView view, String treeViewKey, String flowNodeId, List<ParamDefinition> paramDefinitions, NodeParamPath originNodeParamPath, boolean onlySelectTopNode) {
        TreeView treeView = (TreeView)view.getControl(treeViewKey);
        if (treeView == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6811\u63a7\u4ef6: " + treeViewKey);
        }
        treeView.deleteAllNodes();
        HashMap<String, String> nodePathMap = new HashMap<String, String>();
        TreeNode rootNode = ParamDefinitionTreeHelper.createRootNode();
        rootNode.setDisabled(true);
        for (ParamDefinition paramDefinition : paramDefinitions) {
            if (paramDefinition.getName() == null) continue;
            String string = flowNodeId + "." + paramDefinition.getName();
            TreeNode paramNode = ParamDefinitionTreeHelper.buildParameterNode(flowNodeId, rootNode.getId(), paramDefinition, string, nodePathMap, onlySelectTopNode);
            if (paramNode == null) continue;
            rootNode.addChild(paramNode);
        }
        ParamDefinitionTreeHelper.saveNodePathMapToCache(view, nodePathMap);
        ParamDefinitionTreeHelper.setupTreeView(treeView, rootNode);
        if (originNodeParamPath != null) {
            String treeNodeId = null;
            for (Map.Entry entry : nodePathMap.entrySet()) {
                String nodeParamPathFullPath = originNodeParamPath.getFullPath();
                if (!((String)entry.getValue()).equals(nodeParamPathFullPath)) continue;
                treeNodeId = (String)entry.getKey();
                break;
            }
            if (StringUtils.isNotBlank(treeNodeId)) {
                Optional<TreeNode> optional = ParamDefinitionTreeHelper.traverseTreeAndFindNodeById(rootNode, treeNodeId);
                optional.ifPresent(arg_0 -> ((TreeView)treeView).focusNode(arg_0));
            }
        }
    }

    private static Optional<TreeNode> traverseTreeAndFindNodeById(TreeNode currentTreeNode, String targetId) {
        if (currentTreeNode == null || targetId == null) {
            return Optional.empty();
        }
        if (targetId.equals(currentTreeNode.getId())) {
            return Optional.of(currentTreeNode);
        }
        if (CollectionUtils.isEmpty((Collection)currentTreeNode.getChildren())) {
            return Optional.empty();
        }
        for (TreeNode child : currentTreeNode.getChildren()) {
            Optional<TreeNode> treeNode = ParamDefinitionTreeHelper.traverseTreeAndFindNodeById(child, targetId);
            if (!treeNode.isPresent()) continue;
            return treeNode;
        }
        return Optional.empty();
    }

    public static NodeParamPath getNodeParamPath(IFormView view, String treeNodeId) {
        String pathString = ParamDefinitionTreeHelper.getNodePathStringFromCache(view, treeNodeId);
        if (pathString == null || pathString.isEmpty()) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8282\u70b9ID\u5bf9\u5e94\u7684\u8def\u5f84: " + treeNodeId);
        }
        try {
            return ParamPathHelper.parseFullPath((String)pathString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u89e3\u6790\u8def\u5f84\u5931\u8d25: " + pathString, e);
        }
    }

    private static TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode(null, "root", "\u53c2\u6570\u5217\u8868", true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private static void setupTreeView(TreeView treeView, TreeNode rootNode) {
        treeView.addNode(rootNode);
        treeView.setRootVisible(true);
        treeView.expand(rootNode.getId());
    }

    private static TreeNode buildParameterNode(String flowNodeId, String parentId, ParamDefinition paramDef, String nodePath, Map<String, String> nodePathMap, boolean onlySelectTopNode) {
        if (paramDef == null) {
            return null;
        }
        String treeNodeId = ParamDefinitionTreeHelper.generateTreeNodeId(parentId, paramDef.getName());
        TreeNode node = ParamDefinitionTreeHelper.createTreeNode(parentId, treeNodeId, paramDef);
        nodePathMap.put(treeNodeId, nodePath);
        if (paramDef instanceof ObjectParamDefinition) {
            ParamDefinitionTreeHelper.processObjectParameters((ObjectParamDefinition)paramDef, node, flowNodeId, nodePath, nodePathMap, onlySelectTopNode);
        } else if (paramDef instanceof ArrayParamDefinition) {
            ParamDefinitionTreeHelper.processArrayParameter((ArrayParamDefinition)paramDef, node, flowNodeId, nodePath, nodePathMap, onlySelectTopNode);
        }
        return node;
    }

    private static String generateTreeNodeId(String parentId, String paramName) {
        return (parentId != null ? parentId + "_" : "") + paramName;
    }

    private static TreeNode createTreeNode(String parentId, String treeNodeId, ParamDefinition paramDef) {
        boolean hasChildren = paramDef instanceof ObjectParamDefinition || paramDef instanceof ArrayParamDefinition && !(((ArrayParamDefinition)paramDef).getItemDefinition() instanceof BasicParamDefinition);
        String displayName = StringUtils.isBlank((CharSequence)paramDef.getDisplayName()) ? paramDef.getName() : paramDef.getDisplayName();
        TreeNode node = new TreeNode(parentId, treeNodeId, displayName, hasChildren);
        ParamDefinitionTreeHelper.addTypeLabel(node, paramDef);
        node.setLabelShowType(1);
        return node;
    }

    private static void processObjectParameters(ObjectParamDefinition objDef, TreeNode parentNode, String flowNodeId, String parentPath, Map<String, String> nodePathMap, boolean onlySelectTopNode) {
        List properties = objDef.getProperties();
        for (ParamDefinition property : properties) {
            String propertyPath = parentPath + "." + property.getName();
            TreeNode propertyNode = ParamDefinitionTreeHelper.buildParameterNode(flowNodeId, parentNode.getId(), property, propertyPath, nodePathMap, onlySelectTopNode);
            if (onlySelectTopNode) {
                propertyNode.setDisabled(true);
            }
            if (propertyNode == null) continue;
            parentNode.addChild(propertyNode);
        }
        if (!parentNode.getChildren().isEmpty() && !onlySelectTopNode) {
            parentNode.setIsOpened(true);
        }
    }

    private static void processArrayParameter(ArrayParamDefinition arrayDef, TreeNode parentNode, String flowNodeId, String parentPath, Map<String, String> nodePathMap, boolean onlySelectTopNode) {
        ParamDefinition itemDef = arrayDef.getItemDefinition();
        String arrayItemPath = parentPath + "[*]";
        nodePathMap.put(ParamDefinitionTreeHelper.createArrayItemsNode(parentNode, itemDef).getId(), arrayItemPath);
        if (itemDef instanceof ObjectParamDefinition) {
            ParamDefinitionTreeHelper.processObjectParameters((ObjectParamDefinition)itemDef, parentNode, flowNodeId, arrayItemPath, nodePathMap, onlySelectTopNode);
        } else if (itemDef instanceof ArrayParamDefinition) {
            ParamDefinitionTreeHelper.processArrayParameter((ArrayParamDefinition)itemDef, parentNode, flowNodeId, arrayItemPath, nodePathMap, onlySelectTopNode);
        }
    }

    private static TreeNode createArrayItemsNode(TreeNode parentNode, ParamDefinition itemDef) {
        String itemNodeId = parentNode.getId() + "_items";
        boolean hasChildren = itemDef instanceof ObjectParamDefinition || itemDef instanceof ArrayParamDefinition;
        String displayName = itemDef.getName();
        TreeNode itemNode = new TreeNode(parentNode.getId(), itemNodeId, displayName, hasChildren);
        itemNode.setDisabled(itemNode.isDisabled());
        ParamDefinitionTreeHelper.addTypeLabel(itemNode, itemDef);
        itemNode.setLabelShowType(1);
        if (hasChildren) {
            itemNode.setIsOpened(true);
        }
        return itemNode;
    }

    private static void addTypeLabel(TreeNode node, ParamDefinition paramDef) {
        ArrayList<TreeNodeLabel> labels = new ArrayList<TreeNodeLabel>();
        TreeNodeLabel typeLabel = new TreeNodeLabel();
        typeLabel.setLabel(VarParamConverter.convertDisplayedParamType(paramDef));
        typeLabel.setColor(ParamDefinitionTreeHelper.getColorForDataType(paramDef.getType().name().toLowerCase()));
        labels.add(typeLabel);
        node.setLabelPara(labels);
    }

    private static String getColorForDataType(String type) {
        return "#647599";
    }

    private static void saveNodePathMapToCache(IFormView view, Map<String, String> nodePathMap) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put(TREE_PATH_MAP_CACHE_KEY, SerializationUtils.toJsonString(nodePathMap));
    }

    private static String getNodePathStringFromCache(IFormView view, String treeNodeId) {
        IPageCache pageCache = view.getPageCache();
        String jsonMap = pageCache.get(TREE_PATH_MAP_CACHE_KEY);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return null;
        }
        try {
            Map nodePathMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class);
            return (String)nodePathMap.get(treeNodeId);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u89e3\u6790\u7f13\u5b58\u7684\u8def\u5f84\u6620\u5c04\u5931\u8d25", e);
        }
    }
}

