/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.helper;

import java.util.Collection;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import org.apache.commons.collections4.CollectionUtils;

public class VarParamConverter {
    public static ParamType convertStringToParamType(String typeStr) {
        return ParamType.convertStringToParamType((String)typeStr);
    }

    public static ParamDefinition createParamDefinitionByType(String name, String typeStr) {
        ParamType paramType = VarParamConverter.convertStringToParamType(typeStr);
        switch (paramType) {
            case OBJECT: {
                return new ObjectParamDefinition(name);
            }
            case ARRAY: {
                ParamType itemType = ParamType.STRING;
                if (typeStr != null && typeStr.startsWith("Array<")) {
                    String elementTypeStr = typeStr.substring(6, typeStr.length() - 1);
                    itemType = VarParamConverter.convertStringToParamType(elementTypeStr);
                }
                if (itemType == ParamType.OBJECT) {
                    return new ArrayParamDefinition(name, (ParamDefinition)new ObjectParamDefinition("item"));
                }
                return new ArrayParamDefinition(name, (ParamDefinition)new BasicParamDefinition("item", itemType));
            }
        }
        return new BasicParamDefinition(name, paramType);
    }

    public static String convertDisplayedParamType(ParamDefinition paramDefinition) {
        if (paramDefinition == null) {
            return "";
        }
        if (paramDefinition instanceof ArrayParamDefinition) {
            ArrayParamDefinition arrayParamDefinition = (ArrayParamDefinition)paramDefinition;
            ParamType itemType = arrayParamDefinition.getItemDefinition().getType();
            return GaiFieldTypeInitUtils.buildDisplayedArrayType((ParamType)itemType);
        }
        if (paramDefinition instanceof MessageParamDefinition) {
            return ((MessageParamDefinition)paramDefinition).getMessageType().getValue();
        }
        return paramDefinition.getType().getDesc();
    }

    public static String generateNodeParamDisplay(Flow flow, NodeParamPath nodeParamPath) {
        String nodeName;
        if (nodeParamPath == null) {
            return "";
        }
        String nodeIdStr = nodeParamPath.getNodeId();
        String outputParamName = nodeParamPath.getOutputParamName();
        List propertyPaths = nodeParamPath.getPropertyPath();
        int nodeId = Integer.parseInt(nodeIdStr);
        if (nodeId == flow.getStart().getId()) {
            nodeName = flow.getStart().getName();
        } else if (nodeId == flow.getEnd().getId()) {
            nodeName = flow.getEnd().getName();
        } else {
            Node nodeById = null;
            try {
                nodeById = flow.findNodeById(nodeId);
                nodeName = nodeById.getName();
            }
            catch (Exception ignored) {
                nodeName = String.valueOf(nodeId);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(nodeName).append(".").append(outputParamName);
        if (CollectionUtils.isNotEmpty((Collection)propertyPaths)) {
            sb.append(".");
            sb.append((String)propertyPaths.get(propertyPaths.size() - 1));
        }
        return sb.toString();
    }
}

