/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import org.apache.commons.collections4.CollectionUtils;

public class AskUserFlowConfigPlugin
extends AbstractFlowConfigPlugin<AskUserAction> {
    private static final String KEY_ALLOW_USER_INPUT = "allowuserinput";
    private static final String KEY_SSE_AUTO_CLOSE = "sseautoclose";

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        if (PARAM_TREE_INPUT_CONFIG.getEntryEntityKey().equals(entryEntityKey)) {
            return this.createMessageTypeComboItem();
        }
        if (PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey().equals(entryEntityKey)) {
            return GaiFieldTypeInitUtils.createParamTypeComboItem((ParamType[])new ParamType[]{ParamType.STRING, ParamType.INTEGER});
        }
        return super.getParamTypeComboItem(entryEntityKey);
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        AskUserAction askUserAction = (AskUserAction)this.getAction(flow);
        this.getModel().setValue(KEY_ALLOW_USER_INPUT, (Object)askUserAction.isAllowUserInput());
        this.getModel().setValue(KEY_SSE_AUTO_CLOSE, (Object)askUserAction.isSseAutoClose());
        List outputParams = askUserAction.getParamByGroup(askUserAction.getOutputParamGroup());
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            BasicParamDefinition askUserParamDefinition = ParamDefinitionBuilder.string((String)"askUser_output").asInput().makePrivate().description(ResManager.loadKDString((String)"\u7528\u6237\u6f84\u6e05", (String)"AskUserFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
            ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, Collections.singletonList(askUserParamDefinition));
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)entryName, (CharSequence)PARAM_TREE_INPUT_CONFIG.getEntryEntityKey())) {
            int row = e.getRowDataEntities()[0].getRowIndex();
            String name = this.getName(row);
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getNameKey(), (Object)name, row);
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)MessageType.Text.getValue(), row);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObject dataEntity;
        DynamicObjectCollection outputDoc;
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)entryName, (CharSequence)PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey()) && (outputDoc = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObjectCollection(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey())) != null && outputDoc.size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u51fa\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u53c2\u6570", (String)"AskUserFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject dataEntity;
        DynamicObjectCollection showDoc;
        String showType;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int row = this.getModel().getEntryCurrentRowIndex(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        if (PARAM_TREE_INPUT_CONFIG.getTypeKey().equals(propertyName) && StringUtils.equalsIgnoreCase((CharSequence)(showType = (String)this.getModel().getValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), row)), (CharSequence)MessageType.Iframe.getValue()) && (showDoc = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObjectCollection(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey())) != null && showDoc.size() > 0) {
            int iframeCount = 0;
            for (DynamicObject showDo : showDoc) {
                String type = showDo.getString(PARAM_TREE_INPUT_CONFIG.getTypeKey());
                if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)MessageType.Iframe.getValue())) continue;
                ++iframeCount;
            }
            if (iframeCount > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6dfb\u52a0\u4e00\u4e2aiframe", (String)"AskUserFlowConfigPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), null, row);
            }
        }
    }

    @Override
    protected Optional<String> check() {
        DynamicObjectCollection shows = this.getModel().getEntryEntity(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        if (shows == null || shows.isEmpty()) {
            String errMes = ResManager.loadKDString((String)"\u5c55\u793a\u4fe1\u606f\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u53c2\u6570", (String)"AskUserFlowConfigPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
            return Optional.of(errMes);
        }
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey());
        if (outputDoc == null || outputDoc.isEmpty()) {
            String errMes = ResManager.loadKDString((String)"\u8f93\u51fa\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u53c2\u6570", (String)"AskUserFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            return Optional.of(errMes);
        }
        return super.check();
    }

    private String getName(int row) {
        return String.format("message%s", row + 1);
    }

    private List<ComboItem> createMessageTypeComboItem() {
        MessageType[] types = new MessageType[]{MessageType.Text, MessageType.Picture, MessageType.Iframe, MessageType.HyperLink};
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (MessageType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getText()));
                comboItem.setValue(type.getValue());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.MESSAGE_TYPE_INIT_ERROR.getCode(), GaiErrorCode.MESSAGE_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.clickMessage(flow, this.getNodeId());
    }

    private void clickMessage(Flow flow, int nodeId) {
        AskUserAction askUserAction = (AskUserAction)flow.findActionById(nodeId);
        askUserAction.setAllowUserInput(((Boolean)this.getModel().getValue(KEY_ALLOW_USER_INPUT)).booleanValue());
        askUserAction.setSseAutoClose(((Boolean)this.getModel().getValue(KEY_SSE_AUTO_CLOSE)).booleanValue());
    }

    @Override
    protected boolean needLockParamTypeAfterBind(String entityKey) {
        return false;
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }
}

