/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.helper.ParamReferenceHelper;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.form.field.ComboItem;
import org.apache.commons.collections4.CollectionUtils;

public class BatchProcessFlowConfigPlugin
extends AbstractFlowConfigPlugin<ParallelAction> {
    private static final String PARALLEL_LIMIT = "stepper_parallellimit";
    private static final String BATCH_LIMIT = "stepper_batchlimit";

    @Override
    protected RefrenceDataConfig getReferenceDataConfig(String entityKey) {
        RefrenceDataConfig referenceDataConfig = super.getReferenceDataConfig(entityKey);
        if (PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey().equals(entityKey)) {
            referenceDataConfig.setNeedBlockInnerNode(true);
            referenceDataConfig.setOnlyNeedBlockInnerNode(true);
        }
        if (PARAM_TREE_INPUT_CONFIG.getEntryEntityKey().equals(entityKey)) {
            ArrayList<String> paramTypes = new ArrayList<String>(8);
            for (ParamType basicParamType : ParamType.values()) {
                paramTypes.add(GaiFieldTypeInitUtils.buildDisplayedArrayType((ParamType)basicParamType));
            }
            referenceDataConfig.setOnlyParamTypeList(paramTypes);
        }
        return referenceDataConfig;
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        ParallelAction parallelAction = (ParallelAction)this.getAction(flow);
        this.getModel().setValue(PARALLEL_LIMIT, (Object)BigDecimal.valueOf(parallelAction.getParallelLimit()));
        this.getView().updateView(PARALLEL_LIMIT);
        this.getModel().setValue(BATCH_LIMIT, (Object)BigDecimal.valueOf(parallelAction.getBatchLimit()));
    }

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        List<ComboItem> list = super.getParamTypeComboItem(entryEntityKey);
        list.removeIf(item -> !item.getValue().startsWith(ParamType.ARRAY.getDesc()));
        return list;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        BigDecimal parallelLimit_BD;
        ParallelAction parallelAction = (ParallelAction)this.getAction(flow);
        parallelAction.clearGroupParams("LOOP_ARR_INNER_GROUP");
        super.saveDataToFlow(flow);
        parallelAction.compileParamReference(flow);
        parallelAction.clearGroupParams("BATCH_INNER_GROUP");
        List paramDefinitions = parallelAction.getParamByGroup(parallelAction.getInputParamGroup());
        if (CollectionUtils.isNotEmpty((Collection)paramDefinitions)) {
            for (ParamDefinition paramDefinition : paramDefinitions) {
                if (!(paramDefinition instanceof ArrayParamDefinition)) continue;
                ParamDefinition itemDefinition = ((ArrayParamDefinition)paramDefinition).getItemDefinition();
                itemDefinition = ParamReferenceHelper.cloneDefinition((String)VariableBuilderFactory.getArrayItemParamName((ArrayParamDefinition)((ArrayParamDefinition)paramDefinition)), (ParamDefinition)itemDefinition);
                itemDefinition.setSource(ParamSource.DYNAMIC);
                itemDefinition.setDisplayName(VariableBuilderFactory.getArrayItemParamDisplayName((ArrayParamDefinition)((ArrayParamDefinition)paramDefinition)));
                parallelAction.addParam("BATCH_INNER_GROUP", itemDefinition);
            }
            BasicParamDefinition indexDefinition = ParamDefinitionBuilder.integer((String)VariableBuilderFactory.getArrayItemIndexParamName()).asInput().makePrivate().build();
            indexDefinition.setSource(ParamSource.DYNAMIC);
            parallelAction.addParam("BATCH_INNER_GROUP", (ParamDefinition)indexDefinition);
        }
        if ((parallelLimit_BD = (BigDecimal)this.getModel().getValue(PARALLEL_LIMIT)) != null) {
            int parallelLimit = parallelLimit_BD.intValue();
            if (parallelLimit > 10) {
                parallelLimit = 10;
            } else if (parallelLimit < 1) {
                parallelLimit = 1;
            }
            parallelAction.setParallelLimit(parallelLimit);
        } else {
            log.info("\u89e3\u6790\u201c\u6700\u5927\u5e76\u884c\u8fd0\u884c\u6570\u91cf\u201d\u4e3a\u7a7a\uff0c\u5f53\u524d\u503c\u4e0d\u53d8");
        }
        BigDecimal batchLimit_BD = (BigDecimal)this.getModel().getValue(BATCH_LIMIT);
        if (batchLimit_BD != null) {
            int batchLimit = batchLimit_BD.intValue();
            batchLimit = Math.min(batchLimit, 200);
            batchLimit = Math.max(batchLimit, 1);
            parallelAction.setBatchLimit(batchLimit);
        } else {
            parallelAction.setBatchLimit(200);
        }
    }
}

