/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.BillOperateAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.process.BillOperationType;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BillOprateFlowConfigPlugin
extends AbstractFlowConfigPlugin<BillOperateAction> {
    private static final String KEY_BIZ_BILL = "biz_bill";
    private static final String KEY_BIZ_OPRATE = "biz_oprate";
    public static final String NAME = "name";
    private static final String KEY_NUMBER = "number";
    private static final List<ParamDefinition> init_inputVarList = new ArrayList<ParamDefinition>(1);
    private static final List<ParamDefinition> init_outputVarList = new ArrayList<ParamDefinition>(6);

    @Override
    protected Optional<String> check() {
        DynamicObject bizBillObj = (DynamicObject)this.getModel().getValue(KEY_BIZ_BILL);
        if (bizBillObj == null) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessToolSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        String bizOp = (String)this.getModel().getValue(KEY_BIZ_OPRATE);
        if (StringUtils.isEmpty((String)bizOp)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessToolSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        return super.check();
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.saveBilloprateNode(flow);
    }

    private void saveBilloprateNode(Flow flow) {
        BillOperateAction billOprateAction = (BillOperateAction)this.getAction(flow);
        if (billOprateAction == null) {
            return;
        }
        Object bizObj = this.getModel().getValue(KEY_BIZ_BILL);
        if (bizObj != null) {
            String pkValue = (String)((DynamicObject)bizObj).getPkValue();
            billOprateAction.setBizBill(pkValue);
        }
        billOprateAction.setBizOperate((String)this.getModel().getValue(KEY_BIZ_OPRATE));
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    private List<ComboItem> buildBillOperateComboItem() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZ_BILL);
        if (bizObject == null) {
            return items;
        }
        String bizFormId = bizObject.getString(KEY_NUMBER);
        List bizOperateList = Arrays.stream(BillOperationType.values()).map(BillOperationType::getType).collect(Collectors.toList());
        Predicate<Map> predicate = operationMeta -> {
            String operationType = (String)operationMeta.get("type");
            boolean isBizOperation = bizOperateList.contains(operationType);
            return isBizOperation;
        };
        Function<Map, ComboItem> mapper = operationMeta -> {
            ComboItem comboItem = new ComboItem();
            String key = (String)operationMeta.get("key");
            comboItem.setCaption(new LocaleString(String.format("%s(%s)", LocaleString.fromMap((Map)((Map)operationMeta.get(NAME))).getLocaleValue(), key)));
            comboItem.setValue(key);
            return comboItem;
        };
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)bizFormId);
        List opList = dataEntityOperate.stream().filter(predicate).map(mapper).collect(Collectors.toList());
        items.addAll(opList);
        return items;
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        BillOperateAction billOprateAction = (BillOperateAction)this.getAction(flow);
        this.getModel().setValue(KEY_BIZ_BILL, (Object)billOprateAction.getBizBill());
        this.getModel().setValue(KEY_BIZ_OPRATE, (Object)billOprateAction.getBizOperate());
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        if (CollectionUtils.isEmpty((Collection)inputDoc)) {
            this.loadActionInfo(flow, billOprateAction);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBillOpInfo();
    }

    private void loadActionInfo(Flow flow, BillOperateAction billOprateAction) {
        ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, init_inputVarList);
        ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, init_outputVarList);
    }

    private void initBillOpInfo() {
        ComboEdit bizOprateComboEdit = (ComboEdit)this.getControl(KEY_BIZ_OPRATE);
        List<ComboItem> bizOpList = this.buildBillOperateComboItem();
        bizOprateComboEdit.setComboItems(bizOpList);
        this.getView().updateView(KEY_BIZ_OPRATE);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_BIZ_BILL.equals(key)) {
            ComboEdit bizOprateComboEdit = (ComboEdit)this.getControl(KEY_BIZ_OPRATE);
            List<ComboItem> bizOpList = this.buildBillOperateComboItem();
            bizOprateComboEdit.setComboItems(bizOpList);
        }
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    static {
        init_inputVarList.add((ParamDefinition)ParamDefinitionBuilder.stringArray((String)"ids").description("\u5355\u636eid").build());
        init_outputVarList.add((ParamDefinition)ParamDefinitionBuilder.bool((String)"status").description("\u6210\u529f/\u5931\u8d25").build());
        init_outputVarList.add((ParamDefinition)ParamDefinitionBuilder.string((String)"message").description("\u9519\u8bef\u6d88\u606f").build());
        init_outputVarList.add((ParamDefinition)ParamDefinitionBuilder.stringArray((String)"successIds").description("\u6210\u529f\u5355\u636eids").build());
        init_outputVarList.add((ParamDefinition)ParamDefinitionBuilder.stringArray((String)"errorIds").description("\u5931\u8d25\u5355\u636eids").build());
    }
}

