/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.BillQueryAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.nl2api.model.DataSourceMetadata;
import kd.ai.gai.core.nl2api.model.FieldInfo;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.config.utils.ParamDefinitionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillQueryFlowConfigPlugin
extends AbstractFlowConfigPlugin<BillQueryAction>
implements BeforeF7SelectListener {
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String NUMBER = "number";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_OPERATOR = "input_operator";
    private static final String KEY_INPUT_ISINPUT = "input_isconstant";
    private static final String KEY_INPUT_VALUE = "input_constant_value";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String QUERY_OBJ_FIELD_SEL = "query_obj_field_sel";

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar_input", "toolbar_output"});
        BasedataEdit filedEdit = (BasedataEdit)this.getView().getControl(ENTITY_NUMBER);
        filedEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private ComboItem getCompareTypeItem(CompareTypeEnum compareTypeEnum) {
        CompareType compareType = FilterMetadata.get().getCompareTypeByCompareTypeId(compareTypeEnum.getId());
        ComboItem item = null;
        item = compareType.getId().equals("37") ? new ComboItem(compareType.getName(), "is null") : (compareType.getId().equals("9") ? new ComboItem(compareType.getName(), "is not null") : new ComboItem(compareType.getName(), compareType.getOperate()));
        return item;
    }

    @Override
    protected void setComboItem() {
        List<ComboItem> paramItems = this.getComboItem();
        ComboEdit inputSourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        inputSourceParam.setComboItems(paramItems);
        ArrayList<ComboItem> compareTypeItems = new ArrayList<ComboItem>(16);
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.EQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.NOTEQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.IN));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.NOTIN));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.ISNULL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.ISNOTNULL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.GREATER));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LESS));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.GREATEROREQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LESSOREQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.NOTLIKE));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LIKE));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.BETWEEN));
        ComboEdit comboEditValueType = (ComboEdit)this.getControl(KEY_INPUT_OPERATOR);
        comboEditValueType.setComboItems(compareTypeItems);
        List outPutitemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit outPutEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outPutEdit.setComboItems(outPutitemList);
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        String validMessage = this.checkBill();
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setValidMessage(validMessage);
        if (StringUtils.isNotBlank((CharSequence)validMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
        } else {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        }
        return validateInfo;
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        block5: {
            block4: {
                super.beforeDeleteRow(e);
                if (!e.getEntryProp().getName().equals(KEY_ENTRYENTITY_OUTPUT)) break block4;
                for (int i = 0; i < e.getRowIndexs().length; ++i) {
                    String metaData = (String)this.getModel().getValue("metadata_tag");
                    String fullName = ParamDefinitionUtils.getParamFullName(this.getModel().getEntryEntity(e.getEntryProp().getName()), PARAM_TREE_OUTPUT_CONFIG.getNameKey(), e.getRowIndexs()[i]);
                    if (fullName.contains("result.")) {
                        fullName = fullName.substring(7);
                    }
                    if (fullName.equals("filter") || fullName.equals("message") || fullName.equals("count") || fullName.equals("status") || fullName.equals("result") || fullName.equals("metaData")) {
                        e.setCancel(true);
                        return;
                    }
                    metaData = BillQueryFlowConfigPlugin.reomveFieldId(metaData, fullName);
                    this.getModel().setValue("metadata_tag", (Object)metaData);
                }
                break block5;
            }
            if (!e.getEntryProp().getName().equals(KEY_ENTRYENTITY_INPUT)) break block5;
            for (int i = 0; i < e.getRowIndexs().length; ++i) {
                String filterMetaData = (String)this.getModel().getValue("filtermetadata_tag");
                String fieldName = (String)this.getModel().getEntryRowEntity(e.getEntryProp().getName(), e.getRowIndexs()[i]).get(KEY_INPUT_NAME);
                String newFilterMetaData = BillQueryFlowConfigPlugin.reomveFieldId(filterMetaData, fieldName);
                this.getModel().setValue("filtermetadata_tag", (Object)newFilterMetaData);
            }
        }
    }

    public static String reomveFieldId(String jsonString, String fieldName) {
        JSONObject root = JSONObject.parseObject((String)jsonString);
        if (root != null) {
            JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
            for (int i = 0; i < fieldInfoList.size(); ++i) {
                JSONObject fieldInfo = fieldInfoList.getJSONObject(i);
                JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
                Iterator iterator = plainFieldList.iterator();
                while (iterator.hasNext()) {
                    JSONObject plainField = (JSONObject)iterator.next();
                    String fieldId = plainField.getString("fieldId");
                    if (!fieldId.equals(fieldName)) continue;
                    iterator.remove();
                }
            }
        }
        return root == null ? "" : root.toJSONString();
    }

    public String checkBill() {
        DynamicObject entityNumber = (DynamicObject)this.getModel().getValue("entitynumber");
        if (entityNumber == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"GaiProcessRepoReplySetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean ispreset = (Boolean)this.getGaiProcessView().getModel().getValue("ispreset");
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baseinfoadv", "inputadv", "outputadv"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    private void clickQueryEntity(Flow flow) {
        BillQueryAction billQueryAction = (BillQueryAction)this.getAction(flow);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        if (inputDoc != null) {
            for (DynamicObject row : inputDoc) {
                String name = row.getString(KEY_INPUT_NAME);
                String operator = row.getString(KEY_INPUT_OPERATOR);
                Optional param = billQueryAction.getParamByName(billQueryAction.getInputParamGroup(), name);
                param.ifPresent(oper -> {
                    HashMap<String, String> customProperties = new HashMap<String, String>();
                    customProperties.put(name, operator);
                    oper.setCustomProperties(customProperties);
                });
            }
        }
        billQueryAction.setMetaData((String)this.getModel().getValue("metadata_tag"));
        billQueryAction.setFilter((String)this.getModel().getValue("filtermetadata_tag"));
        billQueryAction.setBillId(String.valueOf(this.getEntityPkValue()));
    }

    private Object getEntityPkValue() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue("entitynumber");
        Object entityNumber = null;
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getPkValue();
        }
        return entityNumber;
    }

    private void loadMessage(BillQueryAction billQueryAction) {
        List varList = billQueryAction.getParamByGroup(billQueryAction.getInputParamGroup());
        String entityNumber = billQueryAction.getBillId();
        this.getModel().getDataEntity(true);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        HashMap inputMap = new HashMap();
        inputDoc.stream().forEach(dynamicObject -> inputMap.put(dynamicObject.getString(KEY_INPUT_NAME), dynamicObject));
        if (varList != null) {
            for (ParamDefinition var : varList) {
                String name = var.getName();
                Map customProperties = var.getCustomProperties();
                ((DynamicObject)inputMap.get(name)).set(KEY_INPUT_OPERATOR, customProperties.get(name));
                this.getView().updateView(KEY_ENTRYENTITY_INPUT);
            }
        }
        String metaData = billQueryAction.getMetaData();
        this.getModel().setValue("metadata_tag", (Object)metaData);
        this.getModel().setValue("filtermetadata_tag", (Object)billQueryAction.getFilter());
        this.getModel().setValue("entitynumber", (Object)entityNumber);
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        BillQueryAction billQueryAction = (BillQueryAction)this.getAction(flow);
        this.loadMessage(billQueryAction);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_INPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        }
        if (propertyName.equals(KEY_OUTPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        }
        if (propertyName.equals("entitynumber") && (data = e.getChangeSet()[0]).getNewValue() != null) {
            DynamicObject newEntityNumber = (DynamicObject)data.getNewValue();
            DynamicObject oldEntityNumber = (DynamicObject)data.getOldValue();
            if (newEntityNumber != null && oldEntityNumber != null) {
                if (newEntityNumber.getString(NUMBER).equals(oldEntityNumber.getString(NUMBER))) {
                    return;
                }
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_OUTPUT);
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_INPUT);
                this.initEntityFieldData(KEY_ENTRYENTITY_OUTPUT);
            } else if (newEntityNumber != null && oldEntityNumber == null) {
                this.initEntityFieldData(KEY_ENTRYENTITY_OUTPUT);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void itemClick(ItemClickEvent event) {
        super.itemClick(event);
        String key = event.getItemKey();
        if ("addqueryparam".equals(key)) {
            if (this.getEntityNumber().isEmpty()) {
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(QUERY_OBJ_FIELD_SEL);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("metadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectqueryparam"));
            StyleCss css = new StyleCss();
            css.setWidth("80%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        } else if ("addfilterparam".equals(key)) {
            if (this.getEntityNumber().isEmpty()) {
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(QUERY_OBJ_FIELD_SEL);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("filtermetadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "filterqueryparam"));
            StyleCss css = new StyleCss();
            css.setWidth("80%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        }
    }

    private List<PlainField> getPlainFieldListFromMetadata(String entityNumber) {
        List fieldInfoList;
        Optional<FieldInfo> first;
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String modelStr = (String)this.getModel().getValue("metadata_tag");
        DataSourceMetadata model = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)modelStr) && (first = (fieldInfoList = (model = (DataSourceMetadata)JSONObject.parseObject((String)modelStr, DataSourceMetadata.class)).getFieldInfoList()).stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst()).isPresent()) {
            FieldInfo fieldInfo = first.get();
            plainFieldList = fieldInfo.getPlainFieldList();
        }
        return plainFieldList;
    }

    private List<PlainField> getFilterPlainFieldListFromMetadata(String entityNumber) {
        List fieldInfoList;
        Optional<FieldInfo> first;
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String modelStr = (String)this.getModel().getValue("filtermetadata_tag");
        DataSourceMetadata model = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)modelStr) && (first = (fieldInfoList = (model = (DataSourceMetadata)JSONObject.parseObject((String)modelStr, DataSourceMetadata.class)).getFieldInfoList()).stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst()).isPresent()) {
            FieldInfo fieldInfo = first.get();
            plainFieldList = fieldInfo.getPlainFieldList();
        }
        return plainFieldList;
    }

    private void insertOutputVar(List<PlainField> list) {
        PlainField plainField = new PlainField();
        plainField.setFieldId("result");
        plainField.setFieldName(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u7ed3\u679c\u96c6", (String)"BillQueryFlowConfigPlugin_15173705", (String)"ai-gai-plugin", (Object[])new Object[0]));
        plainField.setFieldType("Array<Object>");
        plainField.setFieldKey("must");
        list.add(plainField);
        PlainField metaPlainField = new PlainField();
        metaPlainField.setFieldId("message");
        metaPlainField.setFieldName(ResManager.loadKDString((String)"\u9519\u8bef\u6d88\u606f", (String)"BillQueryFlowConfigPlugin_15173706", (String)"ai-gai-plugin", (Object[])new Object[0]));
        metaPlainField.setFieldType("String");
        metaPlainField.setFieldKey("must");
        list.add(metaPlainField);
        PlainField filterPlainField = new PlainField();
        filterPlainField.setFieldId("filter");
        filterPlainField.setFieldName(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"BillQueryFlowConfigPlugin_15173707", (String)"ai-gai-plugin", (Object[])new Object[0]));
        filterPlainField.setFieldType("String");
        filterPlainField.setFieldKey("must");
        list.add(filterPlainField);
        PlainField countPlainField = new PlainField();
        countPlainField.setFieldId("count");
        countPlainField.setFieldName(ResManager.loadKDString((String)"\u6761\u6570", (String)"BillQueryFlowConfigPlugin_15173708", (String)"ai-gai-plugin", (Object[])new Object[0]));
        countPlainField.setFieldType("String");
        countPlainField.setFieldKey("must");
        list.add(countPlainField);
        PlainField statusPlainField = new PlainField();
        statusPlainField.setFieldId("status");
        statusPlainField.setFieldName(ResManager.loadKDString((String)"\u6210\u529f/\u5931\u8d25", (String)"BillQueryFlowConfigPlugin_15173709", (String)"ai-gai-plugin", (Object[])new Object[0]));
        statusPlainField.setFieldType("Boolean");
        statusPlainField.setFieldKey("must");
        list.add(statusPlainField);
        PlainField metaDataPlainField = new PlainField();
        metaDataPlainField.setFieldId("metaData");
        metaDataPlainField.setFieldName(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4fe1\u606f", (String)"BillQueryFlowConfigPlugin_15173710", (String)"ai-gai-plugin", (Object[])new Object[0]));
        metaDataPlainField.setFieldType("String");
        metaDataPlainField.setFieldKey("must");
        list.add(metaDataPlainField);
    }

    private String getEntityNumber() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue("entitynumber");
        String entityNumber = "";
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getString(NUMBER);
        }
        return entityNumber;
    }

    private void initEntityFieldData(String type) {
        String entityNumber = this.getEntityNumber();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(entityNumber);
        List<PlainField> allFilterPlainFieldList = this.getFilterPlainFieldListFromMetadata(entityNumber);
        if (type.equals(KEY_ENTRYENTITY_OUTPUT)) {
            this.insertOutputVar(allPlainFieldList);
            int size = allPlainFieldList.size();
            if (size > 0) {
                PlainField plainField;
                IDataModel dataModel = this.getModel();
                DynamicObjectCollection output = dataModel.getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
                ArrayList<PlainField> outputList = new ArrayList<PlainField>();
                for (DynamicObject dyn : output) {
                    plainField = new PlainField();
                    plainField.setFieldId(dyn.getString(KEY_OUTPUT_NAME));
                    plainField.setFieldName(dyn.getString(KEY_OUTPUT_DESC));
                    plainField.setFieldType(dyn.getString(KEY_OUTPUT_TYPE));
                    outputList.add(plainField);
                }
                ArrayList<PlainField> filterOutputList = new ArrayList<PlainField>();
                for (int i = 0; i < allPlainFieldList.size(); ++i) {
                    plainField = allPlainFieldList.get(i);
                    if (outputList.stream().filter(e -> e.getFieldId().equals(plainField.getFieldId())).count() == 0L) {
                        filterOutputList.add(plainField);
                        continue;
                    }
                    for (int j = 0; j < outputList.size(); ++j) {
                        if (!((PlainField)outputList.get(j)).getFieldId().equalsIgnoreCase(plainField.getFieldId())) continue;
                        ((PlainField)outputList.get(j)).setFieldKey("must");
                        PlainField field = (PlainField)outputList.get(j);
                        filterOutputList.add(field);
                    }
                }
                ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(this.getFlow(), ParamDefinitionUtils.convertPlainFieldToParamDefinition(allPlainFieldList));
            }
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        } else {
            IDataModel dataModel;
            int size;
            if (allPlainFieldList.size() == 0) {
                this.insertOutputVar(allPlainFieldList);
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_OUTPUT);
                size = allPlainFieldList.size();
                if (size > 0) {
                    dataModel = this.getModel();
                    dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY_OUTPUT, size);
                    for (int i = 0; i < allPlainFieldList.size(); ++i) {
                        PlainField plainField = allPlainFieldList.get(i);
                        dataModel.setValue(KEY_OUTPUT_DESC, (Object)plainField.getFieldName(), i);
                        dataModel.setValue(KEY_OUTPUT_NAME, (Object)plainField.getFieldId(), i);
                        dataModel.setValue(KEY_OUTPUT_TYPE, (Object)plainField.getFieldType(), i);
                    }
                }
                this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
            }
            if ((size = allFilterPlainFieldList.size()) > 0) {
                int i;
                Field plainField;
                dataModel = this.getModel();
                DynamicObjectCollection input = dataModel.getEntryEntity(KEY_ENTRYENTITY_INPUT);
                ArrayList<Field> inputList = new ArrayList<Field>();
                for (DynamicObject dyn : input) {
                    plainField = new Field();
                    plainField.setFieldId(dyn.getString(KEY_INPUT_NAME));
                    plainField.setFieldName(dyn.getString(KEY_INPUT_DESC));
                    plainField.setFieldType(dyn.getString(KEY_INPUT_TYPE));
                    plainField.setOperator(dyn.getString(KEY_INPUT_OPERATOR));
                    plainField.setIsInput(dyn.getString(KEY_INPUT_ISINPUT));
                    plainField.setRefrese(dyn.getString(KEY_INPUT_SOURCEPARAM));
                    plainField.setIntputValue(dyn.getString(KEY_INPUT_VALUE));
                    inputList.add(plainField);
                }
                ArrayList<Field> filterinputList = new ArrayList<Field>();
                for (i = 0; i < allFilterPlainFieldList.size(); ++i) {
                    plainField = allFilterPlainFieldList.get(i);
                    if (inputList.stream().filter(arg_0 -> BillQueryFlowConfigPlugin.lambda$initEntityFieldData$5((PlainField)plainField, arg_0)).count() == 0L) {
                        Field field = new Field();
                        field.setFieldId(plainField.getFieldId());
                        field.setFieldName(plainField.getFieldName());
                        field.setFieldType(plainField.getFieldType());
                        filterinputList.add(field);
                        continue;
                    }
                    for (int j = 0; j < inputList.size(); ++j) {
                        if (!((Field)inputList.get(j)).getFieldId().equalsIgnoreCase(plainField.getFieldId())) continue;
                        Field field = (Field)inputList.get(j);
                        filterinputList.add(field);
                    }
                }
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_INPUT);
                dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY_INPUT, filterinputList.size());
                for (i = 0; i < filterinputList.size(); ++i) {
                    plainField = (Field)filterinputList.get(i);
                    dataModel.setValue(KEY_INPUT_DESC, (Object)plainField.getFieldName(), i);
                    dataModel.setValue(KEY_INPUT_NAME, (Object)plainField.getFieldId(), i);
                    dataModel.setValue(KEY_INPUT_TYPE, (Object)plainField.getFieldType(), i);
                    dataModel.setValue(KEY_INPUT_OPERATOR, (Object)plainField.getOperator(), i);
                    dataModel.setValue(KEY_INPUT_ISINPUT, (Object)plainField.getIsInput(), i);
                    dataModel.setValue(KEY_INPUT_SOURCEPARAM, (Object)plainField.getRefrese(), i);
                    dataModel.setValue(KEY_INPUT_VALUE, (Object)plainField.getIntputValue(), i);
                }
            } else {
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_INPUT);
            }
            this.getView().updateView(KEY_ENTRYENTITY_INPUT);
        }
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.clickQueryEntity(flow);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    private void updateBizObjValue(String entityNumber) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter(NUMBER, "=", (Object)entityNumber).toArray());
            this.getModel().setValue(ENTITY_NUMBER, (Object)bosEntityobject);
            this.getView().updateView(ENTITY_NUMBER);
        }
    }

    public static JSONObject parseObj(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        if (obj instanceof String) {
            return JSONObject.parseObject((String)obj.toString());
        }
        return JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"selectqueryparam")) {
            JSONObject dataJo2;
            if (returnData != null && (dataJo2 = BillQueryFlowConfigPlugin.parseObj(returnData)) != null) {
                String entityNumber = dataJo2.getString(ENTITY_NUMBER);
                this.updateBizObjValue(entityNumber);
                String metadataTag = dataJo2.getString("metadata_tag");
                this.getModel().setValue("metadata_tag", (Object)metadataTag);
                this.initEntityFieldData(KEY_ENTRYENTITY_OUTPUT);
            }
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"filterqueryparam") && returnData != null && (dataJo = BillQueryFlowConfigPlugin.parseObj(returnData)) != null) {
            String entityNumber = dataJo.getString(ENTITY_NUMBER);
            this.updateBizObjValue(entityNumber);
            String metadataTag = dataJo.getString("metadata_tag");
            this.getModel().setValue("filtermetadata_tag", (Object)metadataTag);
            this.initEntityFieldData("filter");
        }
        this.getView().updateView();
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    private static /* synthetic */ boolean lambda$initEntityFieldData$5(PlainField plainField, Field e) {
        return e.getFieldId().equals(plainField.getFieldId());
    }

    private static class Field {
        private static final long serialVersionUID = 1L;
        private String fieldId;
        private String fieldName;
        private String fieldType;
        private String operator;
        private String isInput;
        private String refrese;
        private String intputValue;

        private Field() {
        }

        public String getIsInput() {
            return this.isInput;
        }

        public void setIsInput(String isInput) {
            this.isInput = isInput;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getRefrese() {
            return this.refrese;
        }

        public void setRefrese(String refrese) {
            this.refrese = refrese;
        }

        public String getIntputValue() {
            return this.intputValue;
        }

        public void setIntputValue(String intputValue) {
            this.intputValue = intputValue;
        }
    }
}

