/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.BillSaveAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.nl2api.model.DataSourceMetadata;
import kd.ai.gai.core.nl2api.model.FieldInfo;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.config.utils.ParamDefinitionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BillSaveFlowConfigPlugin
extends AbstractFlowConfigPlugin<BillSaveAction> {
    private String KEY_INPUT_NAME = "input_name";
    private String KEY_INPUT_TYPE = "input_type";
    private String KEY_INPUT_MUST = "must";
    private String KEY_INPUT_PARAMDESC = "input_desc";
    private static final String KEY_INPUT_ISINPUT = "input_isconstant";
    private static final String KEY_INPUT_VALUE = "input_constant_value";
    private String INPUT_ENTITYENTRY = "input";
    private static final String QUERY_OBJ_FIELD_SEL = "query_obj_field_sel";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String NUMBER = "number";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar_input"});
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        BillSaveAction action = (BillSaveAction)this.getAction(flow);
        this.loadBillSaveAction(action, flow);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey(), "must"));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        BillSaveAction action = (BillSaveAction)this.getAction(flow);
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue(ENTITY_NUMBER);
        if (bizObject != null) {
            action.setBizId(bizObject.getString("id"));
            String appId = (String)bizObject.get("bizappid.number");
            action.setAppId(appId);
        }
        action.setMetadada((String)this.getModel().getValue("metadata_tag"));
        action.setFilter((String)this.getModel().getValue("filtermetadata_tag"));
    }

    private void loadBillSaveAction(BillSaveAction action, Flow flow) {
        if (action == null) {
            return;
        }
        String bizId = action.getBizId();
        if (bizId != null) {
            this.getModel().setValue(ENTITY_NUMBER, (Object)bizId);
            this.getView().updateView(ENTITY_NUMBER);
        }
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(this.INPUT_ENTITYENTRY);
        HashMap inputMap = new HashMap();
        inputDoc.stream().forEach(dynamicObject -> inputMap.put(dynamicObject.getString(this.KEY_INPUT_NAME), dynamicObject));
        String metaData = action.getMetadada();
        this.getModel().setValue("metadata_tag", (Object)metaData);
        this.getModel().setValue("filtermetadata_tag", (Object)action.getFilter());
        ArrayList<ParamDefinition> outputParams = new ArrayList<ParamDefinition>(5);
        BasicParamDefinition messageParamDefinition = ParamDefinitionBuilder.string((String)"message").asOutput().makePublic().description(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"BillSaveFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
        outputParams.add((ParamDefinition)messageParamDefinition);
        BasicParamDefinition statusParamDefinition = ParamDefinitionBuilder.bool((String)"status").asOutput().makePublic().description(ResManager.loadKDString((String)"\u6210\u529f/\u5931\u8d25", (String)"BillSaveFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
        outputParams.add((ParamDefinition)statusParamDefinition);
        ObjectParamDefinition dataObjectParamDefinition = ParamDefinitionBuilder.object((String)"data").asOutput().makePublic().description(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e", (String)"BillSaveFlowConfigPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
        BasicParamDefinition idParamDefinition = ParamDefinitionBuilder.integer((String)"id").asOutput().makePublic().build();
        BasicParamDefinition billNoParamDefinition = ParamDefinitionBuilder.string((String)"billNo").asOutput().makePublic().build();
        dataObjectParamDefinition.addProperty((ParamDefinition)idParamDefinition);
        dataObjectParamDefinition.addProperty((ParamDefinition)billNoParamDefinition);
        outputParams.add((ParamDefinition)dataObjectParamDefinition);
        ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, outputParams);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(this.KEY_INPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(this.KEY_INPUT_NAME, this.INPUT_ENTITYENTRY, data);
        }
        if (propertyName.equals("entitynumber") && (data = e.getChangeSet()[0]).getNewValue() != null) {
            DynamicObject newEntityNumber = (DynamicObject)data.getNewValue();
            DynamicObject oldEntityNumber = (DynamicObject)data.getOldValue();
            if (newEntityNumber != null && oldEntityNumber != null) {
                if (newEntityNumber.getString(NUMBER).equals(oldEntityNumber.getString(NUMBER))) {
                    return;
                }
                this.getModel().deleteEntryData("input");
            }
        }
    }

    public void itemClick(ItemClickEvent event) {
        super.itemClick(event);
        String key = event.getItemKey();
        if ("input_newentry".equals(key)) {
            if (this.getEntityNumber().isEmpty()) {
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002");
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(QUERY_OBJ_FIELD_SEL);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("filtermetadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "savequeryparam"));
            StyleCss css = new StyleCss();
            css.setWidth("70%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        }
    }

    private String getEntityNumber() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue(ENTITY_NUMBER);
        String entityNumber = "";
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getString(NUMBER);
        }
        return entityNumber;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"savequeryparam") && returnData != null && (dataJo = BillSaveFlowConfigPlugin.parseObj(returnData)) != null) {
            String entityNumber = dataJo.getString(ENTITY_NUMBER);
            this.updateBizObjValue(entityNumber);
            String metadataTag = dataJo.getString("metadata_tag");
            this.getModel().setValue("filtermetadata_tag", (Object)metadataTag);
            this.initEntityFieldData("entryentity");
        }
        this.getView().updateView();
    }

    private void updateBizObjValue(String entityNumber) {
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter(NUMBER, "=", (Object)entityNumber).toArray());
            this.getModel().setValue(ENTITY_NUMBER, (Object)bosEntityobject);
            this.getView().updateView(ENTITY_NUMBER);
        }
    }

    public static JSONObject parseObj(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        if (obj instanceof String) {
            return JSONObject.parseObject((String)obj.toString());
        }
        return JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
    }

    private void initEntityFieldData(String type) {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        List<PlainField> allFilterPlainFieldList = this.getFilterPlainFieldListFromMetadata(entityNumber);
        if (type.equals("entryentity")) {
            int size = allFilterPlainFieldList.size();
            if (size > 0) {
                IDataModel dataModel = this.getModel();
                DynamicObjectCollection input = dataModel.getEntryEntity(this.INPUT_ENTITYENTRY);
                ArrayList<Field> inputList = new ArrayList<Field>();
                for (DynamicObject dyn : input) {
                    Field plainField = new Field();
                    long pid = dyn.getLong("pid");
                    if (pid == 0L) {
                        plainField.setFieldId(dyn.getString(this.KEY_INPUT_NAME));
                    } else {
                        plainField.setFieldId(dyn.getString(this.KEY_INPUT_NAME) + "_" + pid);
                    }
                    plainField.setFieldName(dyn.getString(this.KEY_INPUT_PARAMDESC));
                    plainField.setFieldType(dyn.getString(this.KEY_INPUT_TYPE));
                    plainField.setMust(String.valueOf(dyn.getBoolean(this.KEY_INPUT_MUST)));
                    plainField.setIsInput(dyn.getString(KEY_INPUT_ISINPUT));
                    plainField.setIntputValue(dyn.getString(KEY_INPUT_VALUE));
                    plainField.setReferenceParam(dyn.getString("input_reference"));
                    plainField.setReferenceParamFullPath(dyn.getString("input_reference_path"));
                    inputList.add(plainField);
                }
                List<ParamDefinition> paramDefinitionList = ParamDefinitionUtils.convertPlainFieldToParamDefinition(allFilterPlainFieldList);
                ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(this.getFlow(), paramDefinitionList);
                DynamicObjectCollection newInputCollection = dataModel.getEntryEntity(this.INPUT_ENTITYENTRY);
                for (int i = 0; i < newInputCollection.size(); ++i) {
                    String fieldName = ((DynamicObject)newInputCollection.get(i)).getString(this.KEY_INPUT_NAME);
                    long pid = ((DynamicObject)newInputCollection.get(i)).getLong("pid");
                    for (Field field : inputList) {
                        if (!field.getFieldId().equals(fieldName) || pid != 0L) continue;
                        String isInput = field.getIsInput();
                        if (isInput != null && isInput.equals("false")) {
                            dataModel.setValue("input_reference", (Object)field.getReferenceParam(), i);
                            dataModel.setValue("input_reference_path", (Object)field.getReferenceParamFullPath(), i);
                            dataModel.setValue(KEY_INPUT_ISINPUT, (Object)field.getIsInput(), i);
                        }
                        if (isInput == null || !isInput.equals("true")) continue;
                        dataModel.setValue(KEY_INPUT_ISINPUT, (Object)field.getIsInput(), i);
                        dataModel.setValue(KEY_INPUT_VALUE, (Object)field.getIntputValue(), i);
                    }
                }
            } else if (size == 0) {
                this.getModel().deleteEntryData(this.INPUT_ENTITYENTRY);
            }
            this.getView().updateView(this.INPUT_ENTITYENTRY);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (e.getEntryProp().getName().equals("input")) {
            for (int i = 0; i < e.getRowIndexs().length; ++i) {
                String metaData = (String)this.getModel().getValue("filtermetadata_tag");
                String fullName = ParamDefinitionUtils.getParamFullName(this.getModel().getEntryEntity(e.getEntryProp().getName()), PARAM_TREE_INPUT_CONFIG.getNameKey(), e.getRowIndexs()[i]);
                metaData = BillSaveFlowConfigPlugin.reomveFieldId(metaData, fullName);
                this.getModel().setValue("filtermetadata_tag", (Object)metaData);
            }
        }
    }

    public static String reomveFieldId(String jsonString, String fieldName) {
        JSONObject root = JSONObject.parseObject((String)jsonString);
        if (root != null) {
            JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
            for (int i = 0; i < fieldInfoList.size(); ++i) {
                JSONObject fieldInfo = fieldInfoList.getJSONObject(i);
                JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
                Iterator iterator = plainFieldList.iterator();
                while (iterator.hasNext()) {
                    JSONObject plainField = (JSONObject)iterator.next();
                    String fieldId = plainField.getString("fieldId");
                    if (!fieldId.equals(fieldName)) continue;
                    iterator.remove();
                }
            }
        }
        return root == null ? "" : root.toJSONString();
    }

    private List<PlainField> getFilterPlainFieldListFromMetadata(String entityNumber) {
        List fieldInfoList;
        Optional<FieldInfo> first;
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String modelStr = (String)this.getModel().getValue("filtermetadata_tag");
        DataSourceMetadata model = null;
        if (StringUtils.isNotEmpty((CharSequence)modelStr) && (first = (fieldInfoList = (model = (DataSourceMetadata)JSONObject.parseObject((String)modelStr, DataSourceMetadata.class)).getFieldInfoList()).stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst()).isPresent()) {
            FieldInfo fieldInfo = first.get();
            plainFieldList = fieldInfo.getPlainFieldList();
        }
        return plainFieldList;
    }

    private List<PlainField> getPlainFieldListFromMetadata(String entityNumber) {
        List fieldInfoList;
        Optional<FieldInfo> first;
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String modelStr = (String)this.getModel().getValue("metadata_tag");
        DataSourceMetadata model = null;
        if (StringUtils.isNotEmpty((CharSequence)modelStr) && (first = (fieldInfoList = (model = (DataSourceMetadata)JSONObject.parseObject((String)modelStr, DataSourceMetadata.class)).getFieldInfoList()).stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst()).isPresent()) {
            FieldInfo fieldInfo = first.get();
            plainFieldList = fieldInfo.getPlainFieldList();
        }
        return plainFieldList;
    }

    private static class Field {
        private static final long serialVersionUID = 1L;
        private String fieldId;
        private String fieldName;
        private String fieldType;
        private String isInput;
        private String intputValue;
        private String referenceParam;
        private String referenceParamFullPath;
        private String must;
        private String fullName;

        private Field() {
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getReferenceParam() {
            return this.referenceParam;
        }

        public void setReferenceParam(String referenceParam) {
            this.referenceParam = referenceParam;
        }

        public String getReferenceParamFullPath() {
            return this.referenceParamFullPath;
        }

        public void setReferenceParamFullPath(String referenceParamFullPath) {
            this.referenceParamFullPath = referenceParamFullPath;
        }

        public String getIsInput() {
            return this.isInput;
        }

        public void setIsInput(String isInput) {
            this.isInput = isInput;
        }

        public String getMust() {
            return this.must;
        }

        public void setMust(String must) {
            this.must = must;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getIntputValue() {
            return this.intputValue;
        }

        public void setIntputValue(String intputValue) {
            this.intputValue = intputValue;
        }
    }
}

