/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.script.GaiScript;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.KScriptUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.script.Script;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.CollectionUtils;

public class CodeFlowConfigPlugin
extends AbstractFlowConfigPlugin<CodeAction> {
    private static final String KEY_INPUT_VALUE = "input_value";
    private static final String KEY_OUTPUT_VALUE = "output_value";
    private static final String KEY_CODEEDIT_AP = "codeeditap";
    private static final String KEY_HELPER_DOC = "helperdoc";
    private static final String KEY_TEST_CODE = "testcode";
    private static final String KEY_FULL_SCREEN = "fullscreen";
    private static final String KEY_ENABLE_PARSE_JSON = "enableparsejson";
    private static final String KEY_LANGUAGE = "codelanguage";
    private static final String PLATFORM_SCRIPT = "platformscript";
    private static final String K_SCRIPT = "kscript";
    private static final String HELP_DOC_CLICK_COUNT = "helpDocClickCount";
    private static final String KEY_ISC_ONLINE_HELPER_VIEW = "isc_online_helper_view";

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        CodeAction action = (CodeAction)this.getAction(flow);
        List outputParams = action.getParamByGroup(action.getOutputParamGroup());
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            BasicParamDefinition outputParamDefinition = ParamDefinitionBuilder.string((String)"output").asInput().makePrivate().description(ResManager.loadKDString((String)"\u4ee3\u7801\u8f93\u51fa\u7ed3\u679c", (String)"GaiProcessCodeSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
            ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, Collections.singletonList(outputParamDefinition));
        }
        this.getModel().setValue(KEY_ENABLE_PARSE_JSON, (Object)action.isEnableParseJson());
        this.getModel().setValue(KEY_LANGUAGE, (Object)(action.getLanguage() == null ? PLATFORM_SCRIPT : action.getLanguage()));
        this.initOutputEnttry(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey());
    }

    @Override
    protected RefrenceDataConfig getReferenceDataConfig(String entryEntityKey) {
        RefrenceDataConfig config = super.getReferenceDataConfig(entryEntityKey);
        config.setAddUserChatHistory(true);
        return config;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"input_mustinput"});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FULL_SCREEN});
        if (this.getModel().getValue(KEY_LANGUAGE) == null) {
            this.getModel().setValue(KEY_LANGUAGE, (Object)PLATFORM_SCRIPT);
        }
        this.initCodeEdit(this.getFlow());
    }

    private void initCodeEdit(Flow flow) {
        NodeConfigData nodeConfigData = this.getNodePropertyDesigner().getNodeDataManager().get(this.getNodeId());
        CodeAction codeAction = (CodeAction)this.getAction(flow);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        if (nodeConfigData == null) {
            codeEdit.setText(CodeFlowConfigPlugin.assemblyCodeText(codeAction.getCode(), this.getModel().getValue(KEY_LANGUAGE).toString()));
        } else {
            codeEdit.setText(CodeFlowConfigPlugin.assemblyCodeText(nodeConfigData.getData(), this.getModel().getValue(KEY_LANGUAGE).toString()));
        }
    }

    private static String assemblyCodeText(String code, String language) {
        if (language.equals(PLATFORM_SCRIPT)) {
            return StringUtils.isEmpty((CharSequence)code) ? "//\u901a\u8fc7$input.\u8f93\u5165\u53d8\u91cf\u540d/$input['\u8f93\u5165\u53d8\u91cf\u540d']/{{\u8f93\u5165\u53d8\u91cf\u540d}}\u683c\u5f0f\u5f15\u7528\u8f93\u5165\u53c2\u6570\uff0c\u5982:$input.param/$input['param']/{{param}}\n//\u901a\u8fc7return\u8bed\u6cd5\u8fd4\u56de\u5b57\u7b26\u4e32\u6216JSONObject\uff0c\u5982:return \"Hello World\" \u6216 return {\"output\":\"Hello World\"}\nreturn \"Hello World\";" : StringUtils.stripToEmpty((String)code);
        }
        if (language.equals(K_SCRIPT)) {
            return StringUtils.isEmpty((CharSequence)code) ? "//\u901a\u8fc7\u8f93\u5165\u53d8\u91cf\u540d\u53ef\u76f4\u63a5\u5f15\u7528\u7c7b\u578b\u8f6c\u6362\u540e\u7684\u8f93\u5165\u53c2\u6570\uff0c\u4e5f\u53ef\u901a\u8fc7$input.\u8f93\u5165\u53d8\u91cf\u540d/$input['\u8f93\u5165\u53d8\u91cf\u540d']/{{\u8f93\u5165\u53d8\u91cf\u540d}}\u683c\u5f0f\u5f15\u7528\u539f\u59cb\u8f93\u5165\u53c2\u6570\uff0c\u5982:$input.param/$input['param']/{{param}}\uff0c\u901a\u8fc7param.get[paramName]\u83b7\u53d6\u5c5e\u6027\u503c\n//\u901a\u8fc7return\u8bed\u6cd5\u8fd4\u56de\u5b57\u7b26\u4e32\u6216JSONObject\uff0c\u5982:return \"Hello World\" \u6216 return {\"output\":\"Hello World\"}\nreturn \"Hello World\";" : StringUtils.stripToEmpty((String)code);
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_HELPER_DOC)) {
            String countStr = this.getPageCache().get(HELP_DOC_CLICK_COUNT);
            if (StringUtils.isNotEmpty((CharSequence)countStr)) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(KEY_ISC_ONLINE_HELPER_VIEW);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
                this.getPageCache().remove(HELP_DOC_CLICK_COUNT);
            } else {
                this.getPageCache().put(HELP_DOC_CLICK_COUNT, "1");
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_TEST_CODE)) {
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
            String code = codeEdit.getText();
            HashMap<String, String> $input = new HashMap<String, String>();
            DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
            if (inputDoc != null) {
                for (DynamicObject row : inputDoc) {
                    String name = row.getString(PARAM_TREE_INPUT_CONFIG.getNameKey());
                    String value = row.getString(KEY_INPUT_VALUE);
                    $input.put(name, value);
                    code = FlowUtils.fillCode((String)code, (String)name, (String)value);
                }
            }
            HashMap<String, HashMap<String, String>> scriptCtx = new HashMap<String, HashMap<String, String>>(10);
            scriptCtx.putAll(Constant.ENGINE.scriptCtx);
            scriptCtx.put("$input", $input);
            Object result = "";
            Flow flow = this.getFlow();
            this.saveDataToFlow(flow);
            CodeAction action = (CodeAction)this.getAction(flow);
            if (K_SCRIPT.equals(action.getLanguage())) {
                try {
                    String script = KScriptUtils.generateScript((CodeAction)action, (String)code);
                    result = KScriptUtils.execScript((String)script, scriptCtx);
                    log.info("code eval result: {}", result);
                }
                catch (Exception e) {
                    String msg = Util.formatException((Exception)e);
                    log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + msg, (Throwable)e);
                    this.getView().showErrorNotification(msg);
                    return;
                }
            }
            Script p = null;
            try {
                p = GaiScript.compile((String)code, scriptCtx);
            }
            catch (Exception e) {
                log.error("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:{}" + e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(String.format("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:%s", e.getMessage()));
                return;
            }
            try {
                result = p.eval(scriptCtx);
                log.info("code eval result: {}", result);
            }
            catch (Exception e) {
                String msg = Util.formatException((Exception)e);
                log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + msg, (Throwable)e);
                this.getView().showErrorNotification(msg);
                return;
            }
            String resultStr = StrUtils.getEvalResult((Object)result);
            if (((Boolean)this.getModel().getValue(KEY_ENABLE_PARSE_JSON)).booleanValue()) {
                JSONObject resultJo;
                if (StringUtils.isEmpty((CharSequence)resultStr)) {
                    this.getView().showErrorNotification(String.format("\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u80fd\u89e3\u6790\u4e3a\u6709\u6548JSONObject\u3002", resultStr));
                    return;
                }
                try {
                    resultJo = JSONObject.parseObject((String)resultStr);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u7ed3\u679c\u8f6cJSON\u5f02\u5e38:{}" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(String.format("\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u80fd\u89e3\u6790\u4e3a\u6709\u6548JSONObject\u3002", resultStr));
                    return;
                }
                DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey());
                if (outputDoc != null && !outputDoc.isEmpty()) {
                    int index = 0;
                    for (DynamicObject row : outputDoc) {
                        String name = row.getString(PARAM_TREE_OUTPUT_CONFIG.getNameKey());
                        this.getModel().setValue(KEY_OUTPUT_VALUE, (Object)StrUtils.getEvalResult((Object)resultJo.get((Object)name)), index++);
                    }
                }
            } else {
                this.getModel().setValue(KEY_OUTPUT_VALUE, (Object)resultStr, 0);
            }
        }
    }

    private void initOutputEnttry(String entryKey) {
        Boolean isParseJson = Optional.ofNullable((Boolean)this.getModel().getValue(KEY_ENABLE_PARSE_JSON)).orElse(false);
        if (!isParseJson.booleanValue()) {
            this.getModel().deleteEntryData(entryKey);
            int rowIndex = this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), (Object)"output", rowIndex);
            this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getTypeKey(), (Object)ParamType.STRING.getDesc(), rowIndex);
            this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getDescKey(), (Object)ResManager.loadKDString((String)"\u4ee3\u7801\u8f93\u51fa\u7ed3\u679c", (String)"GaiProcessCodeSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey(), PARAM_TREE_OUTPUT_CONFIG.getDescKey()});
        }
        this.getView().setEnable(isParseJson, new String[]{"output_newentry", "output_insertentry", "output_deleteentry"});
    }

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        List<ComboItem> list = super.getParamTypeComboItem(entryEntityKey);
        if ("output".equals(entryEntityKey)) {
            list.removeIf(item -> !Arrays.asList(ParamType.STRING.getDesc(), ParamType.INTEGER.getDesc()).contains(item.getValue()));
        }
        return list;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        if (propertyName.equals(KEY_ENABLE_PARSE_JSON)) {
            boolean enableParseJson = (Boolean)data.getNewValue();
            this.getView().setEnable(Boolean.valueOf(enableParseJson), 0, new String[]{PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey(), PARAM_TREE_OUTPUT_CONFIG.getDescKey()});
            if (enableParseJson) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"output_newentry", "output_insertentry", "output_deleteentry"});
            } else {
                String entryKey = PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey();
                this.initOutputEnttry(entryKey);
            }
        } else if (propertyName.equals(KEY_LANGUAGE)) {
            String callBackId = "switchLanguage";
            ConfirmCallBackListener listener = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u8bed\u8a00", (String)"CodeFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5207\u6362\u8bed\u8a00\u5c06\u6e05\u9664\u5f53\u524d\u4ee3\u7801\u5e76\u66ff\u6362\u4e3a\u76ee\u6807\u8bed\u8a00\u7684\u6a21\u677f", (String)"CodeFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, listener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        try {
            String callBackId = messageBoxClosedEvent.getCallBackId();
            MessageBoxResult callBackResult = messageBoxClosedEvent.getResult();
            if (callBackId.equals("switchLanguage") && callBackResult.equals((Object)MessageBoxResult.Yes)) {
                this.switchLanguage();
            }
        }
        catch (Exception ex) {
            this.getView().showMessage(ex.getMessage());
        }
    }

    private void switchLanguage() {
        String language = this.getModel().getValue(KEY_LANGUAGE).toString();
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        codeEdit.setText(CodeFlowConfigPlugin.assemblyCodeText("", language));
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        CodeAction codeAction = (CodeAction)this.getAction(flow);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        codeAction.setCode(codeEdit.getText());
        codeAction.setEnableParseJson(((Boolean)this.getModel().getValue(KEY_ENABLE_PARSE_JSON)).booleanValue());
        codeAction.setLanguage((String)this.getModel().getValue(KEY_LANGUAGE));
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        Flow flow = this.getFlow();
        CodeAction codeAction = (CodeAction)this.getAction(flow);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        if (!codeEdit.getText().equals(codeAction.getCode())) {
            this.getModel().setDataChanged(true);
        }
        return super.nodeValidate(noteType, nodeId);
    }

    @Override
    public void cacheData(NodeConfigData nodeData) {
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        nodeData.setData(codeEdit.getText());
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    protected boolean needLockParamTypeAfterBind(String entityKey) {
        return false;
    }
}

