/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class CustomOperationFlowConfigPlugin
extends AbstractFlowConfigPlugin<JavaPluginAction> {
    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        JavaPluginAction pluginAction = (JavaPluginAction)this.getAction(flow);
        this.loadOperation(pluginAction);
    }

    private void loadOperation(JavaPluginAction operation) {
        if (operation != null) {
            this.getModel().setValue("servicename", (Object)operation.getServiceName());
            this.getModel().setValue("app", (Object)operation.getApp());
            this.getModel().setValue("action", (Object)operation.getAction());
            this.getModel().setValue("operationtype", (Object)operation.getOperationType());
        }
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.saveCustomOperation(flow);
    }

    private void saveCustomOperation(Flow flow) {
        JavaPluginAction action = (JavaPluginAction)this.getAction(flow);
        String serviceName = this.getModel().getValue("servicename").toString();
        action.setServiceName(serviceName.trim());
        action.setAction(this.getModel().getValue("action").toString());
        action.setOperationType(this.getModel().getValue("operationtype").toString());
        DynamicObject app = (DynamicObject)this.getModel().getValue("app");
        String appid = app == null ? "" : app.getString("number");
        appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
        action.setAppId(appid);
        if (app != null) {
            action.setApp(app.get("id").toString());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("servicename".equals(propertyName) || "app".equals(propertyName)) {
            String className = (String)this.getModel().getValue("servicename");
            DynamicObject app = (DynamicObject)this.getModel().getValue("app");
            if (StringUtils.isNotBlank((CharSequence)className) && app != null) {
                String appid = app.getString("number");
                appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
                try {
                    Map ret = (Map)DispatchServiceHelper.invokeBOSService((String)appid, (String)"IGPTService", (String)"getObject", (Object[])new Object[]{className});
                    this.setOperationType(ret);
                }
                catch (Exception e2) {
                    log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e2), (Throwable)e2);
                }
            }
        }
    }

    private void setOperationType(Map<String, Object> ret) {
        String type;
        String string = type = ret == null ? "" : (String)ret.get("type");
        if ("IGPTFormAction".equals(type)) {
            type = "0";
        } else if ("IGPTAction".equals(type)) {
            type = "1";
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            this.getModel().setValue("operationtype", (Object)type);
        }
    }

    @Override
    protected Optional<String> check() {
        String type;
        String className = (String)this.getModel().getValue("servicename");
        DynamicObject app = (DynamicObject)this.getModel().getValue("app");
        String appid = app == null ? "" : app.getString("number");
        appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
        String action = (String)this.getModel().getValue("action");
        if (app == null) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"OperationFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)className)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u540d\u3002", (String)"OperationFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        Map ret = (Map)DispatchServiceHelper.invokeBOSService((String)appid, (String)"IGPTService", (String)"getObject", (Object[])new Object[]{className});
        int status = ret == null || ret.get("status") == null ? -1 : (Integer)ret.get("status");
        String string = type = ret == null || ret.get("type") == null ? "" : (String)ret.get("type");
        if (status == 0) {
            return Optional.of(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7c7b\u540d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002", (String)"OperationFlowConfigPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        if (status == 1 && StringUtils.isBlank((CharSequence)type)) {
            return Optional.of(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7c7b\u540d\u672a\u5b9e\u73b0\u64cd\u4f5c\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002", (String)"OperationFlowConfigPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        this.setOperationType(ret);
        if (StringUtils.isBlank((CharSequence)action)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u64cd\u4f5c\u540d\u79f0\u3002", (String)"GaiProcessOperationSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        return super.check();
    }

    @Override
    protected boolean needLockParamTypeAfterBind(String entityKey) {
        return false;
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }
}

