/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.PromptTemplateContent;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.builder.ParamPathBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LLMFlowConfigPlugin
extends AbstractFlowConfigPlugin<LLMAction> {
    private static final String KEY_PROMPTINFO = "promptinfo";
    private static final String KEY_USERINPUT_PARAM = "userinput";
    private static final String KEY_DY_REPO = "dyrepo";
    private static final String KEY_SHOWMESSAGE = "showmessage";
    private static final String KEY_MERGE_SHOW = "merge_show";
    private static final String KEY_CUR_TEMPLATE = "currenttemplate";
    private static final String TOOLBAR_PROMPT_CHOOSE = "toolbar_promptchoose";
    private static final String BARKEY_USE_TEMPLATE = "usetemplate";
    private static final String BARKEY_CHANGE_TEMPLATE = "changetemplate";
    private static final String BARKEY_USE_CUSTOMPROMPT = "usecustomprompt";
    private static final String KEY_LLM = "combofield_llm";
    private static final String KEY_USER_PROMPT = "user_prompt";
    private static final String KEY_USER_PROMPT_TAG = "user_prompt_tag";
    private static final String KEY_SYS_PROMPT = "sys_prompt";
    private static final String KEY_SYS_PROMPT_TAG = "sys_prompt_tag";
    private static final String KEY_ENTRYENTITY_VARCONFIG = "var_configs";
    private static final String KEY_ENTRYENTITY_OUTVARCONFIG = "out_var_configs";
    private static final String SELECT_TEMPLATE_CALLBACK_ACTION_ID = "select_template_callback";
    private static final String SEPERATOR = "#";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl(TOOLBAR_PROMPT_CHOOSE);
        toolbar.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{BARKEY_USE_TEMPLATE});
        this.addClickListeners(new String[]{BARKEY_CHANGE_TEMPLATE});
        this.addClickListeners(new String[]{BARKEY_USE_CUSTOMPROMPT});
    }

    @Override
    protected void setComboItem() {
        super.setComboItem();
        RefrenceDataConfig config = this.getReferenceDataConfig(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit userInputEdit = (ComboEdit)this.getControl(KEY_USERINPUT_PARAM);
        userInputEdit.setComboItems(paramItems);
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        ArrayList<String> paramTypeList = new ArrayList<String>(1);
        paramTypeList.add(ParamType.STRING.getDesc());
        config.setAddUserChatHistory(false);
        config.setAddUserInput(false);
        config.setOnlyNodeTypeList(nodeTypeList);
        config.setOnlyParamTypeList(paramTypeList);
        paramItems = this.getComboItem(config);
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_REPO);
        dyRepo.setComboItems(paramItems);
        String id = String.valueOf(this.getFlow().getId());
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROCESS.getId(), (String)id);
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(KEY_LLM);
        llmComboEdit.setComboItems(comboItems);
    }

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        if (PARAM_TREE_INPUT_CONFIG.getEntryEntityKey().equals(entryEntityKey)) {
            return GaiFieldTypeInitUtils.createParamTypeComboItem((ParamType[])new ParamType[]{ParamType.STRING});
        }
        return super.getParamTypeComboItem(entryEntityKey);
    }

    @Override
    protected RefrenceDataConfig getReferenceDataConfig(String entryEntityKey) {
        RefrenceDataConfig referenceDataConfig = super.getReferenceDataConfig(entryEntityKey);
        if (PARAM_TREE_INPUT_CONFIG.getEntryEntityKey().equals(entryEntityKey)) {
            referenceDataConfig.setAddUserInput(true);
            referenceDataConfig.setAddUserChatHistory(true);
        }
        return referenceDataConfig;
    }

    @Override
    public void initData() {
        String userInputVal;
        super.initData();
        Flow flow = this.getFlow();
        LLMAction llmAction = (LLMAction)this.getAction(flow);
        long promptId = llmAction.getLlmPromptId();
        Optional dyRepoParamDefOpt = llmAction.getParamByName("DEFAULT_GROUP", "repoMapper");
        ParamDefinition dyRepoParamDef = dyRepoParamDefOpt.orElse(null);
        Optional userInputParamDefOpt = llmAction.getParamByName("DEFAULT_GROUP", "userInputMapper");
        ParamDefinition userInputParamDef = userInputParamDefOpt.orElse(null);
        if (userInputParamDef != null) {
            NodeParamPath userInputPath = userInputParamDef.getReferencePath();
            if (userInputPath != null) {
                userInputVal = RefrenceParam.getParamValue(userInputPath.getNodeId(), userInputPath.getOutputParamName());
                this.getModel().setValue(KEY_USERINPUT_PARAM, (Object)userInputVal);
            }
        } else {
            this.getModel().setValue(KEY_USERINPUT_PARAM, (Object)RefrenceParam.getParamValue(flow.getStart().getId(), "system.user_input"));
        }
        if (dyRepoParamDef != null) {
            NodeParamPath dyRepoPath = dyRepoParamDef.getReferencePath();
            if (dyRepoPath != null) {
                userInputVal = RefrenceParam.getParamValue(dyRepoPath.getNodeId(), dyRepoPath.getOutputParamName());
                this.getModel().setValue(KEY_DY_REPO, (Object)userInputVal);
            }
        } else {
            this.getModel().setValue(KEY_DY_REPO, null);
        }
        if (promptId != 0L) {
            this.getModel().setValue(KEY_PROMPTINFO, (Object)promptId);
        }
        boolean isStream = llmAction.isStream();
        boolean merge = llmAction.isMergeLastMessageCard();
        this.getModel().setValue(KEY_SHOWMESSAGE, (Object)isStream);
        this.getModel().setValue(KEY_MERGE_SHOW, (Object)merge);
        int promptType = llmAction.getPromptType();
        this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)promptType);
        String llm = llmAction.getLlm();
        if (StringUtils.isNotEmpty((CharSequence)llm)) {
            this.getModel().setValue(KEY_LLM, (Object)llmAction.getLlm());
        }
        PromptTemplateContent promptTemplateContent = llmAction.getPromptTemplateContent();
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        this.getModel().setValue(userTagFieldKey, (Object)promptTemplateContent.getUserPrompt());
        this.getModel().setValue(sysTagFieldKey, (Object)promptTemplateContent.getSysPrompt());
        this.getView().updateView();
    }

    @Override
    public void afterBindData(EventObject e) {
        int promptType;
        Node parentNode;
        super.afterBindData(e);
        Flow flow = this.getFlow();
        Object node = this.getAction(flow);
        int blockNodeId = node.getBlockNodeId();
        if (blockNodeId != -1 && (parentNode = flow.findNodeById(blockNodeId)) instanceof ParallelAction) {
            this.getModel().setValue(KEY_SHOWMESSAGE, (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWMESSAGE});
            this.getModel().setDataChanged(false);
            this.getModel().updateCache();
        }
        this.changeView((promptType = ((Integer)this.getModel().getValue(KEY_CUR_TEMPLATE)).intValue()) != PromptTemplateType.CUSTOM_PROMPT.getCode());
        Boolean ispreset = (Boolean)this.getGaiProcessView().getModel().getValue("ispreset");
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_LLM, KEY_DY_REPO});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PROMPTINFO, "flexpanelap3", KEY_USERINPUT_PARAM, BARKEY_USE_TEMPLATE, BARKEY_CHANGE_TEMPLATE, BARKEY_USE_CUSTOMPROMPT, KEY_USER_PROMPT, KEY_SYS_PROMPT});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_PROMPTINFO.equals(propertyName)) {
            this.fillInputAndOutput();
        }
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.clickGPTPrompt(flow, this.getNodeId());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)SELECT_TEMPLATE_CALLBACK_ACTION_ID)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows.isEmpty()) {
                    return;
                }
                this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)PromptTemplateType.TEMPLATE_PROMPT.getCode());
                Object[] selectPkArr = selectedRows.getPrimaryKeyValues();
                DynamicObject promptTemplateDo = BusinessDataServiceHelper.loadSingle((Object)selectPkArr[0], (String)GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
                String llm = promptTemplateDo.getString("language_model");
                this.getModel().setValue(KEY_LLM, (Object)llm);
                String prompt = promptTemplateDo.getString("prompt");
                String promptTag = promptTemplateDo.getString("prompt_tag");
                this.getModel().setValue(KEY_USER_PROMPT, null);
                this.getModel().setValue(KEY_USER_PROMPT_TAG, null);
                this.getModel().setValue(KEY_SYS_PROMPT, (Object)prompt);
                this.getModel().setValue(KEY_SYS_PROMPT_TAG, (Object)promptTag);
                DynamicObjectCollection inputVarDoColl = promptTemplateDo.getDynamicObjectCollection(KEY_ENTRYENTITY_VARCONFIG);
                String inputEntryKey = PARAM_TREE_INPUT_CONFIG.getEntryEntityKey();
                this.getModel().deleteEntryData(inputEntryKey);
                if (inputVarDoColl != null && !inputVarDoColl.isEmpty()) {
                    this.getModel().batchCreateNewEntryRow(inputEntryKey, inputVarDoColl.size());
                    int rowIndex = 0;
                    for (DynamicObject varDO : inputVarDoColl) {
                        String varName = varDO.getString("var");
                        String varDesc = varDO.getString("var_name");
                        String varType = varDO.getString("var_type");
                        this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getNameKey(), (Object)varName, rowIndex);
                        this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getDescKey(), (Object)varDesc, rowIndex);
                        this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)varType, rowIndex);
                        ++rowIndex;
                    }
                }
                DynamicObjectCollection outputVarDoColl = promptTemplateDo.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTVARCONFIG);
                String outputEntryKey = PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey();
                this.getModel().deleteEntryData(outputEntryKey);
                if (outputVarDoColl != null && !outputVarDoColl.isEmpty()) {
                    this.getModel().batchCreateNewEntryRow(outputEntryKey, outputVarDoColl.size());
                    int rowIndex = 0;
                    for (DynamicObject varDO : outputVarDoColl) {
                        String varName = varDO.getString("out_var");
                        String varDesc = varDO.getString("out_var_name");
                        String varType = varDO.getString("out_var_type");
                        this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), (Object)varName, rowIndex);
                        this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getDescKey(), (Object)varDesc, rowIndex);
                        this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getTypeKey(), (Object)varType, rowIndex);
                        ++rowIndex;
                    }
                }
            }
            this.getView().updateView();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BARKEY_USE_CUSTOMPROMPT)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(itemKey, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u90e8\u5206\u6570\u636e\u4f1a\u88ab\u6e05\u7a7a", (String)"GaiProcessPromptSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BARKEY_CHANGE_TEMPLATE.equals(itemKey) || BARKEY_USE_TEMPLATE.equals(itemKey)) {
            this.showPromptTemplateForm();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "usecustomprompt": {
                    this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)PromptTemplateType.CUSTOM_PROMPT.getCode());
                    this.fillInputAndOutput();
                    this.getView().updateView();
                    break;
                }
                case "usetemplate": 
                case "changetemplate": {
                    this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)PromptTemplateType.TEMPLATE_PROMPT.getCode());
                    this.showPromptTemplateForm();
                }
            }
        }
    }

    @Override
    protected Optional<String> check() {
        int promptType = (Integer)this.getModel().getValue(KEY_CUR_TEMPLATE);
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            if (this.getModel().getValue(KEY_PROMPTINFO) == null) {
                return Optional.of(ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            }
            if (this.getModel().getValue(KEY_USERINPUT_PARAM) == null) {
                return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
            }
        } else {
            String llm = (String)this.getModel().getValue(KEY_LLM);
            if (StringUtils.isEmpty((CharSequence)llm)) {
                return Optional.of(ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
            }
        }
        return super.check();
    }

    public void showPromptTemplateForm() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
        lsp.setFormId("bos_templatetreelistf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        lsp.setMultiSelect(false);
        lsp.setCustomParam("enable", (Object)EnableEnum.YES.getKeyStr());
        lsp.setLookUp(true);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700");
        inlineStyleCss.setWidth("1080");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_TEMPLATE_CALLBACK_ACTION_ID);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        Object curTemplate = this.getModel().getValue(KEY_CUR_TEMPLATE);
        if (PromptTemplateType.CUSTOM_PROMPT.getCode().equals(curTemplate)) {
            map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        } else {
            map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Collections.singletonList(PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        }
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    private void changeView(boolean isUseTemplate) {
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{BARKEY_USE_CUSTOMPROMPT});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{BARKEY_CHANGE_TEMPLATE});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{BARKEY_USE_TEMPLATE});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{"toolbar_input"});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{"toolbar_output"});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{KEY_LLM});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{KEY_USER_PROMPT});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{KEY_SYS_PROMPT});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{KEY_USERINPUT_PARAM});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{KEY_DY_REPO});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{KEY_PROMPTINFO});
    }

    private void clickGPTPrompt(Flow flow, int nodeId) {
        LLMAction llmAction = (LLMAction)flow.findActionById(nodeId);
        int promptType = (Integer)this.getModel().getValue(KEY_CUR_TEMPLATE);
        llmAction.setPromptType(promptType);
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            DynamicObject serviceInfo = (DynamicObject)this.getModel().getValue(KEY_PROMPTINFO);
            if (serviceInfo != null) {
                llmAction.setLlmPromptId(serviceInfo.getLong("id"));
            }
            String userInputParam = (String)this.getModel().getValue(KEY_USERINPUT_PARAM);
            this.buildMapperDef(userInputParam, "userInputMapper").ifPresent(paramDefinition -> llmAction.addParam("DEFAULT_GROUP", paramDefinition));
            String dyRepo = (String)this.getModel().getValue(KEY_DY_REPO);
            this.buildMapperDef(dyRepo, "repoMapper").ifPresent(paramDefinition -> llmAction.addParam("DEFAULT_GROUP", paramDefinition));
        } else {
            Object LLMObject = this.getModel().getValue(KEY_LLM);
            if (LLMObject != null) {
                String llm = (String)LLMObject;
                llmAction.setLlm(llm);
            }
            this.savePromptContent(llmAction);
        }
        boolean showMessage = (Boolean)this.getModel().getValue(KEY_SHOWMESSAGE);
        llmAction.setStream(showMessage);
        boolean mergeShow = (Boolean)this.getModel().getValue(KEY_MERGE_SHOW);
        llmAction.setMergeLastMessageCard(mergeShow);
    }

    private void savePromptContent(LLMAction llmAction) {
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        String userPrompt = (String)this.getModel().getValue(userTagFieldKey);
        String sysPrompt = (String)this.getModel().getValue(sysTagFieldKey);
        PromptTemplateContent promptTemplateContent = new PromptTemplateContent();
        promptTemplateContent.setUserPrompt(userPrompt);
        promptTemplateContent.setSysPrompt(sysPrompt);
        llmAction.setPromptTemplateContent(promptTemplateContent);
    }

    private void fillInputAndOutput() {
        this.getModel().deleteEntryData(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        this.getModel().deleteEntryData(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey());
        DynamicObject serviceInfo = (DynamicObject)this.getModel().getValue(KEY_PROMPTINFO);
        if (serviceInfo != null) {
            DynamicObjectCollection outRows;
            Flow flow = this.getFlow();
            DynamicObjectCollection preRows = serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_VARCONFIG);
            if (preRows != null && !preRows.isEmpty()) {
                ArrayList<ParamDefinition> inputParamDefinitions = new ArrayList<ParamDefinition>(preRows.size());
                for (int i = 0; i < preRows.size(); ++i) {
                    DynamicObject row = (DynamicObject)preRows.get(i);
                    String name = row.getString("var");
                    String type = row.getString("var_type");
                    ParamType paramType = VarParamConverter.convertStringToParamType(type);
                    if (!paramType.isBasic()) {
                        paramType = ParamType.STRING;
                    }
                    BasicParamDefinition basicParamDefinition = new BasicParamDefinition(name, paramType);
                    basicParamDefinition.setDirection(ParamDirection.INPUT);
                    basicParamDefinition.setVisibility(ParamVisibility.PRIVATE);
                    inputParamDefinitions.add((ParamDefinition)basicParamDefinition);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{PARAM_TREE_INPUT_CONFIG.getTypeKey(), PARAM_TREE_INPUT_CONFIG.getNameKey()});
                }
                ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, inputParamDefinitions);
            }
            if ((outRows = serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTVARCONFIG)) != null && !outRows.isEmpty()) {
                ArrayList<ParamDefinition> outputParamDefinitions = new ArrayList<ParamDefinition>(outRows.size());
                for (int i = 0; i < outRows.size(); ++i) {
                    DynamicObject row = (DynamicObject)outRows.get(i);
                    String name = row.getString("out_var");
                    String type = row.getString("out_var_type");
                    ParamType paramType = VarParamConverter.convertStringToParamType(type);
                    if (!paramType.isBasic()) {
                        paramType = ParamType.STRING;
                    }
                    BasicParamDefinition basicParamDefinition = new BasicParamDefinition(name, paramType);
                    basicParamDefinition.setDirection(ParamDirection.OUTPUT);
                    basicParamDefinition.setVisibility(ParamVisibility.PUBLIC);
                    outputParamDefinitions.add((ParamDefinition)basicParamDefinition);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{PARAM_TREE_OUTPUT_CONFIG.getTypeKey(), PARAM_TREE_OUTPUT_CONFIG.getNameKey()});
                }
                ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, outputParamDefinitions);
            }
        }
    }

    private Optional<ParamDefinition> buildMapperDef(String sourceParam, String newParamName) {
        if (StringUtils.isNotBlank((CharSequence)sourceParam)) {
            String[] arr = sourceParam.split(SEPERATOR);
            int selNodeId = Integer.parseInt(arr[0]);
            String param = arr[1];
            BasicParamDefinition paramDefinition = ParamDefinitionBuilder.string((String)newParamName).reference(ParamPathBuilder.builder((String)String.valueOf(selNodeId), (String)param).build()).makePrivate().asInput().build();
            return Optional.of(paramDefinition);
        }
        return Optional.empty();
    }
}

