/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;

public class MessageFlowConfigPlugin
extends AbstractFlowConfigPlugin<MessageAction> {
    private static final String KEY_REPLACE_LAST_MSG = "replace_last_msg";
    private static final String KEY_SAVE_MESSAGE = "savemessage";

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int row = e.getRowDataEntities()[0].getRowIndex();
        String name = this.generateParamName(row + 1);
        this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getNameKey(), (Object)name, row);
        this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)MessageType.Text.getValue(), row);
    }

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        if (PARAM_TREE_INPUT_CONFIG.getEntryEntityKey().equals(entryEntityKey)) {
            return this.createMessageTypeComboItem();
        }
        return super.getParamTypeComboItem(entryEntityKey);
    }

    private List<ComboItem> createMessageTypeComboItem() {
        MessageType[] types = new MessageType[]{MessageType.Text, MessageType.Picture, MessageType.Iframe, MessageType.HyperLink};
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (MessageType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getText()));
                comboItem.setValue(type.getValue());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.MESSAGE_TYPE_INIT_ERROR.getCode(), GaiErrorCode.MESSAGE_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        MessageAction messageAction = (MessageAction)this.getAction(flow);
        boolean replace = this.getModel().getDataEntity().getBoolean(KEY_REPLACE_LAST_MSG);
        boolean saveMessage = this.getModel().getDataEntity().getBoolean(KEY_SAVE_MESSAGE);
        messageAction.setReplaceLastMessage(replace);
        messageAction.setSaveMessage(saveMessage);
    }

    @Override
    protected boolean needLockParamTypeAfterBind(String entityKey) {
        return false;
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    private String generateParamName(int index) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        String name = String.format("message%s", index);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return name;
        }
        List existNams = entryEntity.stream().map(v -> v.getString(PARAM_TREE_INPUT_CONFIG.getNameKey())).collect(Collectors.toList());
        while (existNams.contains(name)) {
            name = String.format("message%s", index++);
        }
        return name;
    }
}

