/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.BillNLQueryAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.QueryEntityConfig;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.common.QueryCommonOperator;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.config.utils.ParamDefinitionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryEntityFlowConfigPlugin
extends AbstractFlowConfigPlugin<BillNLQueryAction>
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QueryEntityFlowConfigPlugin.class);
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String NUMBER = "number";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String LLM = "llm";
    private static final String USER_PROMPT = "user_prompt";
    private static final String SYS_PROMPT = "sys_prompt";
    private static final String QUERY_OBJ_FIELD_SEL = "query_obj_field_sel";
    private static final long FID = 2224086256877330432L;

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar_output", "advcontoolbarap4"});
    }

    @Override
    protected void setComboItem() {
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        String id = String.valueOf(this.getFlow().getId());
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROCESS.getId(), (String)id);
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(LLM);
        llmComboEdit.setComboItems(comboItems);
        List outputItemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(outputItemList);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean ispreset = (Boolean)this.getGaiProcessView().getModel().getValue("ispreset");
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{LLM});
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap", "advconap2", USER_PROMPT, "flexpanelap"});
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        block5: {
            block4: {
                super.beforeDeleteRow(e);
                if (!e.getEntryProp().getName().equals(KEY_ENTRYENTITY_OUTPUT)) break block4;
                for (int i = 0; i < e.getRowIndexs().length; ++i) {
                    String metaData = (String)this.getModel().getValue("metadata_tag");
                    String fullName = ParamDefinitionUtils.getParamFullName(this.getModel().getEntryEntity(e.getEntryProp().getName()), PARAM_TREE_OUTPUT_CONFIG.getNameKey(), e.getRowIndexs()[i]);
                    if (fullName.contains("result.")) {
                        fullName = fullName.substring(7);
                    }
                    if (fullName.equals("filter") || fullName.equals("metaData") || fullName.equals("message") || fullName.equals("count") || fullName.equals("status") || fullName.equals("result")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u662f\u56fa\u5b9a\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"Common_DELETE_1", (String)"ai-gai-plugin", (Object[])new Object[0]), fullName), Integer.valueOf(3000));
                        e.setCancel(true);
                        return;
                    }
                    metaData = QueryCommonOperator.reomveFieldId(metaData, fullName);
                    this.getModel().setValue("metadata_tag", (Object)metaData);
                }
                break block5;
            }
            if (!e.getEntryProp().getName().equals("filter")) break block5;
            for (int i = 0; i < e.getRowIndexs().length; ++i) {
                String filterMetaData = (String)this.getModel().getValue("filtermetadata_tag");
                String fieldName = (String)this.getModel().getEntryRowEntity(e.getEntryProp().getName(), e.getRowIndexs()[i]).get("filtername");
                String newFilterMetaData = QueryCommonOperator.reomveFieldId(filterMetaData, fieldName);
                this.getModel().setValue("filtermetadata_tag", (Object)newFilterMetaData);
            }
        }
    }

    public String checkBill() {
        DynamicObject entityNumber = (DynamicObject)this.getModel().getValue("entitynumber");
        if (entityNumber == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"GaiProcessRepoReplySetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        String validMessage = this.checkBill();
        validMessage = validMessage.length() == 0 ? this.checkLlm() : validMessage;
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setValidMessage(validMessage);
        if (StringUtils.isNotBlank((CharSequence)validMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
        } else {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        }
        return validateInfo;
    }

    public String checkLlm() {
        String llm = (String)this.getModel().getValue(LLM);
        if (StringUtils.isBlank((CharSequence)llm)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bed\u8a00\u6a21\u578b\u3002", (String)"GaiProcessRepoReplySetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    public String queryPromptTemplate(String name) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        String selectFields = "id,name,prompt_tag";
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gai_prompt", (String)selectFields, (QFilter[])qFilters);
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("prompt_tag");
    }

    public String queryPromptTemplate(Long fid) {
        QFilter qFilter = new QFilter("id", "=", (Object)fid);
        String selectFields = "id,name,prompt_tag";
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gai_prompt", (String)selectFields, (QFilter[])qFilters);
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("prompt_tag");
    }

    private void clickQueryEntity(Flow flow) {
        BillNLQueryAction queryEntityAction = (BillNLQueryAction)this.getAction(flow);
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        String sysPrompt = (String)this.getModel().getValue(sysTagFieldKey);
        if (sysPrompt.length() == 0) {
            sysPrompt = this.queryPromptTemplate(2224086256877330432L);
        }
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        String llm = (String)this.getModel().getValue(LLM);
        String userPrompt = (String)this.getModel().getValue(userTagFieldKey);
        if (StringUtils.isEmpty((CharSequence)userPrompt)) {
            userPrompt = (String)this.getModel().getValue(USER_PROMPT);
        }
        if (StringUtils.isEmpty((CharSequence)sysPrompt)) {
            sysPrompt = (String)this.getModel().getValue(SYS_PROMPT);
        }
        QueryEntityConfig queryEntityConfig = new QueryEntityConfig(llm, userPrompt, sysPrompt);
        queryEntityAction.setQueryENtityConfig(queryEntityConfig);
        queryEntityAction.setMetaData((String)this.getModel().getValue("metadata_tag"));
        queryEntityAction.setFilter((String)this.getModel().getValue("filtermetadata_tag"));
        queryEntityAction.setBillId(String.valueOf(this.getEntityPkValue()));
        ArrayList<Var> filterVars = null;
        DynamicObjectCollection filterDoc = this.getModel().getEntryEntity("filter");
        if (filterDoc != null && filterDoc.size() > 0) {
            filterVars = new ArrayList<Var>();
            for (DynamicObject row : filterDoc) {
                String name = row.getString("filtername");
                String type = row.getString("filtertype");
                String desc = row.getString("filterdesc");
                Var var = new Var(name, type, desc);
                filterVars.add(var);
            }
        }
        queryEntityAction.setFilterList(filterVars);
    }

    private Object getEntityPkValue() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue("entitynumber");
        Object entityNumber = null;
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getPkValue();
        }
        return entityNumber;
    }

    private void loadMessage(BillNLQueryAction queryEntityAction) {
        String entityNumber = queryEntityAction.getBillId();
        String metaData = queryEntityAction.getMetaData();
        this.getModel().setValue("metadata_tag", (Object)metaData);
        List filterVars = queryEntityAction.getFilterList();
        EntryType filterEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get("filter");
        this.getModel().getDataEntity(true);
        DynamicObjectCollection filterDoc = this.getModel().getEntryEntity("filter");
        filterDoc.clear();
        if (filterVars != null) {
            for (Var var : filterVars) {
                DynamicObject row = new DynamicObject((DynamicObjectType)filterEntryType);
                row.set("filtername", (Object)var.getName());
                row.set("filtertype", (Object)var.getType());
                row.set("filterdesc", (Object)var.getDesc());
                filterDoc.add((Object)row);
                this.getView().updateView("filter");
            }
        }
        String filterMetadataTag = queryEntityAction.getFilter();
        this.getModel().setValue("filtermetadata_tag", (Object)filterMetadataTag);
        this.getModel().setValue("entitynumber", (Object)entityNumber);
    }

    @Override
    public void initData() {
        List inputParams;
        super.initData();
        Flow flow = this.getFlow();
        BillNLQueryAction queryEntityAction = (BillNLQueryAction)this.getAction(flow);
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        String sysPrompt = (String)this.getModel().getValue(sysTagFieldKey);
        if (sysPrompt.length() == 0) {
            sysPrompt = this.queryPromptTemplate(2224086256877330432L);
            this.getModel().setValue(SYS_PROMPT, (Object)sysPrompt);
            this.getModel().setValue(sysTagFieldKey, (Object)sysPrompt);
        }
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        QueryEntityConfig queryEntityConfig = queryEntityAction.getQueryENtityConfig();
        if (queryEntityConfig != null) {
            this.getModel().setValue(LLM, (Object)queryEntityConfig.getLlm());
            this.getModel().setValue(USER_PROMPT, (Object)queryEntityConfig.getUserPrompt());
            this.getModel().setValue(SYS_PROMPT, (Object)queryEntityConfig.getSysPrompt());
            this.getModel().setValue(sysTagFieldKey, (Object)queryEntityConfig.getSysPrompt());
            this.getModel().setValue(userTagFieldKey, (Object)queryEntityConfig.getUserPrompt());
        }
        if (CollectionUtils.isEmpty((Collection)(inputParams = queryEntityAction.getParamByGroup(queryEntityAction.getInputParamGroup())))) {
            BasicParamDefinition queryParamDefinition = ParamDefinitionBuilder.string((String)"question").asInput().makePrivate().description(ResManager.loadKDString((String)"\u7528\u6237\u7684\u63d0\u95ee", (String)"GaiProcessRepoReplySetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
            ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, Collections.singletonList(queryParamDefinition));
        }
        this.loadMessage(queryEntityAction);
        Boolean ispreset = (Boolean)this.getGaiProcessView().getModel().getValue("ispreset");
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{LLM});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_INPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        }
        if (propertyName.equals(KEY_OUTPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        }
        if (propertyName.equals("entitynumber") && (data = e.getChangeSet()[0]).getNewValue() != null) {
            DynamicObject newEntityNumber = (DynamicObject)data.getNewValue();
            DynamicObject oldEntityNumber = (DynamicObject)data.getOldValue();
            if (newEntityNumber != null && oldEntityNumber != null) {
                if (newEntityNumber.getString(NUMBER).equals(oldEntityNumber.getString(NUMBER))) {
                    return;
                }
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_OUTPUT);
                this.getModel().deleteEntryData("filter");
                this.initEntityFieldData(KEY_ENTRYENTITY_OUTPUT);
            } else if (newEntityNumber != null && oldEntityNumber == null) {
                this.initEntityFieldData(KEY_ENTRYENTITY_OUTPUT);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void itemClick(ItemClickEvent event) {
        super.itemClick(event);
        String key = event.getItemKey();
        if ("addqueryparam".equals(key)) {
            if (this.getEntityNumber().isEmpty()) {
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(QUERY_OBJ_FIELD_SEL);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("metadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectqueryparam"));
            StyleCss css = new StyleCss();
            css.setWidth("80%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        } else if ("addfilterparam".equals(key)) {
            if (this.getEntityNumber().isEmpty()) {
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(QUERY_OBJ_FIELD_SEL);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("filtermetadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "filterqueryparam"));
            StyleCss css = new StyleCss();
            css.setWidth("80%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        }
    }

    private void insertOutputVar(List<PlainField> list) {
        PlainField plainField = new PlainField();
        plainField.setFieldId("result");
        plainField.setFieldName("\u8fd4\u56de\u7684\u7ed3\u679c\u96c6");
        plainField.setFieldType("Array<Object>");
        plainField.setFieldKey("must");
        list.add(plainField);
        PlainField metaPlainField = new PlainField();
        metaPlainField.setFieldId("message");
        metaPlainField.setFieldName("\u6d88\u606f");
        metaPlainField.setFieldType("String");
        metaPlainField.setFieldKey("must");
        list.add(metaPlainField);
        PlainField filterPlainField = new PlainField();
        filterPlainField.setFieldId("filter");
        filterPlainField.setFieldName("\u8fc7\u6ee4\u6761\u4ef6");
        filterPlainField.setFieldType("String");
        filterPlainField.setFieldKey("must");
        list.add(filterPlainField);
        PlainField countPlainField = new PlainField();
        countPlainField.setFieldId("count");
        countPlainField.setFieldName("\u6761\u6570");
        countPlainField.setFieldType("String");
        countPlainField.setFieldKey("must");
        list.add(countPlainField);
        PlainField statusPlainField = new PlainField();
        statusPlainField.setFieldId("status");
        statusPlainField.setFieldName("\u6210\u529f/\u5931\u8d25");
        statusPlainField.setFieldType("Boolean");
        statusPlainField.setFieldKey("must");
        list.add(statusPlainField);
        PlainField metaDataPlainField = new PlainField();
        metaDataPlainField.setFieldId("metaData");
        metaDataPlainField.setFieldName("\u5143\u6570\u636e");
        metaDataPlainField.setFieldType("String");
        metaDataPlainField.setFieldKey("must");
        list.add(metaDataPlainField);
    }

    private String getEntityNumber() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue("entitynumber");
        String entityNumber = "";
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getString(NUMBER);
        }
        return entityNumber;
    }

    private void initEntityFieldData(String type) {
        String entityNumber = this.getEntityNumber();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        String modelStr = (String)this.getModel().getValue("metadata_tag");
        List<PlainField> allPlainFieldList = QueryCommonOperator.getPlainFieldListFromMetadata(entityNumber, modelStr);
        String filterModelStr = (String)this.getModel().getValue("filtermetadata_tag");
        List<PlainField> allFilterPlainFieldList = QueryCommonOperator.getPlainFieldListFromMetadata(entityNumber, filterModelStr);
        if (type.equals(KEY_ENTRYENTITY_OUTPUT)) {
            this.insertOutputVar(allPlainFieldList);
            int size = allPlainFieldList.size();
            if (size > 0) {
                PlainField plainField;
                IDataModel dataModel = this.getModel();
                DynamicObjectCollection output = dataModel.getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
                ArrayList<PlainField> outputList = new ArrayList<PlainField>();
                for (DynamicObject dyn : output) {
                    plainField = new PlainField();
                    plainField.setFieldId(dyn.getString(KEY_OUTPUT_NAME));
                    plainField.setFieldName(dyn.getString(KEY_OUTPUT_DESC));
                    plainField.setFieldType(dyn.getString(KEY_OUTPUT_TYPE));
                    outputList.add(plainField);
                }
                ArrayList<PlainField> filterOutputList = new ArrayList<PlainField>();
                for (int i = 0; i < allPlainFieldList.size(); ++i) {
                    plainField = allPlainFieldList.get(i);
                    if (outputList.stream().filter(e -> e.getFieldId().equals(plainField.getFieldId())).count() == 0L) {
                        filterOutputList.add(plainField);
                        continue;
                    }
                    for (int j = 0; j < outputList.size(); ++j) {
                        if (!((PlainField)outputList.get(j)).getFieldId().equalsIgnoreCase(plainField.getFieldId())) continue;
                        ((PlainField)outputList.get(j)).setFieldKey("must");
                        PlainField field = (PlainField)outputList.get(j);
                        filterOutputList.add(field);
                    }
                }
                ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(this.getFlow(), ParamDefinitionUtils.convertPlainFieldToParamDefinition(allPlainFieldList));
            }
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        } else {
            IDataModel dataModel;
            int size;
            if (allPlainFieldList.size() == 0) {
                this.insertOutputVar(allPlainFieldList);
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_OUTPUT);
                size = allPlainFieldList.size();
                if (size > 0) {
                    dataModel = this.getModel();
                    dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY_OUTPUT, size);
                    for (int i = 0; i < allPlainFieldList.size(); ++i) {
                        PlainField plainField = allPlainFieldList.get(i);
                        dataModel.setValue(KEY_OUTPUT_DESC, (Object)plainField.getFieldName(), i);
                        dataModel.setValue(KEY_OUTPUT_NAME, (Object)plainField.getFieldId(), i);
                        dataModel.setValue(KEY_OUTPUT_TYPE, (Object)plainField.getFieldType(), i);
                    }
                }
                this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
            }
            if ((size = allFilterPlainFieldList.size()) > 0) {
                int i;
                QueryCommonOperator.Field plainField;
                dataModel = this.getModel();
                DynamicObjectCollection input = dataModel.getEntryEntity("filter");
                ArrayList<QueryCommonOperator.Field> inputList = new ArrayList<QueryCommonOperator.Field>();
                for (DynamicObject dyn : input) {
                    plainField = new QueryCommonOperator.Field();
                    plainField.setFieldId(dyn.getString("filtername"));
                    plainField.setFieldName(dyn.getString("filterdesc"));
                    plainField.setFieldType(dyn.getString("filtertype"));
                    inputList.add(plainField);
                }
                ArrayList<QueryCommonOperator.Field> filterinputList = new ArrayList<QueryCommonOperator.Field>();
                for (i = 0; i < allFilterPlainFieldList.size(); ++i) {
                    plainField = allFilterPlainFieldList.get(i);
                    if (inputList.stream().filter(arg_0 -> QueryEntityFlowConfigPlugin.lambda$initEntityFieldData$1((PlainField)plainField, arg_0)).count() == 0L) {
                        QueryCommonOperator.Field field = new QueryCommonOperator.Field();
                        field.setFieldId(plainField.getFieldId());
                        field.setFieldName(plainField.getFieldName());
                        field.setFieldType(plainField.getFieldType());
                        filterinputList.add(field);
                        continue;
                    }
                    for (int j = 0; j < inputList.size(); ++j) {
                        if (!((QueryCommonOperator.Field)inputList.get(j)).getFieldId().equalsIgnoreCase(plainField.getFieldId())) continue;
                        QueryCommonOperator.Field field = (QueryCommonOperator.Field)inputList.get(j);
                        filterinputList.add(field);
                    }
                }
                this.getModel().deleteEntryData("filter");
                dataModel.batchCreateNewEntryRow("filter", filterinputList.size());
                for (i = 0; i < filterinputList.size(); ++i) {
                    plainField = (QueryCommonOperator.Field)filterinputList.get(i);
                    dataModel.setValue("filterdesc", (Object)plainField.getFieldName(), i);
                    dataModel.setValue("filtername", (Object)plainField.getFieldId(), i);
                    dataModel.setValue("filtertype", (Object)plainField.getFieldType(), i);
                }
            } else {
                this.getModel().deleteEntryData("filter");
            }
            this.getView().updateView("filter");
        }
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.clickQueryEntity(flow);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    private void updateBizObjValue(String entityNumber) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter(NUMBER, "=", (Object)entityNumber).toArray());
            this.getModel().setValue(ENTITY_NUMBER, (Object)bosEntityobject);
            this.getView().updateView(ENTITY_NUMBER);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"selectqueryparam")) {
            JSONObject dataJo2;
            if (returnData != null && (dataJo2 = QueryCommonOperator.parseObj(returnData)) != null) {
                String entityNumber = dataJo2.getString(ENTITY_NUMBER);
                this.updateBizObjValue(entityNumber);
                String metadataTag = dataJo2.getString("metadata_tag");
                this.getModel().setValue("metadata_tag", (Object)metadataTag);
                this.initEntityFieldData(KEY_ENTRYENTITY_OUTPUT);
            }
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"filterqueryparam") && returnData != null && (dataJo = QueryCommonOperator.parseObj(returnData)) != null) {
            String entityNumber = dataJo.getString(ENTITY_NUMBER);
            this.updateBizObjValue(entityNumber);
            String metadataTag = dataJo.getString("metadata_tag");
            this.getModel().setValue("filtermetadata_tag", (Object)metadataTag);
            this.initEntityFieldData("filter");
        }
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    private static /* synthetic */ boolean lambda$initEntityFieldData$1(PlainField plainField, QueryCommonOperator.Field e) {
        return e.getFieldId().equals(plainField.getFieldId());
    }
}

