/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RetrievalConfig;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.enuz.repo.SelectRepoTypeEnum;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.builder.ParamPathBuilder;
import kd.ai.gai.core.flow.param.converter.ParamDefinitionConverterUtil;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.repo.result.DocumentRepoResult;
import kd.ai.gai.core.repo.result.MetaRepoResult;
import kd.ai.gai.core.repo.result.StructuredRepoResult;
import kd.ai.gai.core.repo.result.UniversalRepoResult;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Tab;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class RepoFlowConfigPlugin
extends AbstractFlowConfigPlugin<RepoAction> {
    private static final String KEY_ENTRYENTITY_REPO = "repo";
    private static final String KEY_ENTRYENTITY_STRUCTURE = "structure";
    private static final String KEY_TAB_REPO = "tabrepo";
    private static final String KEY_TAB_PAGE_SELECT = "tabpageselect";
    private static final String KEY_TAB_PAGE_DYNAMIC = "tabpagedynamic";
    private static final String KEY_TAB_PAGE_STRUCTURE = "tabpagestructure";
    private static final String KEY_TAB_PAGE_META = "tabpagemeta";
    private static final String KEY_TAB_PAGE_UNIVERSAL = "tabpageuniversal";
    private static final String KEY_TAB_PAGE_DYNAMIC_UNIVERSAL = "tabpagedynamicuniversal";
    private static final String KEY_TOOL_BAR_SELECT_REPO = "advcontoolbarselectrepo";
    private static final String KEY_MODE = "mode";
    private static final String KEY_UNIVERSAL_MODE = "universalmode";
    private static final String KEY_SELECT_REPO_TYPE = "selectrepotype";
    private static final String KEY_DY_REPO = "dyrepo";
    private static final String KEY_META_REPO = "metarepo";
    private static final String KEY_UNIVERSAL_REPO = "universalrepo";
    private static final String KEY_DY_STRUCTURE = "structure";
    private static final String KEY_DY_UNIVERSAL_REPO = "dyuniversalrepo";
    private static final String SEPERATOR = "#";
    private static final String MODE = "mode";
    private static final String RE_RANK = "rerank";
    private static final String RE_RANK_MODEL_LIST = "rerankmodellist";
    private static final String TOPK = "topk";
    private static final String SIMILARITY = "similarity";
    private static final String REPOID = "repoid";
    private static final String KEY_STRUCTURE_REPO_ENABLE = "structure_repo_enable";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit repo = (BasedataEdit)this.getControl(KEY_META_REPO);
        repo.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("modeltype", (Object)"KMModel");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("bizappid.number", "!=", (Object)"tpl"));
            evt.setCustomQFilters(qFilters);
        });
    }

    @Override
    protected void setComboItem() {
        super.setComboItem();
        RefrenceDataConfig referenceDataConfig = this.getReferenceDataConfig(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        ArrayList<String> paramTypeList = new ArrayList<String>(1);
        paramTypeList.add(VarFieldType.STRING.getType());
        referenceDataConfig.setAddUserInput(false);
        referenceDataConfig.setOnlyNodeTypeList(nodeTypeList);
        referenceDataConfig.setOnlyParamTypeList(paramTypeList);
        List<ComboItem> paramItems = this.getComboItem(this.getReferenceDataConfig(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey()));
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_REPO);
        dyRepo.setComboItems(paramItems);
        this.setDyUniversalComboItems();
    }

    @Override
    protected RefrenceDataConfig getReferenceDataConfig(String entryEntityKey) {
        RefrenceDataConfig referenceDataConfig = super.getReferenceDataConfig(entryEntityKey);
        referenceDataConfig.setAddUserChatHistory(false);
        return referenceDataConfig;
    }

    @Override
    public void initData() {
        super.initData();
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        if (CollectionUtils.isEmpty((Collection)inputDoc)) {
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getNameKey(), (Object)"query");
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)ParamType.STRING.getDesc());
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getDescKey(), (Object)ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u68c0\u7d22\u5165\u53c2", (String)"GaiProcessKnowledgeSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        Flow flow = this.getFlow();
        RepoAction repoAction = (RepoAction)this.getAction(flow);
        String repoType = repoAction.getRepoType();
        this.getModel().setValue(KEY_SELECT_REPO_TYPE, (Object)repoType);
        this.handleRepoTypeChange(flow, repoType, true);
        RetrievalConfig retrievalConfig = repoAction.getRetrievalConfig();
        if (retrievalConfig != null) {
            this.getModel().setValue("mode", (Object)retrievalConfig.getMode());
            this.getModel().setValue(KEY_UNIVERSAL_MODE, (Object)retrievalConfig.getMode());
            this.getModel().setValue(TOPK, (Object)retrievalConfig.getTopK());
            this.getModel().setValue(SIMILARITY, (Object)Float.valueOf(retrievalConfig.getSimilarity()));
            this.getModel().setValue(RE_RANK, (Object)retrievalConfig.isReRank());
            this.getModel().setValue(RE_RANK_MODEL_LIST, (Object)retrievalConfig.getRerankModelNumber());
        }
        this.initRerankList();
        List<ParamDefinition> outputParams = repoAction.getParamByGroup(repoAction.getOutputParamGroup());
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            outputParams = RepoFlowConfigPlugin.buildOutputTreeView(repoAction.getRepoType());
            ParamTreeLoader.create(ParamTreeConfig.createOutputConfig(), this.getView(), this.getModel()).loadTreeData(flow, outputParams);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"input_mustinput"});
        this.knowledgeVersionSwitch();
        Flow flow = this.getFlow();
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        this.knowledgeTypeSwitch(flow, repoType);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_SELECT_REPO_TYPE.equals(propertyName)) {
            Flow flow = this.getFlow();
            String repoType = (String)e.getChangeSet()[0].getNewValue();
            this.knowledgeTypeSwitch(flow, repoType);
        }
        if (KEY_UNIVERSAL_MODE.equals(propertyName)) {
            String universalMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
            if (StringUtils.equals((CharSequence)universalMode, (CharSequence)"TEXT_QA")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SIMILARITY});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SIMILARITY});
            }
        }
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        RepoAction repoAction = (RepoAction)this.getAction(flow);
        this.saveInputData(repoAction);
    }

    @Override
    protected Optional<String> check() {
        String validMessage = this.checkUniversalRepo();
        if (StringUtils.isBlank((CharSequence)validMessage)) {
            validMessage = this.checkRerankModel();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)validMessage)) {
            return Optional.of(validMessage);
        }
        return super.check();
    }

    public void setDyUniversalComboItems() {
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        nodeTypeList.add(ProcessNodeType.Start);
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserChatHistory(false);
        config.setAddUserInput(false);
        config.setOnlyNodeTypeList(nodeTypeList);
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_UNIVERSAL_REPO);
        dyRepo.setComboItems(paramItems);
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        return map;
    }

    private void knowledgeTypeSwitch(Flow flow, String repoType) {
        this.handleRepoTypeChange(flow, repoType, false);
        ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, RepoFlowConfigPlugin.buildOutputTreeView(repoType));
    }

    private void handleRepoTypeChange(Flow flow, String repoType, boolean loadData) {
        Tab tab = (Tab)this.getControl(KEY_TAB_REPO);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SIMILARITY});
        boolean isToolbarVisible = !loadData;
        this.getView().setVisible(Boolean.valueOf(isToolbarVisible), new String[]{KEY_TOOL_BAR_SELECT_REPO});
        if (StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            tab.activeTab(KEY_TAB_PAGE_SELECT);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mode"});
            if (loadData) {
                DynamicObject[] doArr;
                RepoAction repoAction = (RepoAction)this.getAction(flow);
                List repoList = repoAction.getRepoList();
                if (CollectionUtils.isNotEmpty((Collection)repoList) && (doArr = BusinessDataServiceHelper.load((Object[])repoAction.getRepoList().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_REPO_INFO.getId()).getDynamicObjectType())).length > 0) {
                    this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY_REPO, doArr.length);
                    for (int i = 0; i < doArr.length; ++i) {
                        this.getModel().setValue(REPOID, (Object)doArr[i], i);
                    }
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_TOOL_BAR_SELECT_REPO});
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            RepoAction repoAction;
            Long structureId;
            tab.activeTab(KEY_TAB_PAGE_STRUCTURE);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
            if (loadData && (structureId = (repoAction = (RepoAction)this.getAction(flow)).getStructureId()) != null) {
                this.getModel().setValue("structure", (Object)structureId);
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            RepoAction repoAction;
            Optional repoMapperDef;
            tab.activeTab(KEY_TAB_PAGE_DYNAMIC);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mode"});
            if (loadData && (repoMapperDef = (repoAction = (RepoAction)this.getAction(flow)).getParamByName("DEFAULT_GROUP", "repoMapper")).isPresent()) {
                String dynRepoValue = RefrenceParam.getParamValue(((ParamDefinition)repoMapperDef.get()).getReferencePath().getNodeId(), ((ParamDefinition)repoMapperDef.get()).getReferencePath().getOutputParamName());
                this.getModel().setValue(KEY_DY_REPO, (Object)dynRepoValue);
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            RepoAction repoAction;
            List metaId;
            tab.activeTab(KEY_TAB_PAGE_META);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
            if (loadData && (metaId = (repoAction = (RepoAction)this.getAction(flow)).getMetaIdList()) != null) {
                this.getModel().setValue(KEY_META_REPO, (Object)metaId.toArray());
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            RepoAction repoAction;
            List universalIdStrList;
            this.activeUniversalRepoTab(tab);
            if (loadData && (universalIdStrList = (repoAction = (RepoAction)this.getAction(flow)).getUniversalIdList()) != null) {
                List universalIdList = universalIdStrList.stream().map(Long::valueOf).collect(Collectors.toList());
                this.getModel().setValue(KEY_UNIVERSAL_REPO, (Object)universalIdList.toArray());
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            RepoAction repoAction;
            Optional universalRepoMapperDef;
            this.activeDyUniversalRepoTab(tab);
            if (loadData && (universalRepoMapperDef = (repoAction = (RepoAction)this.getAction(flow)).getParamByName("DEFAULT_GROUP", "universalRepoMapper")).isPresent()) {
                String dynUniversalRepoValue = RefrenceParam.getParamValue(((ParamDefinition)universalRepoMapperDef.get()).getReferencePath().getNodeId(), ((ParamDefinition)universalRepoMapperDef.get()).getReferencePath().getOutputParamName());
                this.getModel().setValue(KEY_DY_UNIVERSAL_REPO, (Object)dynUniversalRepoValue);
            }
        }
    }

    private void knowledgeVersionSwitch() {
        ComboEdit repoTypeComboEdit = (ComboEdit)this.getControl(KEY_SELECT_REPO_TYPE);
        List<ComboItem> comboItemList = this.getSelectRepoTypeComboItems();
        repoTypeComboEdit.setComboItems(comboItemList);
        if (CollectionUtils.isNotEmpty(comboItemList)) {
            String savedRepoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
            Set comboItemValueSet = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            if (savedRepoType == null || !comboItemValueSet.contains(savedRepoType)) {
                this.getModel().setValue(KEY_SELECT_REPO_TYPE, (Object)comboItemList.get(0).getValue());
                this.getView().updateView(KEY_SELECT_REPO_TYPE);
            }
        }
    }

    private List<ComboItem> getSelectRepoTypeComboItems() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        for (SelectRepoTypeEnum typeEnum : SelectRepoTypeEnum.values()) {
            boolean isOldKnowledge;
            ComboItem comboItem = new ComboItem(new LocaleString(typeEnum.getName()), typeEnum.getId());
            boolean bl = isOldKnowledge = typeEnum == SelectRepoTypeEnum.SELECT || typeEnum == SelectRepoTypeEnum.DYNAMIC;
            if (!RepoService.isUsingOldKnowledge() && isOldKnowledge) continue;
            comboItemList.add(comboItem);
        }
        if (this.structureRepoEnable()) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93", (String)"SelectRepoTypeEnum_2", (String)"ai-gai-core", (Object[])new Object[0])), "structure"));
        }
        return comboItemList;
    }

    private boolean structureRepoEnable() {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter("name", "=", (Object)KEY_STRUCTURE_REPO_ENABLE).toArray());
        if (configs.length > 0) {
            String value = configs[0].getString("value");
            String valueTag = configs[0].getString("value_tag");
            String paramValue = kd.bos.util.StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
            return "1".equalsIgnoreCase(paramValue);
        }
        return false;
    }

    private static List<ParamDefinition> buildOutputTreeView(String repoType) {
        ParamDefinition repoItemParamDef;
        String itemParamName = "item";
        switch (repoType) {
            case "select": 
            case "dynamic": {
                repoItemParamDef = ParamDefinitionConverterUtil.fromAnnotatedJavaBean((Class)new DocumentRepoResult().getItemsClass(), (String)itemParamName);
                break;
            }
            case "structure": {
                repoItemParamDef = ParamDefinitionConverterUtil.fromAnnotatedJavaBean((Class)new StructuredRepoResult().getItemsClass(), (String)itemParamName);
                break;
            }
            case "meta": {
                repoItemParamDef = ParamDefinitionConverterUtil.fromAnnotatedJavaBean((Class)new MetaRepoResult().getItemsClass(), (String)itemParamName);
                break;
            }
            case "universal": 
            case "dynamic_universal": {
                repoItemParamDef = ParamDefinitionConverterUtil.fromAnnotatedJavaBean((Class)new UniversalRepoResult().getItemsClass(), (String)itemParamName);
                break;
            }
            default: {
                throw new KDBizException(Errors.notSupportRepoType((String)repoType), new Object[0]);
            }
        }
        return Collections.singletonList(ParamDefinitionBuilder.array((String)"outputList", (ParamDefinition)repoItemParamDef).asOutput().makePublic().description("\u77e5\u8bc6\u5e93\u8f93\u51fa").build());
    }

    private void activeUniversalRepoTab(Tab tab) {
        tab.activeTab(KEY_TAB_PAGE_UNIVERSAL);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
        String universalMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        if (StringUtils.equals((CharSequence)universalMode, (CharSequence)"TEXT_QA")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SIMILARITY});
        }
        this.initRerankList();
    }

    private void activeDyUniversalRepoTab(Tab tab) {
        tab.activeTab(KEY_TAB_PAGE_DYNAMIC_UNIVERSAL);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
        String universalMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        if (StringUtils.equals((CharSequence)universalMode, (CharSequence)"TEXT_QA")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SIMILARITY});
        }
        this.initRerankList();
    }

    private String checkUniversalRepo() {
        MulBasedataDynamicObjectCollection universalColl;
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        if (StringUtils.equals((CharSequence)repoType, (CharSequence)"universal") && ((universalColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_UNIVERSAL_REPO)) == null || universalColl.isEmpty())) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u901a\u7528\u77e5\u8bc6\u5e93\u3002", (String)"GaiProcessRepoSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkRerankModel() {
        Boolean reRank = (Boolean)this.getModel().getValue(RE_RANK);
        String rerankModelNumber = (String)this.getModel().getValue(RE_RANK_MODEL_LIST);
        if (reRank.booleanValue() && StringUtils.isBlank((CharSequence)rerankModelNumber)) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u91cd\u6392\u5e8f\u6a21\u578b\u3002", (String)"GaiProcessRepoSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void saveInputData(RepoAction repoAction) {
        String dyRepo;
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        repoAction.setRepoType(repoType);
        Boolean reRank = (Boolean)this.getModel().getValue(RE_RANK);
        repoAction.setReRank(reRank.booleanValue());
        String mode = (String)this.getModel().getValue("mode");
        if (StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            DynamicObjectCollection repoDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_REPO);
            if (repoDoc != null) {
                ArrayList<Long> reopList = new ArrayList<Long>();
                for (DynamicObject row : repoDoc) {
                    if (null == row.getDynamicObject(2)) continue;
                    reopList.add((Long)row.getDynamicObject(2).getPkValue());
                }
                repoAction.setRepoList(reopList);
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            DynamicObject structure = (DynamicObject)this.getModel().getValue("structure");
            if (structure != null) {
                repoAction.setStructureId((Long)structure.get("id"));
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            dyRepo = (String)this.getModel().getValue(KEY_DY_REPO);
            this.buildMapperDef(dyRepo, "repoMapper").ifPresent(paramDefinition -> repoAction.addParam("DEFAULT_GROUP", paramDefinition));
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            MulBasedataDynamicObjectCollection metas = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_META_REPO);
            if (metas != null && !metas.isEmpty()) {
                ArrayList<String> metaIdList = new ArrayList<String>();
                for (DynamicObject dynamicObject : metas) {
                    metaIdList.add((String)dynamicObject.getDynamicObject("fbasedataid").getPkValue());
                }
                repoAction.setMetaIdList(metaIdList);
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            repoAction.setReRank(reRank.booleanValue());
            MulBasedataDynamicObjectCollection universalColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_UNIVERSAL_REPO);
            if (universalColl != null && !universalColl.isEmpty()) {
                ArrayList<String> universalIdList = new ArrayList<String>();
                for (DynamicObject dynamicObject : universalColl) {
                    universalIdList.add(String.valueOf(dynamicObject.getDynamicObject("fbasedataid").getPkValue()));
                }
                repoAction.setUniversalIdList(universalIdList);
            }
            mode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            dyRepo = (String)this.getModel().getValue(KEY_DY_UNIVERSAL_REPO);
            this.buildMapperDef(dyRepo, "universalRepoMapper").ifPresent(paramDefinition -> repoAction.addParam("DEFAULT_GROUP", paramDefinition));
            mode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        }
        BigDecimal topK = (BigDecimal)this.getModel().getValue(TOPK);
        BigDecimal similarity = (BigDecimal)this.getModel().getValue(SIMILARITY);
        reRank = (Boolean)this.getModel().getValue(RE_RANK);
        reRank = reRank != null && reRank != false;
        String rerankModelNumber = (String)this.getModel().getValue(RE_RANK_MODEL_LIST);
        RetrievalConfig retrievalConfig = new RetrievalConfig(mode, topK.intValue(), similarity.floatValue(), reRank.booleanValue(), rerankModelNumber);
        repoAction.setRetrievalConfig(retrievalConfig);
    }

    private void initRerankList() {
        ComboEdit rerankComboEdit = (ComboEdit)this.getView().getControl(RE_RANK_MODEL_LIST);
        List rerankComboItemList = GaiFieldTypeInitUtils.createRerankComboItem();
        if (!rerankComboItemList.isEmpty()) {
            rerankComboEdit.setComboItems(rerankComboItemList);
            String rerankModelNumber = (String)this.getModel().getValue(RE_RANK_MODEL_LIST);
            Set rerankNumberSet = rerankComboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            if (StringUtils.isBlank((CharSequence)rerankModelNumber) || !rerankNumberSet.contains(rerankModelNumber)) {
                this.getModel().setValue(RE_RANK_MODEL_LIST, (Object)((ComboItem)rerankComboItemList.get(0)).getValue());
            }
        } else {
            rerankComboEdit.setComboItems(null);
            this.getModel().setValue(RE_RANK_MODEL_LIST, null);
        }
    }

    private Optional<ParamDefinition> buildMapperDef(String sourceParam, String newParamName) {
        if (StringUtils.isNotBlank((CharSequence)sourceParam)) {
            String[] arr = sourceParam.split(SEPERATOR);
            int selNodeId = Integer.parseInt(arr[0]);
            String param = arr[1];
            BasicParamDefinition paramDefinition = ParamDefinitionBuilder.string((String)newParamName).reference(ParamPathBuilder.builder((String)String.valueOf(selNodeId), (String)param).build()).makePrivate().asInput().build();
            return Optional.of(paramDefinition);
        }
        return Optional.empty();
    }
}

