/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.RepoReplyConfig;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.util.CollectionUtils;

public class RepoReplyFlowConfigPlugin
extends AbstractFlowConfigPlugin<RepoReplyAction> {
    private static final String KEY_TAB_REPO = "tabrepo";
    private static final String KEY_TAB_PAGE_SELECT = "tabpageselect";
    private static final String KEY_TAB_PAGE_DYNAMIC = "tabpagedynamic";
    private static final String KEY_TOOL_BAR_SELECT_REPO = "advcontoolbarselectrepo";
    private static final String KEY_RADIOGROUP_REPO = "radiogrouprepo";
    private static final String LLM = "llm";
    private static final String USER_PROMPT = "user_prompt";
    private static final String SYS_PROMPT = "sys_prompt";
    private static final String REFERENCE = "reference";
    private static final String SHOW_MESSAGE = "showmessage";
    private static final String ENABLE_CHAT_MSG = "enable_chat_msg";
    private static final String REMEMBER_COUNT = "remember_count";

    @Override
    protected void setComboItem() {
        super.setComboItem();
        String id = String.valueOf(this.getFlow().getId());
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROCESS.getId(), (String)id);
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(LLM);
        llmComboEdit.setComboItems(comboItems);
    }

    @Override
    protected List<ComboItem> getParamTypeComboItem(String entryEntityKey) {
        if (PARAM_TREE_INPUT_CONFIG.getEntryEntityKey().equals(entryEntityKey)) {
            return GaiFieldTypeInitUtils.createParamTypeComboItem((ParamType[])new ParamType[]{ParamType.STRING});
        }
        return super.getParamTypeComboItem(entryEntityKey);
    }

    @Override
    public void afterBindData(EventObject e) {
        Node parentNode;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"input_mustinput"});
        Flow flow = this.getFlow();
        Object node = this.getAction(flow);
        int blockNodeId = node.getBlockNodeId();
        if (blockNodeId != -1 && (parentNode = flow.findNodeById(blockNodeId)) instanceof ParallelAction) {
            this.getModel().setValue(SHOW_MESSAGE, (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_MESSAGE});
            this.getModel().setDataChanged(false);
            this.getModel().updateCache();
        }
        boolean enableChatMsg = (Boolean)this.getModel().getValue(ENABLE_CHAT_MSG);
        this.getView().setEnable(Boolean.valueOf(enableChatMsg), new String[]{REMEMBER_COUNT});
        Boolean ispreset = (Boolean)this.getGaiProcessView().getModel().getValue("ispreset");
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{LLM});
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap", SYS_PROMPT, USER_PROMPT, REFERENCE, SHOW_MESSAGE});
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)ParamType.STRING.getDesc(), rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    @Override
    public void initData() {
        List outputParams;
        super.initData();
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        Flow flow = this.getFlow();
        RepoReplyAction repoReplyAction = (RepoReplyAction)this.getAction(flow);
        RepoReplyConfig repoReplyConfig = repoReplyAction.getRepoReplyConfig();
        if (repoReplyConfig != null) {
            this.getModel().setValue(LLM, (Object)repoReplyConfig.getLlm());
            this.getModel().setValue(sysTagFieldKey, (Object)repoReplyConfig.getSysPrompt());
            this.getModel().setValue(userTagFieldKey, (Object)repoReplyConfig.getUserPrompt());
            this.getModel().setValue(REFERENCE, (Object)repoReplyConfig.isReference());
            this.getModel().setValue(SHOW_MESSAGE, (Object)repoReplyConfig.isShowMessage());
            this.getModel().setValue(ENABLE_CHAT_MSG, (Object)repoReplyConfig.isEnableChatMsg());
            this.getModel().setValue(REMEMBER_COUNT, (Object)repoReplyConfig.getRememberCount());
        } else {
            String sysTagValue = ResManager.loadKDString((String)"#\u4f60\u662f\u4e00\u4e2a\u77e5\u8bc6\u95ee\u7b54\u52a9\u624b\uff0c\u8bf7\u4e25\u683c\u4f9d\u636e\u63d0\u4f9b\u7684\u77e5\u8bc6\uff0c\u51c6\u786e\u3001\u7b80\u6d01\u5730\u56de\u7b54\u7528\u6237\u95ee\u9898\uff0c\u8bf7\u4e0d\u8981\u7f16\u9020\u5e7b\u60f3\u3002\u5982\u679c\u4f60\u65e0\u6cd5\u4ece\u63d0\u4f9b\u7684\u77e5\u8bc6\u4e2d\u5f97\u51fa\u7b54\u6848\uff0c\u8bf7\u56de\u590d\u201c\u4e0d\u77e5\u9053\u201d\u3002", (String)"GaiProcessRepoReplySetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            if (!RequestContext.get().getLang().getLangTag().equals("zh-CN")) {
                sysTagValue = "#You are a knowledge question answering assistant. Please strictly follow the knowledge provided to answer user questions accurately and concisely. Please do not make up fantasies. If you cannot get the answer from the knowledge provided, please reply \"I don't know\".";
            }
            this.getModel().setValue(sysTagFieldKey, (Object)sysTagValue);
            String userTagValue = ResManager.loadKDString((String)"#\u8fd9\u662f\u7528\u6237\u7684\u63d0\u95ee: {{question}} #\u8fd9\u662f\u548c\u7528\u6237\u63d0\u95ee\u6700\u76f8\u5173\u7684\u7684\u77e5\u8bc6: {{retrievalContent}}", (String)"GaiProcessRepoReplySetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
            if (!RequestContext.get().getLang().getLangTag().equals("zh-CN")) {
                userTagValue = "#This is the user's question: { {question} } #This is the knowledge most relevant to the user's question: { {retrievalContent} }";
            }
            this.getModel().setValue(userTagFieldKey, (Object)userTagValue);
        }
        this.getView().setEnable((Boolean)this.getModel().getValue(ENABLE_CHAT_MSG), new String[]{REMEMBER_COUNT});
        List inputParams = repoReplyAction.getParamByGroup(repoReplyAction.getInputParamGroup());
        if (CollectionUtils.isEmpty((Collection)inputParams)) {
            BasicParamDefinition queryParamDefinition = ParamDefinitionBuilder.string((String)"question").asInput().makePrivate().description(ResManager.loadKDString((String)"\u7528\u6237\u7684\u63d0\u95ee", (String)"RepoReplyFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
            BasicParamDefinition ragParamDefinition = ParamDefinitionBuilder.string((String)"retrievalContent").asInput().makePrivate().description(ResManager.loadKDString((String)"\u53ec\u56de\u5185\u5bb9", (String)"RepoReplyFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0])).build();
            ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, Arrays.asList(queryParamDefinition, ragParamDefinition));
        }
        if (CollectionUtils.isEmpty((Collection)(outputParams = repoReplyAction.getParamByGroup(repoReplyAction.getOutputParamGroup())))) {
            BasicParamDefinition answerParamDefinition = ParamDefinitionBuilder.string((String)"answer").asInput().makePrivate().build();
            ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, Collections.singletonList(answerParamDefinition));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_RADIOGROUP_REPO.equals(propertyName)) {
            String repoType = (String)e.getChangeSet()[0].getNewValue();
            Tab tab = (Tab)this.getControl(KEY_TAB_REPO);
            if (StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
                tab.activeTab(KEY_TAB_PAGE_SELECT);
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOOL_BAR_SELECT_REPO});
            } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
                tab.activeTab(KEY_TAB_PAGE_DYNAMIC);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOOL_BAR_SELECT_REPO});
            }
        }
        if (propertyName.equals(ENABLE_CHAT_MSG)) {
            ChangeData data = e.getChangeSet()[0];
            this.getView().setEnable((Boolean)data.getNewValue(), new String[]{REMEMBER_COUNT});
        }
    }

    @Override
    protected Optional<String> check() {
        String llm = (String)this.getModel().getValue(LLM);
        if (StringUtils.isBlank((CharSequence)llm)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bed\u8a00\u6a21\u578b\u3002", (String)"RepoReplyFlowConfigPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        return super.check();
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        this.clickRepoReply(flow, this.getNodeId());
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Collections.singletonList(PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    private void clickRepoReply(Flow flow, int nodeId) {
        RepoReplyAction repoReplyAction = (RepoReplyAction)flow.findActionById(nodeId);
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        String llm = (String)this.getModel().getValue(LLM);
        String userPrompt = (String)this.getModel().getValue(userTagFieldKey);
        String sysPrompt = (String)this.getModel().getValue(sysTagFieldKey);
        boolean reference = (Boolean)this.getModel().getValue(REFERENCE);
        boolean showMessage = (Boolean)this.getModel().getValue(SHOW_MESSAGE);
        boolean enableChatMsg = (Boolean)this.getModel().getValue(ENABLE_CHAT_MSG);
        BigDecimal rememberCount = (BigDecimal)this.getModel().getValue(REMEMBER_COUNT);
        this.getView().setEnable(Boolean.valueOf(enableChatMsg), new String[]{REMEMBER_COUNT});
        if (StringUtils.isEmpty((CharSequence)userPrompt)) {
            userPrompt = (String)this.getModel().getValue(USER_PROMPT);
        }
        if (StringUtils.isEmpty((CharSequence)sysPrompt)) {
            sysPrompt = (String)this.getModel().getValue(SYS_PROMPT);
        }
        RepoReplyConfig repoReplyConfig = new RepoReplyConfig(llm, userPrompt, sysPrompt, showMessage, reference, enableChatMsg, rememberCount);
        repoReplyAction.setRepoReplyConfig(repoReplyConfig);
    }
}

