/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.SetVarMapper;
import kd.ai.gai.core.engine.flow.SetVariableAction;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;

public class SetVariableFlowConfigPlugin
extends AbstractFlowConfigPlugin<SetVariableAction> {
    private static final String KEY_SET_VAR = "setvar";
    private static final String IN_PARAM = "in_param";
    private static final String IN_PARAM_PATH = "in_param_path";
    private static final String OUT_PARAM = "out_param";
    private static final String OUT_PARAM_PATH = "out_param_path";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{IN_PARAM});
        this.addClickListeners(new String[]{OUT_PARAM});
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        SetVariableAction setVariableAction = (SetVariableAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam("nodeId")).intValue());
        if (setVariableAction != null) {
            this.loadSetVariableAction(flow, setVariableAction);
            this.getView().updateView();
        }
    }

    private void loadSetVariableAction(Flow flow, SetVariableAction setVariableAction) {
        if (setVariableAction == null) {
            return;
        }
        List varMapperList = setVariableAction.getSetParamMap();
        if (varMapperList != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_SET_VAR);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_SET_VAR);
            shows.clear();
            for (SetVarMapper setVarMapper : varMapperList) {
                NodeParamPath inParamPath = setVarMapper.getInParamPath();
                NodeParamPath outParamPath = setVarMapper.getOutParamPath();
                if (inParamPath == null || outParamPath == null) continue;
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(IN_PARAM, (Object)VarParamConverter.generateNodeParamDisplay(flow, inParamPath));
                row.set(IN_PARAM_PATH, (Object)inParamPath.getFullPath());
                row.set(OUT_PARAM, (Object)VarParamConverter.generateNodeParamDisplay(flow, outParamPath));
                row.set(OUT_PARAM_PATH, (Object)outParamPath.getFullPath());
                shows.add((Object)row);
            }
            this.getView().updateView(KEY_SET_VAR);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        this.getModel().setDataChanged(true);
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickMessage(flow, this.getNodeId());
    }

    private void clickMessage(Flow flow, int nodeId) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_SET_VAR);
        SetVariableAction setVariableAction = (SetVariableAction)flow.findActionById(nodeId);
        if (setVariableAction != null && !rows.isEmpty()) {
            ArrayList<SetVarMapper> setParamList = new ArrayList<SetVarMapper>();
            for (DynamicObject row : rows) {
                String inReferenceParam = row.getString(IN_PARAM_PATH);
                String outReferenceParam = row.getString(OUT_PARAM_PATH);
                if (!StringUtils.isNotBlank((CharSequence)inReferenceParam) || !StringUtils.isNotBlank((CharSequence)outReferenceParam)) continue;
                SetVarMapper setVarMapper = new SetVarMapper();
                NodeParamPath inNodeParamPath = ParamPathHelper.parseFullPath((String)inReferenceParam);
                setVarMapper.setInParamPath(inNodeParamPath);
                NodeParamPath outNodeParamPath = ParamPathHelper.parseFullPath((String)outReferenceParam);
                setVarMapper.setOutParamPath(outNodeParamPath);
                setParamList.add(setVarMapper);
            }
            setVariableAction.setSetParamMap(setParamList);
        }
    }

    @Override
    protected Optional<String> check() {
        DynamicObjectCollection vars = this.getModel().getEntryEntity(KEY_SET_VAR);
        if (vars != null) {
            int i = 1;
            for (DynamicObject var : vars) {
                String loopVar = var.getString(IN_PARAM_PATH);
                String source = var.getString(OUT_PARAM_PATH);
                if (StringUtils.isBlank((CharSequence)loopVar)) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u5faa\u73af\u53d8\u91cf\u201d", (String)"GaiProcessLoopPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i));
                }
                if (StringUtils.isBlank((CharSequence)source)) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessLoopPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i));
                }
                ++i;
            }
        }
        return Optional.empty();
    }

    @Override
    protected RefrenceDataConfig getReferenceDataConfig(String entryEntityKey) {
        RefrenceDataConfig referenceDataConfig = super.getReferenceDataConfig(entryEntityKey);
        referenceDataConfig.setOnlySelectTopNode(true);
        return referenceDataConfig;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        SetVariableAction action = (SetVariableAction)this.getAction(this.getFlow());
        if (evt.getSource() instanceof TextEdit) {
            if (((TextEdit)evt.getSource()).getKey().equals(IN_PARAM)) {
                RefrenceDataConfig refrenceDataConfig = this.getReferenceDataConfig(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
                refrenceDataConfig.setOnlyNeedBlockNodeVar(true);
                refrenceDataConfig.setNodeId(action.getId());
                refrenceDataConfig.setBlockNodeId(action.getBlockNodeId());
                HashSet<Integer> onlyNodeIdList = new HashSet<Integer>();
                onlyNodeIdList.add(action.getBlockNodeId());
                refrenceDataConfig.setOnlyNodeIdList(onlyNodeIdList);
                this.showForm(IN_PARAM_PATH, IN_PARAM, refrenceDataConfig);
            }
            if (((TextEdit)evt.getSource()).getKey().equals(OUT_PARAM)) {
                this.showForm(OUT_PARAM_PATH, OUT_PARAM, this.getReferenceDataConfig(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey()));
            }
        }
    }

    private void showForm(String paramPathKey, String paramKey, RefrenceDataConfig refrenceDataConfig) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gai_flow_treeview");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        fsp.setOpenStyle(openStyle);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_SET_VAR);
        Object referenceParamFullPath = this.getModel().getValue(paramPathKey, rowIndex);
        fsp.setCustomParam("referenceParamFullPath", (Object)(referenceParamFullPath != null ? referenceParamFullPath.toString() : ""));
        fsp.setCustomParam(RefrenceDataConfig.class.getSimpleName(), (Object)JSON.toJSONString((Object)refrenceDataConfig));
        fsp.setCustomParam("nodeId", (Object)this.getNodeId());
        fsp.setCustomParam("needBlockReferenceData", (Object)false);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, paramKey));
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getActionId().equals(IN_PARAM)) {
            this.updateParamPath(evt, IN_PARAM, IN_PARAM_PATH);
        }
        if (evt.getActionId().equals(OUT_PARAM)) {
            this.updateParamPath(evt, OUT_PARAM, OUT_PARAM_PATH);
        }
    }

    private void updateParamPath(ClosedCallBackEvent evt, String paramKey, String paramFullPathKey) {
        Flow flow = this.getFlow();
        ParamDefinition paramDef = (ParamDefinition)evt.getReturnData();
        if (paramDef != null) {
            try {
                int row = this.getModel().getEntryCurrentRowIndex(KEY_SET_VAR);
                NodeParamPath nodeParamPath = paramDef.getReferencePath();
                this.getModel().setValue(paramKey, (Object)VarParamConverter.generateNodeParamDisplay(flow, nodeParamPath), row);
                this.getModel().setValue(paramFullPathKey, (Object)nodeParamPath.getFullPath(), row);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u53c2\u6570\u56de\u8c03\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

