/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.util.CosmicOpenAPIUtils;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIInfo;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIParam;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.flow.param.converter.JsonSchemaToParamDefinitionConverter;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.plugin.flow.config.AbstractFlowBatchConfigPlugin;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ToolFlowConfigPlugin
extends AbstractFlowBatchConfigPlugin<ToolAction> {
    private static final String TOOL_INFO = "basedata_tool";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl(TOOL_INFO);
        textEdit.addClickListener((ClickListener)this);
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (key.equalsIgnoreCase(TOOL_INFO)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("gai_tool_select_custom");
            JSONArray selected_tool = new JSONArray();
            HashMap<String, JSONObject> maps = new HashMap<String, JSONObject>(16);
            String apiInfo = (String)this.getModel().getValue("apiinfo");
            if (apiInfo != null && apiInfo.length() > 0) {
                JSONObject jsonObject = JSONObject.parseObject((String)apiInfo);
                String toolId = jsonObject.getString("toolId");
                if (maps.get(toolId) == null) {
                    maps.put(toolId, jsonObject);
                } else {
                    String operationId = jsonObject.getString("operations");
                    JSONObject json = (JSONObject)maps.get(toolId);
                    String operationIds = json.getString("operations");
                    json.put("operations", (Object)String.format("%s,%s", operationIds, operationId));
                    maps.put(toolId, json);
                }
            }
            Set entries = maps.entrySet();
            for (Map.Entry entry : entries) {
                selected_tool.add(entry.getValue());
            }
            formShowParameter.setCustomParam("selected_tool_config", (Object)selected_tool);
            formShowParameter.setCustomParam("is_process", (Object)true);
            formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "tool"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        ToolAction toolAction = (ToolAction)flow.findActionById(nodeId);
        if (toolAction == null) {
            return;
        }
        Long toolId = toolAction.getToolId();
        if (toolId != null) {
            DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolId, (String)"gai_tool");
            String toolName = tool.getString("name");
            this.getModel().setValue(TOOL_INFO, (Object)(toolAction.getOperationName() == null ? (toolAction.getToolName() == null ? toolName : toolAction.getToolName()) : toolAction.getOperationName()));
            this.getModel().setValue("apiinfo", (Object)toolAction.getToolInfo());
        }
    }

    @Override
    protected Optional<String> check() {
        String toolInfo = (String)this.getModel().getValue(TOOL_INFO);
        if (toolInfo == null || toolInfo.isEmpty()) {
            return Optional.of(ResManager.loadKDString((String)"\u5de5\u5177\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessToolSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        return super.check();
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        int nodeId = this.getNodeId();
        ToolAction toolAction = (ToolAction)flow.findActionById(nodeId);
        String apiInfo = (String)this.getModel().getValue("apiinfo");
        if (!apiInfo.isEmpty()) {
            JSONObject jsonObject = JSONObject.parseObject((String)apiInfo);
            String toolType = jsonObject.getString("type");
            String toolName = jsonObject.getString("toolName");
            String toolId = jsonObject.getString("toolId");
            String operationId = jsonObject.getString("operations");
            String operationName = jsonObject.getString("operationName");
            toolAction.setToolId(Long.valueOf(toolId));
            toolAction.setToolType(toolType);
            toolAction.setToolName(toolName);
            toolAction.setOperationId(operationId);
            toolAction.setOperationName(operationName);
            toolAction.setToolInfo(apiInfo);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(TOOL_INFO) && ((data = e.getChangeSet()[0]).getNewValue() == null || StringUtils.isEmpty((String)String.valueOf(data.getNewValue())))) {
            this.getModel().setValue(TOOL_INFO, (Object)"");
            this.getModel().setValue("name", (Object)"\u5de5\u5177");
            this.getModel().setValue("apiinfo", (Object)"");
            this.getModel().deleteEntryData("batch_input");
            this.getModel().deleteEntryData("batch_output");
            this.getModel().deleteEntryData("input");
            this.getModel().deleteEntryData("output");
            this.getNodePropertyDesigner().sendModifyIconAction("");
            this.getModel().updateCache();
            this.getView().updateView();
        }
    }

    private void updateNode(JSONObject json) {
        String toolName = json.getString("toolName");
        if (StringUtils.isEmpty((String)toolName)) {
            this.getNodePropertyDesigner().sendModifyIconAction("");
            this.getModel().setValue("name", (Object)"");
            this.getModel().updateCache();
            this.getView().updateView();
            return;
        }
        String operationName = json.getString("operationName");
        this.getModel().setValue("name", (Object)(operationName != null ? operationName : toolName));
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)json.get((Object)"toolId"), (String)"gai_tool");
        String iconPath = tool.getString("picture");
        this.sendIconPathToCustomControl(iconPath);
        this.getModel().updateCache();
        this.getView().updateView();
    }

    private void handleRestfulApi(JSONObject json) {
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)json.get((Object)"toolId"), (String)"gai_tool");
        String configTag = tool.getString("config_tag");
        String type = json.getString("type");
        Map operationParamMap = OpenAPIUtils.parserRestfulOperationParam((String)configTag, (String[])new String[]{json.getString("operations")});
        for (Map.Entry entry : operationParamMap.entrySet()) {
            OperationParam operationParam = (OperationParam)entry.getValue();
            JSONObject inputParams = JSONObject.parseObject((String)operationParam.getInputParamsJson());
            ArrayList<ParamDefinition> paramDefList = new ArrayList<ParamDefinition>();
            for (Map.Entry entryObj : inputParams.entrySet()) {
                Object obj = entryObj.getValue();
                if (!(obj instanceof JSONObject)) continue;
                ParamDefinition inputDef = JsonSchemaToParamDefinitionConverter.fromJsonSchema((JSONObject)((JSONObject)obj), (String)((String)entryObj.getKey()));
                inputDef.setDirection(ParamDirection.INPUT);
                paramDefList.add(inputDef);
            }
            Flow flow = this.getFlow();
            ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, paramDefList);
            JSONObject outputParams = null;
            outputParams = type.equals(ToolConstant.ToolType.MCP_TOOL.getType()) ? JSONObject.parseObject((String)("{\"isError\":{\"type\":\"boolean\",\"description\":\"" + ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u662f\u5426\u9519\u8bef", (String)"GaiMCPToolDetailFormPlugin_13885606", (String)"ai-gai-plugin", (Object[])new Object[0]) + " true-" + ResManager.loadKDString((String)"\u662f", (String)"GaiMCPToolDetailFormPlugin_13885605", (String)"ai-gai-plugin", (Object[])new Object[0]) + " false-" + ResManager.loadKDString((String)"\u5426", (String)"GaiMCPToolDetailFormPlugin_13885604", (String)"ai-gai-plugin", (Object[])new Object[0]) + "\"},\"content\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"required\":[\"text\"],\"properties\":{\"text\":{\"type\":\"string\",\"description\":\"" + ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u7ed3\u679c", (String)"GaiMCPToolDetailFormPlugin_13885603", (String)"ai-gai-plugin", (Object[])new Object[0]) + "\"}}}}}")) : JSONObject.parseObject((String)operationParam.getOutputParamsJson());
            ArrayList<ParamDefinition> outPutparamDefList = new ArrayList<ParamDefinition>();
            for (Map.Entry entryObj : outputParams.entrySet()) {
                Object obj = entryObj.getValue();
                if (!(obj instanceof JSONObject)) continue;
                ParamDefinition outputDef = JsonSchemaToParamDefinitionConverter.fromJsonSchema((JSONObject)((JSONObject)obj), (String)((String)entryObj.getKey()));
                outputDef.setDirection(ParamDirection.OUTPUT);
                outPutparamDefList.add(outputDef);
            }
            ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, outPutparamDefList);
            ToolAction toolAction = (ToolAction)this.getAction(flow);
            this.saveParamTreeConfig(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), flow, (Action)toolAction);
            ParamTreeLoader.create(PARAM_TREE_BATCH_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, toolAction.getBatchOutputParams());
        }
    }

    private JSONObject buildParamStructure(CosmicOpenAPIParam param) {
        JSONObject paramJson = new JSONObject();
        String paramName = param.getParamName();
        String paramDesc = param.getDesc();
        String paramType = this.normalizeType(param.getParamType());
        paramJson.put("type", (Object)paramType);
        paramJson.put("description", (Object)paramDesc);
        if (paramType.contains("array")) {
            if (!param.getChildList().isEmpty()) {
                JSONObject items = new JSONObject();
                paramJson.put("items", (Object)items);
                JSONObject arrayItem = new JSONObject();
                arrayItem.put("type", (Object)"object");
                arrayItem.put("properties", (Object)this.buildChildProperties(param.getChildList()));
                items.putAll((Map)arrayItem);
            }
        } else if (!param.getChildList().isEmpty()) {
            paramJson.put("properties", (Object)this.buildChildProperties(param.getChildList()));
        }
        return paramJson;
    }

    private JSONObject buildChildProperties(List<CosmicOpenAPIParam> childParams) {
        JSONObject properties = new JSONObject();
        for (CosmicOpenAPIParam childParam : childParams) {
            properties.put(childParam.getParamName(), (Object)this.buildParamStructure(childParam));
        }
        return properties;
    }

    private String normalizeType(String type) {
        if (type == null) {
            return "string";
        }
        String lowerType = type.toLowerCase(Locale.ROOT);
        return lowerType;
    }

    private void handleOpenApi(JSONObject json) {
        String operationId = json.getString("operations");
        Long apiId = Long.parseLong(operationId);
        CosmicOpenAPIInfo openApi = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo((Long)apiId);
        List params = openApi.getRequest();
        List response = openApi.getResponse();
        Flow flow = this.getFlow();
        ArrayList<ParamDefinition> outputParamDefList = new ArrayList<ParamDefinition>(16);
        for (CosmicOpenAPIParam param : response) {
            JSONObject paramJson = this.buildParamStructure(param);
            ParamDefinition outputDef = JsonSchemaToParamDefinitionConverter.fromJsonSchema((JSONObject)paramJson, (String)param.getParamName());
            outputDef.setDirection(ParamDirection.OUTPUT);
            outputParamDefList.add(outputDef);
        }
        ParamTreeLoader.create(PARAM_TREE_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, outputParamDefList);
        ToolAction toolAction = (ToolAction)this.getAction(flow);
        this.saveParamTreeConfig(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), flow, (Action)toolAction);
        ParamTreeLoader.create(PARAM_TREE_BATCH_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, toolAction.getBatchOutputParams());
        ArrayList<ParamDefinition> paramDefList = new ArrayList<ParamDefinition>(2);
        for (CosmicOpenAPIParam param : params) {
            JSONObject paramJson = this.buildParamStructure(param);
            ParamDefinition inputDef = JsonSchemaToParamDefinitionConverter.fromJsonSchema((JSONObject)paramJson, (String)param.getParamName());
            inputDef.setDirection(ParamDirection.INPUT);
            paramDefList.add(inputDef);
        }
        ParamTreeLoader.create(PARAM_TREE_INPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, paramDefList);
    }

    private void handleCosmic(JSONObject json) {
        ParamType paramType;
        String desc;
        String type;
        String name;
        int index;
        JSONArray inputParams;
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)json.get((Object)"toolId"), (String)"gai_tool");
        String toolTagJson = tool.getString("config_tag");
        if (StringUtils.isEmpty((String)toolTagJson)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)toolTagJson);
        this.getModel().deleteEntryData(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        if (jsonObject.containsKey((Object)"inputParams") && (inputParams = jsonObject.getJSONArray("inputParams")) != null && !inputParams.isEmpty()) {
            for (index = 0; index < inputParams.size(); ++index) {
                JSONObject inputVar = inputParams.getJSONObject(index);
                name = inputVar.getString("paramName");
                type = inputVar.getString("paramType");
                desc = inputVar.getString("paramDesc");
                paramType = VarParamConverter.convertStringToParamType(type);
                this.getModel().createNewEntryRow(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
                this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getNameKey(), (Object)name, index);
                this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)paramType.getDesc(), index);
                this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getDescKey(), (Object)desc, index);
            }
        }
        this.getModel().deleteEntryData(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey());
        if (jsonObject.containsKey((Object)"outputParams")) {
            JSONArray outputParams = jsonObject.getJSONArray("outputParams");
            if (outputParams != null && !outputParams.isEmpty()) {
                for (index = 0; index < outputParams.size(); ++index) {
                    JSONObject outputVar = outputParams.getJSONObject(index);
                    name = outputVar.getString("paramName");
                    type = outputVar.getString("paramType");
                    desc = outputVar.getString("paramDesc");
                    paramType = VarParamConverter.convertStringToParamType(type);
                    this.getModel().createNewEntryRow(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey());
                    this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), (Object)name, index);
                    this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getTypeKey(), (Object)paramType.getDesc(), index);
                    this.getModel().setValue(PARAM_TREE_OUTPUT_CONFIG.getDescKey(), (Object)desc, index);
                }
            }
            Flow flow = this.getFlow();
            ToolAction toolAction = (ToolAction)this.getAction(flow);
            this.saveParamTreeConfig(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), flow, (Action)toolAction);
            ParamTreeLoader.create(PARAM_TREE_BATCH_OUTPUT_CONFIG, this.getView(), this.getModel()).loadTreeData(flow, toolAction.getBatchOutputParams());
        }
    }

    private void toolParamHandler(JSONObject json) {
        String type = json.getString("type");
        this.updateNode(json);
        switch (ToolConstant.ToolType.valueOf((String)type.toUpperCase())) {
            case RESTFUL_API: 
            case MCP_TOOL: {
                this.handleRestfulApi(json);
                return;
            }
            case COSMIC_ACTION: {
                this.handleCosmic(json);
                return;
            }
            case INTERNAL_MCP: {
                this.handleOpenApi(json);
                return;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        JSONArray toolArray;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData == null) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u5de5\u5177");
            return;
        }
        JSONObject jo = new JSONObject();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"tool", (CharSequence)actionId) && (toolArray = (JSONArray)returnData) != null && toolArray.size() > 0) {
            JSONObject toolJo = toolArray.getJSONObject(0);
            jo.put("toolId", (Object)toolJo.getString("toolId"));
            String type = toolJo.getString("type");
            jo.put("type", (Object)type);
            if (toolJo.getString("operationId") != null) {
                jo.put("operations", (Object)toolJo.getString("operationId"));
                jo.put("operationName", (Object)toolJo.getString("operationName"));
                jo.put("operationDescription", (Object)toolJo.getString("operationDescription"));
            }
            DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)jo.get((Object)"toolId"), (String)"gai_tool");
            String toolName = tool.getString("name");
            if (toolJo.getString("operationName") != null) {
                this.getModel().setValue(TOOL_INFO, (Object)toolJo.getString("operationName"));
            } else {
                this.getModel().setValue(TOOL_INFO, (Object)toolName);
            }
            jo.put("toolName", (Object)toolName);
            this.getModel().setValue("apiinfo", (Object)jo.toJSONString());
            this.toolParamHandler(jo);
            this.getView().updateView();
        }
    }

    @Override
    protected boolean needLockParamTypeAfterBind(String entityKey) {
        if (entityKey.equals(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey()) || entityKey.equals(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey())) {
            return false;
        }
        return super.needChangeParamTypeOnClosedCallBack(entityKey);
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        if (entityKey.equals(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey()) || entityKey.equals(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey())) {
            return false;
        }
        return super.needChangeParamTypeOnClosedCallBack(entityKey);
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    private void sendIconPathToCustomControl(String iconPath) {
        this.getNodePropertyDesigner().sendModifyIconAction(this.buildIconUrl(iconPath));
    }

    private String buildIconUrl(String iconPath) {
        if (StringUtils.isNotEmpty((String)iconPath) && iconPath.startsWith("/kingdee")) {
            String host = RequestContext.get().getClientFullContextPath();
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            return host + iconPath;
        }
        return iconPath;
    }
}

