/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TransferFlowConfigPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(TransferFlowConfigPlugin.class);
    private static final String KEY_RELATION = "relation";
    private static final String KEY_ENTRYENTITY_CONDITION = "entryentity_condition";
    private static final String KEY_COMPARETYPE = "comparetype";
    private static final String KEY_VALUETYPE = "valuetype";
    private static final String KEY_TEXTVALUE = "textvalue";
    private static final String IN_PARAM = "in_param";
    private static final String IN_PARAM_PATH = "in_param_path";
    private static final String OUT_PARAM = "out_param";
    private static final String OUT_PARAM_PATH = "out_param_path";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{IN_PARAM});
        this.addClickListeners(new String[]{OUT_PARAM});
    }

    @Override
    protected void setComboItem() {
        ArrayList<ComboItem> compareTypeItems = new ArrayList<ComboItem>();
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.EQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.NOTEQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.GREATER));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.GREATEROREQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LESS));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.LESSOREQUAL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.ISNULL));
        compareTypeItems.add(this.getCompareTypeItem(CompareTypeEnum.ISNOTNULL));
        ComboEdit comboEditValueType = (ComboEdit)this.getControl(KEY_COMPARETYPE);
        comboEditValueType.setComboItems(compareTypeItems);
    }

    private ComboItem getCompareTypeItem(CompareTypeEnum compareTypeEnum) {
        CompareType compareType = FilterMetadata.get().getCompareTypeByCompareTypeId(compareTypeEnum.getId());
        return new ComboItem(compareType.getName(), compareType.getId());
    }

    @Override
    public void initData() {
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_CONDITION);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRYENTITY_CONDITION);
        rows.clear();
        Flow flow = this.getFlow();
        Condition condition = flow.findTransferById(this.getNodeId()).getCondition();
        if (condition == null) {
            return;
        }
        List conditonRows = condition.getConditionRows();
        if (conditonRows != null && !conditonRows.isEmpty()) {
            for (Condition.Row conditionRow : conditonRows) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                NodeParamPath leftParamPath = conditionRow.getLeftParamPath();
                row.set(IN_PARAM, (Object)VarParamConverter.generateNodeParamDisplay(flow, leftParamPath));
                row.set(IN_PARAM_PATH, (Object)leftParamPath.getFullPath());
                row.set(KEY_COMPARETYPE, (Object)conditionRow.getOperator().toCompareTypeEnum().getId());
                row.set(KEY_VALUETYPE, (Object)conditionRow.getValueType());
                row.set(KEY_TEXTVALUE, (Object)conditionRow.getText());
                if (conditionRow.getValueType() == Condition.ValueType.PARAM) {
                    NodeParamPath rightParamPath = conditionRow.getRightParamPath();
                    row.set(OUT_PARAM, (Object)VarParamConverter.generateNodeParamDisplay(flow, rightParamPath));
                    row.set(OUT_PARAM_PATH, (Object)rightParamPath.getFullPath());
                }
                rows.add((Object)row);
            }
        }
        this.getModel().setValue(KEY_RELATION, (Object)(condition.getRelation() != null ? condition.getRelation() : Condition.RelationType.AND));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindData(true);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.bindData(true);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        String sNewValue;
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(KEY_COMPARETYPE) && ((sNewValue = (changeData = e.getChangeSet()[0]).getNewValue().toString()).equals(CompareTypeEnum.ISNULL.getId()) || sNewValue.equals(CompareTypeEnum.ISNOTNULL.getId()))) {
            changeData.getDataEntity().set(KEY_VALUETYPE, null);
            changeData.getDataEntity().set(KEY_TEXTVALUE, null);
            changeData.getDataEntity().set(OUT_PARAM, null);
            changeData.getDataEntity().set(OUT_PARAM_PATH, null);
            this.getView().updateView(KEY_ENTRYENTITY_CONDITION);
        }
        if (e.getProperty().getName().equals(KEY_VALUETYPE)) {
            this.bindData(false);
        }
    }

    private void bindData(boolean initialize) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY_CONDITION);
        Object valueType = this.getModel().getValue(KEY_VALUETYPE, rowIndex);
        if (valueType == null || Condition.ValueType.PARAM.toString().equals(valueType)) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{OUT_PARAM});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{KEY_TEXTVALUE});
            if (!initialize) {
                this.getModel().setValue(KEY_TEXTVALUE, (Object)"", rowIndex);
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{OUT_PARAM});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{KEY_TEXTVALUE});
            if (!initialize) {
                this.getModel().setValue(OUT_PARAM, (Object)"", rowIndex);
                this.getModel().setValue(OUT_PARAM_PATH, (Object)"", rowIndex);
            }
        }
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRYENTITY_CONDITION);
        ArrayList<Condition.Row> conditionRows = new ArrayList<Condition.Row>(rows.size());
        for (DynamicObject row : rows) {
            String inReferenceParam = row.getString(IN_PARAM_PATH);
            if (!StringUtils.isNotEmpty((CharSequence)inReferenceParam)) continue;
            NodeParamPath inNodeParamPath = ParamPathHelper.parseFullPath((String)inReferenceParam);
            Condition.Row conditionRow = new Condition.Row();
            conditionRow.setLeftParamPath(inNodeParamPath);
            CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)row.getString(KEY_COMPARETYPE));
            conditionRow.setOperator(Condition.Operator.fromCompareTypeEnum((CompareTypeEnum)compareTypeEnum));
            if (!compareTypeEnum.equals((Object)CompareTypeEnum.ISNULL) && !compareTypeEnum.equals((Object)CompareTypeEnum.ISNOTNULL)) {
                String outReferenceParam;
                conditionRow.setValueType(Condition.ValueType.valueOf((String)row.getString(KEY_VALUETYPE)));
                if (row.getString(KEY_VALUETYPE).equals(Condition.ValueType.TEXT.toString()) || row.getString(KEY_VALUETYPE).equals(Condition.ValueType.DECIMAL.toString())) {
                    conditionRow.setText(row.getString(KEY_TEXTVALUE));
                } else if (row.getString(KEY_VALUETYPE).equals(Condition.ValueType.PARAM.toString()) && StringUtils.isNotBlank((CharSequence)(outReferenceParam = row.getString(OUT_PARAM_PATH)))) {
                    NodeParamPath outNodeParamPath = ParamPathHelper.parseFullPath((String)outReferenceParam);
                    conditionRow.setRightParamPath(outNodeParamPath);
                }
            }
            conditionRows.add(conditionRow);
        }
        Transfer transfer = flow.findTransferById(this.getNodeId());
        Condition condition = transfer.getCondition();
        if (!conditionRows.isEmpty()) {
            if (condition == null) {
                condition = new Condition();
                transfer.setCondition(condition);
            }
            condition.setConditionRows(conditionRows);
        } else {
            transfer.setCondition(null);
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    private String check() {
        DynamicObjectCollection rowConditions = this.getModel().getEntryEntity(KEY_ENTRYENTITY_CONDITION);
        this.setConditionVisible(!rowConditions.isEmpty());
        for (int i = 0; i < rowConditions.size(); ++i) {
            DynamicObject row = (DynamicObject)rowConditions.get(i);
            if (StringUtils.isEmpty((CharSequence)row.getString(IN_PARAM)) || StringUtils.isEmpty((CharSequence)row.getString(KEY_COMPARETYPE))) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"GaiProcessTranferSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
            }
            if (!row.getString(KEY_COMPARETYPE).equals(CompareTypeEnum.ISNULL.getId()) && !row.getString(KEY_COMPARETYPE).equals(CompareTypeEnum.ISNOTNULL.getId())) {
                if (StringUtils.isEmpty((CharSequence)row.getString(KEY_VALUETYPE))) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"GaiProcessTranferSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
                }
                if (row.getString(KEY_VALUETYPE).equals(Condition.ValueType.PARAM.toString()) && StringUtils.isEmpty((CharSequence)row.getString(OUT_PARAM))) {
                    return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"GaiProcessTranferSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
                }
            }
            String valueType = row.getString(KEY_VALUETYPE);
            if (!Condition.ValueType.DECIMAL.name().equals(valueType)) continue;
            String value = row.getString(KEY_TEXTVALUE);
            try {
                Float.parseFloat(value);
                continue;
            }
            catch (Exception ex) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u914d\u7f6e\u7684\u503c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u503c", (String)"GaiProcessTranferSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i + 1);
            }
        }
        return "";
    }

    private void setConditionVisible(boolean bVisible) {
        String nodeName = bVisible ? this.getModel().getValue("name").toString() : "";
        this.sendNodeNameToCustomControl(nodeName);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            if (((TextEdit)evt.getSource()).getKey().equals(IN_PARAM)) {
                this.showForm(IN_PARAM_PATH, IN_PARAM);
            }
            if (((TextEdit)evt.getSource()).getKey().equals(OUT_PARAM)) {
                this.showForm(OUT_PARAM_PATH, OUT_PARAM);
            }
        }
    }

    private void showForm(String paramPathKey, String paramKey) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gai_flow_treeview");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        fsp.setOpenStyle(openStyle);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY_CONDITION);
        Object referenceParamFullPath = this.getModel().getValue(paramPathKey, rowIndex);
        fsp.setCustomParam("referenceParamFullPath", (Object)(referenceParamFullPath != null ? referenceParamFullPath.toString() : ""));
        fsp.setCustomParam(RefrenceDataConfig.class.getSimpleName(), (Object)JSON.toJSONString((Object)this.getReferenceDataConfig(KEY_ENTRYENTITY_CONDITION)));
        fsp.setCustomParam("nodeId", (Object)this.getNodeId());
        fsp.setCustomParam("needBlockReferenceData", (Object)false);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, paramKey));
        this.getView().showForm(fsp);
    }

    private RefrenceDataConfig getReferenceDataConfig(String entryKey) {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserInput(true);
        config.setAddUserChatHistory(false);
        return config;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getActionId().equals(IN_PARAM)) {
            this.updateParamPath(evt, IN_PARAM, IN_PARAM_PATH);
        }
        if (evt.getActionId().equals(OUT_PARAM)) {
            this.updateParamPath(evt, OUT_PARAM, OUT_PARAM_PATH);
        }
    }

    private void updateParamPath(ClosedCallBackEvent evt, String paramKey, String paramFullPathKey) {
        Flow flow = this.getFlow();
        ParamDefinition paramDef = (ParamDefinition)evt.getReturnData();
        if (paramDef != null) {
            try {
                int row = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY_CONDITION);
                NodeParamPath nodeParamPath = paramDef.getReferencePath();
                this.getModel().setValue(paramKey, (Object)VarParamConverter.generateNodeParamDisplay(flow, nodeParamPath), row);
                this.getModel().setValue(paramFullPathKey, (Object)nodeParamPath.getFullPath(), row);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u53c2\u6570\u56de\u8c03\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

