/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.node;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.VisionAction;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.plugin.flow.config.AbstractFlowConfigPlugin;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.param.ParamTreeLoader;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;

public class VisionServiceFlowConfigPlugin
extends AbstractFlowConfigPlugin<VisionAction>
implements ClickListener {
    private static final Log log = LogFactory.getLog(VisionServiceFlowConfigPlugin.class);
    private static final String TEMPLATE_NAME = "template";
    private static final String TEMPLATE_ID = "templateid";
    private static final String TEMPLATE_TYPE = "templatetype";
    private static final String TEMPLATE_NUMBER = "templatenumber";
    private static final String BUSINESS_OBJECT = "businessobject";
    private static final String BUSINESS_OBJECT_NUMBER = "businessobjectnumber";
    private static final String MAP_ID = "mapid";
    private static final String TEMPLATE = "template";
    private static final String IS_BACKFILL = "isbackfill";
    private static final String SHOW_STATUS = "showstatus";
    private static final String BACK_FILL_BILL_DATA = "backFillBillData";
    private static final String BILL_FORM_ID = "billFormId";
    private static final String BILL_HEAD = "billHead";
    private static final String ENTRY = "entry";
    private static final String TEMPLATE_DATA = "templateData";
    private static final String COMMON_FIELD = "commonField";
    private static final String TABLE_FIELD = "tableField";
    private static final String TEMPLATE_DATA_NUMBER = "templateNumber";
    private static final String BUSINESS_OBJECT_FORM_ID = "gai_vision_businessobj";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"template"});
        this.addClickListeners(new String[]{BUSINESS_OBJECT});
    }

    @Override
    protected Map<String, List<String>> getNeedLockColumnMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_INPUT_CONFIG.getNameKey(), PARAM_TREE_INPUT_CONFIG.getTypeKey()));
        map.put(PARAM_TREE_OUTPUT_CONFIG.getEntryEntityKey(), Arrays.asList(PARAM_TREE_OUTPUT_CONFIG.getNameKey(), PARAM_TREE_OUTPUT_CONFIG.getTypeKey()));
        return map;
    }

    @Override
    protected boolean needChangeParamTypeOnClosedCallBack(String entityKey) {
        return false;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Flow flow = this.getFlow();
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)IS_BACKFILL, (CharSequence)propertyName)) {
            Boolean isBackFill = (Boolean)cd.getNewValue();
            this.backFillSetting(isBackFill);
            if (!isBackFill.booleanValue()) {
                this.getModel().setValue(BUSINESS_OBJECT, (Object)"");
            } else if (!this.getModel().getValue(BUSINESS_OBJECT).toString().isEmpty()) {
                List<ParamDefinition> paramDefinitions = this.buildOutputParamDefs((VisionAction)this.getAction(flow));
                this.setTreeData(flow, paramDefinitions);
            }
        } else if (StringUtils.equals((CharSequence)BUSINESS_OBJECT, (CharSequence)propertyName)) {
            if (this.getModel().getValue(BUSINESS_OBJECT).toString().isEmpty()) {
                this.getModel().setValue(BUSINESS_OBJECT_NUMBER, (Object)"");
                this.getModel().setValue(MAP_ID, (Object)0);
            }
            List<ParamDefinition> paramDefinitions = this.buildOutputParamDefs((VisionAction)this.getAction(flow));
            this.setTreeData(flow, paramDefinitions);
        } else if (StringUtils.equals((CharSequence)"template", (CharSequence)propertyName)) {
            this.getModel().setValue(IS_BACKFILL, (Object)false);
            this.getModel().setValue(BUSINESS_OBJECT, (Object)"");
            List<ParamDefinition> paramDefinitions = this.buildOutputParamDefs((VisionAction)this.getAction(flow));
            this.setTreeData(flow, paramDefinitions);
        }
    }

    private void setTreeData(Flow flow, List<ParamDefinition> params) {
        ParamTreeLoader.create(ParamTreeConfig.createOutputConfig(), this.getView(), this.getModel()).loadTreeData(flow, params);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        if (itemKey.equals("template")) {
            IFormView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1380");
            styleCss.setHeight("780");
            showParameter.setFormId("cvp_clssify_configf7");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectTemplate"));
            view.showForm(showParameter);
        } else if (itemKey.equals(BUSINESS_OBJECT)) {
            IFormView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("templateId", this.getModel().getValue(TEMPLATE_ID).toString());
            data.put("templateType", this.getModel().getValue(TEMPLATE_TYPE).toString());
            showParameter.setCustomParam("data", data);
            showParameter.setFormId(BUSINESS_OBJECT_FORM_ID);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectbusinessobject"));
            view.showForm(showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        Flow flow = this.getFlow();
        String actionId = evt.getActionId();
        if (actionId.equals("selectTemplate")) {
            Object returnData2 = evt.getReturnData();
            if (returnData2 != null) {
                Map returnDataMap = (Map)returnData2;
                long primaryKeyValue = Long.parseLong((String)returnDataMap.get("id"));
                String keyCode = (String)returnDataMap.get("keyCode");
                String templateName = (String)returnDataMap.get("planName");
                String templateNumber = (String)returnDataMap.get("planNumber");
                if (templateName == this.getModel().getValue("template")) {
                    return;
                }
                this.getModel().setValue(TEMPLATE_ID, (Object)primaryKeyValue);
                this.getModel().setValue(TEMPLATE_TYPE, (Object)keyCode);
                this.getModel().setValue("template", (Object)templateName);
                this.getModel().setValue(TEMPLATE_NUMBER, (Object)templateNumber);
                this.getModel().setValue(BUSINESS_OBJECT, (Object)"");
                boolean isBackFill = this.getModel().getDataEntity().getBoolean(IS_BACKFILL);
                this.backFillSetting(isBackFill);
                this.getView().updateView();
            }
        } else if (actionId.equals("selectbusinessobject") && (returnData = (Map)evt.getReturnData()) != null) {
            VisionAction action = (VisionAction)this.getAction(flow);
            action.setBusinessObjectName(returnData.get("name").toString());
            action.setBusinessObjectNumber(returnData.get("number").toString());
            this.getModel().setValue(BUSINESS_OBJECT_NUMBER, returnData.get("number"));
            this.getModel().setValue(MAP_ID, returnData.get(MAP_ID));
            MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)((String)returnData.get("number")));
            String bizAppId = bizEntityType.getAppId();
            action.setAppId(bizAppId);
            this.getModel().setValue("appid", (Object)bizAppId);
            this.getModel().setValue(BUSINESS_OBJECT, returnData.get("name"));
            this.getView().updateView();
        }
    }

    private void backFillSetting(boolean isBackFill) {
        this.getView().setVisible(Boolean.valueOf(isBackFill), new String[]{BUSINESS_OBJECT, "selectbusinessobject"});
        if (!isBackFill) {
            this.getModel().setValue(BUSINESS_OBJECT, (Object)"");
            return;
        }
        String templateId = this.getModel().getValue(TEMPLATE_ID).toString();
        String templateType = this.getModel().getValue(TEMPLATE_TYPE).toString();
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"AgentFlowService", (String)"getBizObjList", (Object[])new Object[]{templateId, templateType, null});
        log.info("getBizObjList result: {}", (Object)resultStr);
        Map result = null;
        try {
            result = (Map)objectMapper.readValue(resultStr, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (result == null || result.isEmpty() || (Integer)result.get("errorCode") != 0) {
            return;
        }
        List businessObjects = (List)objectMapper.convertValue(((Map)objectMapper.convertValue(result.get("data"), Map.class)).get("list"), List.class);
        if (businessObjects == null || businessObjects.size() != 1) {
            return;
        }
        String number = (String)((Map)businessObjects.get(0)).get("number");
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String bizAppId = bizEntityType.getAppId();
        this.getModel().setValue("appid", (Object)bizAppId);
        this.getModel().setValue(BUSINESS_OBJECT_NUMBER, (Object)number);
        this.getModel().setValue(MAP_ID, ((Map)businessObjects.get(0)).get("id"));
        this.getModel().setValue(BUSINESS_OBJECT, (Object)((Map)businessObjects.get(0)).get("name").toString());
    }

    @Override
    protected Optional<String> check() {
        String businessObject;
        boolean isBackFill = this.getModel().getDataEntity().getBoolean(IS_BACKFILL);
        String template = this.getModel().getValue("template").toString();
        if (template == null || template.isEmpty()) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"VisionServiceFlowConfigPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        if (isBackFill && ((businessObject = this.getModel().getValue(BUSINESS_OBJECT).toString()) == null || businessObject.isEmpty())) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"VisionServiceFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        return super.check();
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        super.saveDataToFlow(flow);
        VisionAction visionAction = (VisionAction)this.getAction(flow);
        long templateId = (Long)this.getModel().getValue(TEMPLATE_ID);
        String templateType = (String)this.getModel().getValue(TEMPLATE_TYPE);
        String templateName = (String)this.getModel().getValue("template");
        String templateNumber = (String)this.getModel().getValue(TEMPLATE_NUMBER);
        visionAction.setTemplateId(templateId);
        visionAction.setTemplateName(templateName);
        visionAction.setTemplateType(templateType);
        visionAction.setTemplateNumber(templateNumber);
        boolean isBackFill = this.getModel().getDataEntity().getBoolean(IS_BACKFILL);
        visionAction.setBackFill(isBackFill);
        boolean isShowStatus = this.getModel().getDataEntity().getBoolean(SHOW_STATUS);
        visionAction.setShowStatus(isShowStatus);
        if (isBackFill) {
            String businessObject = this.getModel().getValue(BUSINESS_OBJECT).toString();
            visionAction.setBusinessObjectName(businessObject);
            String businessObjectNumber = this.getModel().getValue(BUSINESS_OBJECT_NUMBER).toString();
            visionAction.setBusinessObjectNumber(businessObjectNumber);
            long mapId = (Long)this.getModel().getValue(MAP_ID);
            visionAction.setMapId(mapId);
            visionAction.setAppId((String)this.getModel().getValue("appid"));
        }
    }

    @Override
    public void initData() {
        super.initData();
        Flow flow = this.getFlow();
        VisionAction visionAction = (VisionAction)this.getAction(flow);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
        if (CollectionUtils.isEmpty((Collection)inputDoc)) {
            this.getModel().createNewEntryRow(PARAM_TREE_INPUT_CONFIG.getEntryEntityKey());
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getNameKey(), (Object)"attachments");
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getTypeKey(), (Object)ParamType.STRING.getDesc());
            this.getModel().setValue(PARAM_TREE_INPUT_CONFIG.getDescKey(), (Object)ResManager.loadKDString((String)"\u9644\u4ef6ID", (String)"VisionServiceFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        this.loadMessage(visionAction);
        List<ParamDefinition> outputParams = visionAction.getParamByGroup(visionAction.getOutputParamGroup());
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            outputParams = this.buildOutputParamDefs(visionAction);
            this.setTreeData(flow, outputParams);
        }
    }

    private void loadMessage(VisionAction visionAction) {
        long templateId = visionAction.getTemplateId();
        if (templateId != 0L) {
            String templateType = visionAction.getTemplateType();
            String templateName = visionAction.getTemplateName();
            String templateNumber = visionAction.getTemplateNumber();
            this.getModel().setValue(TEMPLATE_ID, (Object)templateId);
            this.getModel().setValue(TEMPLATE_TYPE, (Object)templateType);
            this.getModel().setValue("template", (Object)templateName);
            this.getModel().setValue(TEMPLATE_NUMBER, (Object)templateNumber);
        }
        boolean showStatus = visionAction.isShowStatus();
        this.getModel().setValue(SHOW_STATUS, (Object)showStatus);
        boolean backFill = visionAction.isBackFill();
        this.getModel().setValue(IS_BACKFILL, (Object)backFill);
        this.getView().setVisible(Boolean.valueOf(backFill), new String[]{BUSINESS_OBJECT, "selectbusinessobject"});
        String businessObjectName = visionAction.getBusinessObjectName();
        if (backFill && StringUtils.isNotEmpty((CharSequence)businessObjectName)) {
            long mapId = visionAction.getMapId();
            this.getModel().setValue(BUSINESS_OBJECT, (Object)businessObjectName);
            this.getModel().setValue(MAP_ID, (Object)mapId);
        }
    }

    private List<ParamDefinition> buildOutputParamDefs(VisionAction visionAction) {
        ObjectParamDefinition output = ParamDefinitionBuilder.object((String)"output").asOutput().makePublic().build();
        String structure = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"AgentFlowService", (String)"getTemplateAndMappingFields", (Object[])new Object[]{this.getModel().getValue(TEMPLATE_ID).toString(), this.getModel().getValue(TEMPLATE_TYPE).toString(), this.getModel().getValue(BUSINESS_OBJECT_NUMBER).toString(), this.getModel().getValue(MAP_ID).toString()});
        log.info("process getTemplateAndMappingFields: {}", (Object)structure);
        ObjectParamDefinition data = ParamDefinitionBuilder.object((String)"data").makePublic().asOutput().build();
        JSONObject structureMap = JSONObject.parseObject((String)structure);
        if (String.valueOf(structureMap.get("code")).equals("0")) {
            Map param = (Map)structureMap.get("data");
            Map businessObject = (Map)param.get("bizOutput");
            Map templateData = (Map)param.get("templateOutput");
            ObjectParamDefinition bizOutPutParam = ParamDefinitionBuilder.object((String)"bizOutput").makePublic().asOutput().build();
            ObjectParamDefinition templateOutPutParam = ParamDefinitionBuilder.object((String)"templateOutput").makePublic().asOutput().build();
            if (templateData.size() > 0) {
                ObjectParamDefinition templateParam = this.getTemplateParamDef(templateData);
                templateOutPutParam.addProperty((ParamDefinition)templateParam);
            }
            data.addProperty((ParamDefinition)templateOutPutParam);
            BasicParamDefinition status = ParamDefinitionBuilder.bool((String)"status").makePublic().asOutput().build();
            output.addProperty((ParamDefinition)status);
            BasicParamDefinition message = ParamDefinitionBuilder.string((String)"message").makePublic().asOutput().build();
            output.addProperty((ParamDefinition)message);
            BasicParamDefinition savePermission = ParamDefinitionBuilder.bool((String)"savePermission").asOutput().makePublic().build();
            output.addProperty((ParamDefinition)savePermission);
            boolean isBackFill = this.getModel().getDataEntity().getBoolean(IS_BACKFILL);
            BasicParamDefinition backFillStatus = ParamDefinitionBuilder.bool((String)"isBackFill").asOutput().makePublic().build();
            output.addProperty((ParamDefinition)backFillStatus);
            if (isBackFill && !this.getModel().getValue(BUSINESS_OBJECT).toString().isEmpty()) {
                if (businessObject.size() > 0) {
                    ObjectParamDefinition businessObjectDef = this.getBizParamDef(businessObject);
                    bizOutPutParam.addProperty((ParamDefinition)businessObjectDef);
                }
                data.addProperty((ParamDefinition)bizOutPutParam);
            }
            output.addProperty((ParamDefinition)data);
            return Collections.singletonList(output);
        }
        return Collections.emptyList();
    }

    private BasicParamDefinition getBasicParamDef(Map<String, Object> data) {
        String type;
        switch (type = (String)data.get("type")) {
            case "integer": {
                return ParamDefinitionBuilder.integer((String)data.get("key").toString()).makePublic().asOutput().build();
            }
            case "String": {
                return ParamDefinitionBuilder.string((String)data.get("key").toString()).makePublic().asOutput().build();
            }
            case "boolean": {
                return ParamDefinitionBuilder.bool((String)data.get("key").toString()).makePublic().asOutput().build();
            }
            case "date": {
                return ParamDefinitionBuilder.date((String)data.get("key").toString()).makePublic().asOutput().build();
            }
            case "float": {
                return ParamDefinitionBuilder.ffloat((String)data.get("key").toString()).makePublic().asOutput().build();
            }
        }
        throw new RuntimeException("nonsupport data class");
    }

    private ArrayParamDefinition getArrayParamDef(Map<String, Object> data) {
        String name = data.get("key").toString();
        ObjectParamDefinition item = ParamDefinitionBuilder.object((String)"item").makePublic().asOutput().build();
        List cols = (List)objectMapper.convertValue(data.get("cols"), List.class);
        cols.forEach(col -> item.addProperty((ParamDefinition)this.getBasicParamDef((Map<String, Object>)col)));
        return ParamDefinitionBuilder.array((String)name, (ParamDefinition)item).makePublic().asOutput().build();
    }

    private ObjectParamDefinition getObjectParamDef(String name, List<Map<String, Object>> data) {
        ObjectParamDefinition objectParamDefinition = ParamDefinitionBuilder.object((String)name).makePublic().asOutput().build();
        if (data == null || data.isEmpty()) {
            return objectParamDefinition;
        }
        data.forEach(objectMap -> {
            String paramName = name.equals("businessObject") ? objectMap.get(BILL_FORM_ID).toString() : objectMap.get(TEMPLATE_DATA_NUMBER).toString();
            ObjectParamDefinition paramDefinition = ParamDefinitionBuilder.object((String)paramName).makePublic().asOutput().build();
            objectMap.forEach((key, value) -> {
                if (key.equals(COMMON_FIELD) || key.equals(BILL_HEAD)) {
                    List params = (List)objectMapper.convertValue(value, List.class);
                    params.forEach(filed -> paramDefinition.addProperty((ParamDefinition)this.getBasicParamDef((Map<String, Object>)filed)));
                } else if (key.equals(ENTRY) || key.equals(TABLE_FIELD)) {
                    List params = (List)objectMapper.convertValue(value, List.class);
                    params.forEach(filed -> paramDefinition.addProperty((ParamDefinition)this.getArrayParamDef((Map<String, Object>)filed)));
                }
            });
            objectParamDefinition.addProperty((ParamDefinition)paramDefinition);
        });
        return objectParamDefinition;
    }

    private BasicParamDefinition getBasicParamDef(String name, Map<String, Object> data) {
        String type;
        switch (type = (String)data.get("type")) {
            case "integer": {
                return ParamDefinitionBuilder.integer((String)name).makePublic().description((String)data.get("keyName")).asOutput().build();
            }
            case "string": {
                return ParamDefinitionBuilder.string((String)name).makePublic().description((String)data.get("keyName")).asOutput().build();
            }
            case "boolean": {
                return ParamDefinitionBuilder.bool((String)name).makePublic().description((String)data.get("keyName")).asOutput().build();
            }
            case "date": {
                return ParamDefinitionBuilder.date((String)name).makePublic().description((String)data.get("keyName")).asOutput().build();
            }
            case "float": {
                return ParamDefinitionBuilder.ffloat((String)name).makePublic().description((String)data.get("keyName")).asOutput().build();
            }
        }
        throw new RuntimeException("nonsupport data class");
    }

    private ArrayParamDefinition getArrayParamDef(String name, Map<String, Object> data) {
        List paramArray = (List)objectMapper.convertValue(data.get("value"), List.class);
        Map value = (Map)objectMapper.convertValue(paramArray.get(0), Map.class);
        ObjectParamDefinition item = this.getObjectParamDef("item", value);
        return ParamDefinitionBuilder.array((String)name, (ParamDefinition)item).makePublic().asOutput().build();
    }

    private ObjectParamDefinition getObjectParamDef(String name, Map<String, Object> data) {
        ObjectParamDefinition objectParamDefinition = ParamDefinitionBuilder.object((String)name).makePublic().asOutput().build();
        data.entrySet().forEach(entry -> {
            Map param = (Map)objectMapper.convertValue(entry.getValue(), Map.class);
            if (param.get("dataType").equals("common")) {
                objectParamDefinition.addProperty((ParamDefinition)this.getBasicParamDef((String)entry.getKey(), param));
            } else if (param.get("dataType").equals(ENTRY)) {
                objectParamDefinition.addProperty((ParamDefinition)this.getArrayParamDef((String)entry.getKey(), param));
            } else {
                Map value = (Map)objectMapper.convertValue(param.get("value"), Map.class);
                objectParamDefinition.addProperty((ParamDefinition)this.getObjectParamDef((String)entry.getKey(), value));
            }
        });
        return objectParamDefinition;
    }

    private ObjectParamDefinition getTemplateParamDef(Map<String, Object> templateOutput) {
        ObjectParamDefinition templateKey = null;
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : templateOutput.entrySet()) {
            if (!isFirst) continue;
            templateKey = ParamDefinitionBuilder.object((String)entry.getKey()).makePublic().asOutput().build();
            Map templateValue = (Map)entry.getValue();
            ObjectParamDefinition dataParam = this.getObjectParamDef("data", (Map)templateValue.get("data"));
            templateKey.addProperty((ParamDefinition)dataParam);
            isFirst = false;
        }
        return templateKey;
    }

    private ObjectParamDefinition getBizParamDef(Map<String, Object> bizTempData) {
        ObjectParamDefinition bizDataKey = null;
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : bizTempData.entrySet()) {
            if (!isFirst) continue;
            bizDataKey = ParamDefinitionBuilder.object((String)entry.getKey()).makePublic().asOutput().build();
            Map bizDataValue = (Map)entry.getValue();
            ObjectParamDefinition dataParam = this.getObjectParamDef("data", (Map)bizDataValue.get("data"));
            bizDataKey.addProperty((ParamDefinition)dataParam);
            BasicParamDefinition bizFormId = ParamDefinitionBuilder.string((String)"bizFormId").makePublic().asOutput().build();
            BasicParamDefinition bizAppId = ParamDefinitionBuilder.string((String)"bizAppId").makePublic().asOutput().build();
            bizDataKey.addProperty((ParamDefinition)bizFormId);
            bizDataKey.addProperty((ParamDefinition)bizAppId);
            isFirst = false;
        }
        return bizDataKey;
    }
}

