/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AbstractParamTreeSupport {
    protected static final Log log = LogFactory.getLog(AbstractParamTreeSupport.class);
    protected final ParamTreeConfig config;
    protected final IFormView view;
    protected final IDataModel model;

    public AbstractParamTreeSupport(ParamTreeConfig config, IFormView view, IDataModel model) {
        this.config = config;
        this.view = view;
        this.model = model;
    }

    protected final Map<String, List<DynamicObject>> buildParentChildMap(DynamicObjectCollection allRows) {
        HashMap<String, List<DynamicObject>> childrenMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject row : allRows) {
            Object pid = row.get("pid");
            String parentId = pid == null ? "0" : pid.toString();
            childrenMap.computeIfAbsent(parentId, k -> new ArrayList()).add(row);
        }
        return childrenMap;
    }

    protected final void setValueIfVisible(String controlKey, Object value, int rowIndex) {
        if (!this.isControlInvisible(controlKey)) {
            this.model.setValue(controlKey, value, rowIndex);
        }
    }

    protected final <T> T getValueIfVisible(String controlKey, DynamicObject row, T defaultValue) {
        if (this.isControlInvisible(controlKey)) {
            return defaultValue;
        }
        try {
            Object value = row.get(controlKey);
            return (T)(value != null ? value : defaultValue);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6" + controlKey + "\u503c\u5931\u8d25", (Throwable)e);
            return defaultValue;
        }
    }

    protected final boolean isControlInvisible(String controlKey) {
        Control control = this.view.getControl(controlKey);
        return control == null || control.isInvisible();
    }

    protected final String generateNodeParamDisplay(Flow flow, NodeParamPath nodeParamPath) {
        return VarParamConverter.generateNodeParamDisplay(flow, nodeParamPath);
    }
}

