/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.param;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.param.AbstractParamTreeSupport;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEventListener;

public class ParamTreeBinder
extends AbstractParamTreeSupport {
    private static final String OPERATE_TYPE_INSERT_ENTRY = "insertentry";
    private static final String CACHE_SELECT_REF_PARAM = "selectRefrenceParam";
    private static final String IS_RESETTING = "isResetting";
    private final boolean paramTypeLockConfig;

    private ParamTreeBinder(ParamTreeConfig config, IFormView view, IDataModel model, boolean paramTypeLockConfig) {
        super(config, view, model);
        this.paramTypeLockConfig = paramTypeLockConfig;
    }

    public static ParamTreeBinder create(ParamTreeConfig config, IFormView view, IDataModel model, boolean paramTypeLockConfig) {
        return new ParamTreeBinder(config, view, model, paramTypeLockConfig);
    }

    public void initBinding(List<String> lockColumnKeys) {
        if (this.isControlInvisible(this.config.getEntryEntityKey())) {
            return;
        }
        DynamicObjectCollection rows = this.model.getEntryEntity(this.config.getEntryEntityKey());
        if (rows == null) {
            return;
        }
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            this.setRowEnable(row, i);
            this.setEntryColumnEnable(i, lockColumnKeys);
        }
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.view.getControl(this.config.getEntryEntityKey());
        int entryRowCount = this.model.getEntryRowCount(this.config.getEntryEntityKey());
        if (entryRowCount > 0) {
            treeGrid.expand(IntStream.range(0, entryRowCount).toArray());
        }
        this.setEntryInsertVisible(this.config.getEntryEntityKey(), -1);
        this.setParamValueVisible();
    }

    public void initBindingForNewRow(String entryName, int rowIndex, List<String> lockColumnKeys) {
        if (!StringUtils.equals((CharSequence)entryName, (CharSequence)this.config.getEntryEntityKey())) {
            return;
        }
        if (this.isControlInvisible(this.config.getEntryEntityKey())) {
            return;
        }
        DynamicObject row = this.model.getEntryRowEntity(this.config.getEntryEntityKey(), rowIndex);
        this.setChildRowValue(row, rowIndex);
        row = this.model.getEntryRowEntity(this.config.getEntryEntityKey(), rowIndex);
        this.setRowEnable(row, rowIndex);
        this.setEntryColumnEnable(rowIndex, lockColumnKeys);
    }

    public void registerEntryRowClickListener(RowClickEventListener listener) {
        if (!this.isControlInvisible(this.config.getEntryEntityKey())) {
            EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.config.getEntryEntityKey());
            entryGrid.addRowClickListener(listener);
        }
    }

    public void handleConstantModeToggle(String propertyName, int rowIndex, List<String> lockColumns) {
        if (this.isControlInvisible(this.config.getEntryEntityKey())) {
            return;
        }
        if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)this.config.getIsConstantKey())) {
            return;
        }
        DynamicObject changedRow = this.model.getEntryRowEntity(this.config.getEntryEntityKey(), rowIndex);
        this.setRowEnable(changedRow, rowIndex);
        this.clearRowValue(changedRow, rowIndex);
        Long parentId = (Long)changedRow.get("id");
        Map<Integer, DynamicObject> allChildRow = this.findAllChildRow(parentId);
        for (Map.Entry<Integer, DynamicObject> entry : allChildRow.entrySet()) {
            DynamicObject currentRow = entry.getValue();
            Integer currentRowIndex = entry.getKey();
            this.setChildRowValue(this.config.getIsConstantKey(), changedRow.get(this.config.getIsConstantKey()), currentRowIndex);
            this.clearRowValue(currentRow, currentRowIndex);
            this.setRowEnable(currentRow, currentRowIndex);
            this.setEntryColumnEnable(currentRowIndex, lockColumns);
        }
    }

    public void setEntryInsertVisible(String entryKey, int rowIndex) {
        if (!StringUtils.equals((CharSequence)entryKey, (CharSequence)this.config.getEntryEntityKey()) || this.isControlInvisible(entryKey) || StringUtils.isBlank((CharSequence)this.config.getTypeKey())) {
            return;
        }
        String insertRowItemKey = this.config.getInsertRowItemKey();
        if (rowIndex < 0) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.view.getControl(entryKey);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.view.setVisible(Boolean.valueOf(false), new String[]{insertRowItemKey});
                return;
            }
            rowIndex = selectRows[0];
        }
        String typeKey = this.config.getTypeKey();
        Object paramType = this.model.getValue(typeKey, rowIndex);
        this.view.setVisible(Boolean.valueOf(this.isObjectParamType(paramType)), new String[]{insertRowItemKey});
    }

    public void handleParamTypeChanged(int rowIndex) {
        this.setEntryInsertVisible(this.config.getEntryEntityKey(), rowIndex);
        DynamicObjectCollection allRows = this.model.getEntryEntity(this.config.getEntryEntityKey());
        Object entryId = ((DynamicObject)allRows.get(rowIndex)).getPkValue();
        List<DynamicObject> childRows = this.getChildRows(allRows, entryId);
        if (!childRows.isEmpty()) {
            int[] childRowIndexes = childRows.stream().mapToInt(row -> row.getInt("seq") - 1).toArray();
            this.model.deleteEntryRows(this.config.getEntryEntityKey(), childRowIndexes);
        }
    }

    public void handleReferenceParamChanged(ChangeData changeData, int rowIndex, List<String> lockColumns) {
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if (oldValue != null && StringUtils.isBlank((Object)newValue)) {
            this.model.setValue(this.config.getReferenceParamFullPath(), null, rowIndex);
        }
        this.setRowEnable(changeData.getDataEntity(), rowIndex);
        this.setEntryColumnEnable(rowIndex, lockColumns);
        String selectRefParam = this.view.getPageCache().get(CACHE_SELECT_REF_PARAM);
        if (StringUtils.isBlank((CharSequence)selectRefParam)) {
            if ("1".equals(this.view.getPageCache().get(IS_RESETTING))) {
                return;
            }
            if (this.isControlInvisible(this.config.getIsConstantKey())) {
                this.view.getPageCache().put(IS_RESETTING, "1");
                this.model.setValue(this.config.getReferenceParam(), oldValue, rowIndex);
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u6570\u503c\u4ec5\u652f\u6301\u6765\u6e90\u5f15\u7528\u3002", (String)"ParamTreeBinder_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.view.getPageCache().remove(IS_RESETTING);
            } else {
                this.model.setValue(this.config.getIsConstantKey(), (Object)true, rowIndex);
                this.model.setValue(this.config.getConstantValueKey(), newValue, rowIndex);
                this.model.setValue(this.config.getReferenceParamFullPath(), null, rowIndex);
            }
        } else {
            this.model.setValue(this.config.getIsConstantKey(), (Object)false);
            this.view.getPageCache().remove(CACHE_SELECT_REF_PARAM);
        }
    }

    public void setEntryColumnEnable(int rowIndex, List<String> columnKeys) {
        if (columnKeys == null || columnKeys.isEmpty()) {
            return;
        }
        this.view.setEnable(Boolean.valueOf(false), rowIndex, columnKeys.toArray(new String[0]));
    }

    private Map<Integer, DynamicObject> findAllChildRow(Long parentId) {
        LinkedHashMap<Integer, DynamicObject> childRows = new LinkedHashMap<Integer, DynamicObject>();
        DynamicObjectCollection allRows = this.model.getEntryEntity(this.config.getEntryEntityKey());
        this.findAllChildRow(allRows, parentId, childRows);
        return childRows;
    }

    private void findAllChildRow(DynamicObjectCollection allRows, Long parentId, Map<Integer, DynamicObject> childRows) {
        for (int i = 0; i < allRows.size(); ++i) {
            DynamicObject row = (DynamicObject)allRows.get(i);
            Object rowPid = row.get("pid");
            if (!parentId.equals(rowPid)) continue;
            childRows.put(i, row);
            Long currentId = (Long)row.getPkValue();
            if (currentId == null) continue;
            this.findAllChildRow(allRows, currentId, childRows);
        }
    }

    private void setRowEnable(DynamicObject row, int i) {
        Object pid = row.get("pid");
        boolean isChildRow = pid != null && !Long.valueOf(0L).equals(pid);
        boolean isConstant = this.getValueIfVisible(this.config.getIsConstantKey(), row, false);
        boolean isReference = !isConstant && StringUtils.isNotBlank((CharSequence)this.getValueIfVisible(this.config.getReferenceParam(), row, ""));
        this.view.setEnable(Boolean.valueOf(!isReference || !this.paramTypeLockConfig), i, new String[]{this.config.getTypeKey()});
        this.view.setEnable(Boolean.valueOf(isConstant), i, new String[]{this.config.getConstantValueKey()});
        if (isChildRow) {
            this.view.setEnable(Boolean.valueOf(false), i, new String[]{this.config.getReferenceParam()});
            this.view.setEnable(Boolean.valueOf(false), i, new String[]{this.config.getIsConstantKey()});
            this.view.setEnable(Boolean.valueOf(false), i, new String[]{this.config.getConstantValueKey()});
        }
    }

    private void setChildRowValue(DynamicObject row, int rowIndex) {
        boolean isChildRow;
        Object pid = row.get("pid");
        boolean bl = isChildRow = pid != null && !Long.valueOf(0L).equals(pid);
        if (isChildRow) {
            Long parentId = (Long)pid;
            DynamicObjectCollection allRows = this.model.getEntryEntity(this.config.getEntryEntityKey());
            DynamicObject parentRow = null;
            for (DynamicObject potentialParent : allRows) {
                Long rowId = (Long)potentialParent.get("id");
                if (rowId == null || !rowId.equals(parentId)) continue;
                parentRow = potentialParent;
                break;
            }
            if (parentRow != null) {
                Boolean parentIsConstant = parentRow.getBoolean(this.config.getIsConstantKey());
                this.setChildRowValue(this.config.getIsConstantKey(), parentIsConstant, rowIndex);
            }
        }
    }

    private void setChildRowValue(String field, Object fieldValue, int rowIndex) {
        this.model.setValue(field, fieldValue, rowIndex);
    }

    private void clearRowValue(DynamicObject row, int rowIndex) {
        boolean isConstant = this.getValueIfVisible(this.config.getIsConstantKey(), row, false);
        if (isConstant) {
            this.model.setValue(this.config.getReferenceParamFullPath(), (Object)"", rowIndex);
        } else {
            this.model.setValue(this.config.getConstantValueKey(), (Object)"", rowIndex);
        }
    }

    private boolean isObjectParamType(Object type) {
        if (StringUtils.isBlank((Object)type)) {
            return false;
        }
        return ParamType.OBJECT.getDesc().equals(type) || GaiFieldTypeInitUtils.buildDisplayedArrayType((ParamType)ParamType.OBJECT).equals(type);
    }

    private List<DynamicObject> getChildRows(DynamicObjectCollection allRows, Object entryId) {
        ArrayList<DynamicObject> childRows = new ArrayList<DynamicObject>(10);
        for (DynamicObject row : allRows) {
            if (!entryId.equals(row.get("pid"))) continue;
            childRows.add(row);
            childRows.addAll(this.getChildRows(allRows, row.getPkValue()));
        }
        return childRows;
    }

    private void setParamValueVisible() {
        boolean referenceParamInvisible = this.isControlInvisible(this.config.getReferenceParam());
        if (!referenceParamInvisible) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{this.config.getReferenceParam()});
            this.view.setVisible(Boolean.valueOf(false), new String[]{this.config.getConstantValueKey()});
        }
    }
}

