/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.param;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.config.param.AbstractParamTreeSupport;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import org.apache.commons.collections4.CollectionUtils;

public class ParamTreeLoader
extends AbstractParamTreeSupport {
    public static ParamTreeLoader create(ParamTreeConfig config, IFormView view, IDataModel model) {
        return new ParamTreeLoader(config, view, model);
    }

    private ParamTreeLoader(ParamTreeConfig config, IFormView view, IDataModel model) {
        super(config, view, model);
    }

    public void loadParamTypeComboItem(List<ComboItem> paramTypeComboItem) {
        this.loadCustomComboItems(paramTypeComboItem, this.config.getTypeKey());
    }

    public void loadCustomComboItems(List<ComboItem> customComboItems, String controlKey) {
        if (customComboItems == null || customComboItems.isEmpty()) {
            return;
        }
        if (!this.isControlInvisible(controlKey)) {
            ComboEdit comboEdit = (ComboEdit)this.view.getControl(controlKey);
            comboEdit.setComboItems(customComboItems);
        }
    }

    public void loadTreeData(Flow flow, List<ParamDefinition> params) {
        this.loadTreeData(flow, params, false);
    }

    public void loadTreeData(Flow flow, List<ParamDefinition> params, boolean processReferencedParams) {
        if (this.isControlInvisible(this.config.getEntryEntityKey())) {
            return;
        }
        this.model.deleteEntryData(this.config.getEntryEntityKey());
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        this.model.beginInit();
        for (ParamDefinition param : params) {
            int rowIndex = this.model.createNewEntryRow(this.config.getEntryEntityKey());
            this.setupParamRow(flow, param, param, rowIndex, true);
            if (param.isReference() && !param.isHeterogeneousReference() && !processReferencedParams) continue;
            this.processComplexParamDefinition(flow, param, param, rowIndex, processReferencedParams);
        }
        this.model.endInit();
        this.view.updateView(this.config.getEntryEntityKey());
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.view.getControl(this.config.getEntryEntityKey());
        int entryRowCount = this.model.getEntryRowCount(this.config.getEntryEntityKey());
        if (entryRowCount > 0) {
            treeGrid.expand(IntStream.range(0, entryRowCount).toArray());
        }
    }

    public void loadConstantValue() {
        int size = this.model.getEntryRowCount(this.config.getEntryEntityKey());
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(this.model.getValue(this.config.getIsConstantKey(), i))) continue;
            this.setValueIfVisible(this.config.getReferenceParam(), this.convertToStringValue(this.model.getValue(this.config.getConstantValueKey(), i)), i);
        }
        this.view.updateView(this.config.getEntryEntityKey());
    }

    private void processComplexParamDefinition(Flow flow, ParamDefinition topLevelParam, ParamDefinition paramDef, int parentRowIndex, boolean processReferencedParams) {
        if (paramDef.isReference() && !paramDef.isHeterogeneousReference() && !processReferencedParams) {
            return;
        }
        if (paramDef instanceof ObjectParamDefinition) {
            this.processObjectProperties(flow, topLevelParam, (ObjectParamDefinition)paramDef, parentRowIndex, processReferencedParams);
        }
        if (paramDef instanceof ArrayParamDefinition) {
            this.processArrayItems(flow, topLevelParam, (ArrayParamDefinition)paramDef, parentRowIndex, processReferencedParams);
        }
    }

    private void processObjectProperties(Flow flow, ParamDefinition topLevelParam, ObjectParamDefinition objDef, int parentRowIndex, boolean processReferencedParams) {
        List properties = objDef.getProperties();
        if (CollectionUtils.isNotEmpty((Collection)properties)) {
            for (ParamDefinition property : properties) {
                int childRowIndex = this.model.insertEntryRow(this.config.getEntryEntityKey(), parentRowIndex);
                this.setupParamRow(flow, topLevelParam, property, childRowIndex, false);
                this.processComplexParamDefinition(flow, topLevelParam, property, childRowIndex, processReferencedParams);
            }
        }
    }

    private void processArrayItems(Flow flow, ParamDefinition topLevelParam, ArrayParamDefinition arrayDef, int parentRowIndex, boolean processReferencedParams) {
        ParamDefinition itemDef = arrayDef.getItemDefinition();
        if (itemDef == null) {
            return;
        }
        if (itemDef instanceof ObjectParamDefinition) {
            this.processObjectProperties(flow, topLevelParam, (ObjectParamDefinition)itemDef, parentRowIndex, processReferencedParams);
        } else if (itemDef instanceof ArrayParamDefinition) {
            this.processArrayItems(flow, topLevelParam, (ArrayParamDefinition)itemDef, parentRowIndex, processReferencedParams);
        }
    }

    private void setupParamRow(Flow flow, ParamDefinition topLevelParam, ParamDefinition param, int rowIndex, boolean isTopLevel) {
        Map mustProperties;
        String mustData;
        this.setValueIfVisible(this.config.getNameKey(), param.getName(), rowIndex);
        this.setValueIfVisible(this.config.getDescKey(), param.getDescription(), rowIndex);
        String type = VarParamConverter.convertDisplayedParamType(param);
        this.setValueIfVisible(this.config.getTypeKey(), type, rowIndex);
        if (topLevelParam.isConstant()) {
            this.setValueIfVisible(this.config.getIsConstantKey(), true, rowIndex);
        }
        if (isTopLevel && param.isConstant()) {
            this.setValueIfVisible(this.config.getConstantValueKey(), this.convertToStringValue(param.getConstantValue()), rowIndex);
        }
        if (isTopLevel && param.isReference()) {
            NodeParamPath nodeParamPath = param.getReferencePath();
            this.setValueIfVisible(this.config.getReferenceParam(), this.generateNodeParamDisplay(flow, nodeParamPath), rowIndex);
            this.model.setValue(this.config.getReferenceParamFullPath(), (Object)nodeParamPath.getFullPath(), rowIndex);
        }
        if (Boolean.TRUE.equals(this.model.getValue(this.config.getIsConstantKey(), rowIndex))) {
            this.setValueIfVisible(this.config.getReferenceParam(), this.convertToStringValue(param.getConstantValue()), rowIndex);
        }
        if (param.getCustomProperties() != null && StringUtils.isNotEmpty((CharSequence)(mustData = (String)(mustProperties = param.getCustomProperties()).get("isMust")))) {
            this.setValueIfVisible("must", mustData, rowIndex);
        }
    }

    private String convertToStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return String.valueOf(value);
        }
        return JSON.toJSONString((Object)value);
    }
}

