/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.param;

import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.FlowConfigParamHelper;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.config.param.AbstractParamTreeSupport;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ParamTreeRefSelector
extends AbstractParamTreeSupport {
    private static final Log log = LogFactory.getLog(ParamTreeRefSelector.class);
    public static final String KEY_ENTITY_TREEVIEW = "gai_flow_treeview";
    private static final String CACHE_SELECT_REF_PARAM = "selectRefrenceParam";

    public static ParamTreeRefSelector create(ParamTreeConfig config, IFormView view, IDataModel model) {
        return new ParamTreeRefSelector(config, view, model);
    }

    private ParamTreeRefSelector(ParamTreeConfig config, IFormView view, IDataModel model) {
        super(config, view, model);
    }

    public void registerReferenceClickListener(AbstractFormPlugin plugin) {
        if (!this.isControlInvisible(this.config.getReferenceParam())) {
            plugin.addClickListeners(new String[]{this.config.getReferenceParam()});
        }
    }

    public boolean showReferenceTreeView(IFormPlugin formPlugin, String controlKey, String referenceParamFullPathKey, RefrenceDataConfig referenceDataConfig, int nodeId) {
        if (!this.config.getReferenceParam().equals(controlKey)) {
            return false;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(KEY_ENTITY_TREEVIEW);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        fsp.setOpenStyle(openStyle);
        int rowIndex = this.model.getEntryCurrentRowIndex(this.config.getEntryEntityKey());
        Object referenceParamFullPath = this.model.getValue(referenceParamFullPathKey, rowIndex);
        fsp.setCustomParam("referenceParamFullPath", (Object)(referenceParamFullPath != null ? referenceParamFullPath.toString() : ""));
        fsp.setCustomParam(RefrenceDataConfig.class.getSimpleName(), (Object)referenceDataConfig.toJSONString());
        fsp.setCustomParam("nodeId", (Object)nodeId);
        fsp.setCloseCallBack(new CloseCallBack(formPlugin, this.config.getReferenceParam()));
        fsp.setCaption("\u9009\u62e9\u6765\u6e90\u53c2\u6570");
        this.view.showForm(fsp);
        return true;
    }

    public void closedCallBack(Flow flow, Action action, ClosedCallBackEvent evt, boolean updateParamType) {
        ParamDefinition paramDef;
        if (this.config.getReferenceParam().equals(evt.getActionId()) && (paramDef = (ParamDefinition)evt.getReturnData()) != null) {
            try {
                int row = this.model.getEntryCurrentRowIndex(this.config.getEntryEntityKey());
                NodeParamPath nodeParamPath = paramDef.getReferencePath();
                String newParamValue = this.generateNodeParamDisplay(flow, nodeParamPath);
                String referenceParam = this.config.getReferenceParam();
                if (StringUtils.equals((CharSequence)newParamValue, (CharSequence)this.model.getValue(referenceParam, row).toString())) {
                    return;
                }
                this.view.getPageCache().put(CACHE_SELECT_REF_PARAM, "1");
                this.setValueIfVisible(referenceParam, newParamValue, row);
                this.model.setValue(this.config.getReferenceParamFullPath(), (Object)nodeParamPath.getFullPath(), row);
                int referenceBlockNodeId = flow.getBlockNodeIdByActionId(nodeParamPath.getNodeIdAtInt());
                if (referenceBlockNodeId == action.getId()) {
                    paramDef = FlowConfigParamHelper.wrapperArrayParamDefinition((ParamDefinition)paramDef);
                }
                if (updateParamType) {
                    String paramType = VarParamConverter.convertDisplayedParamType(paramDef);
                    this.setValueIfVisible(this.config.getTypeKey(), paramType, row);
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u53c2\u6570\u56de\u8c03\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

