/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.FlowConfigParamHelper;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.ai.gai.plugin.flow.config.param.AbstractParamTreeSupport;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ParamTreeSaver
extends AbstractParamTreeSupport {
    public static ParamTreeSaver create(ParamTreeConfig config, IFormView view, IDataModel model) {
        return new ParamTreeSaver(config, view, model);
    }

    private ParamTreeSaver(ParamTreeConfig config, IFormView view, IDataModel model) {
        super(config, view, model);
    }

    public List<ParamDefinition> saveTreeData(IFormView gaiProcessView, Flow flow, Action action, ParamDirection paramDirection, String paramGroup) {
        ArrayList<ParamDefinition> result = new ArrayList<ParamDefinition>();
        if (this.isControlInvisible(this.config.getEntryEntityKey())) {
            return result;
        }
        action.clearGroupParams(paramGroup);
        DynamicObjectCollection treeDoc = this.model.getEntryEntity(this.config.getEntryEntityKey());
        if (treeDoc == null || treeDoc.isEmpty()) {
            return result;
        }
        Map<String, List<DynamicObject>> childrenMap = this.buildParentChildMap(treeDoc);
        List topLevelRows = childrenMap.getOrDefault("0", new ArrayList());
        for (DynamicObject row : topLevelRows) {
            ParamDefinition paramDef;
            String name = this.getValueIfVisible(this.config.getNameKey(), row, "");
            if (StringUtils.isBlank((CharSequence)name)) continue;
            String type = this.getValueIfVisible(this.config.getTypeKey(), row, "");
            String desc = this.getValueIfVisible(this.config.getDescKey(), row, "");
            boolean isConstant = this.getValueIfVisible(this.config.getIsConstantKey(), row, false);
            String constantValue = this.getValueIfVisible(this.config.getConstantValueKey(), row, "");
            Object referenceParamFullPath = row.get(this.config.getReferenceParamFullPath());
            boolean isReferenceType = referenceParamFullPath != null && StringUtils.isNotBlank((CharSequence)referenceParamFullPath.toString());
            boolean hasChildParamDefinition = CollectionUtils.isNotEmpty((Collection)childrenMap.get(row.getPkValue().toString()));
            if (isReferenceType && !hasChildParamDefinition) {
                paramDef = ParamTreeSaver.createFullReferenceParamDefinition(row, flow, action, paramDirection, name, desc, type, referenceParamFullPath);
                ParamType paramType = ParamType.convertStringToParamType((String)type);
                if (paramType == paramDef.getType() && paramType.isArray()) {
                    String arrType = GaiFieldTypeInitUtils.buildDisplayedArrayType((ParamType)((ArrayParamDefinition)paramDef).getItemDefinition().getType());
                    if (!(type.equals(arrType) || action.isLoopBlockNode() || action.isParallelBlockNode())) {
                        paramDef = this.createCustomParamDefinition(paramDirection, row, name, desc, type, isConstant, constantValue, referenceParamFullPath, childrenMap);
                    }
                } else if (!(paramDef instanceof MessageParamDefinition) && paramType != paramDef.getType()) {
                    paramDef = this.createCustomParamDefinition(paramDirection, row, name, desc, type, isConstant, constantValue, referenceParamFullPath, childrenMap);
                }
            } else {
                paramDef = this.createCustomParamDefinition(paramDirection, row, name, desc, type, isConstant, constantValue, referenceParamFullPath, childrenMap);
            }
            if (paramDef == null) continue;
            this.validateConstantValueToShowTip(gaiProcessView, action, paramDef);
            action.addParam(paramGroup, paramDef);
            result.add(paramDef);
        }
        return result;
    }

    private static ParamDefinition createFullReferenceParamDefinition(DynamicObject row, Flow flow, Action action, ParamDirection paramDirection, String name, String desc, String type, Object referenceParamFullPath) {
        String must;
        boolean containRow;
        ParamDefinition paramDef = FlowConfigParamHelper.createReferenceParamDefinition((Flow)flow, (Action)action, (ParamDirection)paramDirection, (String)name, (String)desc, (String)type, (String)referenceParamFullPath.toString());
        if (paramDef instanceof ObjectParamDefinition) {
            ((ObjectParamDefinition)paramDef).clearProperties();
        }
        if (paramDef instanceof ArrayParamDefinition) {
            ParamDefinition itemDefinition = ((ArrayParamDefinition)paramDef).getItemDefinition();
            if (itemDefinition instanceof ObjectParamDefinition) {
                ((ObjectParamDefinition)itemDefinition).clearProperties();
            }
            if (itemDefinition instanceof ArrayParamDefinition) {
                ((ArrayParamDefinition)itemDefinition).clearItemDefinition();
            }
        }
        if (paramDef instanceof BasicParamDefinition && (containRow = row.getDynamicObjectType().getProperties().containsKey((Object)"must")) && StringUtils.isNotEmpty((CharSequence)(must = row.getString("must")))) {
            HashMap<String, String> mustProperties = new HashMap<String, String>(1);
            mustProperties.put("isMust", must);
            paramDef.setCustomProperties(mustProperties);
        }
        return paramDef;
    }

    private ParamDefinition createCustomParamDefinition(ParamDirection paramDirection, DynamicObject row, String name, String desc, String type, boolean isConstant, String constantValue, Object referenceParamFullPath, Map<String, List<DynamicObject>> childrenMap) {
        ParamDefinition paramDef = FlowConfigParamHelper.createCustomDefParam((DynamicObject)row, (ParamDirection)paramDirection, (String)name, (String)desc, (String)type, (boolean)isConstant, (String)constantValue, (String)(referenceParamFullPath == null ? "" : referenceParamFullPath.toString()));
        this.processChildParamsWithMap(paramDef, row.getPkValue().toString(), childrenMap);
        if (isConstant && constantValue != null) {
            paramDef.setConstantValue((Object)constantValue);
        }
        return paramDef;
    }

    private void processChildParamsWithMap(ParamDefinition parentParam, String parentId, Map<String, List<DynamicObject>> childrenMap) {
        List childRows = childrenMap.getOrDefault(parentId, Collections.emptyList());
        for (DynamicObject row : childRows) {
            String name = this.getValueIfVisible(this.config.getNameKey(), row, "");
            if (StringUtils.isBlank((CharSequence)name)) continue;
            String type = this.getValueIfVisible(this.config.getTypeKey(), row, "");
            String desc = this.getValueIfVisible(this.config.getDescKey(), row, "");
            boolean isConstant = this.getValueIfVisible(this.config.getIsConstantKey(), row, false);
            String constantValue = this.getValueIfVisible(this.config.getConstantValueKey(), row, "");
            String must = this.getValueIfVisible("must", row, "");
            this.addChildToParent(parentParam, name, type, desc, isConstant, constantValue, must).ifPresent(childParam -> this.processChildParamsWithMap((ParamDefinition)childParam, row.getPkValue().toString(), childrenMap));
        }
    }

    private Optional<ParamDefinition> addChildToParent(ParamDefinition parent, String name, String type, String desc, boolean isConstant, String constantValue, String mustValue) {
        ParamDefinition childParam = VarParamConverter.createParamDefinitionByType(name, type);
        childParam.setDescription(desc);
        if (isConstant && constantValue != null) {
            try {
                childParam.setConstantValue((Object)constantValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)mustValue)) {
            HashMap<String, String> mustProperties = new HashMap<String, String>(1);
            mustProperties.put("isMust", mustValue);
            childParam.setCustomProperties(mustProperties);
        }
        if (parent instanceof ObjectParamDefinition) {
            ObjectParamDefinition objDef = (ObjectParamDefinition)parent;
            objDef.addProperty(childParam);
            childParam.setDirection(parent.getDirection());
            childParam.setVisibility(parent.getVisibility());
            return Optional.of(childParam);
        }
        if (parent instanceof ArrayParamDefinition) {
            ArrayParamDefinition arrayDef = (ArrayParamDefinition)parent;
            ParamDefinition itemDef = arrayDef.getItemDefinition();
            if (itemDef instanceof ObjectParamDefinition) {
                ObjectParamDefinition objItemDef = (ObjectParamDefinition)itemDef;
                objItemDef.addProperty(childParam);
                childParam.setDirection(itemDef.getDirection());
                childParam.setVisibility(itemDef.getVisibility());
                return Optional.of(childParam);
            }
            if (childParam instanceof ObjectParamDefinition) {
                ObjectParamDefinition newObjItemDef = new ObjectParamDefinition("item");
                newObjItemDef.setDirection(parent.getDirection());
                newObjItemDef.setVisibility(parent.getVisibility());
                arrayDef.setItemDefinition((ParamDefinition)newObjItemDef);
                newObjItemDef.addProperty(childParam);
                return Optional.of(childParam);
            }
        }
        return Optional.empty();
    }

    private void validateConstantValueToShowTip(IFormView gaiProcessView, Action action, ParamDefinition paramDefinition) {
        if (paramDefinition.getSource() == ParamSource.CONSTANT && paramDefinition.getConstantValue() == null) {
            String showType = VarParamConverter.convertDisplayedParamType(paramDefinition);
            String tipMessage = "\u8282\u70b9(id=" + action.getId() + "): \u8282\u70b9\u53c2\u6570[" + paramDefinition.getName() + "]\u7684\u624b\u5de5\u8f93\u5165\u53c2\u6570\u503c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u53c2\u6570\u7c7b\u578b[" + showType + "], \u8bf7\u91cd\u65b0\u8f93\u5165";
            gaiProcessView.showErrorNotification(ResManager.loadKDString((String)tipMessage, (String)"AbstractFlowConfigPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }
}

