/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.param;

import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.plugin.flow.config.ParamTreeConfig;
import kd.ai.gai.plugin.flow.config.param.AbstractParamTreeSupport;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;

public class ParamTreeValidator
extends AbstractParamTreeSupport {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static final Pattern VALID_INPUT_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9._-]+$");

    private ParamTreeValidator(ParamTreeConfig config, IFormView view, IDataModel model) {
        super(config, view, model);
    }

    public static ParamTreeValidator create(ParamTreeConfig config, IFormView view, IDataModel model) {
        return new ParamTreeValidator(config, view, model);
    }

    public Optional<String> validateParameters() {
        if (this.isControlInvisible(this.config.getEntryEntityKey())) {
            return Optional.empty();
        }
        DynamicObjectCollection rows = this.model.getEntryEntity(this.config.getEntryEntityKey());
        if (rows != null && !rows.isEmpty()) {
            int i = 1;
            for (DynamicObject row : rows) {
                boolean isChildRow;
                Object pid;
                String name = this.getValueIfVisible(this.config.getNameKey(), row, "");
                if (!this.isControlInvisible(this.config.getNameKey()) && StringUtils.isBlank((CharSequence)name)) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c'\u53c2\u6570\u540d'", (String)"FlowConfigPlugin_ValidateInput_0", (String)"ai-gai-plugin", (Object[])new Object[0]), i));
                }
                String type = this.getValueIfVisible(this.config.getTypeKey(), row, "");
                if (!this.isControlInvisible(this.config.getTypeKey()) && StringUtils.isBlank((CharSequence)type)) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c'\u53c2\u6570\u7c7b\u578b'", (String)"FlowConfigPlugin_ValidateInput_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i));
                }
                boolean isConstant = this.getValueIfVisible(this.config.getIsConstantKey(), row, false);
                if (isConstant) {
                    pid = row.get("pid");
                    boolean bl = isChildRow = pid != null && !Long.valueOf(0L).equals(pid);
                    if (!isChildRow) {
                        String constantValue = this.getValueIfVisible(this.config.getConstantValueKey(), row, "");
                        if (!this.isControlInvisible(this.config.getConstantValueKey()) && StringUtils.isBlank((CharSequence)constantValue)) {
                            return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c'\u624b\u5de5\u7ef4\u62a4\u5185\u5bb9'", (String)"FlowConfigPlugin_ValidateInput_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i));
                        }
                    }
                } else {
                    pid = row.get("pid");
                    boolean bl = isChildRow = pid != null && !Long.valueOf(0L).equals(pid);
                    if (!isChildRow) {
                        String referenceParam = this.getValueIfVisible(this.config.getReferenceParam(), row, "");
                        if (!this.isControlInvisible(this.config.getReferenceParam()) && StringUtils.isBlank((CharSequence)referenceParam)) {
                            return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c'\u53c2\u6570\u6765\u6e90'", (String)"FlowConfigPlugin_ValidateInput_3", (String)"ai-gai-plugin", (Object[])new Object[0]), i));
                        }
                    }
                }
                ++i;
            }
        }
        return Optional.empty();
    }

    public void validateNodeVarName(Set<String> systemVarList, String propertyName, ChangeData data, ParamDirection paramDirection) {
        if (this.isControlInvisible(propertyName)) {
            return;
        }
        if (!this.config.getNameKey().equals(propertyName)) {
            return;
        }
        if (data.getNewValue() == null || StringUtils.isEmpty((CharSequence)data.getNewValue().toString())) {
            return;
        }
        String newValue = data.getNewValue().toString();
        if (StringUtils.isNotBlank((CharSequence)newValue) && systemVarList.contains(newValue.toLowerCase())) {
            this.view.showTipNotification(String.format(kd.bos.dataentity.resource.ResManager.loadKDString((String)"%s\u4e3a\u9884\u7f6e\u53d8\u91cf\uff0c\u4e0d\u5141\u8bb8\u8f93\u5165\u3002", (String)"AbstractGaiProcessSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), newValue));
            this.model.beginInit();
            this.model.setValue(propertyName, data.getOldValue());
            this.model.endInit();
            return;
        }
        if (ParamDirection.INPUT == paramDirection && !VALID_INPUT_NAME_PATTERN.matcher(newValue).matches()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u53ea\u80fd\u5305\u542b\u82f1\u6587\u3001\u6570\u5b57\u548c\u90e8\u5206\u7279\u6b8a\u7b26\u53f7\uff08.-_\uff09\u3002", (String)"ParamTreeValidator_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            this.model.beginInit();
            this.model.setValue(propertyName, data.getOldValue());
            this.model.endInit();
            return;
        }
        if (!newValue.startsWith("system.") && ParamDirection.INPUT != paramDirection && !VALID_NAME_PATTERN.matcher(newValue).matches()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u53ea\u80fd\u5305\u542b\u82f1\u6587\u3001\u6570\u5b57\u548c\u90e8\u5206\u7279\u6b8a\u7b26\u53f7\uff08-_\uff09\u3002", (String)"ParamTreeValidator_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            this.model.beginInit();
            this.model.setValue(propertyName, data.getOldValue());
            this.model.endInit();
            return;
        }
        DynamicObjectCollection rows = this.model.getEntryEntity(this.config.getEntryEntityKey());
        if (!rows.isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                if (data.getRowIndex() == i || !((DynamicObject)rows.get(i)).getString(propertyName).equals(newValue) || data.getDataEntity().get("pid") == null || ((DynamicObject)rows.get(i)).get("pid") == null || !((DynamicObject)rows.get(i)).get("pid").equals(data.getDataEntity().get("pid"))) continue;
                this.view.showTipNotification(kd.bos.dataentity.resource.ResManager.loadKDString((String)"\u540c\u8282\u70b9\u7684\u53c2\u6570\u540d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"AbstractGaiProcessSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.model.beginInit();
                this.model.setValue(propertyName, data.getOldValue());
                this.model.endInit();
                break;
            }
        }
    }

    public String validateNodeVarName(String fieldKey, int rowIndex) {
        String name = (String)this.model.getValue(fieldKey, rowIndex);
        if (StringUtils.isBlank((CharSequence)name)) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamTreeValidator_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        if (!name.matches("^[a-zA-Z_][a-zA-Z0-9_]*$")) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u540d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934", (String)"ParamTreeValidator_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        if (!this.validateNameUniqueness(name, rowIndex)) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u540d\u79f0", (String)"ParamTreeValidator_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean validateNameUniqueness(String name, int currentRowIndex) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return true;
        }
        DynamicObjectCollection rows = this.model.getEntryEntity(this.config.getEntryEntityKey());
        if (rows != null) {
            for (int i = 0; i < rows.size(); ++i) {
                if (i == currentRowIndex) continue;
                DynamicObject row = (DynamicObject)rows.get(i);
                String existingName = this.getValueIfVisible(this.config.getNameKey(), row, "");
                if (!name.equals(existingName)) continue;
                return false;
            }
        }
        return true;
    }
}

